/*
 * Decompiled with CFR 0.152.
 */
package scala.actors.remote;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import scala.MatchError;
import scala.Predef$;
import scala.ScalaObject;
import scala.ScalaObject$class;
import scala.StringBuilder;
import scala.actors.Debug$;
import scala.actors.remote.Node;
import scala.actors.remote.TcpService;

public class TcpServiceWorker
extends Thread
implements ScalaObject {
    private boolean running;
    private Node connectedNode;
    private final DataOutputStream dataout;
    private final DataInputStream datain;
    private final OutputStream out;
    private final InputStream in;
    private final Socket so;
    private final TcpService parent;

    public TcpServiceWorker(TcpService parent, Socket so) {
        this.parent = parent;
        this.so = so;
        this.in = so.getInputStream();
        this.out = so.getOutputStream();
        this.datain = new DataInputStream(this.in());
        this.dataout = new DataOutputStream(this.out());
        this.running = true;
    }

    public void run() {
        try {
            while (this.running()) {
                Object msg = this.parent.serializer().readObject(this.datain());
                this.parent.kernel().processMsg(this.connectedNode(), msg);
            }
        }
        catch (Exception exception) {
            Debug$.MODULE$.info(new StringBuilder().append((Object)Predef$.MODULE$.any2stringadd(this).$plus(": caught ")).append(exception).toString());
            this.parent.nodeDown(this.connectedNode());
        }
        catch (IOException iOException) {
            Debug$.MODULE$.info(new StringBuilder().append((Object)Predef$.MODULE$.any2stringadd(this).$plus(": caught ")).append(iOException).toString());
            this.parent.nodeDown(this.connectedNode());
        }
        Debug$.MODULE$.info(Predef$.MODULE$.any2stringadd(this).$plus(": terminated"));
    }

    public void halt() {
        TcpServiceWorker tcpServiceWorker = this;
        synchronized (tcpServiceWorker) {
            this.so.close();
            this.running_$eq(false);
            return;
        }
    }

    public void running_$eq(boolean x$1) {
        this.running = x$1;
    }

    public boolean running() {
        return this.running;
    }

    public void transmit(byte[] data2) {
        TcpServiceWorker tcpServiceWorker = this;
        synchronized (tcpServiceWorker) {
            Debug$.MODULE$.info(Predef$.MODULE$.any2stringadd(this).$plus(": transmitting data..."));
            this.dataout().writeInt(data2.length);
            this.dataout().write(data2);
            this.dataout().flush();
            return;
        }
    }

    public void readNode() {
        Object node = this.parent.serializer().readObject(this.datain());
        Object object = node;
        if (object instanceof Node) {
            Node node2;
            Node n = node2 = (Node)object;
            this.connectedNode_$eq(n);
            this.parent.addConnection(n, this);
            return;
        }
        throw new MatchError(object);
    }

    public void sendNode(Node n) {
        this.connectedNode_$eq(n);
        this.parent.serializer().writeObject(this.dataout(), this.parent.node());
    }

    public void connectedNode_$eq(Node x$1) {
        this.connectedNode = x$1;
    }

    public Node connectedNode() {
        return this.connectedNode;
    }

    public DataOutputStream dataout() {
        return this.dataout;
    }

    public DataInputStream datain() {
        return this.datain;
    }

    public OutputStream out() {
        return this.out;
    }

    public InputStream in() {
        return this.in;
    }

    public int $tag() {
        return ScalaObject$class.$tag(this);
    }
}

