/*                     __                                               *\
**     ________ ___   / /  ___     Scala API                            **
**    / __/ __// _ | / /  / _ |    (c) 2005-2010, LAMP/EPFL             **
**  __\ \/ /__/ __ |/ /__/ __ |                                         **
** /____/\___/_/ |_/____/_/ | |                                         **
**                          |/                                          **
\*                                                                      */

// $Id: ActorTask.scala 21490 2010-04-12 16:37:39Z cunei $


package scala.actors

/** <p>
 *    The class <code>ActorTask</code>.
 *  </p>
 *
 *  @author Philipp Haller
 */
private[actors] class ActorTask(actor: Actor,
                                fun: () => Unit,
                                handler: PartialFunction[Any, Any],
                                msg: Any)
  extends ReplyReactorTask(actor, fun, handler, msg) {

  protected override def beginExecution() {
    super.beginExecution()
    if (actor.shouldExit)
      actor.exit()
  }

  protected override def terminateExecution(e: Exception) {
    val senderInfo = try { Some(actor.sender) } catch {
      case _: Exception => None
    }
    val uncaught = new UncaughtException(actor,
                                         if (msg != null) Some(msg) else None,
                                         senderInfo,
                                         currentThread,
                                         e)

    actor.synchronized {
      if (!actor.links.isEmpty)
        actor exitLinked uncaught
    }
  }

}
