/*                     __                                               *\
**     ________ ___   / /  ___     Scala API                            **
**    / __/ __// _ | / /  / _ |    (c) 2003-2010, LAMP/EPFL             **
**  __\ \/ /__/ __ |/ /__/ __ |    http://scala-lang.org/               **
** /____/\___/_/ |_/____/_/ | |                                         **
**                          |/                                          **
\*                                                                      */

// $Id: BufferedIterator.scala 20154 2009-12-16 16:07:30Z cunei $


package scala.collection

/** Buffered iterators are iterators which provide a method <code>head</code>
 *  that inspects the next element without discarding it.
 *
 *  @author  Martin Odersky
 *  @version 2.8
 *  @since   2.8
 */
trait BufferedIterator[+A] extends Iterator[A] {

  /** Returns next element of iterator without advancing beyond it.
   */
  def head: A

  override def buffered: this.type = this
}
