package scala

trait Fractional[T] extends Numeric[T] {
  def div(x: T, y: T): T
  
  class FractionalOps(lhs: T) extends Ops(lhs) {
    def /(rhs: T) = div(lhs, rhs)
  }
  override implicit def mkNumericOps(lhs: T): FractionalOps = new FractionalOps(lhs)
}
