/*                     __                                               *\
**     ________ ___   / /  ___     Scala API                            **
**    / __/ __// _ | / /  / _ |    (c) 2003-2009, LAMP/EPFL             **
**  __\ \/ /__/ __ |/ /__/ __ |    http://scala-lang.org/               **
** /____/\___/_/ |_/____/_/ | |                                         **
**                          |/                                          **
\*                                                                      */

// $Id$


package scala.collection

import generic._

/** <p>
 *    A map from keys of type <code>A</code> to values of type <code>B</code>.
 *    To implement a concrete map, you need to provide implementations of the
 *    following methods (where <code>This</code> is the type of the map in question):
 *  </p><pre>
 *    <b>def</b> get(key: A): Option[B]
 *    <b>def</b> iterator: Iterator[(A, B)]
 *    <b>def</b> + [B1 >: B](kv: (A, B1)): This
 *    <b>def</b> -(key: A): This</pre>
 *  <p>
 *    If you wish that methods like, take, drop, filter return the same kind
 *    of map, you should also override:
 *  </p><pre>
 *    <b>def</b> empty: This</pre>
 *  <p>
 *    It might also be a good idea to override methods <code>foreach</code>
 *    and <code>size</code> for efficiency.
 *  </p>
 *
 * @note If you do not have specific implementations for `add` and `-` in mind,
 *       you might consider inheriting from <code>DefaultMap</code> instead.
 *
 * @note Of you additions and mutations return the same kind of map as the map
 *       you are defining, you should inherit from <code>MapTemplate</code> as well.
 */
trait Map[A, +B] extends Iterable[(A, B)] with MapTemplate[A, B, Map[A, B]] {
  def empty: Map[A, B] = Map.empty
}

/* Factory object for `Map` class */
object Map extends ImmutableMapFactory[immutable.Map] {
  def empty[A, B]: immutable.Map[A, B] = immutable.Map.empty
  implicit def builderFactory[A, B]: BuilderFactory[(A, B), Map[A, B], Coll] = new MapBuilderFactory[A, B]
}
