/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.mutable;

import scala.Function1;
import scala.Function1$class;
import scala.Function2;
import scala.Option;
import scala.PartialFunction;
import scala.PartialFunction$class;
import scala.Predef$;
import scala.Range;
import scala.ScalaObject;
import scala.Tuple2;
import scala.Unhashable$class;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Sequence;
import scala.collection.Traversable;
import scala.collection.Vector$class;
import scala.collection.generic.Builder;
import scala.collection.generic.Builder$class;
import scala.collection.generic.BuilderFactory;
import scala.collection.generic.Companion;
import scala.collection.generic.Growable;
import scala.collection.generic.Growable$class;
import scala.collection.generic.IterableTemplate;
import scala.collection.generic.IterableTemplate$class;
import scala.collection.generic.MutableVectorTemplate$class;
import scala.collection.generic.MutableVectorView;
import scala.collection.generic.SequenceTemplate$class;
import scala.collection.generic.TraversableClass$class;
import scala.collection.generic.TraversableTemplate;
import scala.collection.generic.TraversableTemplate$class;
import scala.collection.generic.VectorTemplate;
import scala.collection.generic.VectorTemplate$class;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Iterable$class;
import scala.collection.mutable.Sequence$class;
import scala.collection.mutable.StringBuilder$;
import scala.collection.mutable.Traversable$class;
import scala.collection.mutable.Vector;
import scala.compat.Platform$;
import scala.runtime.BoxedArray;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class StringBuilder
implements Builder<Character, String>,
Vector<Character>,
ScalaObject {
    public static final long serialVersionUID = -8525408645367278351L;
    private int count;
    private char[] array;
    private final String initValue;

    public StringBuilder(int initCapacity, String initValue) {
        this.initValue = initValue;
        Growable$class.$init$(this);
        Builder$class.$init$(this);
        TraversableTemplate$class.$init$(this);
        TraversableClass$class.$init$(this);
        scala.collection.Traversable$class.$init$(this);
        Traversable$class.$init$(this);
        IterableTemplate$class.$init$(this);
        scala.collection.Iterable$class.$init$(this);
        Iterable$class.$init$(this);
        Function1$class.$init$(this);
        PartialFunction$class.$init$(this);
        SequenceTemplate$class.$init$(this);
        scala.collection.Sequence$class.$init$(this);
        Unhashable$class.$init$(this);
        Sequence$class.$init$(this);
        VectorTemplate$class.$init$(this);
        Vector$class.$init$(this);
        MutableVectorTemplate$class.$init$(this);
        scala.collection.mutable.Vector$class.$init$(this);
        Predef$.MODULE$.require(initCapacity > 0);
        this.array = new char[initCapacity + initValue.length()];
        this.count = 0;
        this.append(initValue);
    }

    @Override
    public String result() {
        return this.toString();
    }

    @Override
    public String toString() {
        return new String(this.array(), 0, this.count());
    }

    @Override
    public StringBuilder reverse() {
        boolean hasSurrogate = false;
        int n = this.count() - 1;
        for (int j = n - 1 >> 1; j >= 0; --j) {
            char temp = this.array()[j];
            char temp2 = this.array()[n - j];
            if (!hasSurrogate) {
                hasSurrogate = temp >= StringBuilder$.MODULE$.scala$collection$mutable$StringBuilder$$MIN_SURROGATE() && temp <= StringBuilder$.MODULE$.scala$collection$mutable$StringBuilder$$MAX_SURROGATE() || temp2 >= StringBuilder$.MODULE$.scala$collection$mutable$StringBuilder$$MIN_SURROGATE() && temp2 <= StringBuilder$.MODULE$.scala$collection$mutable$StringBuilder$$MAX_SURROGATE();
            }
            this.array()[j] = temp2;
            this.array()[n - j] = temp;
        }
        if (hasSurrogate) {
            for (int i = 0; i < this.count() - 1; ++i) {
                char c1;
                char c2 = this.array()[i];
                if (!StringBuilder$.MODULE$.scala$collection$mutable$StringBuilder$$isLowSurrogate(c2) || !StringBuilder$.MODULE$.scala$collection$mutable$StringBuilder$$isHighSurrogate(c1 = this.array()[i + 1])) continue;
                this.array()[i] = c1;
                this.array()[++i] = c2;
            }
        }
        return this;
    }

    @Override
    public int lastIndexOf(String str, int fromIndex) {
        return this.lastIndexOfSeq(ScalaRunTime$.MODULE$.boxArray(Predef$.MODULE$.stringWrapper(str).toArray()), fromIndex);
    }

    @Override
    public int lastIndexOf(String str) {
        return this.lastIndexOfSeq(ScalaRunTime$.MODULE$.boxArray(Predef$.MODULE$.stringWrapper(str).toArray()), this.count());
    }

    @Override
    public int indexOf(String str, int fromIndex) {
        return this.indexOfSeq(ScalaRunTime$.MODULE$.boxArray(Predef$.MODULE$.stringWrapper(str).toArray()), fromIndex);
    }

    @Override
    public int indexOf(String str) {
        return this.indexOfSeq(ScalaRunTime$.MODULE$.boxArray(Predef$.MODULE$.stringWrapper(str).toArray()));
    }

    public StringBuilder insert(int at, double x) {
        return this.insert(at, String.valueOf(x));
    }

    public StringBuilder insert(int at, float x) {
        return this.insert(at, String.valueOf(x));
    }

    public StringBuilder insert(int at, long x) {
        return this.insert(at, String.valueOf(x));
    }

    public StringBuilder insert(int at, int x) {
        return this.insert(at, String.valueOf(x));
    }

    public StringBuilder insert(int at, short x) {
        return this.insert(at, String.valueOf(BoxesRunTime.boxToShort(x)));
    }

    public StringBuilder insert(int at, char x) {
        if (at < 0 || at > this.count()) {
            throw new StringIndexOutOfBoundsException(at);
        }
        this.ensureCapacity(this.count() + 1);
        Platform$.MODULE$.arraycopy(this.array(), at, this.array(), at + 1, this.count() - at);
        this.array()[at] = x;
        this.count_$eq(this.count() + 1);
        return this;
    }

    public StringBuilder insert(int at, byte x) {
        return this.insert(at, String.valueOf(BoxesRunTime.boxToByte(x)));
    }

    public StringBuilder insert(int at, boolean x) {
        return this.insert(at, String.valueOf(x));
    }

    public StringBuilder insert(int at, char[] x) {
        return this.insertAll(at, x);
    }

    public StringBuilder insertAll(int at, char[] x) {
        if (at < 0 || at > this.count()) {
            throw new StringIndexOutOfBoundsException(at);
        }
        int len = x.length;
        this.ensureCapacity(this.count() + len);
        Platform$.MODULE$.arraycopy(this.array(), at, this.array(), at + len, this.count() - at);
        Platform$.MODULE$.arraycopy(x, 0, this.array(), at, len);
        this.count_$eq(this.count() + len);
        return this;
    }

    public StringBuilder insert(int at, Sequence<Character> x) {
        return this.insertAll(at, x);
    }

    public StringBuilder insertAll(int at, Sequence<Character> x) {
        Object object = ScalaRunTime$.MODULE$.arrayValue(x.toArray(), Character.TYPE);
        return this.insertAll(at, (char[])(object instanceof BoxedArray ? ScalaRunTime$.MODULE$.arrayValue((BoxedArray)object, Character.TYPE) : object));
    }

    public StringBuilder insert(int at, String x) {
        if (at < 0 || at > this.count()) {
            throw new StringIndexOutOfBoundsException(at);
        }
        String string2 = x;
        String str = string2 == null || string2.equals(null) ? "null" : x;
        int len = str.length();
        this.ensureCapacity(this.count() + len);
        Platform$.MODULE$.arraycopy(this.array(), at, this.array(), at + len, this.count() - at);
        str.getChars(0, len, this.array(), at);
        this.count_$eq(this.count() + len);
        return this;
    }

    public StringBuilder insert(int at, Object x) {
        return this.insert(at, String.valueOf(x));
    }

    public StringBuilder insert(int index2, char[] str, int offset, int len) {
        return this.insertAll(index2, str, offset, len);
    }

    public StringBuilder insertAll(int index2, char[] str, int offset, int len) {
        if (index2 < 0 || index2 > this.count()) {
            throw new StringIndexOutOfBoundsException(index2);
        }
        if (offset < 0 || len < 0 || offset > str.length - len) {
            throw new StringIndexOutOfBoundsException(new StringBuilder().append((Object)"offset ").append(BoxesRunTime.boxToInteger(offset)).append((Object)", len ").append(BoxesRunTime.boxToInteger(len)).append((Object)", str.length ").append(BoxesRunTime.boxToInteger(str.length)).toString());
        }
        this.ensureCapacity(this.count() + len);
        Platform$.MODULE$.arraycopy(this.array(), index2, this.array(), index2 + len, this.count() - index2);
        Platform$.MODULE$.arraycopy(str, offset, this.array(), index2, len);
        this.count_$eq(this.count() + len);
        return this;
    }

    public void replace(int start2, int end, String str) {
        if (start2 < 0 || start2 > this.count() || start2 > end) {
            throw new StringIndexOutOfBoundsException(start2);
        }
        int end0 = end > this.count() ? this.count() : end;
        int len = str.length();
        int newCount = this.count() + len - (end0 - start2);
        this.ensureCapacity(newCount);
        Platform$.MODULE$.arraycopy(this.array(), end, this.array(), start2 + len, this.count() - end);
        str.getChars(0, len, this.array(), start2);
        this.count_$eq(newCount);
    }

    public StringBuilder delete(int start2, int end) {
        if (start2 < 0 || start2 > end) {
            throw new StringIndexOutOfBoundsException(start2);
        }
        int end0 = end > this.count() ? this.count() : end;
        int len = end0 - start2;
        if (len > 0) {
            Platform$.MODULE$.arraycopy(this.array(), start2 + len, this.array(), start2, this.count() - end0);
            this.count_$eq(this.count() - len);
        }
        return this;
    }

    public StringBuilder append(double x) {
        return this.append(String.valueOf(x));
    }

    public StringBuilder append(float x) {
        return this.append(String.valueOf(x));
    }

    public StringBuilder append(long x) {
        return this.append(String.valueOf(x));
    }

    public StringBuilder append(int x) {
        return this.append(String.valueOf(x));
    }

    public StringBuilder append(short x) {
        return this.append(String.valueOf(BoxesRunTime.boxToShort(x)));
    }

    public StringBuilder append(char x) {
        this.ensureCapacity(this.count() + 1);
        this.array()[this.count()] = x;
        this.count_$eq(this.count() + 1);
        return this;
    }

    public StringBuilder append(byte x) {
        return this.append(String.valueOf(BoxesRunTime.boxToByte(x)));
    }

    public StringBuilder append(boolean x) {
        return this.append(String.valueOf(x));
    }

    public StringBuilder append(char[] x, int offset, int len) {
        return this.appendAll(x, offset, len);
    }

    public StringBuilder appendAll(char[] x, int offset, int len) {
        this.ensureCapacity(this.count() + len);
        Platform$.MODULE$.arraycopy(x, offset, this.array(), this.count(), len);
        this.count_$eq(this.count() + len);
        return this;
    }

    public StringBuilder append(char[] x) {
        return this.appendAll(x);
    }

    public StringBuilder appendAll(char[] x) {
        return this.appendAll(x, 0, x.length);
    }

    public StringBuilder append(Sequence<Character> x) {
        return this.appendAll(x);
    }

    public StringBuilder appendAll(Sequence<Character> x) {
        Object object = ScalaRunTime$.MODULE$.arrayValue(x.toArray(), Character.TYPE);
        return this.appendAll((char[])(object instanceof BoxedArray ? ScalaRunTime$.MODULE$.arrayValue((BoxedArray)object, Character.TYPE) : object), 0, x.length());
    }

    public StringBuilder append(StringBuilder sb) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = sb;
        if (stringBuilder2 == null || ((Object)stringBuilder2).equals(null)) {
            stringBuilder = this.append("null");
        } else {
            int len = sb.length();
            this.ensureCapacity(this.count() + len);
            Platform$.MODULE$.arraycopy(sb.toArray(), 0, this.array(), this.count(), len);
            this.count_$eq(this.count() + len);
            stringBuilder = this;
        }
        return stringBuilder;
    }

    public StringBuilder append(String s) {
        String string2 = s;
        String str = string2 == null || string2.equals(null) ? "null" : s;
        int len = str.length();
        this.ensureCapacity(this.count() + len);
        str.getChars(0, len, this.array(), this.count());
        this.count_$eq(this.count() + len);
        return this;
    }

    public StringBuilder append(Object x) {
        return this.append(String.valueOf(x));
    }

    public StringBuilder $plus(char x) {
        this.$plus$eq(x);
        return this;
    }

    public StringBuilder $plus$eq(char x) {
        this.append(x);
        return this;
    }

    public CharSequence subSequence(int start2, int end) {
        return this.substring(start2, end);
    }

    public String substring(int start2, int end) {
        if (start2 < 0) {
            throw new StringIndexOutOfBoundsException(start2);
        }
        if (end > this.count()) {
            throw new StringIndexOutOfBoundsException(end);
        }
        if (start2 > end) {
            throw new StringIndexOutOfBoundsException(end - start2);
        }
        return new String(this.array(), start2, end - start2);
    }

    public String substring(int start2) {
        return this.substring(start2, this.count());
    }

    @Override
    public void update(int i, char c) {
        this.setCharAt(i, c);
    }

    public void setCharAt(int index2, char ch) {
        if (index2 < 0 || index2 >= this.count()) {
            throw new StringIndexOutOfBoundsException(index2);
        }
        this.array()[index2] = ch;
    }

    public StringBuilder deleteCharAt(int index2) {
        if (index2 < 0 || index2 >= this.count()) {
            throw new StringIndexOutOfBoundsException(index2);
        }
        Platform$.MODULE$.arraycopy(this.array(), index2 + 1, this.array(), index2, this.count() - index2 - 1);
        this.count_$eq(this.count() - 1);
        return this;
    }

    @Override
    public char apply(int i) {
        return this.charAt(i);
    }

    public char charAt(int index2) {
        if (index2 < 0 || index2 >= this.count()) {
            throw new StringIndexOutOfBoundsException(index2);
        }
        return this.array()[index2];
    }

    public void ensureCapacity(int n) {
        if (n > this.array().length) {
            int newsize;
            for (newsize = this.array().length * 2; n > newsize; newsize *= 2) {
            }
            char[] newar = new char[newsize];
            Platform$.MODULE$.arraycopy(this.array(), 0, newar, 0, this.count());
            this.array_$eq(newar);
        }
    }

    public void capacity_$eq(int n) {
        this.ensureCapacity(n);
    }

    public int capacity() {
        return this.array().length;
    }

    public void setLength(int n$1) {
        Predef$.MODULE$.require(n$1 >= 0, new $anonfun$setLength$1(this, n$1));
        while (this.count() < n$1) {
            this.append('\u0000');
        }
        this.count_$eq(n$1);
    }

    @Override
    public void clear() {
        this.setLength(0);
    }

    public void length_$eq(int n) {
        this.setLength(n);
    }

    @Override
    public int length() {
        return this.count();
    }

    public char[] toArray() {
        return this.array();
    }

    public StringBuilder(String str) {
        this(16, str);
    }

    public StringBuilder(int capacity) {
        this(capacity, "");
    }

    public StringBuilder() {
        this(16, "");
    }

    private void count_$eq(int n) {
        this.count = n;
    }

    private int count() {
        return this.count;
    }

    private void array_$eq(char[] cArray) {
        this.array = cArray;
    }

    private char[] array() {
        return this.array;
    }

    private String initValue() {
        return this.initValue;
    }

    @Override
    public Growable $plus$plus$eq(Traversable iter) {
        return Growable$class.$plus$plus$eq((Growable)this, iter);
    }

    @Override
    public Growable $plus$plus$eq(Iterator iter) {
        return Growable$class.$plus$plus$eq((Growable)this, iter);
    }

    @Override
    public Growable $plus$eq(Object elem1, Object elem2, Sequence elems) {
        return Growable$class.$plus$eq(this, elem1, elem2, elems);
    }

    @Override
    public Builder mapResult(Function1 f) {
        return Builder$class.mapResult(this, f);
    }

    @Override
    public void sizeHint(int size2) {
        Builder$class.sizeHint(this, size2);
    }

    @Override
    public String stringPrefix() {
        return TraversableTemplate$class.stringPrefix(this);
    }

    @Override
    public StringBuilder addString(StringBuilder b) {
        return TraversableTemplate$class.addString(this, b);
    }

    @Override
    public StringBuilder addString(StringBuilder b, String sep) {
        return TraversableTemplate$class.addString(this, b, sep);
    }

    @Override
    public StringBuilder addString(StringBuilder b, String start2, String sep, String end) {
        return TraversableTemplate$class.addString(this, b, start2, sep, end);
    }

    @Override
    public String mkString() {
        return TraversableTemplate$class.mkString(this);
    }

    @Override
    public String mkString(String sep) {
        return TraversableTemplate$class.mkString(this, sep);
    }

    @Override
    public String mkString(String start2, String sep, String end) {
        return TraversableTemplate$class.mkString(this, start2, sep, end);
    }

    @Override
    public Set toSet() {
        return TraversableTemplate$class.toSet(this);
    }

    @Override
    public List toList() {
        return TraversableTemplate$class.toList(this);
    }

    public BoxedArray toArray() {
        return TraversableTemplate$class.toArray(this);
    }

    public void copyToArray(BoxedArray xs, int start2) {
        TraversableTemplate$class.copyToArray(this, xs, start2);
    }

    @Override
    public void copyToBuffer(Buffer dest) {
        TraversableTemplate$class.copyToBuffer(this, dest);
    }

    @Override
    public Option lastOption() {
        return TraversableTemplate$class.lastOption(this);
    }

    @Override
    public Option headOption() {
        return TraversableTemplate$class.headOption(this);
    }

    @Override
    public Option reduceRightOption(Function2 op) {
        return TraversableTemplate$class.reduceRightOption(this, op);
    }

    @Override
    public Option reduceLeftOption(Function2 op) {
        return TraversableTemplate$class.reduceLeftOption(this, op);
    }

    @Override
    public Object $colon$bslash(Object z, Function2 op) {
        return TraversableTemplate$class.$colon$bslash(this, z, op);
    }

    @Override
    public Object $div$colon(Object z, Function2 op) {
        return TraversableTemplate$class.$div$colon(this, z, op);
    }

    @Override
    public int count(Function1 p) {
        return TraversableTemplate$class.count(this, p);
    }

    @Override
    public Map groupBy(Function1 f) {
        return TraversableTemplate$class.groupBy(this, f);
    }

    @Override
    public Tuple2 partition(Function1 p) {
        return TraversableTemplate$class.partition(this, p);
    }

    @Override
    public TraversableTemplate remove(Function1 p) {
        return TraversableTemplate$class.remove(this, p);
    }

    @Override
    public TraversableTemplate filterNot(Function1 p) {
        return TraversableTemplate$class.filterNot(this, p);
    }

    @Override
    public Object filterMap(PartialFunction pf, BuilderFactory bf) {
        return TraversableTemplate$class.filterMap(this, pf, bf);
    }

    @Override
    public TraversableTemplate filter(Function1 p) {
        return TraversableTemplate$class.filter(this, p);
    }

    @Override
    public Object flatMap(Function1 f, BuilderFactory bf) {
        return TraversableTemplate$class.flatMap(this, f, bf);
    }

    @Override
    public Object map(Function1 f, BuilderFactory bf) {
        return TraversableTemplate$class.map(this, f, bf);
    }

    @Override
    public Object $plus$plus(Iterator that, BuilderFactory bf) {
        return TraversableTemplate$class.$plus$plus((TraversableTemplate)this, that, bf);
    }

    @Override
    public Object $plus$plus(Traversable that, BuilderFactory bf) {
        return TraversableTemplate$class.$plus$plus((TraversableTemplate)this, that, bf);
    }

    @Override
    public boolean hasDefiniteSize() {
        return TraversableTemplate$class.hasDefiniteSize(this);
    }

    @Override
    public boolean nonEmpty() {
        return TraversableTemplate$class.nonEmpty(this);
    }

    @Override
    public TraversableTemplate thisCollection() {
        return TraversableTemplate$class.thisCollection(this);
    }

    @Override
    public Traversable transpose(Function1 toTraversable) {
        return TraversableClass$class.transpose(this, toTraversable);
    }

    @Override
    public Traversable flatten(Function1 toTraversable) {
        return TraversableClass$class.flatten(this, toTraversable);
    }

    @Override
    public Tuple2 unzip(Function1 toPair) {
        return TraversableClass$class.unzip(this, toPair);
    }

    @Override
    public Builder genericBuilder() {
        return TraversableClass$class.genericBuilder(this);
    }

    @Override
    public Builder newBuilder() {
        return TraversableClass$class.newBuilder(this);
    }

    @Override
    public Sequence toSeq() {
        return IterableTemplate$class.toSeq(this);
    }

    @Override
    public Option firstOption() {
        return IterableTemplate$class.firstOption(this);
    }

    @Override
    public Object first() {
        return IterableTemplate$class.first(this);
    }

    @Override
    public Stream toStream() {
        return IterableTemplate$class.toStream(this);
    }

    @Override
    public Iterable toIterable() {
        return IterableTemplate$class.toIterable(this);
    }

    @Override
    public Iterator elements() {
        return IterableTemplate$class.elements(this);
    }

    @Override
    public Function1 compose(Function1 g) {
        return Function1$class.compose(this, g);
    }

    @Override
    public PartialFunction andThen(Function1 k) {
        return PartialFunction$class.andThen(this, k);
    }

    @Override
    public PartialFunction orElse(PartialFunction that) {
        return PartialFunction$class.orElse(this, that);
    }

    @Override
    public Object projection() {
        return SequenceTemplate$class.projection(this);
    }

    @Override
    public boolean containsSlice(Sequence that) {
        return SequenceTemplate$class.containsSlice(this, that);
    }

    @Override
    public boolean equalsWith(Sequence that, Function2 f) {
        return SequenceTemplate$class.equalsWith(this, that, f);
    }

    @Override
    public Sequence slice(int from2) {
        return SequenceTemplate$class.slice(this, from2);
    }

    @Override
    public int findLastIndexOf(Function1 p) {
        return SequenceTemplate$class.findLastIndexOf(this, p);
    }

    @Override
    public IterableTemplate sortWith(Function2 lt) {
        return SequenceTemplate$class.sortWith(this, lt);
    }

    @Override
    public Range indices() {
        return SequenceTemplate$class.indices(this);
    }

    @Override
    public Sequence toSequence() {
        return SequenceTemplate$class.toSequence(this);
    }

    @Override
    public Object padTo(int len, Object elem2, BuilderFactory bf) {
        return SequenceTemplate$class.padTo(this, len, elem2, bf);
    }

    @Override
    public Object patch(int from2, Sequence patch, int replaced, BuilderFactory bf) {
        return SequenceTemplate$class.patch(this, from2, patch, replaced, bf);
    }

    @Override
    public IterableTemplate removeDuplicates() {
        return SequenceTemplate$class.removeDuplicates(this);
    }

    @Override
    public IterableTemplate intersect(Sequence that) {
        return SequenceTemplate$class.intersect(this, that);
    }

    @Override
    public IterableTemplate diff(Sequence that) {
        return SequenceTemplate$class.diff(this, that);
    }

    @Override
    public Object union(Sequence that, BuilderFactory bf) {
        return SequenceTemplate$class.union(this, that, bf);
    }

    @Override
    public boolean contains(Object elem2) {
        return SequenceTemplate$class.contains(this, elem2);
    }

    @Override
    public int lastIndexOfSeq(Sequence that, int fromIndex) {
        return SequenceTemplate$class.lastIndexOfSeq(this, that, fromIndex);
    }

    @Override
    public int lastIndexOfSeq(Sequence that) {
        return SequenceTemplate$class.lastIndexOfSeq(this, that);
    }

    @Override
    public int indexOfSeq(Sequence that, int fromIndex) {
        return SequenceTemplate$class.indexOfSeq(this, that, fromIndex);
    }

    @Override
    public int indexOfSeq(Sequence that) {
        return SequenceTemplate$class.indexOfSeq(this, that);
    }

    @Override
    public boolean startsWith(Sequence that) {
        return SequenceTemplate$class.startsWith(this, that);
    }

    @Override
    public Iterator reversedElements() {
        return SequenceTemplate$class.reversedElements(this);
    }

    @Override
    public int lastIndexWhere(Function1 p) {
        return SequenceTemplate$class.lastIndexWhere(this, p);
    }

    @Override
    public int lastIndexOf(Object elem2, int end) {
        return SequenceTemplate$class.lastIndexOf(this, elem2, end);
    }

    @Override
    public int lastIndexOf(Object elem2) {
        return SequenceTemplate$class.lastIndexOf(this, elem2);
    }

    @Override
    public int indexOf(Object elem2, int from2) {
        return SequenceTemplate$class.indexOf(this, elem2, from2);
    }

    @Override
    public int indexOf(Object elem2) {
        return SequenceTemplate$class.indexOf(this, elem2);
    }

    @Override
    public int findIndexOf(Function1 p) {
        return SequenceTemplate$class.findIndexOf(this, p);
    }

    @Override
    public int indexWhere(Function1 p) {
        return SequenceTemplate$class.indexWhere(this, p);
    }

    @Override
    public int prefixLength(Function1 p) {
        return SequenceTemplate$class.prefixLength(this, p);
    }

    @Override
    public Object zipAll(Sequence that, Object thisElem, Object thatElem, BuilderFactory bf) {
        return SequenceTemplate$class.zipAll(this, that, thisElem, thatElem, bf);
    }

    @Override
    public boolean isDefinedAt(int x) {
        return SequenceTemplate$class.isDefinedAt(this, x);
    }

    @Override
    public int size() {
        return SequenceTemplate$class.size(this);
    }

    @Override
    public int identityHashCode() {
        return Unhashable$class.identityHashCode(this);
    }

    @Override
    public int hashCode() {
        return Unhashable$class.hashCode(this);
    }

    @Override
    public final int scala$Unhashable$$super$hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object that) {
        return VectorTemplate$class.equals(this, that);
    }

    @Override
    public boolean endsWith(Sequence that) {
        return VectorTemplate$class.endsWith(this, that);
    }

    @Override
    public boolean startsWith(Sequence that, int offset) {
        return VectorTemplate$class.startsWith(this, that, offset);
    }

    @Override
    public Iterator reverseIterator() {
        return VectorTemplate$class.reverseIterator(this);
    }

    @Override
    public int lastIndexWhere(Function1 p, int end) {
        return VectorTemplate$class.lastIndexWhere(this, p, end);
    }

    @Override
    public int indexWhere(Function1 p, int from2) {
        return VectorTemplate$class.indexWhere(this, p, from2);
    }

    @Override
    public int segmentLength(Function1 p, int from2) {
        return VectorTemplate$class.segmentLength(this, p, from2);
    }

    @Override
    public int lengthCompare(int len) {
        return VectorTemplate$class.lengthCompare(this, len);
    }

    public void copyToArray(BoxedArray xs, int start2, int len) {
        VectorTemplate$class.copyToArray(this, xs, start2, len);
    }

    @Override
    public boolean sameElements(Iterable that) {
        return VectorTemplate$class.sameElements(this, that);
    }

    @Override
    public Tuple2 span(Function1 p) {
        return VectorTemplate$class.span(this, p);
    }

    @Override
    public VectorTemplate dropWhile(Function1 p) {
        return VectorTemplate$class.dropWhile(this, p);
    }

    @Override
    public VectorTemplate takeWhile(Function1 p) {
        return VectorTemplate$class.takeWhile(this, p);
    }

    @Override
    public Tuple2 splitAt(int n) {
        return VectorTemplate$class.splitAt(this, n);
    }

    @Override
    public VectorTemplate dropRight(int n) {
        return VectorTemplate$class.dropRight(this, n);
    }

    @Override
    public VectorTemplate takeRight(int n) {
        return VectorTemplate$class.takeRight(this, n);
    }

    @Override
    public VectorTemplate drop(int n) {
        return VectorTemplate$class.drop(this, n);
    }

    @Override
    public VectorTemplate take(int n) {
        return VectorTemplate$class.take(this, n);
    }

    @Override
    public VectorTemplate init() {
        return VectorTemplate$class.init(this);
    }

    @Override
    public Object last() {
        return VectorTemplate$class.last(this);
    }

    @Override
    public VectorTemplate tail() {
        return VectorTemplate$class.tail(this);
    }

    @Override
    public Object head() {
        return VectorTemplate$class.head(this);
    }

    @Override
    public VectorTemplate slice(int from2, int until2) {
        return VectorTemplate$class.slice(this, from2, until2);
    }

    @Override
    public Object zipWithIndex(BuilderFactory bf) {
        return VectorTemplate$class.zipWithIndex(this, bf);
    }

    @Override
    public Object zip(Sequence that, BuilderFactory bf) {
        return VectorTemplate$class.zip(this, that, bf);
    }

    @Override
    public Object reduceRight(Function2 op) {
        return VectorTemplate$class.reduceRight(this, op);
    }

    @Override
    public Object reduceLeft(Function2 op) {
        return VectorTemplate$class.reduceLeft(this, op);
    }

    @Override
    public Object foldRight(Object z, Function2 op) {
        return VectorTemplate$class.foldRight(this, z, op);
    }

    @Override
    public Object foldLeft(Object z, Function2 op) {
        return VectorTemplate$class.foldLeft(this, z, op);
    }

    @Override
    public Option find(Function1 p) {
        return VectorTemplate$class.find(this, p);
    }

    @Override
    public boolean exists(Function1 p) {
        return VectorTemplate$class.exists(this, p);
    }

    @Override
    public boolean forall(Function1 p) {
        return VectorTemplate$class.forall(this, p);
    }

    @Override
    public void foreach(Function1 f) {
        VectorTemplate$class.foreach(this, f);
    }

    @Override
    public boolean isEmpty() {
        return VectorTemplate$class.isEmpty(this);
    }

    @Override
    public Iterator iterator() {
        return VectorTemplate$class.iterator(this);
    }

    @Override
    public final boolean scala$collection$generic$VectorTemplate$$super$equals(Object that) {
        return SequenceTemplate$class.equals(this, that);
    }

    @Override
    public final boolean scala$collection$generic$VectorTemplate$$super$endsWith(Sequence that) {
        return SequenceTemplate$class.endsWith(this, that);
    }

    @Override
    public final boolean scala$collection$generic$VectorTemplate$$super$sameElements(Iterable that) {
        return IterableTemplate$class.sameElements(this, that);
    }

    @Override
    public final VectorTemplate scala$collection$generic$VectorTemplate$$super$init() {
        return (VectorTemplate)TraversableTemplate$class.init(this);
    }

    @Override
    public final Object scala$collection$generic$VectorTemplate$$super$last() {
        return TraversableTemplate$class.last(this);
    }

    @Override
    public final Object scala$collection$generic$VectorTemplate$$super$head() {
        return IterableTemplate$class.head(this);
    }

    @Override
    public final Object scala$collection$generic$VectorTemplate$$super$zip(Sequence that, BuilderFactory bf) {
        return SequenceTemplate$class.zip(this, that, bf);
    }

    @Override
    public final Object scala$collection$generic$VectorTemplate$$super$reduceRight(Function2 op) {
        return IterableTemplate$class.reduceRight(this, op);
    }

    @Override
    public final Object scala$collection$generic$VectorTemplate$$super$reduceLeft(Function2 op) {
        return TraversableTemplate$class.reduceLeft(this, op);
    }

    @Override
    public MutableVectorView view(int from2, int until2) {
        return MutableVectorTemplate$class.view(this, from2, until2);
    }

    @Override
    public Object view() {
        return MutableVectorTemplate$class.view(this);
    }

    @Override
    public Companion companion() {
        return scala.collection.mutable.Vector$class.companion(this);
    }
}

