/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.mutable;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.Iterator$;
import scala.collection.Iterator$class;
import scala.collection.TraversableOnce$class;
import scala.collection.immutable.Range;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.FlatHashTable;
import scala.collection.mutable.FlatHashTable$;
import scala.collection.mutable.HashTable$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public abstract class FlatHashTable$class {
    public static int capacity(FlatHashTable $this, int expectedSize) {
        return expectedSize == 0 ? 1 : HashTable$.MODULE$.powerOfTwo(expectedSize);
    }

    private static int initialCapacity(FlatHashTable $this) {
        return $this.capacity(FlatHashTable$.MODULE$.initialSize());
    }

    public static void init(FlatHashTable $this, ObjectInputStream in, Function1 f2) {
        in.defaultReadObject();
        $this._loadFactor_$eq(in.readInt());
        Predef$.MODULE$.assert($this._loadFactor() > 0);
        int size2 = in.readInt();
        $this.tableSize_$eq(0);
        Predef$.MODULE$.assert(size2 >= 0);
        $this.table_$eq(new Object[$this.capacity(FlatHashTable$.MODULE$.sizeForThreshold(size2, $this._loadFactor()))]);
        $this.threshold_$eq(FlatHashTable$.MODULE$.newThreshold($this._loadFactor(), Predef$.MODULE$.refArrayOps($this.table()).size()));
        boolean smDefined = in.readBoolean();
        if (smDefined) {
            $this.sizeMapInit($this.table().length);
        } else {
            $this.sizemap_$eq(null);
        }
        for (int index2 = 0; index2 < size2; ++index2) {
            Object elem2 = in.readObject();
            f2.apply(elem2);
            $this.addEntry(elem2);
        }
    }

    public static void serializeTo(FlatHashTable $this, ObjectOutputStream out$1) {
        out$1.defaultWriteObject();
        out$1.writeInt($this._loadFactor());
        out$1.writeInt($this.tableSize());
        out$1.writeBoolean($this.isSizeMapDefined());
        $this.iterator().foreach(new Serializable($this, out$1){
            public static final long serialVersionUID;
            public final ObjectOutputStream out$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Object object) {
                this.out$1.writeObject(object);
            }
            {
                this.out$1 = flatHashTable;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public static Option findEntry(FlatHashTable $this, Object elem2) {
        int h = $this.index($this.elemHashCode(elem2));
        Object entry = $this.table()[h];
        void y1;
        void x1;
        Object object;
        Object object2;
        while (entry != null && !((object2 = entry) == (object = elem2) ? true : (x1 == null ? false : (x1 instanceof Number ? BoxesRunTime.equalsNumObject((Number)x1, y1) : (x1 instanceof Character ? BoxesRunTime.equalsCharObject((Character)x1, y1) : x1.equals(y1)))))) {
            h = (h + 1) % $this.table().length;
            entry = $this.table()[h];
        }
        return entry == null ? None$.MODULE$ : new Some<Object>(entry);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean containsEntry(FlatHashTable $this, Object elem2) {
        int h = $this.index($this.elemHashCode(elem2));
        Object entry = $this.table()[h];
        void y1;
        void x1;
        Object object;
        Object object2;
        while (entry != null && !((object2 = entry) == (object = elem2) ? true : (x1 == null ? false : (x1 instanceof Number ? BoxesRunTime.equalsNumObject((Number)x1, y1) : (x1 instanceof Character ? BoxesRunTime.equalsCharObject((Character)x1, y1) : x1.equals(y1)))))) {
            h = (h + 1) % $this.table().length;
            entry = $this.table()[h];
        }
        return entry != null;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean addEntry(FlatHashTable $this, Object elem2) {
        int h = $this.index($this.elemHashCode(elem2));
        Object entry = $this.table()[h];
        while (true) {
            void y1;
            void x1;
            if (entry == null) {
                $this.table()[h] = elem2;
                $this.tableSize_$eq($this.tableSize() + 1);
                $this.nnSizeMapAdd(h);
                if ($this.tableSize() >= $this.threshold()) {
                    FlatHashTable$class.growTable($this);
                }
                return true;
            }
            Object object = entry;
            Object object2 = elem2;
            if (object == object2 ? true : (x1 == null ? false : (x1 instanceof Number ? BoxesRunTime.equalsNumObject((Number)x1, y1) : (x1 instanceof Character ? BoxesRunTime.equalsCharObject((Character)x1, y1) : x1.equals(y1))))) {
                return false;
            }
            h = (h + 1) % $this.table().length;
            entry = $this.table()[h];
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Option removeEntry(FlatHashTable $this, Object elem2) {
        int h = $this.index($this.elemHashCode(elem2));
        Object entry = $this.table()[h];
        while (entry != null) {
            void y1;
            void x1;
            Object object = entry;
            Object object2 = elem2;
            if (object == object2 ? true : (x1 == null ? false : (x1 instanceof Number ? BoxesRunTime.equalsNumObject((Number)x1, y1) : (x1 instanceof Character ? BoxesRunTime.equalsCharObject((Character)x1, y1) : x1.equals(y1))))) {
                int h0 = h;
                int h1 = (h0 + 1) % $this.table().length;
                while (true) {
                    if ($this.table()[h1] == null) {
                        $this.table()[h0] = null;
                        $this.tableSize_$eq($this.tableSize() - 1);
                        $this.nnSizeMapRemove(h0);
                        return new Some<Object>(entry);
                    }
                    int h2 = $this.index($this.elemHashCode($this.table()[h1]));
                    if (h2 != h1 && FlatHashTable$class.precedes$1($this, h2, h0)) {
                        $this.table()[h0] = $this.table()[h1];
                        h0 = h1;
                    }
                    h1 = (h1 + 1) % $this.table().length;
                }
            }
            h = (h + 1) % $this.table().length;
            entry = $this.table()[h];
        }
        return None$.MODULE$;
    }

    public static Iterator iterator(FlatHashTable $this) {
        return new Iterator<A>($this){
            private int i;
            private final FlatHashTable $outer;

            private int i() {
                return this.i;
            }

            private void i_$eq(int n) {
                this.i = n;
            }

            public boolean hasNext() {
                while (this.i() < this.$outer.table().length && this.$outer.table()[this.i()] == null) {
                    this.i_$eq(this.i() + 1);
                }
                return this.i() < this.$outer.table().length;
            }

            public A next() {
                Object object;
                if (this.hasNext()) {
                    this.i_$eq(this.i() + 1);
                    object = this.$outer.table()[this.i() - 1];
                } else {
                    object = Iterator$.MODULE$.empty().next();
                }
                return object;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                TraversableOnce$class.$init$(this);
                Iterator$class.$init$(this);
                this.i = 0;
            }
        };
    }

    private static void growTable(FlatHashTable $this) {
        Object[] oldtable = $this.table();
        $this.table_$eq(new Object[$this.table().length * 2]);
        $this.tableSize_$eq(0);
        $this.nnSizeMapReset($this.table().length);
        $this.threshold_$eq(FlatHashTable$.MODULE$.newThreshold($this._loadFactor(), $this.table().length));
        for (int i = 0; i < oldtable.length; ++i) {
            Object entry = oldtable[i];
            if (entry == null) continue;
            $this.addEntry(entry);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void checkConsistent(FlatHashTable $this) {
        int n;
        int n2 = n = $this.table().length;
        int n3 = 0;
        Serializable serializable2 = new Serializable($this){
            public static final long serialVersionUID;
            public final FlatHashTable $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int v1$1) {
                if (this.$outer.table()[v1$1] != null && !this.$outer.containsEntry(this.$outer.table()[v1$1])) {
                    Predef$.MODULE$.assert(false, (Function0<Object>)((Object)new Serializable(this, v1$1){
                        public static final long serialVersionUID;
                        public final FlatHashTable$.anonfun.checkConsistent.1 $outer;
                        public final int v1$1;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply() {
                            return new StringBuilder().append(this.v1$1).append((Object)" ").append(this.$outer.$outer.table()[this.v1$1]).append((Object)" ").append((Object)Predef$.MODULE$.refArrayOps(this.$outer.$outer.table()).mkString()).toString();
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.v1$1 = n;
                        }
                    }));
                }
            }

            public FlatHashTable scala$collection$mutable$FlatHashTable$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        };
        Range range2 = new Range(n3, n2, 1);
        if (range2.length() > 0) {
            void v1$12;
            void f1;
            int i1;
            void $inlThis1;
            int last1 = $inlThis1.last();
            for (i1 = $inlThis1.start(); i1 != last1; i1 += $inlThis1.step()) {
                void v1$11;
                int n4 = i1;
                if ($this.table()[n4] == null || $this.containsEntry($this.table()[v1$11]) || false) {
                    continue;
                }
                Object[] objectArray = f1.$outer.table();
                throw new AssertionError((Object)new StringBuilder().append((Object)"assertion failed: ").append((Object)new StringBuilder().append(i1).append((Object)" ").append(f1.$outer.table()[i1]).append((Object)" ").append((Object)new ArrayOps.ofRef<Object>(objectArray).mkString()).toString()).toString());
            }
            int n5 = i1;
            if ($this.table()[n5] != null && !$this.containsEntry($this.table()[v1$12]) && !false) {
                Object[] objectArray = f1.$outer.table();
                throw new AssertionError((Object)new StringBuilder().append((Object)"assertion failed: ").append((Object)new StringBuilder().append(i1).append((Object)" ").append(f1.$outer.table()[i1]).append((Object)" ").append((Object)new ArrayOps.ofRef<Object>(objectArray).mkString()).toString()).toString());
            }
        }
    }

    public static void nnSizeMapAdd(FlatHashTable $this, int h) {
        if ($this.sizemap() != null) {
            int p = h >> $this.sizeMapBucketBitSize();
            int[] nArray = $this.sizemap();
            nArray[p] = nArray[p] + 1;
        }
    }

    public static void nnSizeMapRemove(FlatHashTable $this, int h) {
        if ($this.sizemap() != null) {
            int[] nArray = $this.sizemap();
            int n = h >> $this.sizeMapBucketBitSize();
            nArray[n] = nArray[n] - 1;
        }
    }

    public static void nnSizeMapReset(FlatHashTable $this, int tableLength) {
        if ($this.sizemap() != null) {
            int nsize = $this.calcSizeMapSize(tableLength);
            if ($this.sizemap().length != nsize) {
                $this.sizemap_$eq(new int[nsize]);
            } else {
                Arrays.fill($this.sizemap(), 0);
            }
        }
    }

    public static final int totalSizeMapBuckets(FlatHashTable $this) {
        return $this.sizeMapBucketSize() < $this.table().length ? 1 : $this.table().length / $this.sizeMapBucketSize();
    }

    public static int calcSizeMapSize(FlatHashTable $this, int tableLength) {
        return (tableLength >> $this.sizeMapBucketBitSize()) + 1;
    }

    public static void sizeMapInit(FlatHashTable $this, int tableLength) {
        $this.sizemap_$eq(new int[$this.calcSizeMapSize(tableLength)]);
    }

    public static void sizeMapInitAndRebuild(FlatHashTable $this) {
        $this.sizeMapInit($this.table().length);
        int totalbuckets = $this.totalSizeMapBuckets();
        int tableidx = 0;
        Object[] tbl = $this.table();
        int tableuntil = Predef$.MODULE$.intWrapper($this.sizeMapBucketSize()).min(tbl.length);
        for (int bucketidx = 0; bucketidx < totalbuckets; ++bucketidx) {
            int currbucketsz = 0;
            while (tableidx < tableuntil) {
                if (tbl[tableidx] != null) {
                    ++currbucketsz;
                }
                ++tableidx;
            }
            $this.sizemap()[bucketidx] = currbucketsz;
            tableuntil += $this.sizeMapBucketSize();
        }
    }

    public static void printSizeMap(FlatHashTable $this) {
        Predef$.MODULE$.println(Predef$.MODULE$.intArrayOps($this.sizemap()).toList());
    }

    public static void sizeMapDisable(FlatHashTable $this) {
        $this.sizemap_$eq(null);
    }

    public static boolean isSizeMapDefined(FlatHashTable $this) {
        return $this.sizemap() != null;
    }

    public static boolean alwaysInitSizeMap(FlatHashTable $this) {
        return false;
    }

    public static final int index(FlatHashTable $this, int hcode) {
        int improved = $this.improve(hcode);
        int ones = $this.table().length - 1;
        return improved >> 32 - Integer.bitCount(ones) & ones;
    }

    public static void clearTable(FlatHashTable $this) {
        for (int i = $this.table().length - 1; i >= 0; --i) {
            $this.table()[i] = null;
        }
        $this.tableSize_$eq(0);
        $this.nnSizeMapReset($this.table().length);
    }

    public static FlatHashTable.Contents hashTableContents(FlatHashTable $this) {
        return new FlatHashTable.Contents($this._loadFactor(), $this.table(), $this.tableSize(), $this.threshold(), $this.sizemap());
    }

    public static void initWithContents(FlatHashTable $this, FlatHashTable.Contents c) {
        if (c != null) {
            $this._loadFactor_$eq(c.loadFactor());
            $this.table_$eq(c.table());
            $this.tableSize_$eq(c.tableSize());
            $this.threshold_$eq(c.threshold());
            $this.sizemap_$eq(c.sizemap());
        }
        if ($this.alwaysInitSizeMap() && $this.sizemap() == null) {
            $this.sizeMapInitAndRebuild();
        }
    }

    private static final boolean precedes$1(FlatHashTable $this, int i, int j) {
        int d = $this.table().length >> 1;
        return i <= j ? j - i < d : i - j > d;
    }

    public static void $init$(FlatHashTable $this) {
        $this._loadFactor_$eq(FlatHashTable$.MODULE$.defaultLoadFactor());
        $this.table_$eq(new Object[FlatHashTable$class.initialCapacity($this)]);
        $this.tableSize_$eq(0);
        $this.threshold_$eq(FlatHashTable$.MODULE$.newThreshold($this._loadFactor(), FlatHashTable$class.initialCapacity($this)));
        $this.sizemap_$eq(null);
    }
}

