/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.mutable;

import scala.Array$;
import scala.collection.Iterator;
import scala.collection.StrictOptimizedSeqOps;
import scala.collection.generic.CommonErrors$;
import scala.collection.mutable.ArrayDeque$;
import scala.runtime.ScalaRunTime$;

public interface ArrayDequeOps<A, CC, C>
extends StrictOptimizedSeqOps<A, CC, C> {
    public static void $init$(ArrayDequeOps $this) {
    }

    public /* synthetic */ Iterator scala$collection$mutable$ArrayDequeOps$$super$sliding(int var1, int var2);

    public Object[] array();

    public static Object clone$(ArrayDequeOps $this) {
        return $this.clone();
    }

    default public C clone() {
        return this.klone();
    }

    public C klone();

    public C ofArray(Object[] var1, int var2);

    public int start_$plus(int var1);

    public static void requireBounds$(ArrayDequeOps $this, int idx, int until) {
        $this.requireBounds(idx, until);
    }

    default public void requireBounds(int idx, int until) {
        if (idx < 0 || idx >= until) {
            throw CommonErrors$.MODULE$.indexOutOfBounds(idx, until - 1);
        }
    }

    public static int requireBounds$default$2$(ArrayDequeOps $this) {
        return $this.requireBounds$default$2();
    }

    default public int requireBounds$default$2() {
        return this.length();
    }

    public static Object copySliceToArray$(ArrayDequeOps $this, int srcStart, Object dest, int destStart, int maxItems) {
        return $this.copySliceToArray(srcStart, dest, destStart, maxItems);
    }

    default public Object copySliceToArray(int srcStart, Object dest, int destStart, int maxItems) {
        this.requireBounds(destStart, ScalaRunTime$.MODULE$.array_length(dest) + 1);
        int toCopy = Math.min(maxItems, Math.min(this.length() - srcStart, ScalaRunTime$.MODULE$.array_length(dest) - destStart));
        if (toCopy > 0) {
            this.requireBounds(srcStart, this.requireBounds$default$2());
            int startIdx = this.start_$plus(srcStart);
            int block1 = Math.min(toCopy, this.array().length - startIdx);
            Array$.MODULE$.copy(this.array(), startIdx, dest, destStart, block1);
            int block2 = toCopy - block1;
            if (block2 > 0) {
                Array$.MODULE$.copy(this.array(), 0, dest, destStart + block1, block2);
            }
        }
        return dest;
    }

    public static Object reverse$(ArrayDequeOps $this) {
        return $this.reverse();
    }

    @Override
    default public C reverse() {
        int n = this.length();
        Object[] arr = ArrayDeque$.MODULE$.alloc(n);
        for (int i = 0; i < n; ++i) {
            arr[i] = this.apply(n - i - 1);
        }
        return this.ofArray(arr, n);
    }

    public static Object slice$(ArrayDequeOps $this, int from, int until) {
        return $this.slice(from, until);
    }

    @Override
    default public C slice(int from, int until) {
        int n = this.length();
        int left = Math.max(0, Math.min(n, from));
        int right = Math.max(0, Math.min(n, until));
        int len = right - left;
        if (len <= 0) {
            return this.empty();
        }
        if (len >= n) {
            return this.klone();
        }
        Object[] array2 = (Object[])this.copySliceToArray(left, ArrayDeque$.MODULE$.alloc(len), 0, len);
        return this.ofArray(array2, len);
    }

    public static Iterator sliding$(ArrayDequeOps $this, int size, int step) {
        return $this.sliding(size, step);
    }

    @Override
    default public Iterator<C> sliding(int size, int step) {
        return this.scala$collection$mutable$ArrayDequeOps$$super$sliding(size, step);
    }

    public static Iterator grouped$(ArrayDequeOps $this, int n) {
        return $this.grouped(n);
    }

    @Override
    default public Iterator<C> grouped(int n) {
        return this.sliding(n, n);
    }
}

