/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.semanticdb;

import dotty.tools.dotc.semanticdb.ApplyTree;
import dotty.tools.dotc.semanticdb.FunctionTree;
import dotty.tools.dotc.semanticdb.IdTree;
import dotty.tools.dotc.semanticdb.LiteralTree;
import dotty.tools.dotc.semanticdb.MacroExpansionTree;
import dotty.tools.dotc.semanticdb.OriginalTree;
import dotty.tools.dotc.semanticdb.PPrint$package$;
import dotty.tools.dotc.semanticdb.PrinterSymtab;
import dotty.tools.dotc.semanticdb.Range;
import dotty.tools.dotc.semanticdb.SelectTree;
import dotty.tools.dotc.semanticdb.SymbolInformationPrinter;
import dotty.tools.dotc.semanticdb.Synthetic;
import dotty.tools.dotc.semanticdb.Tree;
import dotty.tools.dotc.semanticdb.Type;
import dotty.tools.dotc.semanticdb.TypeApplyTree;
import dotty.tools.dotc.util.SourceFile;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;

public class SyntheticPrinter
extends SymbolInformationPrinter {
    private final SourceFile source;

    public SyntheticPrinter(PrinterSymtab symtab, SourceFile source) {
        this.source = source;
        super(symtab);
    }

    public String pprint(Synthetic synth) {
        StringBuilder stringBuilder;
        StringBuilder sb = new StringBuilder();
        SymbolInformationPrinter.InfoNotes notes = new SymbolInformationPrinter.InfoNotes(this);
        TreePrinter treePrinter = new TreePrinter(this, this.source, synth.range(), notes);
        Option<Range> option = synth.range();
        if (option instanceof Some) {
            Range range = (Range)((Some)option).value();
            PPrint$package$.MODULE$.processRange(sb, range);
            stringBuilder = sb.append(this.substring(this.source, range));
        } else if (None$.MODULE$.equals(option)) {
            stringBuilder = sb.append("[):");
        } else {
            throw new MatchError(option);
        }
        sb.append(" => ");
        sb.append(treePrinter.pprint(synth.tree()));
        return sb.toString();
    }

    public String dotty$tools$dotc$semanticdb$SyntheticPrinter$$substring(SourceFile source, Option<Range> range) {
        String string;
        Option<Range> option = range;
        if (option instanceof Some) {
            Range range2 = (Range)((Some)option).value();
            string = this.substring(source, range2);
        } else if (None$.MODULE$.equals(option)) {
            string = "";
        } else {
            throw new MatchError(option);
        }
        return string;
    }

    private String substring(SourceFile source, Range range) {
        int start = source.lineToOffset(range.startLine()) + package$.MODULE$.min(range.startCharacter(), SyntheticPrinter.lineLength$1(source, range.startLine()));
        int end = source.lineToOffset(range.endLine()) + package$.MODULE$.min(range.endCharacter(), SyntheticPrinter.lineLength$1(source, range.endLine()));
        return new String(source.content(), start, end - start);
    }

    private static final int lineLength$1(SourceFile source$1, int line) {
        boolean isLastLine = source$1.lineToOffsetOpt(line).nonEmpty() && source$1.lineToOffsetOpt(line + 1).isEmpty();
        return isLastLine ? source$1.content().length - source$1.lineToOffset(line) - 1 : source$1.lineToOffset(line + 1) - source$1.lineToOffset(line) - 1;
    }

    private static final Object x$1(Tuple2 x$1$1) {
        return x$1$1._1();
    }

    private static final int i$1(Tuple2 x$1$2) {
        return BoxesRunTime.unboxToInt((Object)x$1$2._2());
    }

    public static final /* synthetic */ void dotty$tools$dotc$semanticdb$SyntheticPrinter$TreePrinter$$_$rep$$anonfun$1(String seq$1, Function1 f$1, StringBuilder sb$2, Tuple2 x$1) {
        if (SyntheticPrinter.i$1(x$1) != 0) {
            sb$2.append(seq$1);
        }
        f$1.apply(SyntheticPrinter.x$1(x$1));
    }

    public static final /* synthetic */ void dotty$tools$dotc$semanticdb$SyntheticPrinter$TreePrinter$$_$processTree$$anonfun$1(StringBuilder sb$3, TreePrinter $this$1, Tree tree) {
        $this$1.dotty$tools$dotc$semanticdb$SyntheticPrinter$TreePrinter$$processTree(tree, sb$3);
    }

    public static final /* synthetic */ void dotty$tools$dotc$semanticdb$SyntheticPrinter$TreePrinter$$_$processTree$$anonfun$2(StringBuilder sb$4, TreePrinter $this$2, Tree tree) {
        $this$2.dotty$tools$dotc$semanticdb$SyntheticPrinter$TreePrinter$$processTree(tree, sb$4);
    }

    public static final /* synthetic */ void dotty$tools$dotc$semanticdb$SyntheticPrinter$TreePrinter$$_$processTree$$anonfun$3(StringBuilder sb$5, TreePrinter $this$3, Type t) {
        sb$5.append($this$3.pprint(t));
    }

    public class TreePrinter
    extends SymbolInformationPrinter.InfoPrinter {
        private final SourceFile source;
        private final Option<Range> originalRange;
        private final SyntheticPrinter $outer;

        public TreePrinter(SyntheticPrinter $outer, SourceFile source, Option<Range> originalRange, SymbolInformationPrinter.InfoNotes notes) {
            this.source = source;
            this.originalRange = originalRange;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            super($outer, notes);
        }

        public String pprint(Tree tree) {
            StringBuilder sb = new StringBuilder();
            this.dotty$tools$dotc$semanticdb$SyntheticPrinter$TreePrinter$$processTree(tree, sb);
            return sb.toString();
        }

        private <T> void rep(Seq<T> xs, String seq, Function1<T, BoxedUnit> f, StringBuilder sb) {
            ((IterableOnceOps)xs.zipWithIndex()).foreach((Function1)((JProcedure1 & Serializable)arg_0 -> SyntheticPrinter.dotty$tools$dotc$semanticdb$SyntheticPrinter$TreePrinter$$_$rep$$anonfun$1(seq, f, sb, arg_0)));
        }

        public void dotty$tools$dotc$semanticdb$SyntheticPrinter$TreePrinter$$processTree(Tree tree, StringBuilder sb) {
            block12: {
                Tree tree2;
                TreePrinter treePrinter;
                block13: {
                    Option<IdTree> option;
                    treePrinter = this;
                    Tree tree3 = tree;
                    while (true) {
                        if ((tree2 = tree3) instanceof ApplyTree) {
                            ApplyTree tree4 = (ApplyTree)tree2;
                            treePrinter.dotty$tools$dotc$semanticdb$SyntheticPrinter$TreePrinter$$processTree(tree4.function(), sb);
                            sb.append("(");
                            treePrinter.rep((Seq)tree4.arguments(), ", ", (Function1)((JProcedure1 & Serializable)arg_0 -> SyntheticPrinter.dotty$tools$dotc$semanticdb$SyntheticPrinter$TreePrinter$$_$processTree$$anonfun$1(sb, treePrinter, arg_0)), sb);
                            sb.append(")");
                            break block12;
                        }
                        if (tree2 instanceof FunctionTree) {
                            FunctionTree tree5 = (FunctionTree)tree2;
                            sb.append("{");
                            sb.append("(");
                            treePrinter.rep((Seq)tree5.parameters(), ", ", (Function1)((JProcedure1 & Serializable)arg_0 -> SyntheticPrinter.dotty$tools$dotc$semanticdb$SyntheticPrinter$TreePrinter$$_$processTree$$anonfun$2(sb, treePrinter, arg_0)), sb);
                            sb.append(") =>");
                            treePrinter.dotty$tools$dotc$semanticdb$SyntheticPrinter$TreePrinter$$processTree(tree5.body(), sb);
                            sb.append("}");
                            break block12;
                        }
                        if (tree2 instanceof IdTree) {
                            IdTree tree6 = (IdTree)tree2;
                            sb.append(treePrinter.pprintRef(tree6.symbol()));
                            break block12;
                        }
                        if (tree2 instanceof LiteralTree) {
                            LiteralTree tree7 = (LiteralTree)tree2;
                            sb.append(treePrinter.pprint(tree7.constant()));
                            break block12;
                        }
                        if (tree2 instanceof MacroExpansionTree) {
                            MacroExpansionTree tree8 = (MacroExpansionTree)tree2;
                            sb.append("(`macro-expandee` : `");
                            sb.append(treePrinter.pprint(tree8.tpe()));
                            sb.append(")");
                            break block12;
                        }
                        if (tree2 instanceof OriginalTree) {
                            OriginalTree tree9 = (OriginalTree)tree2;
                            Option<Range> option2 = tree9.range();
                            Option<Range> option3 = treePrinter.originalRange;
                            if (!(option2 != null ? !option2.equals(option3) : option3 != null) && treePrinter.originalRange.nonEmpty()) {
                                sb.append("*");
                            } else {
                                sb.append("orig(");
                                sb.append(treePrinter.$outer.dotty$tools$dotc$semanticdb$SyntheticPrinter$$substring(treePrinter.source, tree9.range()));
                                sb.append(")");
                            }
                            break block12;
                        }
                        if (!(tree2 instanceof SelectTree)) break block13;
                        SelectTree tree10 = (SelectTree)tree2;
                        treePrinter.dotty$tools$dotc$semanticdb$SyntheticPrinter$TreePrinter$$processTree(tree10.qualifier(), sb);
                        sb.append(".");
                        option = tree10.id();
                        if (!(option instanceof Some)) break;
                        IdTree tree11 = (IdTree)((Some)option).value();
                        TreePrinter treePrinter2 = treePrinter;
                        IdTree idTree = tree11;
                        treePrinter = treePrinter2;
                        tree3 = idTree;
                    }
                    if (!None$.MODULE$.equals(option)) {
                        throw new MatchError(option);
                    }
                    break block12;
                }
                if (tree2 instanceof TypeApplyTree) {
                    TypeApplyTree tree12 = (TypeApplyTree)tree2;
                    treePrinter.dotty$tools$dotc$semanticdb$SyntheticPrinter$TreePrinter$$processTree(tree12.function(), sb);
                    sb.append("[");
                    treePrinter.rep((Seq)tree12.typeArguments(), ", ", (Function1)((JProcedure1 & Serializable)arg_0 -> SyntheticPrinter.dotty$tools$dotc$semanticdb$SyntheticPrinter$TreePrinter$$_$processTree$$anonfun$3(sb, treePrinter, arg_0)), sb);
                    sb.append("]");
                } else {
                    sb.append("<?>");
                }
            }
        }

        public final SyntheticPrinter dotty$tools$dotc$semanticdb$SyntheticPrinter$TreePrinter$$$outer() {
            return this.$outer;
        }
    }
}

