/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.pc;

import java.io.Serializable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicReference;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.meta.internal.pc.CompilerJobQueue;
import scala.meta.internal.pc.CompilerJobQueue$;
import scala.meta.internal.pc.CompilerJobQueue$State$;
import scala.meta.internal.pc.CompilerJobQueue$State$Empty$;
import scala.meta.internal.pc.CompilerJobQueue$State$Initialized$;
import scala.meta.internal.pc.CompilerJobQueue$State$Initializing$;
import scala.meta.internal.pc.CompilerJobQueue$State$Stopped$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public class CompilerJobQueue {
    private final Function0<ThreadPoolExecutor> newExecutor;
    private final AtomicReference<State> state;

    public static CompilerJobQueue apply() {
        return CompilerJobQueue$.MODULE$.apply();
    }

    public CompilerJobQueue(Function0<ThreadPoolExecutor> newExecutor) {
        this.newExecutor = newExecutor;
        this.state = new AtomicReference<CompilerJobQueue$State$Empty$>(CompilerJobQueue$State$Empty$.MODULE$);
    }

    public void submit(Function0<BoxedUnit> fn) {
        this.submit(new CompletableFuture(), fn);
    }

    public void submit(CompletableFuture<?> result, Function0<BoxedUnit> fn) {
        this.onExecutor((Function1 & Serializable)_$1 -> {
            _$1.execute(new Job(result, fn));
            return BoxedUnit.UNIT;
        }, (Function0 & Serializable)() -> BoxesRunTime.boxToBoolean((boolean)result.completeExceptionally(new CancellationException())));
    }

    private <A> A onExecutor(Function1<ThreadPoolExecutor, A> f, Function0<A> fallback) {
        State state;
        while (true) {
            if (CompilerJobQueue$State$Empty$.MODULE$.equals(state = this.state.get())) {
                if (this.state.compareAndSet(CompilerJobQueue$State$Empty$.MODULE$, CompilerJobQueue$State$Initializing$.MODULE$)) {
                    ThreadPoolExecutor value = (ThreadPoolExecutor)this.newExecutor.apply();
                    this.state.set(CompilerJobQueue$State$Initialized$.MODULE$.apply(value));
                    return (A)f.apply((Object)value);
                }
                this.delay();
                continue;
            }
            if (state instanceof State.Initialized) {
                ThreadPoolExecutor threadPoolExecutor;
                State.Initialized initialized = (State.Initialized)state;
                State.Initialized initialized2 = CompilerJobQueue$State$Initialized$.MODULE$.unapply(initialized);
                ThreadPoolExecutor v = threadPoolExecutor = initialized2._1();
                return (A)f.apply((Object)v);
            }
            if (!CompilerJobQueue$State$Initializing$.MODULE$.equals(state)) break;
            this.delay();
        }
        if (CompilerJobQueue$State$Stopped$.MODULE$.equals(state)) {
            return (A)fallback.apply();
        }
        throw new MatchError((Object)state);
    }

    public void shutdown() {
        State state = this.state.get();
        if (CompilerJobQueue$State$Empty$.MODULE$.equals(state)) {
            if (!this.state.compareAndSet(CompilerJobQueue$State$Empty$.MODULE$, CompilerJobQueue$State$Stopped$.MODULE$)) {
                this.delay();
                this.shutdown();
                return;
            }
            return;
        }
        if (state instanceof State.Initialized) {
            ThreadPoolExecutor threadPoolExecutor;
            State.Initialized initialized = (State.Initialized)state;
            State.Initialized initialized2 = CompilerJobQueue$State$Initialized$.MODULE$.unapply(initialized);
            ThreadPoolExecutor v = threadPoolExecutor = initialized2._1();
            State.Initialized curr = initialized;
            if (this.state.compareAndSet(curr, CompilerJobQueue$State$Stopped$.MODULE$)) {
                v.shutdown();
                return;
            }
            this.delay();
            this.shutdown();
            return;
        }
        if (CompilerJobQueue$State$Initializing$.MODULE$.equals(state)) {
            this.delay();
            this.shutdown();
            return;
        }
        if (CompilerJobQueue$State$Stopped$.MODULE$.equals(state)) {
            return;
        }
        throw new MatchError((Object)state);
    }

    public void reset() {
        State state = this.state.get();
        if (state instanceof State.Initialized) {
            ThreadPoolExecutor threadPoolExecutor;
            State.Initialized initialized = (State.Initialized)state;
            State.Initialized initialized2 = CompilerJobQueue$State$Initialized$.MODULE$.unapply(initialized);
            ThreadPoolExecutor v = threadPoolExecutor = initialized2._1();
            State.Initialized curr = initialized;
            if (this.state.compareAndSet(curr, CompilerJobQueue$State$Empty$.MODULE$)) {
                v.shutdown();
                return;
            }
            this.delay();
            this.reset();
            return;
        }
    }

    private void delay() {
        Thread.sleep(50L);
    }

    public String toString() {
        return new StringBuilder(18).append("CompilerJobQueue(").append(this.state.get()).append(")").toString();
    }

    public void finalize() {
        this.shutdown();
    }

    public static class Job
    implements Runnable {
        private final CompletableFuture<?> result;
        private final Function0<BoxedUnit> _run;
        private final long start;

        public Job(CompletableFuture<?> result, Function0<BoxedUnit> _run) {
            this.result = result;
            this._run = _run;
            this.start = System.nanoTime();
        }

        public void reject() {
            this.result.completeExceptionally(new CancellationException("rejected"));
        }

        public long start() {
            return this.start;
        }

        @Override
        public void run() {
            if (!this.result.isDone()) {
                this._run.apply$mcV$sp();
                return;
            }
        }
    }

    public static class LastInFirstOutBlockingQueue
    extends PriorityBlockingQueue<Runnable> {
        public LastInFirstOutBlockingQueue() {
            super(10, CompilerJobQueue$.MODULE$.scala$meta$internal$pc$CompilerJobQueue$$$LastInFirstOutBlockingQueue$superArg$1());
        }
    }

    public static interface State {
        public static int ordinal(State state) {
            return CompilerJobQueue$State$.MODULE$.ordinal(state);
        }
    }
}

