/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.scalap;

import scala.Predef$;
import scala.ScalaObject;
import scala.io.Codec$;

public class ByteArrayReader
implements ScalaObject {
    private int bp;
    private final byte[] buf;

    public ByteArrayReader(byte[] content) {
        this.buf = content;
        this.bp = 0;
    }

    public void skip(int n) {
        this.bp_$eq(this.bp() + n);
    }

    public double getDouble(int bp) {
        return Double.longBitsToDouble(this.getLong(bp));
    }

    public float getFloat(int bp) {
        return Float.intBitsToFloat(this.getInt(bp));
    }

    public long getLong(int bp) {
        return ((long)this.getInt(bp) << 32) + ((long)this.getInt(bp + 4) & 0xFFFFFFFFL);
    }

    public int getInt(int bp) {
        return ((this.buf()[bp] & 0xFF) << 24) + ((this.buf()[bp + 1] & 0xFF) << 16) + ((this.buf()[bp + 2] & 0xFF) << 8) + (this.buf()[bp + 3] & 0xFF);
    }

    public char getChar(int bp) {
        return (char)(((this.buf()[bp] & 0xFF) << 8) + (this.buf()[bp + 1] & 0xFF));
    }

    public String nextUTF8(int len) {
        char[] cs = Codec$.MODULE$.toUTF8((byte[])Predef$.MODULE$.byteArrayOps(this.buf()).slice(this.bp(), this.bp() + len));
        this.bp_$eq(this.bp() + len);
        return new String(cs);
    }

    public double nextDouble() {
        return Double.longBitsToDouble(this.nextLong());
    }

    public float nextFloat() {
        return Float.intBitsToFloat(this.nextInt());
    }

    public long nextLong() {
        this.bp_$eq(this.bp() + 8);
        return this.getLong(this.bp() - 8);
    }

    public int nextInt() {
        this.bp_$eq(this.bp() + 4);
        return this.getInt(this.bp() - 4);
    }

    public char nextChar() {
        this.bp_$eq(this.bp() + 2);
        return this.getChar(this.bp() - 2);
    }

    /*
     * WARNING - void declaration
     */
    public byte[] nextBytes(int len) {
        void var2_2;
        byte[] res = new byte[len];
        System.arraycopy(this.buf(), this.bp(), res, 0, len);
        this.bp_$eq(this.bp() + len);
        return var2_2;
    }

    public byte nextByte() {
        this.bp_$eq(this.bp() + 1);
        return this.buf()[this.bp() - 1];
    }

    public byte byteAt(int pos) {
        return this.buf()[pos];
    }

    public void bp_$eq(int n) {
        this.bp = n;
    }

    public int bp() {
        return this.bp;
    }

    public byte[] buf() {
        return this.buf;
    }
}

