/*
 * Decompiled with CFR 0.152.
 */
package scala.scalanative.nir.serialization;

import java.io.Serializable;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.UnrolledBuffer;
import scala.collection.mutable.UnrolledBuffer$;
import scala.reflect.ClassTag$;
import scala.reflect.NameTransformer$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.Scala3RunTime$;
import scala.scalanative.nir.Attr;
import scala.scalanative.nir.Attr$Abstract$;
import scala.scalanative.nir.Attr$AlwaysInline$;
import scala.scalanative.nir.Attr$BailOpt$;
import scala.scalanative.nir.Attr$DidOpt$;
import scala.scalanative.nir.Attr$Dyn$;
import scala.scalanative.nir.Attr$Extern$;
import scala.scalanative.nir.Attr$InlineHint$;
import scala.scalanative.nir.Attr$Link$;
import scala.scalanative.nir.Attr$LinktimeResolved$;
import scala.scalanative.nir.Attr$MayInline$;
import scala.scalanative.nir.Attr$MaySpecialize$;
import scala.scalanative.nir.Attr$NoInline$;
import scala.scalanative.nir.Attr$NoOpt$;
import scala.scalanative.nir.Attr$NoSpecialize$;
import scala.scalanative.nir.Attr$Stub$;
import scala.scalanative.nir.Attr$UnOpt$;
import scala.scalanative.nir.Attrs;
import scala.scalanative.nir.Attrs$;
import scala.scalanative.nir.Bin;
import scala.scalanative.nir.Bin$And$;
import scala.scalanative.nir.Bin$Ashr$;
import scala.scalanative.nir.Bin$Fadd$;
import scala.scalanative.nir.Bin$Fdiv$;
import scala.scalanative.nir.Bin$Fmul$;
import scala.scalanative.nir.Bin$Frem$;
import scala.scalanative.nir.Bin$Fsub$;
import scala.scalanative.nir.Bin$Iadd$;
import scala.scalanative.nir.Bin$Imul$;
import scala.scalanative.nir.Bin$Isub$;
import scala.scalanative.nir.Bin$Lshr$;
import scala.scalanative.nir.Bin$Or$;
import scala.scalanative.nir.Bin$Sdiv$;
import scala.scalanative.nir.Bin$Shl$;
import scala.scalanative.nir.Bin$Srem$;
import scala.scalanative.nir.Bin$Udiv$;
import scala.scalanative.nir.Bin$Urem$;
import scala.scalanative.nir.Bin$Xor$;
import scala.scalanative.nir.Comp;
import scala.scalanative.nir.Comp$Feq$;
import scala.scalanative.nir.Comp$Fge$;
import scala.scalanative.nir.Comp$Fgt$;
import scala.scalanative.nir.Comp$Fle$;
import scala.scalanative.nir.Comp$Flt$;
import scala.scalanative.nir.Comp$Fne$;
import scala.scalanative.nir.Comp$Ieq$;
import scala.scalanative.nir.Comp$Ine$;
import scala.scalanative.nir.Comp$Sge$;
import scala.scalanative.nir.Comp$Sgt$;
import scala.scalanative.nir.Comp$Sle$;
import scala.scalanative.nir.Comp$Slt$;
import scala.scalanative.nir.Comp$Uge$;
import scala.scalanative.nir.Comp$Ugt$;
import scala.scalanative.nir.Comp$Ule$;
import scala.scalanative.nir.Comp$Ult$;
import scala.scalanative.nir.Conv;
import scala.scalanative.nir.Conv$Bitcast$;
import scala.scalanative.nir.Conv$Fpext$;
import scala.scalanative.nir.Conv$Fptosi$;
import scala.scalanative.nir.Conv$Fptoui$;
import scala.scalanative.nir.Conv$Fptrunc$;
import scala.scalanative.nir.Conv$Inttoptr$;
import scala.scalanative.nir.Conv$Ptrtoint$;
import scala.scalanative.nir.Conv$Sext$;
import scala.scalanative.nir.Conv$Sitofp$;
import scala.scalanative.nir.Conv$Trunc$;
import scala.scalanative.nir.Conv$Uitofp$;
import scala.scalanative.nir.Conv$Zext$;
import scala.scalanative.nir.Defn;
import scala.scalanative.nir.Defn$Class$;
import scala.scalanative.nir.Defn$Const$;
import scala.scalanative.nir.Defn$Declare$;
import scala.scalanative.nir.Defn$Define$;
import scala.scalanative.nir.Defn$Module$;
import scala.scalanative.nir.Defn$Trait$;
import scala.scalanative.nir.Defn$Var$;
import scala.scalanative.nir.Global;
import scala.scalanative.nir.Global$Member$;
import scala.scalanative.nir.Global$None$;
import scala.scalanative.nir.Global$Top$;
import scala.scalanative.nir.Inst;
import scala.scalanative.nir.Inst$If$;
import scala.scalanative.nir.Inst$Jump$;
import scala.scalanative.nir.Inst$Label$;
import scala.scalanative.nir.Inst$Let$;
import scala.scalanative.nir.Inst$LinktimeIf$;
import scala.scalanative.nir.Inst$Ret$;
import scala.scalanative.nir.Inst$Switch$;
import scala.scalanative.nir.Inst$Throw$;
import scala.scalanative.nir.Inst$Unreachable$;
import scala.scalanative.nir.LinktimeCondition;
import scala.scalanative.nir.LinktimeCondition$ComplexCondition$;
import scala.scalanative.nir.LinktimeCondition$SimpleCondition$;
import scala.scalanative.nir.Local$;
import scala.scalanative.nir.Next;
import scala.scalanative.nir.Next$Case$;
import scala.scalanative.nir.Next$Label$;
import scala.scalanative.nir.Next$None$;
import scala.scalanative.nir.Next$Unwind$;
import scala.scalanative.nir.Op;
import scala.scalanative.nir.Op$Arrayalloc$;
import scala.scalanative.nir.Op$Arraylength$;
import scala.scalanative.nir.Op$Arrayload$;
import scala.scalanative.nir.Op$Arraystore$;
import scala.scalanative.nir.Op$As$;
import scala.scalanative.nir.Op$Bin$;
import scala.scalanative.nir.Op$Box$;
import scala.scalanative.nir.Op$Call$;
import scala.scalanative.nir.Op$Classalloc$;
import scala.scalanative.nir.Op$Comp$;
import scala.scalanative.nir.Op$Conv$;
import scala.scalanative.nir.Op$Copy$;
import scala.scalanative.nir.Op$Dynmethod$;
import scala.scalanative.nir.Op$Elem$;
import scala.scalanative.nir.Op$Extract$;
import scala.scalanative.nir.Op$Field$;
import scala.scalanative.nir.Op$Fieldload$;
import scala.scalanative.nir.Op$Fieldstore$;
import scala.scalanative.nir.Op$Insert$;
import scala.scalanative.nir.Op$Is$;
import scala.scalanative.nir.Op$Load$;
import scala.scalanative.nir.Op$Method$;
import scala.scalanative.nir.Op$Module$;
import scala.scalanative.nir.Op$Sizeof$;
import scala.scalanative.nir.Op$Stackalloc$;
import scala.scalanative.nir.Op$Store$;
import scala.scalanative.nir.Op$Unbox$;
import scala.scalanative.nir.Op$Var$;
import scala.scalanative.nir.Op$Varload$;
import scala.scalanative.nir.Op$Varstore$;
import scala.scalanative.nir.Position;
import scala.scalanative.nir.Position$;
import scala.scalanative.nir.Prelude;
import scala.scalanative.nir.Prelude$;
import scala.scalanative.nir.Sig;
import scala.scalanative.nir.Sig$;
import scala.scalanative.nir.Type;
import scala.scalanative.nir.Type$Array$;
import scala.scalanative.nir.Type$ArrayValue$;
import scala.scalanative.nir.Type$Bool$;
import scala.scalanative.nir.Type$Byte$;
import scala.scalanative.nir.Type$Char$;
import scala.scalanative.nir.Type$Double$;
import scala.scalanative.nir.Type$Float$;
import scala.scalanative.nir.Type$Function$;
import scala.scalanative.nir.Type$Int$;
import scala.scalanative.nir.Type$Long$;
import scala.scalanative.nir.Type$Nothing$;
import scala.scalanative.nir.Type$Null$;
import scala.scalanative.nir.Type$Ptr$;
import scala.scalanative.nir.Type$Ref$;
import scala.scalanative.nir.Type$Short$;
import scala.scalanative.nir.Type$StructValue$;
import scala.scalanative.nir.Type$Unit$;
import scala.scalanative.nir.Type$Var$;
import scala.scalanative.nir.Type$Vararg$;
import scala.scalanative.nir.Type$Virtual$;
import scala.scalanative.nir.Val;
import scala.scalanative.nir.Val$ArrayValue$;
import scala.scalanative.nir.Val$Byte$;
import scala.scalanative.nir.Val$Char$;
import scala.scalanative.nir.Val$Chars$;
import scala.scalanative.nir.Val$ClassOf$;
import scala.scalanative.nir.Val$Const$;
import scala.scalanative.nir.Val$Double$;
import scala.scalanative.nir.Val$False$;
import scala.scalanative.nir.Val$Float$;
import scala.scalanative.nir.Val$Global$;
import scala.scalanative.nir.Val$Int$;
import scala.scalanative.nir.Val$Local$;
import scala.scalanative.nir.Val$Long$;
import scala.scalanative.nir.Val$Null$;
import scala.scalanative.nir.Val$Short$;
import scala.scalanative.nir.Val$String$;
import scala.scalanative.nir.Val$StructValue$;
import scala.scalanative.nir.Val$True$;
import scala.scalanative.nir.Val$Unit$;
import scala.scalanative.nir.Val$Virtual$;
import scala.scalanative.nir.Val$Zero$;
import scala.scalanative.nir.serialization.Tags$;
import scala.scalanative.util.package$;

public final class BinaryDeserializer {
    private final ByteBuffer buffer;
    private Position lastPosition;
    private final Seq<Tuple2<Global, Object>> header;
    private final URI[] files;
    private final boolean usesEncodedMemberNames;

    public BinaryDeserializer(ByteBuffer buffer, String bufferName) {
        this.buffer = buffer;
        this.lastPosition = Position$.MODULE$.NoPosition();
        buffer.position(0);
        Prelude prelude = Prelude$.MODULE$.readFrom(buffer, bufferName);
        URI[] files = (URI[])Array$.MODULE$.fill(buffer.getInt(), this::$init$$$anonfun$1, ClassTag$.MODULE$.apply(URI.class));
        Seq pairs = this.getSeq(() -> this.$init$$$anonfun$2(buffer));
        Tuple3 tuple3 = Tuple3$.MODULE$.apply((Object)prelude, pairs, (Object)files);
        if (!(tuple3 instanceof Tuple3)) {
            throw new MatchError((Object)tuple3);
        }
        Tuple3 tuple32 = tuple3;
        Prelude prelude2 = (Prelude)tuple32._1();
        Seq header = (Seq)tuple32._2();
        URI[] files2 = (URI[])tuple32._3();
        Tuple3 tuple33 = Tuple3$.MODULE$.apply((Object)prelude2, (Object)header, (Object)files2);
        Prelude prelude3 = (Prelude)tuple33._1();
        this.header = (Seq)tuple33._2();
        this.files = (URI[])tuple33._3();
        this.usesEncodedMemberNames = prelude3.revision() >= 9;
    }

    public final Seq<Defn> deserialize() {
        UnrolledBuffer allDefns = UnrolledBuffer$.MODULE$.empty(ClassTag$.MODULE$.apply(Defn.class));
        this.header.foreach((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Global g = (Global)tuple2._1();
            int offset = BoxesRunTime.unboxToInt((Object)tuple2._2());
            this.buffer.position(offset);
            return (UnrolledBuffer)allDefns.$plus$eq((Object)this.getDefn());
        });
        return allDefns.toSeq();
    }

    private <T> Seq<T> getSeq(Function0<T> getT) {
        return RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), this.buffer.getInt()).map((Function1 & Serializable)_$1 -> getT.apply()).toSeq();
    }

    private <T> Option<T> getOpt(Function0<T> getT) {
        return this.buffer.get() == 0 ? None$.MODULE$ : Some$.MODULE$.apply(getT.apply());
    }

    private Seq<Object> getInts() {
        return this.getSeq(this::getInts$$anonfun$1);
    }

    private String getUTF8String() {
        return new String(this.getBytes(), StandardCharsets.UTF_8);
    }

    /*
     * WARNING - void declaration
     */
    private byte[] getBytes() {
        void var1_1;
        byte[] arr = new byte[this.buffer.getInt()];
        this.buffer.get(arr);
        return var1_1;
    }

    private boolean getBool() {
        return this.buffer.get() != 0;
    }

    private Attrs getAttrs() {
        return Attrs$.MODULE$.fromSeq(this.getSeq(this::getAttrs$$anonfun$1));
    }

    private Attr getAttr() {
        Attr attr;
        int n = this.buffer.getInt();
        switch (n) {
            case 1: {
                attr = Attr$MayInline$.MODULE$;
                break;
            }
            case 2: {
                attr = Attr$InlineHint$.MODULE$;
                break;
            }
            case 3: {
                attr = Attr$NoInline$.MODULE$;
                break;
            }
            case 4: {
                attr = Attr$AlwaysInline$.MODULE$;
                break;
            }
            case 5: {
                attr = Attr$MaySpecialize$.MODULE$;
                break;
            }
            case 6: {
                attr = Attr$NoSpecialize$.MODULE$;
                break;
            }
            case 7: {
                attr = Attr$UnOpt$.MODULE$;
                break;
            }
            case 8: {
                attr = Attr$NoOpt$.MODULE$;
                break;
            }
            case 9: {
                attr = Attr$DidOpt$.MODULE$;
                break;
            }
            case 10: {
                attr = Attr$BailOpt$.MODULE$.apply(this.getUTF8String());
                break;
            }
            case 13: {
                attr = Attr$Dyn$.MODULE$;
                break;
            }
            case 14: {
                attr = Attr$Stub$.MODULE$;
                break;
            }
            case 11: {
                attr = Attr$Extern$.MODULE$;
                break;
            }
            case 12: {
                attr = Attr$Link$.MODULE$.apply(this.getUTF8String());
                break;
            }
            case 15: {
                attr = Attr$Abstract$.MODULE$;
                break;
            }
            case 16: {
                attr = Attr$LinktimeResolved$.MODULE$;
                break;
            }
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            }
        }
        return attr;
    }

    private Bin getBin() {
        Bin bin;
        int n = this.buffer.getInt();
        switch (n) {
            case 33: {
                bin = Bin$Iadd$.MODULE$;
                break;
            }
            case 34: {
                bin = Bin$Fadd$.MODULE$;
                break;
            }
            case 35: {
                bin = Bin$Isub$.MODULE$;
                break;
            }
            case 36: {
                bin = Bin$Fsub$.MODULE$;
                break;
            }
            case 37: {
                bin = Bin$Imul$.MODULE$;
                break;
            }
            case 38: {
                bin = Bin$Fmul$.MODULE$;
                break;
            }
            case 39: {
                bin = Bin$Sdiv$.MODULE$;
                break;
            }
            case 40: {
                bin = Bin$Udiv$.MODULE$;
                break;
            }
            case 41: {
                bin = Bin$Fdiv$.MODULE$;
                break;
            }
            case 42: {
                bin = Bin$Srem$.MODULE$;
                break;
            }
            case 43: {
                bin = Bin$Urem$.MODULE$;
                break;
            }
            case 44: {
                bin = Bin$Frem$.MODULE$;
                break;
            }
            case 45: {
                bin = Bin$Shl$.MODULE$;
                break;
            }
            case 46: {
                bin = Bin$Lshr$.MODULE$;
                break;
            }
            case 47: {
                bin = Bin$Ashr$.MODULE$;
                break;
            }
            case 48: {
                bin = Bin$And$.MODULE$;
                break;
            }
            case 49: {
                bin = Bin$Or$.MODULE$;
                break;
            }
            case 50: {
                bin = Bin$Xor$.MODULE$;
                break;
            }
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            }
        }
        return bin;
    }

    private Seq<Inst> getInsts() {
        return this.getSeq(this::getInsts$$anonfun$1);
    }

    private Inst getInst() {
        Inst inst;
        Position pos = this.getPosition();
        int n = this.buffer.getInt();
        switch (n) {
            case 161: {
                inst = Inst$Label$.MODULE$.apply(this.getLocal(), this.getParams(), pos);
                break;
            }
            case 162: {
                inst = Inst$Let$.MODULE$.apply(this.getLocal(), this.getOp(), Next$None$.MODULE$, pos);
                break;
            }
            case 163: {
                inst = Inst$Let$.MODULE$.apply(this.getLocal(), this.getOp(), this.getNext(), pos);
                break;
            }
            case 164: {
                inst = Inst$Ret$.MODULE$.apply(this.getVal(), pos);
                break;
            }
            case 165: {
                inst = Inst$Jump$.MODULE$.apply(this.getNext(), pos);
                break;
            }
            case 166: {
                inst = Inst$If$.MODULE$.apply(this.getVal(), this.getNext(), this.getNext(), pos);
                break;
            }
            case 167: {
                inst = Inst$Switch$.MODULE$.apply(this.getVal(), this.getNext(), this.getNexts(), pos);
                break;
            }
            case 168: {
                inst = Inst$Throw$.MODULE$.apply(this.getVal(), this.getNext(), pos);
                break;
            }
            case 169: {
                inst = Inst$Unreachable$.MODULE$.apply(this.getNext(), pos);
                break;
            }
            case 170: {
                inst = Inst$LinktimeIf$.MODULE$.apply(this.getLinktimeCondition(), this.getNext(), this.getNext(), pos);
                break;
            }
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            }
        }
        return inst;
    }

    private Comp getComp() {
        Comp comp;
        int n = this.buffer.getInt();
        switch (n) {
            case 65: {
                comp = Comp$Ieq$.MODULE$;
                break;
            }
            case 66: {
                comp = Comp$Ine$.MODULE$;
                break;
            }
            case 67: {
                comp = Comp$Ugt$.MODULE$;
                break;
            }
            case 68: {
                comp = Comp$Uge$.MODULE$;
                break;
            }
            case 69: {
                comp = Comp$Ult$.MODULE$;
                break;
            }
            case 70: {
                comp = Comp$Ule$.MODULE$;
                break;
            }
            case 71: {
                comp = Comp$Sgt$.MODULE$;
                break;
            }
            case 72: {
                comp = Comp$Sge$.MODULE$;
                break;
            }
            case 73: {
                comp = Comp$Slt$.MODULE$;
                break;
            }
            case 74: {
                comp = Comp$Sle$.MODULE$;
                break;
            }
            case 75: {
                comp = Comp$Feq$.MODULE$;
                break;
            }
            case 76: {
                comp = Comp$Fne$.MODULE$;
                break;
            }
            case 77: {
                comp = Comp$Fgt$.MODULE$;
                break;
            }
            case 78: {
                comp = Comp$Fge$.MODULE$;
                break;
            }
            case 79: {
                comp = Comp$Flt$.MODULE$;
                break;
            }
            case 80: {
                comp = Comp$Fle$.MODULE$;
                break;
            }
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            }
        }
        return comp;
    }

    private Conv getConv() {
        Conv conv;
        int n = this.buffer.getInt();
        switch (n) {
            case 97: {
                conv = Conv$Trunc$.MODULE$;
                break;
            }
            case 98: {
                conv = Conv$Zext$.MODULE$;
                break;
            }
            case 99: {
                conv = Conv$Sext$.MODULE$;
                break;
            }
            case 100: {
                conv = Conv$Fptrunc$.MODULE$;
                break;
            }
            case 101: {
                conv = Conv$Fpext$.MODULE$;
                break;
            }
            case 102: {
                conv = Conv$Fptoui$.MODULE$;
                break;
            }
            case 103: {
                conv = Conv$Fptosi$.MODULE$;
                break;
            }
            case 104: {
                conv = Conv$Uitofp$.MODULE$;
                break;
            }
            case 105: {
                conv = Conv$Sitofp$.MODULE$;
                break;
            }
            case 106: {
                conv = Conv$Ptrtoint$.MODULE$;
                break;
            }
            case 107: {
                conv = Conv$Inttoptr$.MODULE$;
                break;
            }
            case 108: {
                conv = Conv$Bitcast$.MODULE$;
                break;
            }
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            }
        }
        return conv;
    }

    private Seq<Defn> getDefns() {
        return this.getSeq(this::getDefns$$anonfun$1);
    }

    private Defn getDefn() {
        Defn defn;
        Position pos = this.getPosition();
        int n = this.buffer.getInt();
        switch (n) {
            case 129: {
                defn = Defn$Var$.MODULE$.apply(this.getAttrs(), this.getGlobal(), this.getType(), this.getVal(), pos);
                break;
            }
            case 130: {
                defn = Defn$Const$.MODULE$.apply(this.getAttrs(), this.getGlobal(), this.getType(), this.getVal(), pos);
                break;
            }
            case 131: {
                defn = Defn$Declare$.MODULE$.apply(this.getAttrs(), this.getGlobal(), this.getType(), pos);
                break;
            }
            case 132: {
                defn = Defn$Define$.MODULE$.apply(this.getAttrs(), this.getGlobal(), this.getType(), this.getInsts(), pos);
                break;
            }
            case 133: {
                defn = Defn$Trait$.MODULE$.apply(this.getAttrs(), this.getGlobal(), this.getGlobals(), pos);
                break;
            }
            case 134: {
                defn = Defn$Class$.MODULE$.apply(this.getAttrs(), this.getGlobal(), this.getGlobalOpt(), this.getGlobals(), pos);
                break;
            }
            case 135: {
                defn = Defn$Module$.MODULE$.apply(this.getAttrs(), this.getGlobal(), this.getGlobalOpt(), this.getGlobals(), pos);
                break;
            }
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            }
        }
        return defn;
    }

    private Seq<Global> getGlobals() {
        return this.getSeq(this::getGlobals$$anonfun$1);
    }

    private Option<Global> getGlobalOpt() {
        return this.getOpt(this::getGlobalOpt$$anonfun$1);
    }

    private Global getGlobal() {
        Global global;
        int n = this.buffer.getInt();
        switch (n) {
            case 193: {
                global = Global$None$.MODULE$;
                break;
            }
            case 194: {
                global = Global$Top$.MODULE$.apply(this.getUTF8String());
                break;
            }
            case 195: {
                global = Global$Member$.MODULE$.apply(Global$Top$.MODULE$.apply(this.getUTF8String()), this.getSig());
                break;
            }
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            }
        }
        return global;
    }

    private Sig getSig() {
        Sig sig;
        Sig sig2 = new Sig(this.getUTF8String());
        if (this.usesEncodedMemberNames) {
            sig = sig2;
        } else {
            Sig.Unmangled unmangled = sig2.unmangled();
            if (unmangled instanceof Sig.Field) {
                Sig.Field s = (Sig.Field)unmangled;
                sig = Sig$.MODULE$.unmangledToMangled(s.copy(NameTransformer$.MODULE$.encode(s.id()), s.copy$default$2()));
            } else if (unmangled instanceof Sig.Method) {
                Sig.Method s = (Sig.Method)unmangled;
                sig = Sig$.MODULE$.unmangledToMangled(s.copy(NameTransformer$.MODULE$.encode(s.id()), s.copy$default$2(), s.copy$default$3()));
            } else {
                Sig.Unmangled sig3 = unmangled;
                sig = Sig$.MODULE$.unmangledToMangled(sig3);
            }
        }
        return sig;
    }

    private long getLocal() {
        return Local$.MODULE$.apply(this.buffer.getLong());
    }

    private Seq<Next> getNexts() {
        return this.getSeq(this::getNexts$$anonfun$1);
    }

    private Next getNext() {
        Next next;
        int n = this.buffer.getInt();
        if (Tags$.MODULE$.NoneNext() == n) {
            next = Next$None$.MODULE$;
        } else if (Tags$.MODULE$.UnwindNext() == n) {
            next = Next$Unwind$.MODULE$.apply(this.getParam(), this.getNext());
        } else if (Tags$.MODULE$.CaseNext() == n) {
            next = Next$Case$.MODULE$.apply(this.getVal(), this.getNext());
        } else if (Tags$.MODULE$.LabelNext() == n) {
            next = Next$Label$.MODULE$.apply(this.getLocal(), this.getVals());
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
        }
        return next;
    }

    private Op getOp() {
        Op op;
        int n = this.buffer.getInt();
        if (Tags$.MODULE$.CallOp() == n) {
            op = Op$Call$.MODULE$.apply(this.getType(), this.getVal(), this.getVals());
        } else if (Tags$.MODULE$.LoadOp() == n) {
            op = Op$Load$.MODULE$.apply(this.getType(), this.getVal());
        } else if (Tags$.MODULE$.StoreOp() == n) {
            op = Op$Store$.MODULE$.apply(this.getType(), this.getVal(), this.getVal());
        } else if (Tags$.MODULE$.ElemOp() == n) {
            op = Op$Elem$.MODULE$.apply(this.getType(), this.getVal(), this.getVals());
        } else if (Tags$.MODULE$.ExtractOp() == n) {
            op = Op$Extract$.MODULE$.apply(this.getVal(), this.getInts());
        } else if (Tags$.MODULE$.InsertOp() == n) {
            op = Op$Insert$.MODULE$.apply(this.getVal(), this.getVal(), this.getInts());
        } else if (Tags$.MODULE$.StackallocOp() == n) {
            op = Op$Stackalloc$.MODULE$.apply(this.getType(), this.getVal());
        } else if (Tags$.MODULE$.BinOp() == n) {
            op = Op$Bin$.MODULE$.apply(this.getBin(), this.getType(), this.getVal(), this.getVal());
        } else if (Tags$.MODULE$.CompOp() == n) {
            op = Op$Comp$.MODULE$.apply(this.getComp(), this.getType(), this.getVal(), this.getVal());
        } else if (Tags$.MODULE$.ConvOp() == n) {
            op = Op$Conv$.MODULE$.apply(this.getConv(), this.getType(), this.getVal());
        } else if (Tags$.MODULE$.ClassallocOp() == n) {
            op = Op$Classalloc$.MODULE$.apply(this.getGlobal());
        } else if (Tags$.MODULE$.FieldloadOp() == n) {
            op = Op$Fieldload$.MODULE$.apply(this.getType(), this.getVal(), this.getGlobal());
        } else if (Tags$.MODULE$.FieldstoreOp() == n) {
            op = Op$Fieldstore$.MODULE$.apply(this.getType(), this.getVal(), this.getGlobal(), this.getVal());
        } else if (Tags$.MODULE$.FieldOp() == n) {
            op = Op$Field$.MODULE$.apply(this.getVal(), this.getGlobal());
        } else if (Tags$.MODULE$.MethodOp() == n) {
            op = Op$Method$.MODULE$.apply(this.getVal(), this.getSig());
        } else if (Tags$.MODULE$.DynmethodOp() == n) {
            op = Op$Dynmethod$.MODULE$.apply(this.getVal(), this.getSig());
        } else if (Tags$.MODULE$.ModuleOp() == n) {
            op = Op$Module$.MODULE$.apply(this.getGlobal());
        } else if (Tags$.MODULE$.AsOp() == n) {
            op = Op$As$.MODULE$.apply(this.getType(), this.getVal());
        } else if (Tags$.MODULE$.IsOp() == n) {
            op = Op$Is$.MODULE$.apply(this.getType(), this.getVal());
        } else if (Tags$.MODULE$.CopyOp() == n) {
            op = Op$Copy$.MODULE$.apply(this.getVal());
        } else if (Tags$.MODULE$.SizeofOp() == n) {
            op = Op$Sizeof$.MODULE$.apply(this.getType());
        } else if (Tags$.MODULE$.BoxOp() == n) {
            op = Op$Box$.MODULE$.apply(this.getType(), this.getVal());
        } else if (Tags$.MODULE$.UnboxOp() == n) {
            op = Op$Unbox$.MODULE$.apply(this.getType(), this.getVal());
        } else if (Tags$.MODULE$.VarOp() == n) {
            op = Op$Var$.MODULE$.apply(this.getType());
        } else if (Tags$.MODULE$.VarloadOp() == n) {
            op = Op$Varload$.MODULE$.apply(this.getVal());
        } else if (Tags$.MODULE$.VarstoreOp() == n) {
            op = Op$Varstore$.MODULE$.apply(this.getVal(), this.getVal());
        } else if (Tags$.MODULE$.ArrayallocOp() == n) {
            op = Op$Arrayalloc$.MODULE$.apply(this.getType(), this.getVal());
        } else if (Tags$.MODULE$.ArrayloadOp() == n) {
            op = Op$Arrayload$.MODULE$.apply(this.getType(), this.getVal(), this.getVal());
        } else if (Tags$.MODULE$.ArraystoreOp() == n) {
            op = Op$Arraystore$.MODULE$.apply(this.getType(), this.getVal(), this.getVal(), this.getVal());
        } else if (Tags$.MODULE$.ArraylengthOp() == n) {
            op = Op$Arraylength$.MODULE$.apply(this.getVal());
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
        }
        return op;
    }

    private Seq<Val.Local> getParams() {
        return this.getSeq(this::getParams$$anonfun$1);
    }

    private Val.Local getParam() {
        return Val$Local$.MODULE$.apply(this.getLocal(), this.getType());
    }

    private Seq<Type> getTypes() {
        return this.getSeq(this::getTypes$$anonfun$1);
    }

    private Type getType() {
        Type type;
        int n = this.buffer.getInt();
        if (Tags$.MODULE$.VarargType() == n) {
            type = Type$Vararg$.MODULE$;
        } else if (Tags$.MODULE$.PtrType() == n) {
            type = Type$Ptr$.MODULE$;
        } else if (Tags$.MODULE$.BoolType() == n) {
            type = Type$Bool$.MODULE$;
        } else if (Tags$.MODULE$.CharType() == n) {
            type = Type$Char$.MODULE$;
        } else if (Tags$.MODULE$.ByteType() == n) {
            type = Type$Byte$.MODULE$;
        } else if (Tags$.MODULE$.ShortType() == n) {
            type = Type$Short$.MODULE$;
        } else if (Tags$.MODULE$.IntType() == n) {
            type = Type$Int$.MODULE$;
        } else if (Tags$.MODULE$.LongType() == n) {
            type = Type$Long$.MODULE$;
        } else if (Tags$.MODULE$.FloatType() == n) {
            type = Type$Float$.MODULE$;
        } else if (Tags$.MODULE$.DoubleType() == n) {
            type = Type$Double$.MODULE$;
        } else if (Tags$.MODULE$.ArrayValueType() == n) {
            type = Type$ArrayValue$.MODULE$.apply(this.getType(), this.buffer.getInt());
        } else if (Tags$.MODULE$.StructValueType() == n) {
            type = Type$StructValue$.MODULE$.apply(this.getTypes());
        } else if (Tags$.MODULE$.FunctionType() == n) {
            type = Type$Function$.MODULE$.apply(this.getTypes(), this.getType());
        } else if (Tags$.MODULE$.NullType() == n) {
            type = Type$Null$.MODULE$;
        } else if (Tags$.MODULE$.NothingType() == n) {
            type = Type$Nothing$.MODULE$;
        } else if (Tags$.MODULE$.VirtualType() == n) {
            type = Type$Virtual$.MODULE$;
        } else if (Tags$.MODULE$.VarType() == n) {
            type = Type$Var$.MODULE$.apply(this.getType());
        } else if (Tags$.MODULE$.UnitType() == n) {
            type = Type$Unit$.MODULE$;
        } else if (Tags$.MODULE$.ArrayType() == n) {
            type = Type$Array$.MODULE$.apply(this.getType(), this.getBool());
        } else if (Tags$.MODULE$.RefType() == n) {
            type = Type$Ref$.MODULE$.apply(this.getGlobal(), this.getBool(), this.getBool());
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
        }
        return type;
    }

    private Seq<Val> getVals() {
        return this.getSeq(this::getVals$$anonfun$1);
    }

    private Val getVal() {
        Val val;
        int n = this.buffer.getInt();
        if (Tags$.MODULE$.TrueVal() == n) {
            val = Val$True$.MODULE$;
        } else if (Tags$.MODULE$.FalseVal() == n) {
            val = Val$False$.MODULE$;
        } else if (Tags$.MODULE$.NullVal() == n) {
            val = Val$Null$.MODULE$;
        } else if (Tags$.MODULE$.ZeroVal() == n) {
            val = Val$Zero$.MODULE$.apply(this.getType());
        } else if (Tags$.MODULE$.CharVal() == n) {
            val = Val$Char$.MODULE$.apply((char)this.buffer.getShort());
        } else if (Tags$.MODULE$.ByteVal() == n) {
            val = Val$Byte$.MODULE$.apply(this.buffer.get());
        } else if (Tags$.MODULE$.ShortVal() == n) {
            val = Val$Short$.MODULE$.apply(this.buffer.getShort());
        } else if (Tags$.MODULE$.IntVal() == n) {
            val = Val$Int$.MODULE$.apply(this.buffer.getInt());
        } else if (Tags$.MODULE$.LongVal() == n) {
            val = Val$Long$.MODULE$.apply(this.buffer.getLong());
        } else if (Tags$.MODULE$.FloatVal() == n) {
            val = Val$Float$.MODULE$.apply(this.buffer.getFloat());
        } else if (Tags$.MODULE$.DoubleVal() == n) {
            val = Val$Double$.MODULE$.apply(this.buffer.getDouble());
        } else if (Tags$.MODULE$.StructValueVal() == n) {
            val = Val$StructValue$.MODULE$.apply(this.getVals());
        } else if (Tags$.MODULE$.ArrayValueVal() == n) {
            val = Val$ArrayValue$.MODULE$.apply(this.getType(), this.getVals());
        } else if (Tags$.MODULE$.CharsVal() == n) {
            Object object = Predef$.MODULE$.byteArrayOps(this.getBytes());
            val = Val$Chars$.MODULE$.apply((Seq<Object>)ArrayOps$.MODULE$.toIndexedSeq$extension(object));
        } else if (Tags$.MODULE$.LocalVal() == n) {
            val = Val$Local$.MODULE$.apply(this.getLocal(), this.getType());
        } else if (Tags$.MODULE$.GlobalVal() == n) {
            val = Val$Global$.MODULE$.apply(this.getGlobal(), this.getType());
        } else if (Tags$.MODULE$.UnitVal() == n) {
            val = Val$Unit$.MODULE$;
        } else if (Tags$.MODULE$.ConstVal() == n) {
            val = Val$Const$.MODULE$.apply(this.getVal());
        } else if (Tags$.MODULE$.StringVal() == n) {
            char[] chars = (char[])Array$.MODULE$.fill(this.buffer.getInt(), this::$anonfun$1, ClassTag$.MODULE$.apply(Character.TYPE));
            val = Val$String$.MODULE$.apply(new String(chars));
        } else if (Tags$.MODULE$.VirtualVal() == n) {
            val = Val$Virtual$.MODULE$.apply(this.buffer.getLong());
        } else if (Tags$.MODULE$.ClassOfVal() == n) {
            val = Val$ClassOf$.MODULE$.apply(this.getGlobal());
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
        }
        return val;
    }

    private LinktimeCondition getLinktimeCondition() {
        Product product;
        int n = this.buffer.getInt();
        if (1 == n) {
            product = LinktimeCondition$SimpleCondition$.MODULE$.apply(this.getUTF8String(), this.getComp(), this.getVal(), this.getPosition());
        } else if (2 == n) {
            product = LinktimeCondition$ComplexCondition$.MODULE$.apply(this.getBin(), this.getLinktimeCondition(), this.getLinktimeCondition(), this.getPosition());
        } else {
            int n2 = n;
            throw package$.MODULE$.unsupported(new StringBuilder(32).append("Unknown linktime condition tag: ").append(n2).toString());
        }
        return product;
    }

    public Position getPosition() {
        return this.readPosition$1();
    }

    private final URI $init$$$anonfun$1() {
        return new URI(this.getUTF8String());
    }

    private final Tuple2 $init$$$anonfun$2(ByteBuffer buffer$1) {
        return Tuple2$.MODULE$.apply((Object)this.getGlobal(), (Object)BoxesRunTime.boxToInteger((int)buffer$1.getInt()));
    }

    private final int getInts$$anonfun$1() {
        return this.buffer.getInt();
    }

    private final Attr getAttrs$$anonfun$1() {
        return this.getAttr();
    }

    private final Inst getInsts$$anonfun$1() {
        return this.getInst();
    }

    private final Defn getDefns$$anonfun$1() {
        return this.getDefn();
    }

    private final Global getGlobals$$anonfun$1() {
        return this.getGlobal();
    }

    private final Global getGlobalOpt$$anonfun$1() {
        return this.getGlobal();
    }

    private final Next getNexts$$anonfun$1() {
        return this.getNext();
    }

    private final Val.Local getParams$$anonfun$1() {
        return this.getParam();
    }

    private final Type getTypes$$anonfun$1() {
        return this.getType();
    }

    private final Val getVals$$anonfun$1() {
        return this.getVal();
    }

    private final char $anonfun$1() {
        return this.buffer.getChar();
    }

    /*
     * WARNING - void declaration
     */
    private final Position readPosition$1() {
        Position position;
        byte first = this.buffer.get();
        if (first == -1) {
            position = Position$.MODULE$.NoPosition();
        } else {
            void var2_11;
            Position result;
            Position position2;
            if ((first & 0xF) == 7) {
                URI file = this.files[this.buffer.getInt()];
                int line = this.buffer.getInt();
                int column = this.buffer.getInt();
                position2 = Position$.MODULE$.apply(file, line, column);
            } else {
                Position position3 = this.lastPosition;
                Position position4 = Position$.MODULE$.NoPosition();
                if (!(position3 != null ? !((Object)position3).equals(position4) : position4 != null)) {
                    throw Scala3RunTime$.MODULE$.assertFailed((Object)"Position format error: first position must be full");
                }
                if ((first & 1) == 0) {
                    int columnDiff = first >> 1;
                    position2 = Position$.MODULE$.apply(this.lastPosition.source(), this.lastPosition.line(), this.lastPosition.column() + columnDiff);
                } else if ((first & 3) == 1) {
                    int lineDiff = first >> 2;
                    int column = this.buffer.get() & 0xFF;
                    position2 = Position$.MODULE$.apply(this.lastPosition.source(), this.lastPosition.line() + lineDiff, column);
                } else {
                    if ((first & 0xF) != 3) {
                        throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(60).append("Position format error: first byte ").append(first).append(" does not match any format").toString());
                    }
                    short lineDiff = this.buffer.getShort();
                    int column = this.buffer.get() & 0xFF;
                    position2 = Position$.MODULE$.apply(this.lastPosition.source(), this.lastPosition.line() + lineDiff, column);
                }
            }
            this.lastPosition = result = position2;
            position = var2_11;
        }
        return position;
    }
}

