/*
 * Decompiled with CFR 0.152.
 */
package scala.scalanative.nir.serialization;

import java.io.DataOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import scala.Byte$;
import scala.Char$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Short$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.UnrolledBuffer;
import scala.collection.mutable.UnrolledBuffer$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;
import scala.scalanative.nir.Attr;
import scala.scalanative.nir.Attr$Abstract$;
import scala.scalanative.nir.Attr$AlwaysInline$;
import scala.scalanative.nir.Attr$BailOpt$;
import scala.scalanative.nir.Attr$DidOpt$;
import scala.scalanative.nir.Attr$Dyn$;
import scala.scalanative.nir.Attr$Extern$;
import scala.scalanative.nir.Attr$InlineHint$;
import scala.scalanative.nir.Attr$Link$;
import scala.scalanative.nir.Attr$LinktimeResolved$;
import scala.scalanative.nir.Attr$MayInline$;
import scala.scalanative.nir.Attr$MaySpecialize$;
import scala.scalanative.nir.Attr$NoInline$;
import scala.scalanative.nir.Attr$NoOpt$;
import scala.scalanative.nir.Attr$NoSpecialize$;
import scala.scalanative.nir.Attr$Stub$;
import scala.scalanative.nir.Attr$UnOpt$;
import scala.scalanative.nir.Attrs;
import scala.scalanative.nir.Bin;
import scala.scalanative.nir.Bin$And$;
import scala.scalanative.nir.Bin$Ashr$;
import scala.scalanative.nir.Bin$Fadd$;
import scala.scalanative.nir.Bin$Fdiv$;
import scala.scalanative.nir.Bin$Fmul$;
import scala.scalanative.nir.Bin$Frem$;
import scala.scalanative.nir.Bin$Fsub$;
import scala.scalanative.nir.Bin$Iadd$;
import scala.scalanative.nir.Bin$Imul$;
import scala.scalanative.nir.Bin$Isub$;
import scala.scalanative.nir.Bin$Lshr$;
import scala.scalanative.nir.Bin$Or$;
import scala.scalanative.nir.Bin$Sdiv$;
import scala.scalanative.nir.Bin$Shl$;
import scala.scalanative.nir.Bin$Srem$;
import scala.scalanative.nir.Bin$Udiv$;
import scala.scalanative.nir.Bin$Urem$;
import scala.scalanative.nir.Bin$Xor$;
import scala.scalanative.nir.Comp;
import scala.scalanative.nir.Comp$Feq$;
import scala.scalanative.nir.Comp$Fge$;
import scala.scalanative.nir.Comp$Fgt$;
import scala.scalanative.nir.Comp$Fle$;
import scala.scalanative.nir.Comp$Flt$;
import scala.scalanative.nir.Comp$Fne$;
import scala.scalanative.nir.Comp$Ieq$;
import scala.scalanative.nir.Comp$Ine$;
import scala.scalanative.nir.Comp$Sge$;
import scala.scalanative.nir.Comp$Sgt$;
import scala.scalanative.nir.Comp$Sle$;
import scala.scalanative.nir.Comp$Slt$;
import scala.scalanative.nir.Comp$Uge$;
import scala.scalanative.nir.Comp$Ugt$;
import scala.scalanative.nir.Comp$Ule$;
import scala.scalanative.nir.Comp$Ult$;
import scala.scalanative.nir.Conv;
import scala.scalanative.nir.Conv$Bitcast$;
import scala.scalanative.nir.Conv$Fpext$;
import scala.scalanative.nir.Conv$Fptosi$;
import scala.scalanative.nir.Conv$Fptoui$;
import scala.scalanative.nir.Conv$Fptrunc$;
import scala.scalanative.nir.Conv$Inttoptr$;
import scala.scalanative.nir.Conv$Ptrtoint$;
import scala.scalanative.nir.Conv$Sext$;
import scala.scalanative.nir.Conv$Sitofp$;
import scala.scalanative.nir.Conv$Trunc$;
import scala.scalanative.nir.Conv$Uitofp$;
import scala.scalanative.nir.Conv$Zext$;
import scala.scalanative.nir.Defn;
import scala.scalanative.nir.Defn$;
import scala.scalanative.nir.Defn$Class$;
import scala.scalanative.nir.Defn$Const$;
import scala.scalanative.nir.Defn$Declare$;
import scala.scalanative.nir.Defn$Define$;
import scala.scalanative.nir.Defn$Module$;
import scala.scalanative.nir.Defn$Trait$;
import scala.scalanative.nir.Defn$Var$;
import scala.scalanative.nir.Global;
import scala.scalanative.nir.Global$Member$;
import scala.scalanative.nir.Global$None$;
import scala.scalanative.nir.Global$Top$;
import scala.scalanative.nir.Inst;
import scala.scalanative.nir.Inst$If$;
import scala.scalanative.nir.Inst$Jump$;
import scala.scalanative.nir.Inst$Label$;
import scala.scalanative.nir.Inst$Let$;
import scala.scalanative.nir.Inst$LinktimeIf$;
import scala.scalanative.nir.Inst$Ret$;
import scala.scalanative.nir.Inst$Switch$;
import scala.scalanative.nir.Inst$Throw$;
import scala.scalanative.nir.Inst$Unreachable$;
import scala.scalanative.nir.LinktimeCondition;
import scala.scalanative.nir.LinktimeCondition$ComplexCondition$;
import scala.scalanative.nir.LinktimeCondition$SimpleCondition$;
import scala.scalanative.nir.Next;
import scala.scalanative.nir.Next$Case$;
import scala.scalanative.nir.Next$Label$;
import scala.scalanative.nir.Next$None$;
import scala.scalanative.nir.Next$Unwind$;
import scala.scalanative.nir.Op;
import scala.scalanative.nir.Op$Arrayalloc$;
import scala.scalanative.nir.Op$Arraylength$;
import scala.scalanative.nir.Op$Arrayload$;
import scala.scalanative.nir.Op$Arraystore$;
import scala.scalanative.nir.Op$As$;
import scala.scalanative.nir.Op$Bin$;
import scala.scalanative.nir.Op$Box$;
import scala.scalanative.nir.Op$Call$;
import scala.scalanative.nir.Op$Classalloc$;
import scala.scalanative.nir.Op$Comp$;
import scala.scalanative.nir.Op$Conv$;
import scala.scalanative.nir.Op$Copy$;
import scala.scalanative.nir.Op$Dynmethod$;
import scala.scalanative.nir.Op$Elem$;
import scala.scalanative.nir.Op$Extract$;
import scala.scalanative.nir.Op$Field$;
import scala.scalanative.nir.Op$Fieldload$;
import scala.scalanative.nir.Op$Fieldstore$;
import scala.scalanative.nir.Op$Insert$;
import scala.scalanative.nir.Op$Is$;
import scala.scalanative.nir.Op$Load$;
import scala.scalanative.nir.Op$Method$;
import scala.scalanative.nir.Op$Module$;
import scala.scalanative.nir.Op$Sizeof$;
import scala.scalanative.nir.Op$Stackalloc$;
import scala.scalanative.nir.Op$Store$;
import scala.scalanative.nir.Op$Unbox$;
import scala.scalanative.nir.Op$Var$;
import scala.scalanative.nir.Op$Varload$;
import scala.scalanative.nir.Op$Varstore$;
import scala.scalanative.nir.Position;
import scala.scalanative.nir.Position$;
import scala.scalanative.nir.Prelude$;
import scala.scalanative.nir.Sig;
import scala.scalanative.nir.Type;
import scala.scalanative.nir.Type$Array$;
import scala.scalanative.nir.Type$ArrayValue$;
import scala.scalanative.nir.Type$Bool$;
import scala.scalanative.nir.Type$Byte$;
import scala.scalanative.nir.Type$Char$;
import scala.scalanative.nir.Type$Double$;
import scala.scalanative.nir.Type$Float$;
import scala.scalanative.nir.Type$Function$;
import scala.scalanative.nir.Type$Int$;
import scala.scalanative.nir.Type$Long$;
import scala.scalanative.nir.Type$Nothing$;
import scala.scalanative.nir.Type$Null$;
import scala.scalanative.nir.Type$Ptr$;
import scala.scalanative.nir.Type$Ref$;
import scala.scalanative.nir.Type$Short$;
import scala.scalanative.nir.Type$StructValue$;
import scala.scalanative.nir.Type$Unit$;
import scala.scalanative.nir.Type$Var$;
import scala.scalanative.nir.Type$Vararg$;
import scala.scalanative.nir.Type$Virtual$;
import scala.scalanative.nir.Val;
import scala.scalanative.nir.Val$ArrayValue$;
import scala.scalanative.nir.Val$Byte$;
import scala.scalanative.nir.Val$Char$;
import scala.scalanative.nir.Val$ClassOf$;
import scala.scalanative.nir.Val$Const$;
import scala.scalanative.nir.Val$Double$;
import scala.scalanative.nir.Val$False$;
import scala.scalanative.nir.Val$Float$;
import scala.scalanative.nir.Val$Global$;
import scala.scalanative.nir.Val$Int$;
import scala.scalanative.nir.Val$Local$;
import scala.scalanative.nir.Val$Long$;
import scala.scalanative.nir.Val$Null$;
import scala.scalanative.nir.Val$Short$;
import scala.scalanative.nir.Val$String$;
import scala.scalanative.nir.Val$StructValue$;
import scala.scalanative.nir.Val$True$;
import scala.scalanative.nir.Val$Unit$;
import scala.scalanative.nir.Val$Virtual$;
import scala.scalanative.nir.Val$Zero$;
import scala.scalanative.nir.Versions$;
import scala.scalanative.nir.serialization.JumpBackByteArrayOutputStream;
import scala.scalanative.nir.serialization.Tags$;
import scala.scalanative.util.package$;

public final class BinarySerializer {
    private final JumpBackByteArrayOutputStream bufferUnderyling = new JumpBackByteArrayOutputStream();
    private final DataOutputStream buffer = new DataOutputStream(this.bufferUnderyling);
    private Position lastPosition = Position$.MODULE$.NoPosition();
    private final Map<URI, Object> fileIndexMap = (Map)Map$.MODULE$.empty();

    public void serialize(Seq<Defn> defns, OutputStream outputStream) {
        Seq names = (Seq)defns.map((Function1 & Serializable)_$1 -> _$1.name());
        Seq<String> filenames = this.initFiles(defns);
        UnrolledBuffer positions = UnrolledBuffer$.MODULE$.empty(ClassTag$.MODULE$.apply(Integer.TYPE));
        Prelude$.MODULE$.writeTo(this.buffer, Prelude$.MODULE$.apply(Versions$.MODULE$.magic(), Versions$.MODULE$.compat(), Versions$.MODULE$.revision(), Defn$.MODULE$.existsEntryPoint(defns)));
        this.putSeq((Seq)filenames, (Function1)(JProcedure1 & Serializable)v -> this.putUTF8String((String)v));
        this.putSeq((Seq)names, (Function1)(JProcedure1 & Serializable)n -> {
            this.putGlobal((Global)n);
            positions.$plus$eq((Object)BoxesRunTime.boxToInteger((int)this.bufferUnderyling.currentPosition()));
            this.buffer.writeInt(0);
        });
        ((IterableOnceOps)defns.zip((IterableOnce)positions)).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Defn defn = (Defn)tuple2._1();
            int marker = BoxesRunTime.unboxToInt((Object)tuple2._2());
            int offset = this.bufferUnderyling.currentPosition();
            this.bufferUnderyling.jumpTo(marker);
            this.buffer.writeInt(offset);
            this.bufferUnderyling.continue();
            this.putDefn(defn);
        });
        this.buffer.flush();
        this.bufferUnderyling.writeTo(outputStream);
    }

    private <T> void putSeq(Seq<T> seq, Function1<T, BoxedUnit> putT) {
        this.buffer.writeInt(seq.length());
        seq.foreach(putT);
    }

    private <T> void putOpt(Option<T> opt, Function1<T, BoxedUnit> putT) {
        Option<T> option = opt;
        if (None$.MODULE$.equals(option)) {
            this.buffer.write(Byte$.MODULE$.byte2int((byte)0));
        } else if (option instanceof Some) {
            Object t = ((Some)option).value();
            this.buffer.write(Byte$.MODULE$.byte2int((byte)1));
            putT.apply(t);
        } else {
            throw new MatchError(option);
        }
    }

    private void putInts(Seq<Object> ints) {
        this.putSeq((Seq)ints, (Function1)(JFunction1.mcVI.sp & Serializable)x$0 -> this.buffer.writeInt(x$0));
    }

    private void putUTF8String(String v) {
        this.putBytes(v.getBytes(StandardCharsets.UTF_8));
    }

    private void putBytes(byte[] bytes) {
        this.buffer.writeInt(bytes.length);
        this.buffer.write(bytes);
    }

    private void putBool(boolean v) {
        this.buffer.write(Byte$.MODULE$.byte2int((byte)(v ? 1 : 0)));
    }

    private void putAttrs(Attrs attrs) {
        this.putSeq((Seq)attrs.toSeq(), (Function1)(JProcedure1 & Serializable)attr -> this.putAttr((Attr)attr));
    }

    private void putAttr(Attr attr) {
        Attr attr2 = attr;
        if (Attr$MayInline$.MODULE$.equals(attr2)) {
            this.buffer.writeInt(1);
        } else if (Attr$InlineHint$.MODULE$.equals(attr2)) {
            this.buffer.writeInt(2);
        } else if (Attr$NoInline$.MODULE$.equals(attr2)) {
            this.buffer.writeInt(3);
        } else if (Attr$AlwaysInline$.MODULE$.equals(attr2)) {
            this.buffer.writeInt(4);
        } else if (Attr$MaySpecialize$.MODULE$.equals(attr2)) {
            this.buffer.writeInt(5);
        } else if (Attr$NoSpecialize$.MODULE$.equals(attr2)) {
            this.buffer.writeInt(6);
        } else if (Attr$UnOpt$.MODULE$.equals(attr2)) {
            this.buffer.writeInt(7);
        } else if (Attr$NoOpt$.MODULE$.equals(attr2)) {
            this.buffer.writeInt(8);
        } else if (Attr$DidOpt$.MODULE$.equals(attr2)) {
            this.buffer.writeInt(9);
        } else if (attr2 instanceof Attr.BailOpt) {
            String string;
            Attr.BailOpt bailOpt = Attr$BailOpt$.MODULE$.unapply((Attr.BailOpt)attr2);
            String msg = string = bailOpt._1();
            this.buffer.writeInt(10);
            this.putUTF8String(msg);
        } else if (Attr$Dyn$.MODULE$.equals(attr2)) {
            this.buffer.writeInt(13);
        } else if (Attr$Stub$.MODULE$.equals(attr2)) {
            this.buffer.writeInt(14);
        } else if (Attr$Extern$.MODULE$.equals(attr2)) {
            this.buffer.writeInt(11);
        } else if (attr2 instanceof Attr.Link) {
            String string;
            Attr.Link link = Attr$Link$.MODULE$.unapply((Attr.Link)attr2);
            String s = string = link._1();
            this.buffer.writeInt(12);
            this.putUTF8String(s);
        } else if (Attr$Abstract$.MODULE$.equals(attr2)) {
            this.buffer.writeInt(15);
        } else if (Attr$LinktimeResolved$.MODULE$.equals(attr2)) {
            this.buffer.writeInt(16);
        } else {
            throw new MatchError((Object)attr2);
        }
    }

    private void putBin(Bin bin) {
        Bin bin2 = bin;
        if (Bin$Iadd$.MODULE$.equals(bin2)) {
            this.buffer.writeInt(33);
        } else if (Bin$Fadd$.MODULE$.equals(bin2)) {
            this.buffer.writeInt(34);
        } else if (Bin$Isub$.MODULE$.equals(bin2)) {
            this.buffer.writeInt(35);
        } else if (Bin$Fsub$.MODULE$.equals(bin2)) {
            this.buffer.writeInt(36);
        } else if (Bin$Imul$.MODULE$.equals(bin2)) {
            this.buffer.writeInt(37);
        } else if (Bin$Fmul$.MODULE$.equals(bin2)) {
            this.buffer.writeInt(38);
        } else if (Bin$Sdiv$.MODULE$.equals(bin2)) {
            this.buffer.writeInt(39);
        } else if (Bin$Udiv$.MODULE$.equals(bin2)) {
            this.buffer.writeInt(40);
        } else if (Bin$Fdiv$.MODULE$.equals(bin2)) {
            this.buffer.writeInt(41);
        } else if (Bin$Srem$.MODULE$.equals(bin2)) {
            this.buffer.writeInt(42);
        } else if (Bin$Urem$.MODULE$.equals(bin2)) {
            this.buffer.writeInt(43);
        } else if (Bin$Frem$.MODULE$.equals(bin2)) {
            this.buffer.writeInt(44);
        } else if (Bin$Shl$.MODULE$.equals(bin2)) {
            this.buffer.writeInt(45);
        } else if (Bin$Lshr$.MODULE$.equals(bin2)) {
            this.buffer.writeInt(46);
        } else if (Bin$Ashr$.MODULE$.equals(bin2)) {
            this.buffer.writeInt(47);
        } else if (Bin$And$.MODULE$.equals(bin2)) {
            this.buffer.writeInt(48);
        } else if (Bin$Or$.MODULE$.equals(bin2)) {
            this.buffer.writeInt(49);
        } else if (Bin$Xor$.MODULE$.equals(bin2)) {
            this.buffer.writeInt(50);
        } else {
            throw new MatchError((Object)bin2);
        }
    }

    private void putInsts(Seq<Inst> insts) {
        this.putSeq((Seq)insts, (Function1)(JProcedure1 & Serializable)cf -> this.putInst((Inst)cf));
    }

    private void putInst(Inst cf) {
        this.putPosition(cf.pos());
        Inst inst = cf;
        if (inst instanceof Inst.Label) {
            Inst.Label label = Inst$Label$.MODULE$.unapply((Inst.Label)inst);
            long l = label._1();
            Seq<Val.Local> seq = label._2();
            long name = l;
            Seq<Val.Local> params = seq;
            this.buffer.writeInt(161);
            this.putLocal(name);
            this.putParams(params);
        } else if (inst instanceof Inst.Let) {
            Inst.Let let = Inst$Let$.MODULE$.unapply((Inst.Let)inst);
            long l = let._1();
            Op op = let._2();
            Next next = let._3();
            long name = l;
            Op op2 = op;
            if (Next$None$.MODULE$.equals(next)) {
                this.buffer.writeInt(162);
                this.putLocal(name);
                this.putOp(op2);
            } else {
                long name2 = l;
                Op op3 = op;
                Next unwind = next;
                this.buffer.writeInt(163);
                this.putLocal(name2);
                this.putOp(op3);
                this.putNext(unwind);
            }
        } else if (inst instanceof Inst.Ret) {
            Val val;
            Inst.Ret ret = Inst$Ret$.MODULE$.unapply((Inst.Ret)inst);
            Val v = val = ret._1();
            this.buffer.writeInt(164);
            this.putVal(v);
        } else if (inst instanceof Inst.Jump) {
            Next next;
            Inst.Jump jump = Inst$Jump$.MODULE$.unapply((Inst.Jump)inst);
            Next next2 = next = jump._1();
            this.buffer.writeInt(165);
            this.putNext(next2);
        } else if (inst instanceof Inst.If) {
            Inst.If if_ = Inst$If$.MODULE$.unapply((Inst.If)inst);
            Val val = if_._1();
            Next next = if_._2();
            Next next3 = if_._3();
            Val v = val;
            Next thenp = next;
            Next elsep = next3;
            this.buffer.writeInt(166);
            this.putVal(v);
            this.putNext(thenp);
            this.putNext(elsep);
        } else if (inst instanceof Inst.LinktimeIf) {
            Inst.LinktimeIf linktimeIf = Inst$LinktimeIf$.MODULE$.unapply((Inst.LinktimeIf)inst);
            LinktimeCondition linktimeCondition = linktimeIf._1();
            Next next = linktimeIf._2();
            Next next4 = linktimeIf._3();
            LinktimeCondition v = linktimeCondition;
            Next thenp = next;
            Next elsep = next4;
            this.buffer.writeInt(170);
            this.putLinktimeCondition(v);
            this.putNext(thenp);
            this.putNext(elsep);
        } else if (inst instanceof Inst.Switch) {
            Inst.Switch switch_ = Inst$Switch$.MODULE$.unapply((Inst.Switch)inst);
            Val val = switch_._1();
            Next next = switch_._2();
            Seq<Next> seq = switch_._3();
            Val v = val;
            Next next5 = next;
            Seq<Next> cases = seq;
            this.buffer.writeInt(167);
            this.putVal(v);
            this.putNext(next5);
            this.putNexts(cases);
        } else if (inst instanceof Inst.Throw) {
            Inst.Throw throw_ = Inst$Throw$.MODULE$.unapply((Inst.Throw)inst);
            Val val = throw_._1();
            Next next = throw_._2();
            Val v = val;
            Next unwind = next;
            this.buffer.writeInt(168);
            this.putVal(v);
            this.putNext(unwind);
        } else if (inst instanceof Inst.Unreachable) {
            Next next;
            Inst.Unreachable unreachable = Inst$Unreachable$.MODULE$.unapply((Inst.Unreachable)inst);
            Next unwind = next = unreachable._1();
            this.buffer.writeInt(169);
            this.putNext(unwind);
        } else {
            throw new MatchError((Object)inst);
        }
    }

    private void putComp(Comp comp) {
        Comp comp2 = comp;
        if (Comp$Ieq$.MODULE$.equals(comp2)) {
            this.buffer.writeInt(65);
        } else if (Comp$Ine$.MODULE$.equals(comp2)) {
            this.buffer.writeInt(66);
        } else if (Comp$Ugt$.MODULE$.equals(comp2)) {
            this.buffer.writeInt(67);
        } else if (Comp$Uge$.MODULE$.equals(comp2)) {
            this.buffer.writeInt(68);
        } else if (Comp$Ult$.MODULE$.equals(comp2)) {
            this.buffer.writeInt(69);
        } else if (Comp$Ule$.MODULE$.equals(comp2)) {
            this.buffer.writeInt(70);
        } else if (Comp$Sgt$.MODULE$.equals(comp2)) {
            this.buffer.writeInt(71);
        } else if (Comp$Sge$.MODULE$.equals(comp2)) {
            this.buffer.writeInt(72);
        } else if (Comp$Slt$.MODULE$.equals(comp2)) {
            this.buffer.writeInt(73);
        } else if (Comp$Sle$.MODULE$.equals(comp2)) {
            this.buffer.writeInt(74);
        } else if (Comp$Feq$.MODULE$.equals(comp2)) {
            this.buffer.writeInt(75);
        } else if (Comp$Fne$.MODULE$.equals(comp2)) {
            this.buffer.writeInt(76);
        } else if (Comp$Fgt$.MODULE$.equals(comp2)) {
            this.buffer.writeInt(77);
        } else if (Comp$Fge$.MODULE$.equals(comp2)) {
            this.buffer.writeInt(78);
        } else if (Comp$Flt$.MODULE$.equals(comp2)) {
            this.buffer.writeInt(79);
        } else if (Comp$Fle$.MODULE$.equals(comp2)) {
            this.buffer.writeInt(80);
        } else {
            throw new MatchError((Object)comp2);
        }
    }

    private void putConv(Conv conv) {
        Conv conv2 = conv;
        if (Conv$Trunc$.MODULE$.equals(conv2)) {
            this.buffer.writeInt(97);
        } else if (Conv$Zext$.MODULE$.equals(conv2)) {
            this.buffer.writeInt(98);
        } else if (Conv$Sext$.MODULE$.equals(conv2)) {
            this.buffer.writeInt(99);
        } else if (Conv$Fptrunc$.MODULE$.equals(conv2)) {
            this.buffer.writeInt(100);
        } else if (Conv$Fpext$.MODULE$.equals(conv2)) {
            this.buffer.writeInt(101);
        } else if (Conv$Fptoui$.MODULE$.equals(conv2)) {
            this.buffer.writeInt(102);
        } else if (Conv$Fptosi$.MODULE$.equals(conv2)) {
            this.buffer.writeInt(103);
        } else if (Conv$Uitofp$.MODULE$.equals(conv2)) {
            this.buffer.writeInt(104);
        } else if (Conv$Sitofp$.MODULE$.equals(conv2)) {
            this.buffer.writeInt(105);
        } else if (Conv$Ptrtoint$.MODULE$.equals(conv2)) {
            this.buffer.writeInt(106);
        } else if (Conv$Inttoptr$.MODULE$.equals(conv2)) {
            this.buffer.writeInt(107);
        } else if (Conv$Bitcast$.MODULE$.equals(conv2)) {
            this.buffer.writeInt(108);
        } else {
            throw new MatchError((Object)conv2);
        }
    }

    private void putDefn(Defn value) {
        this.putPosition(value.pos());
        Defn defn = value;
        if (defn instanceof Defn.Var) {
            Defn.Var var = Defn$Var$.MODULE$.unapply((Defn.Var)defn);
            Attrs attrs = var._1();
            Global global = var._2();
            Type type = var._3();
            Val val = var._4();
            Attrs attrs2 = attrs;
            Global name = global;
            Type ty = type;
            Val value2 = val;
            this.buffer.writeInt(129);
            this.putAttrs(attrs2);
            this.putGlobal(name);
            this.putType(ty);
            this.putVal(value2);
        } else if (defn instanceof Defn.Const) {
            Defn.Const const_ = Defn$Const$.MODULE$.unapply((Defn.Const)defn);
            Attrs attrs = const_._1();
            Global global = const_._2();
            Type type = const_._3();
            Val val = const_._4();
            Attrs attrs3 = attrs;
            Global name = global;
            Type ty = type;
            Val value3 = val;
            this.buffer.writeInt(130);
            this.putAttrs(attrs3);
            this.putGlobal(name);
            this.putType(ty);
            this.putVal(value3);
        } else if (defn instanceof Defn.Declare) {
            Defn.Declare declare = Defn$Declare$.MODULE$.unapply((Defn.Declare)defn);
            Attrs attrs = declare._1();
            Global global = declare._2();
            Type type = declare._3();
            Attrs attrs4 = attrs;
            Global name = global;
            Type ty = type;
            this.buffer.writeInt(131);
            this.putAttrs(attrs4);
            this.putGlobal(name);
            this.putType(ty);
        } else if (defn instanceof Defn.Define) {
            Defn.Define define = Defn$Define$.MODULE$.unapply((Defn.Define)defn);
            Attrs attrs = define._1();
            Global global = define._2();
            Type type = define._3();
            Seq<Inst> seq = define._4();
            Attrs attrs5 = attrs;
            Global name = global;
            Type ty = type;
            Seq<Inst> insts = seq;
            this.buffer.writeInt(132);
            this.putAttrs(attrs5);
            this.putGlobal(name);
            this.putType(ty);
            this.putInsts(insts);
        } else if (defn instanceof Defn.Trait) {
            Defn.Trait trait = Defn$Trait$.MODULE$.unapply((Defn.Trait)defn);
            Attrs attrs = trait._1();
            Global global = trait._2();
            Seq<Global> seq = trait._3();
            Attrs attrs6 = attrs;
            Global name = global;
            Seq<Global> ifaces = seq;
            this.buffer.writeInt(133);
            this.putAttrs(attrs6);
            this.putGlobal(name);
            this.putGlobals(ifaces);
        } else if (defn instanceof Defn.Class) {
            Defn.Class clazz = Defn$Class$.MODULE$.unapply((Defn.Class)defn);
            Attrs attrs = clazz._1();
            Global global = clazz._2();
            Option<Global> option = clazz._3();
            Seq<Global> seq = clazz._4();
            Attrs attrs7 = attrs;
            Global name = global;
            Option<Global> parent = option;
            Seq<Global> ifaces = seq;
            this.buffer.writeInt(134);
            this.putAttrs(attrs7);
            this.putGlobal(name);
            this.putGlobalOpt(parent);
            this.putGlobals(ifaces);
        } else if (defn instanceof Defn.Module) {
            Defn.Module module = Defn$Module$.MODULE$.unapply((Defn.Module)defn);
            Attrs attrs = module._1();
            Global global = module._2();
            Option<Global> option = module._3();
            Seq<Global> seq = module._4();
            Attrs attrs8 = attrs;
            Global name = global;
            Option<Global> parent = option;
            Seq<Global> ifaces = seq;
            this.buffer.writeInt(135);
            this.putAttrs(attrs8);
            this.putGlobal(name);
            this.putGlobalOpt(parent);
            this.putGlobals(ifaces);
        } else {
            throw new MatchError((Object)defn);
        }
    }

    private void putGlobals(Seq<Global> globals) {
        this.putSeq((Seq)globals, (Function1)(JProcedure1 & Serializable)global -> this.putGlobal((Global)global));
    }

    private void putGlobalOpt(Option<Global> globalopt) {
        this.putOpt((Option)globalopt, (Function1)(JProcedure1 & Serializable)global -> this.putGlobal((Global)global));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void putGlobal(Global global) {
        Global global2 = global;
        if (Global$None$.MODULE$.equals(global2)) {
            this.buffer.writeInt(193);
            return;
        } else if (global2 instanceof Global.Top) {
            String string;
            Global.Top top = Global$Top$.MODULE$.unapply((Global.Top)global2);
            String id = string = top._1();
            this.buffer.writeInt(194);
            this.putUTF8String(id);
            return;
        } else {
            String string;
            if (!(global2 instanceof Global.Member)) throw package$.MODULE$.unreachable();
            Global.Member member = Global$Member$.MODULE$.unapply((Global.Member)global2);
            Global global3 = member._1();
            Sig sig = member._2();
            if (!(global3 instanceof Global.Top)) throw package$.MODULE$.unreachable();
            Global.Top top = Global$Top$.MODULE$.unapply((Global.Top)global3);
            String owner = string = top._1();
            Sig sig2 = sig;
            this.buffer.writeInt(195);
            this.putUTF8String(owner);
            this.putSig(sig2);
        }
    }

    private void putSig(Sig sig) {
        this.putUTF8String(sig.mangle());
    }

    private void putLocal(long local) {
        this.buffer.writeLong(local);
    }

    private void putNexts(Seq<Next> nexts) {
        this.putSeq((Seq)nexts, (Function1)(JProcedure1 & Serializable)next -> this.putNext((Next)next));
    }

    private void putNext(Next next) {
        block5: {
            Next next2;
            BinarySerializer binarySerializer = this;
            Next next3 = next;
            while (true) {
                if (Next$None$.MODULE$.equals(next2 = next3)) {
                    binarySerializer.buffer.writeInt(Tags$.MODULE$.NoneNext());
                    break block5;
                }
                if (next2 instanceof Next.Unwind) {
                    Next.Unwind unwind = Next$Unwind$.MODULE$.unapply((Next.Unwind)next2);
                    Val.Local local = unwind._1();
                    Next next4 = unwind._2();
                    Val.Local e = local;
                    Next n = next4;
                    binarySerializer.buffer.writeInt(Tags$.MODULE$.UnwindNext());
                    binarySerializer.putParam(e);
                    BinarySerializer binarySerializer2 = binarySerializer;
                    Next next5 = n;
                    binarySerializer = binarySerializer2;
                    next3 = next5;
                    continue;
                }
                if (!(next2 instanceof Next.Case)) break;
                Next.Case case_ = Next$Case$.MODULE$.unapply((Next.Case)next2);
                Val val = case_._1();
                Next next6 = case_._2();
                Val v = val;
                Next n = next6;
                binarySerializer.buffer.writeInt(Tags$.MODULE$.CaseNext());
                binarySerializer.putVal(v);
                BinarySerializer binarySerializer3 = binarySerializer;
                Next next7 = n;
                binarySerializer = binarySerializer3;
                next3 = next7;
            }
            if (next2 instanceof Next.Label) {
                Next.Label label = Next$Label$.MODULE$.unapply((Next.Label)next2);
                long l = label._1();
                Seq<Val> seq = label._2();
                long n = l;
                Seq<Val> vs = seq;
                binarySerializer.buffer.writeInt(Tags$.MODULE$.LabelNext());
                binarySerializer.putLocal(n);
                binarySerializer.putVals(vs);
            } else {
                throw new MatchError((Object)next2);
            }
        }
    }

    private void putOp(Op op) {
        Op op2 = op;
        if (op2 instanceof Op.Call) {
            Op.Call call = Op$Call$.MODULE$.unapply((Op.Call)op2);
            Type type = call._1();
            Val val = call._2();
            Seq<Val> seq = call._3();
            Type ty = type;
            Val v = val;
            Seq<Val> args = seq;
            this.buffer.writeInt(Tags$.MODULE$.CallOp());
            this.putType(ty);
            this.putVal(v);
            this.putVals(args);
        } else if (op2 instanceof Op.Load) {
            Op.Load load = Op$Load$.MODULE$.unapply((Op.Load)op2);
            Type type = load._1();
            Val val = load._2();
            Type ty = type;
            Val ptr = val;
            this.buffer.writeInt(Tags$.MODULE$.LoadOp());
            this.putType(ty);
            this.putVal(ptr);
        } else if (op2 instanceof Op.Store) {
            Op.Store store = Op$Store$.MODULE$.unapply((Op.Store)op2);
            Type type = store._1();
            Val val = store._2();
            Val val2 = store._3();
            Type ty = type;
            Val value = val;
            Val ptr = val2;
            this.buffer.writeInt(Tags$.MODULE$.StoreOp());
            this.putType(ty);
            this.putVal(value);
            this.putVal(ptr);
        } else if (op2 instanceof Op.Elem) {
            Op.Elem elem = Op$Elem$.MODULE$.unapply((Op.Elem)op2);
            Type type = elem._1();
            Val val = elem._2();
            Seq<Val> seq = elem._3();
            Type ty = type;
            Val v = val;
            Seq<Val> indexes = seq;
            this.buffer.writeInt(Tags$.MODULE$.ElemOp());
            this.putType(ty);
            this.putVal(v);
            this.putVals(indexes);
        } else if (op2 instanceof Op.Extract) {
            Op.Extract extract = Op$Extract$.MODULE$.unapply((Op.Extract)op2);
            Val val = extract._1();
            Seq<Object> seq = extract._2();
            Val v = val;
            Seq<Object> indexes = seq;
            this.buffer.writeInt(Tags$.MODULE$.ExtractOp());
            this.putVal(v);
            this.putInts(indexes);
        } else if (op2 instanceof Op.Insert) {
            Op.Insert insert = Op$Insert$.MODULE$.unapply((Op.Insert)op2);
            Val val = insert._1();
            Val val3 = insert._2();
            Seq<Object> seq = insert._3();
            Val v = val;
            Val value = val3;
            Seq<Object> indexes = seq;
            this.buffer.writeInt(Tags$.MODULE$.InsertOp());
            this.putVal(v);
            this.putVal(value);
            this.putInts(indexes);
        } else if (op2 instanceof Op.Stackalloc) {
            Op.Stackalloc stackalloc = Op$Stackalloc$.MODULE$.unapply((Op.Stackalloc)op2);
            Type type = stackalloc._1();
            Val val = stackalloc._2();
            Type ty = type;
            Val n = val;
            this.buffer.writeInt(Tags$.MODULE$.StackallocOp());
            this.putType(ty);
            this.putVal(n);
        } else if (op2 instanceof Op.Bin) {
            Op.Bin bin = Op$Bin$.MODULE$.unapply((Op.Bin)op2);
            Bin bin2 = bin._1();
            Type type = bin._2();
            Val val = bin._3();
            Val val4 = bin._4();
            Bin bin3 = bin2;
            Type ty = type;
            Val l = val;
            Val r = val4;
            this.buffer.writeInt(Tags$.MODULE$.BinOp());
            this.putBin(bin3);
            this.putType(ty);
            this.putVal(l);
            this.putVal(r);
        } else if (op2 instanceof Op.Comp) {
            Op.Comp comp = Op$Comp$.MODULE$.unapply((Op.Comp)op2);
            Comp comp2 = comp._1();
            Type type = comp._2();
            Val val = comp._3();
            Val val5 = comp._4();
            Comp comp3 = comp2;
            Type ty = type;
            Val l = val;
            Val r = val5;
            this.buffer.writeInt(Tags$.MODULE$.CompOp());
            this.putComp(comp3);
            this.putType(ty);
            this.putVal(l);
            this.putVal(r);
        } else if (op2 instanceof Op.Conv) {
            Op.Conv conv = Op$Conv$.MODULE$.unapply((Op.Conv)op2);
            Conv conv2 = conv._1();
            Type type = conv._2();
            Val val = conv._3();
            Conv conv3 = conv2;
            Type ty = type;
            Val v = val;
            this.buffer.writeInt(Tags$.MODULE$.ConvOp());
            this.putConv(conv3);
            this.putType(ty);
            this.putVal(v);
        } else if (op2 instanceof Op.Classalloc) {
            Global global;
            Op.Classalloc classalloc = Op$Classalloc$.MODULE$.unapply((Op.Classalloc)op2);
            Global n = global = classalloc._1();
            this.buffer.writeInt(Tags$.MODULE$.ClassallocOp());
            this.putGlobal(n);
        } else if (op2 instanceof Op.Fieldload) {
            Op.Fieldload fieldload = Op$Fieldload$.MODULE$.unapply((Op.Fieldload)op2);
            Type type = fieldload._1();
            Val val = fieldload._2();
            Global global = fieldload._3();
            Type ty = type;
            Val obj = val;
            Global name = global;
            this.buffer.writeInt(Tags$.MODULE$.FieldloadOp());
            this.putType(ty);
            this.putVal(obj);
            this.putGlobal(name);
        } else if (op2 instanceof Op.Fieldstore) {
            Op.Fieldstore fieldstore = Op$Fieldstore$.MODULE$.unapply((Op.Fieldstore)op2);
            Type type = fieldstore._1();
            Val val = fieldstore._2();
            Global global = fieldstore._3();
            Val val6 = fieldstore._4();
            Type ty = type;
            Val obj = val;
            Global name = global;
            Val value = val6;
            this.buffer.writeInt(Tags$.MODULE$.FieldstoreOp());
            this.putType(ty);
            this.putVal(obj);
            this.putGlobal(name);
            this.putVal(value);
        } else if (op2 instanceof Op.Field) {
            Op.Field field = Op$Field$.MODULE$.unapply((Op.Field)op2);
            Val val = field._1();
            Global global = field._2();
            Val v = val;
            Global name = global;
            this.buffer.writeInt(Tags$.MODULE$.FieldOp());
            this.putVal(v);
            this.putGlobal(name);
        } else if (op2 instanceof Op.Method) {
            Op.Method method = Op$Method$.MODULE$.unapply((Op.Method)op2);
            Val val = method._1();
            Sig sig = method._2();
            Val v = val;
            Sig sig2 = sig;
            this.buffer.writeInt(Tags$.MODULE$.MethodOp());
            this.putVal(v);
            this.putSig(sig2);
        } else if (op2 instanceof Op.Dynmethod) {
            Op.Dynmethod dynmethod = Op$Dynmethod$.MODULE$.unapply((Op.Dynmethod)op2);
            Val val = dynmethod._1();
            Sig sig = dynmethod._2();
            Val obj = val;
            Sig sig3 = sig;
            this.buffer.writeInt(Tags$.MODULE$.DynmethodOp());
            this.putVal(obj);
            this.putSig(sig3);
        } else if (op2 instanceof Op.Module) {
            Global global;
            Op.Module module = Op$Module$.MODULE$.unapply((Op.Module)op2);
            Global name = global = module._1();
            this.buffer.writeInt(Tags$.MODULE$.ModuleOp());
            this.putGlobal(name);
        } else if (op2 instanceof Op.As) {
            Op.As as = Op$As$.MODULE$.unapply((Op.As)op2);
            Type type = as._1();
            Val val = as._2();
            Type ty = type;
            Val v = val;
            this.buffer.writeInt(Tags$.MODULE$.AsOp());
            this.putType(ty);
            this.putVal(v);
        } else if (op2 instanceof Op.Is) {
            Op.Is is = Op$Is$.MODULE$.unapply((Op.Is)op2);
            Type type = is._1();
            Val val = is._2();
            Type ty = type;
            Val v = val;
            this.buffer.writeInt(Tags$.MODULE$.IsOp());
            this.putType(ty);
            this.putVal(v);
        } else if (op2 instanceof Op.Copy) {
            Val val;
            Op.Copy copy = Op$Copy$.MODULE$.unapply((Op.Copy)op2);
            Val v = val = copy._1();
            this.buffer.writeInt(Tags$.MODULE$.CopyOp());
            this.putVal(v);
        } else if (op2 instanceof Op.Sizeof) {
            Type type;
            Op.Sizeof sizeof = Op$Sizeof$.MODULE$.unapply((Op.Sizeof)op2);
            Type ty = type = sizeof._1();
            this.buffer.writeInt(Tags$.MODULE$.SizeofOp());
            this.putType(ty);
        } else if (op2 instanceof Op.Box) {
            Op.Box box = Op$Box$.MODULE$.unapply((Op.Box)op2);
            Type type = box._1();
            Val val = box._2();
            Type ty = type;
            Val obj = val;
            this.buffer.writeInt(Tags$.MODULE$.BoxOp());
            this.putType(ty);
            this.putVal(obj);
        } else if (op2 instanceof Op.Unbox) {
            Op.Unbox unbox = Op$Unbox$.MODULE$.unapply((Op.Unbox)op2);
            Type type = unbox._1();
            Val val = unbox._2();
            Type ty = type;
            Val obj = val;
            this.buffer.writeInt(Tags$.MODULE$.UnboxOp());
            this.putType(ty);
            this.putVal(obj);
        } else if (op2 instanceof Op.Var) {
            Type type;
            Op.Var var = Op$Var$.MODULE$.unapply((Op.Var)op2);
            Type ty = type = var._1();
            this.buffer.writeInt(Tags$.MODULE$.VarOp());
            this.putType(ty);
        } else if (op2 instanceof Op.Varload) {
            Val val;
            Op.Varload varload = Op$Varload$.MODULE$.unapply((Op.Varload)op2);
            Val slot = val = varload._1();
            this.buffer.writeInt(Tags$.MODULE$.VarloadOp());
            this.putVal(slot);
        } else if (op2 instanceof Op.Varstore) {
            Op.Varstore varstore = Op$Varstore$.MODULE$.unapply((Op.Varstore)op2);
            Val val = varstore._1();
            Val val7 = varstore._2();
            Val slot = val;
            Val value = val7;
            this.buffer.writeInt(Tags$.MODULE$.VarstoreOp());
            this.putVal(slot);
            this.putVal(value);
        } else if (op2 instanceof Op.Arrayalloc) {
            Op.Arrayalloc arrayalloc = Op$Arrayalloc$.MODULE$.unapply((Op.Arrayalloc)op2);
            Type type = arrayalloc._1();
            Val val = arrayalloc._2();
            Type ty = type;
            Val init = val;
            this.buffer.writeInt(Tags$.MODULE$.ArrayallocOp());
            this.putType(ty);
            this.putVal(init);
        } else if (op2 instanceof Op.Arrayload) {
            Op.Arrayload arrayload = Op$Arrayload$.MODULE$.unapply((Op.Arrayload)op2);
            Type type = arrayload._1();
            Val val = arrayload._2();
            Val val8 = arrayload._3();
            Type ty = type;
            Val arr = val;
            Val idx = val8;
            this.buffer.writeInt(Tags$.MODULE$.ArrayloadOp());
            this.putType(ty);
            this.putVal(arr);
            this.putVal(idx);
        } else if (op2 instanceof Op.Arraystore) {
            Op.Arraystore arraystore = Op$Arraystore$.MODULE$.unapply((Op.Arraystore)op2);
            Type type = arraystore._1();
            Val val = arraystore._2();
            Val val9 = arraystore._3();
            Val val10 = arraystore._4();
            Type ty = type;
            Val arr = val;
            Val idx = val9;
            Val value = val10;
            this.buffer.writeInt(Tags$.MODULE$.ArraystoreOp());
            this.putType(ty);
            this.putVal(arr);
            this.putVal(idx);
            this.putVal(value);
        } else if (op2 instanceof Op.Arraylength) {
            Val val;
            Op.Arraylength arraylength = Op$Arraylength$.MODULE$.unapply((Op.Arraylength)op2);
            Val arr = val = arraylength._1();
            this.buffer.writeInt(Tags$.MODULE$.ArraylengthOp());
            this.putVal(arr);
        } else {
            throw new MatchError((Object)op2);
        }
    }

    private void putParams(Seq<Val.Local> params) {
        this.putSeq((Seq)params, (Function1)(JProcedure1 & Serializable)param -> this.putParam((Val.Local)param));
    }

    private void putParam(Val.Local param) {
        this.putLocal(param.name());
        this.putType(param.ty());
    }

    private void putTypes(Seq<Type> tys) {
        this.putSeq((Seq)tys, (Function1)(JProcedure1 & Serializable)ty -> this.putType((Type)ty));
    }

    private void putType(Type ty) {
        block23: {
            Type type;
            BinarySerializer binarySerializer = this;
            Type type2 = ty;
            while (true) {
                Type type3;
                if (Type$Vararg$.MODULE$.equals(type = type2)) {
                    binarySerializer.buffer.writeInt(Tags$.MODULE$.VarargType());
                    break block23;
                }
                if (Type$Ptr$.MODULE$.equals(type)) {
                    binarySerializer.buffer.writeInt(Tags$.MODULE$.PtrType());
                    break block23;
                }
                if (Type$Bool$.MODULE$.equals(type)) {
                    binarySerializer.buffer.writeInt(Tags$.MODULE$.BoolType());
                    break block23;
                }
                if (Type$Char$.MODULE$.equals(type)) {
                    binarySerializer.buffer.writeInt(Tags$.MODULE$.CharType());
                    break block23;
                }
                if (Type$Byte$.MODULE$.equals(type)) {
                    binarySerializer.buffer.writeInt(Tags$.MODULE$.ByteType());
                    break block23;
                }
                if (Type$Short$.MODULE$.equals(type)) {
                    binarySerializer.buffer.writeInt(Tags$.MODULE$.ShortType());
                    break block23;
                }
                if (Type$Int$.MODULE$.equals(type)) {
                    binarySerializer.buffer.writeInt(Tags$.MODULE$.IntType());
                    break block23;
                }
                if (Type$Long$.MODULE$.equals(type)) {
                    binarySerializer.buffer.writeInt(Tags$.MODULE$.LongType());
                    break block23;
                }
                if (Type$Float$.MODULE$.equals(type)) {
                    binarySerializer.buffer.writeInt(Tags$.MODULE$.FloatType());
                    break block23;
                }
                if (Type$Double$.MODULE$.equals(type)) {
                    binarySerializer.buffer.writeInt(Tags$.MODULE$.DoubleType());
                    break block23;
                }
                if (type instanceof Type.ArrayValue) {
                    Type.ArrayValue arrayValue = Type$ArrayValue$.MODULE$.unapply((Type.ArrayValue)type);
                    Type type4 = arrayValue._1();
                    int n = arrayValue._2();
                    Type ty2 = type4;
                    int n2 = n;
                    binarySerializer.buffer.writeInt(Tags$.MODULE$.ArrayValueType());
                    binarySerializer.putType(ty2);
                    binarySerializer.buffer.writeInt(n2);
                    break block23;
                }
                if (type instanceof Type.StructValue) {
                    Seq<Type> seq;
                    Type.StructValue structValue = Type$StructValue$.MODULE$.unapply((Type.StructValue)type);
                    Seq<Type> tys = seq = structValue._1();
                    binarySerializer.buffer.writeInt(Tags$.MODULE$.StructValueType());
                    binarySerializer.putTypes(tys);
                    break block23;
                }
                if (type instanceof Type.Function) {
                    Type.Function function = Type$Function$.MODULE$.unapply((Type.Function)type);
                    Seq<Type> seq = function._1();
                    Type type5 = function._2();
                    Seq<Type> args = seq;
                    Type ret = type5;
                    binarySerializer.buffer.writeInt(Tags$.MODULE$.FunctionType());
                    binarySerializer.putTypes(args);
                    BinarySerializer binarySerializer2 = binarySerializer;
                    Type type6 = ret;
                    binarySerializer = binarySerializer2;
                    type2 = type6;
                    continue;
                }
                if (Type$Null$.MODULE$.equals(type)) {
                    binarySerializer.buffer.writeInt(Tags$.MODULE$.NullType());
                    break block23;
                }
                if (Type$Nothing$.MODULE$.equals(type)) {
                    binarySerializer.buffer.writeInt(Tags$.MODULE$.NothingType());
                    break block23;
                }
                if (Type$Virtual$.MODULE$.equals(type)) {
                    binarySerializer.buffer.writeInt(Tags$.MODULE$.VirtualType());
                    break block23;
                }
                if (!(type instanceof Type.Var)) break;
                Type.Var var = Type$Var$.MODULE$.unapply((Type.Var)type);
                Type ty3 = type3 = var._1();
                binarySerializer.buffer.writeInt(Tags$.MODULE$.VarType());
                BinarySerializer binarySerializer3 = binarySerializer;
                Type type7 = ty3;
                binarySerializer = binarySerializer3;
                type2 = type7;
            }
            if (Type$Unit$.MODULE$.equals(type)) {
                binarySerializer.buffer.writeInt(Tags$.MODULE$.UnitType());
            } else if (type instanceof Type.Array) {
                Type.Array array = Type$Array$.MODULE$.unapply((Type.Array)type);
                Type type8 = array._1();
                boolean bl = array._2();
                Type ty4 = type8;
                boolean nullable = bl;
                binarySerializer.buffer.writeInt(Tags$.MODULE$.ArrayType());
                binarySerializer.putType(ty4);
                binarySerializer.putBool(nullable);
            } else if (type instanceof Type.Ref) {
                Type.Ref ref = Type$Ref$.MODULE$.unapply((Type.Ref)type);
                Global global = ref._1();
                boolean bl = ref._2();
                boolean bl2 = ref._3();
                Global n = global;
                boolean exact = bl;
                boolean nullable = bl2;
                binarySerializer.buffer.writeInt(Tags$.MODULE$.RefType());
                binarySerializer.putGlobal(n);
                binarySerializer.putBool(exact);
                binarySerializer.putBool(nullable);
            } else {
                throw new MatchError((Object)type);
            }
        }
    }

    private void putVals(Seq<Val> values) {
        this.putSeq((Seq)values, (Function1)(JProcedure1 & Serializable)value -> this.putVal((Val)value));
    }

    private void putVal(Val value) {
        block24: {
            Val val;
            BinarySerializer binarySerializer = this;
            Val val2 = value;
            while (true) {
                Val val3;
                if (Val$True$.MODULE$.equals(val = val2)) {
                    binarySerializer.buffer.writeInt(Tags$.MODULE$.TrueVal());
                    break block24;
                }
                if (Val$False$.MODULE$.equals(val)) {
                    binarySerializer.buffer.writeInt(Tags$.MODULE$.FalseVal());
                    break block24;
                }
                if (Val$Null$.MODULE$.equals(val)) {
                    binarySerializer.buffer.writeInt(Tags$.MODULE$.NullVal());
                    break block24;
                }
                if (val instanceof Val.Zero) {
                    Type type;
                    Val.Zero zero = Val$Zero$.MODULE$.unapply((Val.Zero)val);
                    Type ty = type = zero._1();
                    binarySerializer.buffer.writeInt(Tags$.MODULE$.ZeroVal());
                    binarySerializer.putType(ty);
                    break block24;
                }
                if (val instanceof Val.Char) {
                    char c;
                    Val.Char char_ = Val$Char$.MODULE$.unapply((Val.Char)val);
                    char v = c = char_._1();
                    binarySerializer.buffer.writeInt(Tags$.MODULE$.CharVal());
                    binarySerializer.buffer.writeShort(Short$.MODULE$.short2int((short)v));
                    break block24;
                }
                if (val instanceof Val.Byte) {
                    byte by;
                    Val.Byte byteVal = Val$Byte$.MODULE$.unapply((Val.Byte)val);
                    byte v = by = byteVal._1();
                    binarySerializer.buffer.writeInt(Tags$.MODULE$.ByteVal());
                    binarySerializer.buffer.write(Byte$.MODULE$.byte2int(v));
                    break block24;
                }
                if (val instanceof Val.Short) {
                    short s;
                    Val.Short shortVal = Val$Short$.MODULE$.unapply((Val.Short)val);
                    short v = s = shortVal._1();
                    binarySerializer.buffer.writeInt(Tags$.MODULE$.ShortVal());
                    binarySerializer.buffer.writeShort(Short$.MODULE$.short2int(v));
                    break block24;
                }
                if (val instanceof Val.Int) {
                    int n;
                    Val.Int intVal = Val$Int$.MODULE$.unapply((Val.Int)val);
                    int v = n = intVal._1();
                    binarySerializer.buffer.writeInt(Tags$.MODULE$.IntVal());
                    binarySerializer.buffer.writeInt(v);
                    break block24;
                }
                if (val instanceof Val.Long) {
                    long l;
                    Val.Long longVal = Val$Long$.MODULE$.unapply((Val.Long)val);
                    long v = l = longVal._1();
                    binarySerializer.buffer.writeInt(Tags$.MODULE$.LongVal());
                    binarySerializer.buffer.writeLong(v);
                    break block24;
                }
                if (val instanceof Val.Float) {
                    float f;
                    Val.Float float_ = Val$Float$.MODULE$.unapply((Val.Float)val);
                    float v = f = float_._1();
                    binarySerializer.buffer.writeInt(Tags$.MODULE$.FloatVal());
                    binarySerializer.buffer.writeFloat(v);
                    break block24;
                }
                if (val instanceof Val.Double) {
                    double d;
                    Val.Double double_ = Val$Double$.MODULE$.unapply((Val.Double)val);
                    double v = d = double_._1();
                    binarySerializer.buffer.writeInt(Tags$.MODULE$.DoubleVal());
                    binarySerializer.buffer.writeDouble(v);
                    break block24;
                }
                if (val instanceof Val.StructValue) {
                    Seq<Val> seq;
                    Val.StructValue structValue = Val$StructValue$.MODULE$.unapply((Val.StructValue)val);
                    Seq<Val> vs = seq = structValue._1();
                    binarySerializer.buffer.writeInt(Tags$.MODULE$.StructValueVal());
                    binarySerializer.putVals(vs);
                    break block24;
                }
                if (val instanceof Val.ArrayValue) {
                    Val.ArrayValue arrayValue = Val$ArrayValue$.MODULE$.unapply((Val.ArrayValue)val);
                    Type type = arrayValue._1();
                    Seq<Val> seq = arrayValue._2();
                    Type ty = type;
                    Seq<Val> vs = seq;
                    binarySerializer.buffer.writeInt(Tags$.MODULE$.ArrayValueVal());
                    binarySerializer.putType(ty);
                    binarySerializer.putVals(vs);
                    break block24;
                }
                if (val instanceof Val.Chars) {
                    Val.Chars v = (Val.Chars)val;
                    binarySerializer.buffer.writeInt(Tags$.MODULE$.CharsVal());
                    binarySerializer.putBytes(v.bytes());
                    break block24;
                }
                if (val instanceof Val.Local) {
                    Val.Local local = Val$Local$.MODULE$.unapply((Val.Local)val);
                    long l = local._1();
                    Type type = local._2();
                    long n = l;
                    Type ty = type;
                    binarySerializer.buffer.writeInt(Tags$.MODULE$.LocalVal());
                    binarySerializer.putLocal(n);
                    binarySerializer.putType(ty);
                    break block24;
                }
                if (val instanceof Val.Global) {
                    Val.Global global = Val$Global$.MODULE$.unapply((Val.Global)val);
                    Global global2 = global._1();
                    Type type = global._2();
                    Global n = global2;
                    Type ty = type;
                    binarySerializer.buffer.writeInt(Tags$.MODULE$.GlobalVal());
                    binarySerializer.putGlobal(n);
                    binarySerializer.putType(ty);
                    break block24;
                }
                if (Val$Unit$.MODULE$.equals(val)) {
                    binarySerializer.buffer.writeInt(Tags$.MODULE$.UnitVal());
                    break block24;
                }
                if (!(val instanceof Val.Const)) break;
                Val.Const const_ = Val$Const$.MODULE$.unapply((Val.Const)val);
                Val v = val3 = const_._1();
                binarySerializer.buffer.writeInt(Tags$.MODULE$.ConstVal());
                BinarySerializer binarySerializer2 = binarySerializer;
                Val val4 = v;
                binarySerializer = binarySerializer2;
                val2 = val4;
            }
            if (val instanceof Val.String) {
                String string;
                Val.String string2 = Val$String$.MODULE$.unapply((Val.String)val);
                String v = string = string2._1();
                binarySerializer.buffer.writeInt(Tags$.MODULE$.StringVal());
                binarySerializer.buffer.writeInt(v.length());
                StringOps$.MODULE$.foreach$extension(Predef$.MODULE$.augmentString(v), (Function1 & Serializable)v1 -> {
                    binarySerializer.buffer.writeChar(Char$.MODULE$.char2int(BoxesRunTime.unboxToChar((Object)v1)));
                    return BoxedUnit.UNIT;
                });
            } else if (val instanceof Val.Virtual) {
                long l;
                Val.Virtual virtual = Val$Virtual$.MODULE$.unapply((Val.Virtual)val);
                long v = l = virtual._1();
                binarySerializer.buffer.writeInt(Tags$.MODULE$.VirtualVal());
                binarySerializer.buffer.writeLong(v);
            } else if (val instanceof Val.ClassOf) {
                Global global;
                Val.ClassOf classOf = Val$ClassOf$.MODULE$.unapply((Val.ClassOf)val);
                Global cls = global = classOf._1();
                binarySerializer.buffer.writeInt(Tags$.MODULE$.ClassOfVal());
                binarySerializer.putGlobal(cls);
            } else {
                throw new MatchError((Object)val);
            }
        }
    }

    private void putLinktimeCondition(LinktimeCondition cond) {
        LinktimeCondition linktimeCondition = cond;
        if (linktimeCondition instanceof LinktimeCondition.SimpleCondition) {
            LinktimeCondition.SimpleCondition simpleCondition = LinktimeCondition$SimpleCondition$.MODULE$.unapply((LinktimeCondition.SimpleCondition)linktimeCondition);
            String string = simpleCondition._1();
            Comp comp = simpleCondition._2();
            Val val = simpleCondition._3();
            String propertyName = string;
            Comp comparison = comp;
            Val value = val;
            this.buffer.writeInt(1);
            this.putUTF8String(propertyName);
            this.putComp(comparison);
            this.putVal(value);
            this.putPosition(cond.position());
        } else if (linktimeCondition instanceof LinktimeCondition.ComplexCondition) {
            LinktimeCondition.ComplexCondition complexCondition = LinktimeCondition$ComplexCondition$.MODULE$.unapply((LinktimeCondition.ComplexCondition)linktimeCondition);
            Bin bin = complexCondition._1();
            LinktimeCondition linktimeCondition2 = complexCondition._2();
            LinktimeCondition linktimeCondition3 = complexCondition._3();
            Bin op = bin;
            LinktimeCondition left = linktimeCondition2;
            LinktimeCondition right = linktimeCondition3;
            this.buffer.writeInt(2);
            this.putBin(op);
            this.putLinktimeCondition(left);
            this.putLinktimeCondition(right);
            this.putPosition(cond.position());
        } else {
            throw new MatchError((Object)linktimeCondition);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void putPosition(Position pos) {
        boolean columnIsByte;
        block11: {
            block10: {
                Position position = pos;
                Position position2 = Position$.MODULE$.NoPosition();
                if (!(position != null ? !((Object)position).equals(position2) : position2 != null)) {
                    this.buffer.write(Byte$.MODULE$.byte2int((byte)-1));
                    return;
                }
                Position position3 = this.lastPosition;
                Position position4 = Position$.MODULE$.NoPosition();
                if (!(position3 == null ? position4 != null : !((Object)position3).equals(position4))) break block10;
                URI uRI = pos.source();
                URI uRI2 = this.lastPosition.source();
                if (!(uRI == null ? uRI2 != null : !((Object)uRI).equals(uRI2))) break block11;
            }
            this.writeFull$1(pos);
            this.lastPosition = pos;
            return;
        }
        int line = pos.line();
        int column = pos.column();
        int lineDiff = line - this.lastPosition.line();
        int columnDiff = column - this.lastPosition.column();
        boolean bl = columnIsByte = column >= 0 && column < 256;
        if (lineDiff == 0 && columnDiff >= -64 && columnDiff < 64) {
            this.buffer.write(Byte$.MODULE$.byte2int((byte)(columnDiff << 1 | 0)));
        } else if (lineDiff >= -32 && lineDiff < 32 && columnIsByte) {
            this.buffer.write(Byte$.MODULE$.byte2int((byte)(lineDiff << 2 | 1)));
            this.buffer.write(Byte$.MODULE$.byte2int((byte)column));
        } else if (lineDiff >= Short.MIN_VALUE && lineDiff <= Short.MAX_VALUE && columnIsByte) {
            this.buffer.write(Byte$.MODULE$.byte2int((byte)3));
            this.buffer.writeShort(Short$.MODULE$.short2int((short)lineDiff));
            this.buffer.write(Byte$.MODULE$.byte2int((byte)column));
        } else {
            this.writeFull$1(pos);
        }
        this.lastPosition = pos;
    }

    private Seq<String> initFiles(Seq<Defn> defns) {
        UnrolledBuffer filesList = UnrolledBuffer$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class));
        defns.foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Defn defn = x$1;
            if (defn instanceof Defn.Define) {
                Seq<Inst> seq;
                Defn.Define define = (Defn.Define)defn;
                Defn.Define define2 = Defn$Define$.MODULE$.unapply(define);
                Attrs attrs = define2._1();
                Global global = define2._2();
                Type type = define2._3();
                Seq<Inst> insts = seq = define2._4();
                Defn.Define defn2 = define;
                this.initFile$1(filesList, defn2.pos());
                insts.foreach((Function1)(JProcedure1 & Serializable)inst -> this.initFile$1(filesList, inst.pos()));
            } else {
                Defn defn3 = defn;
                this.initFile$1(filesList, defn3.pos());
            }
        });
        return filesList.toSeq();
    }

    private final void writeFull$1(Position pos$1) {
        this.buffer.write(Byte$.MODULE$.byte2int((byte)7));
        this.buffer.writeInt(BoxesRunTime.unboxToInt((Object)this.fileIndexMap.apply((Object)pos$1.source())));
        this.buffer.writeInt(pos$1.line());
        this.buffer.writeInt(pos$1.column());
    }

    /*
     * WARNING - void declaration
     */
    private static final int initFile$1$$anonfun$1(UnrolledBuffer filesList$2, URI file$1) {
        void var2_2;
        int idx = filesList$2.size();
        filesList$2.$plus$eq((Object)file$1.toString());
        return (int)var2_2;
    }

    private final void initFile$1(UnrolledBuffer filesList$1, Position pos) {
        URI file = pos.source();
        if (pos.isDefined()) {
            this.fileIndexMap.getOrElseUpdate((Object)file, () -> BinarySerializer.initFile$1$$anonfun$1(filesList$1, file));
        }
    }
}

