/*
 * Decompiled with CFR 0.152.
 */
package scala.scalanative.io;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.scalanative.io.VirtualDirectory;
import scala.scalanative.io.VirtualDirectory$EmptyDirectory$;
import scala.scalanative.util.Scope;

public final class VirtualDirectory$ {
    public static final VirtualDirectory$ MODULE$;
    private final VirtualDirectory empty;

    static {
        new VirtualDirectory$();
    }

    public VirtualDirectory local(Path file) {
        Predef$.MODULE$.assert(Files.exists(file, new LinkOption[0]), (Function0)new Serializable(file){
            public static final long serialVersionUID = 0L;
            private final Path file$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Local directory doesn't exist: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{VirtualDirectory$.MODULE$.scala$scalanative$io$VirtualDirectory$$absolute$1(this.file$1)}));
            }
            {
                this.file$1 = file$1;
            }
        });
        Predef$.MODULE$.assert(Files.isDirectory(file, new LinkOption[0]), (Function0)new Serializable(file){
            public static final long serialVersionUID = 0L;
            private final Path file$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Not a directory: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{VirtualDirectory$.MODULE$.scala$scalanative$io$VirtualDirectory$$absolute$1(this.file$1)}));
            }
            {
                this.file$1 = file$1;
            }
        });
        return new VirtualDirectory.LocalDirectory(file);
    }

    public VirtualDirectory jar(Path file, Scope in) {
        Path absolute = file.toAbsolutePath();
        Predef$.MODULE$.assert(Files.exists(file, new LinkOption[0]), (Function0)new Serializable(absolute){
            public static final long serialVersionUID = 0L;
            private final Path absolute$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Jar doesn't exist: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.absolute$2}));
            }
            {
                this.absolute$2 = absolute$2;
            }
        });
        Predef$.MODULE$.assert(((Object)absolute).toString().endsWith(".jar"), (Function0)new Serializable(absolute){
            public static final long serialVersionUID = 0L;
            private final Path absolute$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Not a jar: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.absolute$2}));
            }
            {
                this.absolute$2 = absolute$2;
            }
        });
        return new VirtualDirectory.JarDirectory(file, in);
    }

    public VirtualDirectory real(Path file, Scope in) {
        block4: {
            VirtualDirectory virtualDirectory;
            block3: {
                block2: {
                    if (!Files.isDirectory(file, new LinkOption[0])) break block2;
                    virtualDirectory = this.local(file);
                    break block3;
                }
                if (!((Object)file).toString().endsWith(".jar")) break block4;
                virtualDirectory = this.jar(file, in);
            }
            return virtualDirectory;
        }
        throw new UnsupportedOperationException(new StringBuilder().append((Object)"Neither a jar, nor a directory: ").append((Object)file).toString());
    }

    public VirtualDirectory empty() {
        return this.empty;
    }

    public final Path scala$scalanative$io$VirtualDirectory$$absolute$1(Path file$1) {
        return file$1.toAbsolutePath();
    }

    private VirtualDirectory$() {
        MODULE$ = this;
        this.empty = VirtualDirectory$EmptyDirectory$.MODULE$;
    }
}

