/*
 * Decompiled with CFR 0.152.
 */
package scala.scalanative.io;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.scalanative.io.VirtualDirectory;
import scala.scalanative.io.VirtualDirectory$EmptyDirectory$;
import scala.scalanative.util.Scope;

public final class VirtualDirectory$ {
    public static VirtualDirectory$ MODULE$;
    private final VirtualDirectory empty;

    static {
        new VirtualDirectory$();
    }

    public VirtualDirectory local(Path file) {
        Predef$.MODULE$.assert(Files.exists(file, new LinkOption[0]), (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(31).append("Local directory doesn't exist: ").append(VirtualDirectory$.absolute$1(file)).toString());
        Predef$.MODULE$.assert(Files.isDirectory(file, new LinkOption[0]), (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(17).append("Not a directory: ").append(VirtualDirectory$.absolute$1(file)).toString());
        return new VirtualDirectory.LocalDirectory(file);
    }

    public VirtualDirectory jar(Path file, Scope in) {
        Path absolute = file.toAbsolutePath();
        Predef$.MODULE$.assert(Files.exists(file, new LinkOption[0]), (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(19).append("Jar doesn't exist: ").append(absolute).toString());
        Predef$.MODULE$.assert(((Object)absolute).toString().endsWith(".jar"), (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(11).append("Not a jar: ").append(absolute).toString());
        return new VirtualDirectory.JarDirectory(file, in);
    }

    public VirtualDirectory real(Path file, Scope in) {
        VirtualDirectory virtualDirectory;
        if (Files.isDirectory(file, new LinkOption[0])) {
            virtualDirectory = this.local(file);
        } else if (((Object)file).toString().endsWith(".jar")) {
            virtualDirectory = this.jar(file, in);
        } else {
            throw new UnsupportedOperationException(new StringBuilder(32).append("Neither a jar, nor a directory: ").append(file).toString());
        }
        return virtualDirectory;
    }

    public VirtualDirectory empty() {
        return this.empty;
    }

    private static final Path absolute$1(Path file$1) {
        return file$1.toAbsolutePath();
    }

    private VirtualDirectory$() {
        MODULE$ = this;
        this.empty = VirtualDirectory$EmptyDirectory$.MODULE$;
    }
}

