/*
 * Decompiled with CFR 0.152.
 */
package scala.scalanative.nir.serialization;

import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.UnrolledBuffer;
import scala.collection.mutable.UnrolledBuffer$;
import scala.reflect.ClassTag$;
import scala.reflect.NameTransformer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.scalanative.nir.Attr;
import scala.scalanative.nir.Attr$Abstract$;
import scala.scalanative.nir.Attr$AlwaysInline$;
import scala.scalanative.nir.Attr$DidOpt$;
import scala.scalanative.nir.Attr$Dyn$;
import scala.scalanative.nir.Attr$Extern$;
import scala.scalanative.nir.Attr$InlineHint$;
import scala.scalanative.nir.Attr$LinktimeResolved$;
import scala.scalanative.nir.Attr$MayInline$;
import scala.scalanative.nir.Attr$MaySpecialize$;
import scala.scalanative.nir.Attr$NoInline$;
import scala.scalanative.nir.Attr$NoOpt$;
import scala.scalanative.nir.Attr$NoSpecialize$;
import scala.scalanative.nir.Attr$Stub$;
import scala.scalanative.nir.Attr$UnOpt$;
import scala.scalanative.nir.Attrs;
import scala.scalanative.nir.Attrs$;
import scala.scalanative.nir.Bin;
import scala.scalanative.nir.Bin$And$;
import scala.scalanative.nir.Bin$Ashr$;
import scala.scalanative.nir.Bin$Fadd$;
import scala.scalanative.nir.Bin$Fdiv$;
import scala.scalanative.nir.Bin$Fmul$;
import scala.scalanative.nir.Bin$Frem$;
import scala.scalanative.nir.Bin$Fsub$;
import scala.scalanative.nir.Bin$Iadd$;
import scala.scalanative.nir.Bin$Imul$;
import scala.scalanative.nir.Bin$Isub$;
import scala.scalanative.nir.Bin$Lshr$;
import scala.scalanative.nir.Bin$Or$;
import scala.scalanative.nir.Bin$Sdiv$;
import scala.scalanative.nir.Bin$Shl$;
import scala.scalanative.nir.Bin$Srem$;
import scala.scalanative.nir.Bin$Udiv$;
import scala.scalanative.nir.Bin$Urem$;
import scala.scalanative.nir.Bin$Xor$;
import scala.scalanative.nir.Comp;
import scala.scalanative.nir.Comp$Feq$;
import scala.scalanative.nir.Comp$Fge$;
import scala.scalanative.nir.Comp$Fgt$;
import scala.scalanative.nir.Comp$Fle$;
import scala.scalanative.nir.Comp$Flt$;
import scala.scalanative.nir.Comp$Fne$;
import scala.scalanative.nir.Comp$Ieq$;
import scala.scalanative.nir.Comp$Ine$;
import scala.scalanative.nir.Comp$Sge$;
import scala.scalanative.nir.Comp$Sgt$;
import scala.scalanative.nir.Comp$Sle$;
import scala.scalanative.nir.Comp$Slt$;
import scala.scalanative.nir.Comp$Uge$;
import scala.scalanative.nir.Comp$Ugt$;
import scala.scalanative.nir.Comp$Ule$;
import scala.scalanative.nir.Comp$Ult$;
import scala.scalanative.nir.Conv;
import scala.scalanative.nir.Conv$Bitcast$;
import scala.scalanative.nir.Conv$Fpext$;
import scala.scalanative.nir.Conv$Fptosi$;
import scala.scalanative.nir.Conv$Fptoui$;
import scala.scalanative.nir.Conv$Fptrunc$;
import scala.scalanative.nir.Conv$Inttoptr$;
import scala.scalanative.nir.Conv$Ptrtoint$;
import scala.scalanative.nir.Conv$Sext$;
import scala.scalanative.nir.Conv$Sitofp$;
import scala.scalanative.nir.Conv$Trunc$;
import scala.scalanative.nir.Conv$Uitofp$;
import scala.scalanative.nir.Conv$Zext$;
import scala.scalanative.nir.Defn;
import scala.scalanative.nir.Global;
import scala.scalanative.nir.Global$None$;
import scala.scalanative.nir.Inst;
import scala.scalanative.nir.LinktimeCondition;
import scala.scalanative.nir.Next;
import scala.scalanative.nir.Next$None$;
import scala.scalanative.nir.Op;
import scala.scalanative.nir.Position;
import scala.scalanative.nir.Position$;
import scala.scalanative.nir.Prelude;
import scala.scalanative.nir.Prelude$;
import scala.scalanative.nir.Sig;
import scala.scalanative.nir.Sig$;
import scala.scalanative.nir.Type;
import scala.scalanative.nir.Type$Bool$;
import scala.scalanative.nir.Type$Byte$;
import scala.scalanative.nir.Type$Char$;
import scala.scalanative.nir.Type$Double$;
import scala.scalanative.nir.Type$Float$;
import scala.scalanative.nir.Type$Int$;
import scala.scalanative.nir.Type$Long$;
import scala.scalanative.nir.Type$Nothing$;
import scala.scalanative.nir.Type$Null$;
import scala.scalanative.nir.Type$Ptr$;
import scala.scalanative.nir.Type$Short$;
import scala.scalanative.nir.Type$Unit$;
import scala.scalanative.nir.Type$Vararg$;
import scala.scalanative.nir.Type$Virtual$;
import scala.scalanative.nir.Val;
import scala.scalanative.nir.Val$False$;
import scala.scalanative.nir.Val$Null$;
import scala.scalanative.nir.Val$True$;
import scala.scalanative.nir.Val$Unit$;
import scala.scalanative.nir.serialization.Tags$;
import scala.scalanative.util.package$;

@ScalaSignature(bytes="\u0006\u0001\t%c\u0001\u0002\u00180\u0005aB\u0001\"\u0010\u0001\u0003\u0002\u0003\u0006IA\u0010\u0005\t\r\u0002\u0011\t\u0011)A\u0005\u000f\")!\u000b\u0001C\u0001'\"1\u0001\f\u0001Q!\neC!\"\u0018\u0001\u0011\u0002\u0003\r\t\u0015!\u0003_\u0011!y\bA1A\u0005\n\u0005\u0005\u0001bBA\u0002\u0001\u0001\u0006I!\u0019\u0005\n\u0003\u000b\u0001!\u0019!C\u0005\u0003\u000fAq!!\u0003\u0001A\u0003%A\rC\u0005\u0002\f\u0001\u0011\r\u0011\"\u0003\u0002\u000e!9\u0011q\u0002\u0001!\u0002\u00131\b\"CA\t\u0001\t\u0007I\u0011BA\n\u0011!\tY\u0002\u0001Q\u0001\n\u0005U\u0001bBA\u000f\u0001\u0011\u0015\u0011q\u0004\u0005\b\u0003S\u0001A\u0011BA\u0016\u0011\u001d\t\t\u0006\u0001C\u0005\u0003'Bq!!\u001a\u0001\t\u0013\t9\u0007C\u0004\u0002l\u0001!I!!\u001c\t\u000f\u0005=\u0004\u0001\"\u0003\u0002r!9\u00111\u0010\u0001\u0005\n\u0005u\u0004bBA@\u0001\u0011%\u0011\u0011\u0011\u0005\b\u0003\u0013\u0003A\u0011BAF\u0011\u001d\t\u0019\n\u0001C\u0005\u0003+Cq!!(\u0001\t\u0013\ty\nC\u0004\u0002*\u0002!I!a+\t\u000f\u00055\u0006\u0001\"\u0003\u00020\"9\u0011q\u0017\u0001\u0005\n\u0005e\u0006bBAa\u0001\u0011%\u0011q\u0004\u0005\b\u0003\u0007\u0004A\u0011BAc\u0011\u001d\t9\r\u0001C\u0005\u0003\u0013Dq!!4\u0001\t\u0013\ty\rC\u0004\u0002T\u0002!I!!6\t\u000f\u0005]\u0007\u0001\"\u0003\u0002Z\"9\u0011\u0011\u001d\u0001\u0005\n\u0005\r\bbBAv\u0001\u0011%\u0011Q\u001e\u0005\b\u0003o\u0004A\u0011BA}\u0011\u001d\tY\u0010\u0001C\u0005\u0003{DqA!\u0002\u0001\t\u0013\u00119\u0001C\u0004\u0003\u0018\u0001!IA!\u0007\t\u000f\tm\u0001\u0001\"\u0003\u0003\u001e!9!q\u0005\u0001\u0005\n\t%\u0002b\u0002B\u0016\u0001\u0011%!Q\u0006\u0005\b\u0005o\u0001A\u0011\u0002B\u001d\u0011\u001d\u0011Y\u0004\u0001C\u0005\u0005{AqA!\u0012\u0001\t\u0003\u00119E\u0001\nCS:\f'/\u001f#fg\u0016\u0014\u0018.\u00197ju\u0016\u0014(B\u0001\u00192\u00035\u0019XM]5bY&T\u0018\r^5p]*\u0011!gM\u0001\u0004]&\u0014(B\u0001\u001b6\u0003-\u00198-\u00197b]\u0006$\u0018N^3\u000b\u0003Y\nQa]2bY\u0006\u001c\u0001a\u0005\u0002\u0001sA\u0011!hO\u0007\u0002k%\u0011A(\u000e\u0002\u0007\u0003:L(+\u001a4\u0002\r\t,hMZ3s!\tyD)D\u0001A\u0015\t\t%)A\u0002oS>T\u0011aQ\u0001\u0005U\u00064\u0018-\u0003\u0002F\u0001\nQ!)\u001f;f\u0005V4g-\u001a:\u0002\u0015\t,hMZ3s\u001d\u0006lW\r\u0005\u0002I\u001f:\u0011\u0011*\u0014\t\u0003\u0015Vj\u0011a\u0013\u0006\u0003\u0019^\na\u0001\u0010:p_Rt\u0014B\u0001(6\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001+\u0015\u0002\u0007'R\u0014\u0018N\\4\u000b\u00059+\u0014A\u0002\u001fj]&$h\bF\u0002U-^\u0003\"!\u0016\u0001\u000e\u0003=BQ!P\u0002A\u0002yBQAR\u0002A\u0002\u001d\u000bA\u0002\\1tiB{7/\u001b;j_:\u0004\"AW.\u000e\u0003EJ!\u0001X\u0019\u0003\u0011A{7/\u001b;j_:\f1\u0001\u001f\u00132!\u0015Qt,\u00193w\u0013\t\u0001WG\u0001\u0004UkBdWm\r\t\u00035\nL!aY\u0019\u0003\u000fA\u0013X\r\\;eKB\u0019QM[7\u000f\u0005\u0019DgB\u0001&h\u0013\u00051\u0014BA56\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u001b7\u0003\u0007M+\u0017O\u0003\u0002jkA!!H\u001c9t\u0013\tyWG\u0001\u0004UkBdWM\r\t\u00035FL!A]\u0019\u0003\r\u001dcwNY1m!\tQD/\u0003\u0002vk\t\u0019\u0011J\u001c;\u0011\u0007i:\u00180\u0003\u0002yk\t)\u0011I\u001d:bsB\u0011!0`\u0007\u0002w*\u0011APQ\u0001\u0004]\u0016$\u0018B\u0001@|\u0005\r)&+S\u0001\baJ,G.\u001e3f+\u0005\t\u0017\u0001\u00039sK2,H-\u001a\u0011\u0002\r!,\u0017\rZ3s+\u0005!\u0017a\u00025fC\u0012,'\u000fI\u0001\u0006M&dWm]\u000b\u0002m\u00061a-\u001b7fg\u0002\na#^:fg\u0016s7m\u001c3fI6+WNY3s\u001d\u0006lWm]\u000b\u0003\u0003+\u00012AOA\f\u0013\r\tI\"\u000e\u0002\b\u0005>|G.Z1o\u0003])8/Z:F]\u000e|G-\u001a3NK6\u0014WM\u001d(b[\u0016\u001c\b%A\u0006eKN,'/[1mSj,GCAA\u0011!\u0011)'.a\t\u0011\u0007i\u000b)#C\u0002\u0002(E\u0012A\u0001R3g]\u00061q-\u001a;TKF,B!!\f\u00026Q!\u0011qFA$!\u0011)'.!\r\u0011\t\u0005M\u0012Q\u0007\u0007\u0001\t\u001d\t9d\u0004b\u0001\u0003s\u0011\u0011\u0001V\t\u0005\u0003w\t\t\u0005E\u0002;\u0003{I1!a\u00106\u0005\u001dqu\u000e\u001e5j]\u001e\u00042AOA\"\u0013\r\t)%\u000e\u0002\u0004\u0003:L\b\u0002CA%\u001f\u0011\u0005\r!a\u0013\u0002\t\u001d,G\u000f\u0016\t\u0006u\u00055\u0013\u0011G\u0005\u0004\u0003\u001f*$\u0001\u0003\u001fcs:\fW.\u001a \u0002\r\u001d,Go\u00149u+\u0011\t)&a\u0018\u0015\t\u0005]\u0013\u0011\r\t\u0006u\u0005e\u0013QL\u0005\u0004\u00037*$AB(qi&|g\u000e\u0005\u0003\u00024\u0005}CaBA\u001c!\t\u0007\u0011\u0011\b\u0005\t\u0003\u0013\u0002B\u00111\u0001\u0002dA)!(!\u0014\u0002^\u00059q-\u001a;J]R\u001cHCAA5!\r)'n]\u0001\u000eO\u0016$X\u000b\u0016$9'R\u0014\u0018N\\4\u0015\u0003\u001d\u000b\u0001bZ3u\u0005f$Xm\u001d\u000b\u0003\u0003g\u0002BAO<\u0002vA\u0019!(a\u001e\n\u0007\u0005eTG\u0001\u0003CsR,\u0017aB4fi\n{w\u000e\u001c\u000b\u0003\u0003+\t\u0001bZ3u\u0003R$(o\u001d\u000b\u0003\u0003\u0007\u00032AWAC\u0013\r\t9)\r\u0002\u0006\u0003R$(o]\u0001\bO\u0016$\u0018\t\u001e;s)\t\ti\tE\u0002[\u0003\u001fK1!!%2\u0005\u0011\tE\u000f\u001e:\u0002\r\u001d,GOQ5o)\t\t9\nE\u0002[\u00033K1!a'2\u0005\r\u0011\u0015N\\\u0001\tO\u0016$\u0018J\\:ugR\u0011\u0011\u0011\u0015\t\u0005K*\f\u0019\u000bE\u0002[\u0003KK1!a*2\u0005\u0011Ien\u001d;\u0002\u000f\u001d,G/\u00138tiR\u0011\u00111U\u0001\bO\u0016$8i\\7q)\t\t\t\fE\u0002[\u0003gK1!!.2\u0005\u0011\u0019u.\u001c9\u0002\u000f\u001d,GoQ8omR\u0011\u00111\u0018\t\u00045\u0006u\u0016bAA`c\t!1i\u001c8w\u0003!9W\r\u001e#fM:\u001c\u0018aB4fi\u0012+gM\u001c\u000b\u0003\u0003G\t!bZ3u\u000f2|'-\u00197t)\t\tY\rE\u0002fUB\fAbZ3u\u000f2|'-\u00197PaR$\"!!5\u0011\ti\nI\u0006]\u0001\nO\u0016$x\t\\8cC2$\u0012\u0001]\u0001\u0007O\u0016$8+[4\u0015\u0005\u0005m\u0007c\u0001.\u0002^&\u0019\u0011q\\\u0019\u0003\u0007MKw-\u0001\u0005hKRdunY1m)\t\t)\u000fE\u0002[\u0003OL1!!;2\u0005\u0015aunY1m\u0003!9W\r\u001e(fqR\u001cHCAAx!\u0011)'.!=\u0011\u0007i\u000b\u00190C\u0002\u0002vF\u0012AAT3yi\u00069q-\u001a;OKb$HCAAy\u0003\u00159W\r^(q)\t\ty\u0010E\u0002[\u0005\u0003I1Aa\u00012\u0005\ty\u0005/A\u0005hKR\u0004\u0016M]1ngR\u0011!\u0011\u0002\t\u0005K*\u0014Y\u0001\u0005\u0003\u0003\u000e\tMab\u0001.\u0003\u0010%\u0019!\u0011C\u0019\u0002\u0007Y\u000bG.\u0003\u0003\u0002j\nU!b\u0001B\tc\u0005Aq-\u001a;QCJ\fW\u000e\u0006\u0002\u0003\f\u0005Aq-\u001a;UsB,7\u000f\u0006\u0002\u0003 A!QM\u001bB\u0011!\rQ&1E\u0005\u0004\u0005K\t$\u0001\u0002+za\u0016\fqaZ3u)f\u0004X\r\u0006\u0002\u0003\"\u00059q-\u001a;WC2\u001cHC\u0001B\u0018!\u0011)'N!\r\u0011\u0007i\u0013\u0019$C\u0002\u00036E\u00121AV1m\u0003\u00199W\r\u001e,bYR\u0011!\u0011G\u0001\u0015O\u0016$H*\u001b8li&lWmQ8oI&$\u0018n\u001c8\u0015\u0005\t}\u0002c\u0001.\u0003B%\u0019!1I\u0019\u0003#1Kgn\u001b;j[\u0016\u001cuN\u001c3ji&|g.A\u0006hKR\u0004vn]5uS>tG#A-")
public final class BinaryDeserializer {
    private final ByteBuffer buffer;
    private Position lastPosition;
    private final /* synthetic */ Tuple3 x$1;
    private final Prelude prelude;
    private final scala.collection.Seq<Tuple2<Global, Object>> header;
    private final URI[] files;
    private final boolean usesEncodedMemberNames;

    private Prelude prelude() {
        return this.prelude;
    }

    private scala.collection.Seq<Tuple2<Global, Object>> header() {
        return this.header;
    }

    private URI[] files() {
        return this.files;
    }

    private boolean usesEncodedMemberNames() {
        return this.usesEncodedMemberNames;
    }

    public final scala.collection.Seq<Defn> deserialize() {
        UnrolledBuffer allDefns = (UnrolledBuffer)UnrolledBuffer$.MODULE$.empty(ClassTag$.MODULE$.apply(Defn.class));
        this.header().foreach((Function1 & java.io.Serializable & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int offset = tuple2._2$mcI$sp();
            $this.buffer.position(offset);
            UnrolledBuffer unrolledBuffer = allDefns.$plus$eq((Object)this.getDefn());
            return unrolledBuffer;
        });
        return allDefns.toSeq();
    }

    private <T> scala.collection.Seq<T> getSeq(Function0<T> getT) {
        return ((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.buffer.getInt()).map((Function1 & java.io.Serializable & Serializable)x$2 -> getT.apply(), IndexedSeq$.MODULE$.canBuildFrom())).toSeq();
    }

    private <T> Option<T> getOpt(Function0<T> getT) {
        return this.buffer.get() == 0 ? None$.MODULE$ : new Some(getT.apply());
    }

    private scala.collection.Seq<Object> getInts() {
        return this.getSeq((Function0)(JFunction0.mcI.sp & java.io.Serializable & Serializable)() -> $this.buffer.getInt());
    }

    private String getUTF8String() {
        return new String(this.getBytes(), StandardCharsets.UTF_8);
    }

    /*
     * WARNING - void declaration
     */
    private byte[] getBytes() {
        void var1_1;
        byte[] arr = new byte[this.buffer.getInt()];
        this.buffer.get(arr);
        return var1_1;
    }

    private boolean getBool() {
        return this.buffer.get() != 0;
    }

    private Attrs getAttrs() {
        return Attrs$.MODULE$.fromSeq(this.getSeq((Function0 & java.io.Serializable & Serializable)() -> this.getAttr()));
    }

    private Attr getAttr() {
        Attr attr;
        int n = this.buffer.getInt();
        switch (n) {
            case 1: {
                attr = Attr$MayInline$.MODULE$;
                break;
            }
            case 2: {
                attr = Attr$InlineHint$.MODULE$;
                break;
            }
            case 3: {
                attr = Attr$NoInline$.MODULE$;
                break;
            }
            case 4: {
                attr = Attr$AlwaysInline$.MODULE$;
                break;
            }
            case 5: {
                attr = Attr$MaySpecialize$.MODULE$;
                break;
            }
            case 6: {
                attr = Attr$NoSpecialize$.MODULE$;
                break;
            }
            case 7: {
                attr = Attr$UnOpt$.MODULE$;
                break;
            }
            case 8: {
                attr = Attr$NoOpt$.MODULE$;
                break;
            }
            case 9: {
                attr = Attr$DidOpt$.MODULE$;
                break;
            }
            case 10: {
                attr = new Attr.BailOpt(this.getUTF8String());
                break;
            }
            case 13: {
                attr = Attr$Dyn$.MODULE$;
                break;
            }
            case 14: {
                attr = Attr$Stub$.MODULE$;
                break;
            }
            case 11: {
                attr = Attr$Extern$.MODULE$;
                break;
            }
            case 12: {
                attr = new Attr.Link(this.getUTF8String());
                break;
            }
            case 15: {
                attr = Attr$Abstract$.MODULE$;
                break;
            }
            case 16: {
                attr = Attr$LinktimeResolved$.MODULE$;
                break;
            }
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            }
        }
        return attr;
    }

    private Bin getBin() {
        Bin bin;
        int n = this.buffer.getInt();
        switch (n) {
            case 33: {
                bin = Bin$Iadd$.MODULE$;
                break;
            }
            case 34: {
                bin = Bin$Fadd$.MODULE$;
                break;
            }
            case 35: {
                bin = Bin$Isub$.MODULE$;
                break;
            }
            case 36: {
                bin = Bin$Fsub$.MODULE$;
                break;
            }
            case 37: {
                bin = Bin$Imul$.MODULE$;
                break;
            }
            case 38: {
                bin = Bin$Fmul$.MODULE$;
                break;
            }
            case 39: {
                bin = Bin$Sdiv$.MODULE$;
                break;
            }
            case 40: {
                bin = Bin$Udiv$.MODULE$;
                break;
            }
            case 41: {
                bin = Bin$Fdiv$.MODULE$;
                break;
            }
            case 42: {
                bin = Bin$Srem$.MODULE$;
                break;
            }
            case 43: {
                bin = Bin$Urem$.MODULE$;
                break;
            }
            case 44: {
                bin = Bin$Frem$.MODULE$;
                break;
            }
            case 45: {
                bin = Bin$Shl$.MODULE$;
                break;
            }
            case 46: {
                bin = Bin$Lshr$.MODULE$;
                break;
            }
            case 47: {
                bin = Bin$Ashr$.MODULE$;
                break;
            }
            case 48: {
                bin = Bin$And$.MODULE$;
                break;
            }
            case 49: {
                bin = Bin$Or$.MODULE$;
                break;
            }
            case 50: {
                bin = Bin$Xor$.MODULE$;
                break;
            }
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            }
        }
        return bin;
    }

    private scala.collection.Seq<Inst> getInsts() {
        return this.getSeq((Function0 & java.io.Serializable & Serializable)() -> this.getInst());
    }

    private Inst getInst() {
        Inst inst;
        Position pos = this.getPosition();
        int n = this.buffer.getInt();
        switch (n) {
            case 161: {
                inst = new Inst.Label(this.getLocal(), this.getParams(), pos);
                break;
            }
            case 162: {
                inst = new Inst.Let(this.getLocal(), this.getOp(), Next$None$.MODULE$, pos);
                break;
            }
            case 163: {
                inst = new Inst.Let(this.getLocal(), this.getOp(), this.getNext(), pos);
                break;
            }
            case 164: {
                inst = new Inst.Ret(this.getVal(), pos);
                break;
            }
            case 165: {
                inst = new Inst.Jump(this.getNext(), pos);
                break;
            }
            case 166: {
                inst = new Inst.If(this.getVal(), this.getNext(), this.getNext(), pos);
                break;
            }
            case 167: {
                inst = new Inst.Switch(this.getVal(), this.getNext(), this.getNexts(), pos);
                break;
            }
            case 168: {
                inst = new Inst.Throw(this.getVal(), this.getNext(), pos);
                break;
            }
            case 169: {
                inst = new Inst.Unreachable(this.getNext(), pos);
                break;
            }
            case 170: {
                inst = new Inst.LinktimeIf(this.getLinktimeCondition(), this.getNext(), this.getNext(), pos);
                break;
            }
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            }
        }
        return inst;
    }

    private Comp getComp() {
        Comp comp;
        int n = this.buffer.getInt();
        switch (n) {
            case 65: {
                comp = Comp$Ieq$.MODULE$;
                break;
            }
            case 66: {
                comp = Comp$Ine$.MODULE$;
                break;
            }
            case 67: {
                comp = Comp$Ugt$.MODULE$;
                break;
            }
            case 68: {
                comp = Comp$Uge$.MODULE$;
                break;
            }
            case 69: {
                comp = Comp$Ult$.MODULE$;
                break;
            }
            case 70: {
                comp = Comp$Ule$.MODULE$;
                break;
            }
            case 71: {
                comp = Comp$Sgt$.MODULE$;
                break;
            }
            case 72: {
                comp = Comp$Sge$.MODULE$;
                break;
            }
            case 73: {
                comp = Comp$Slt$.MODULE$;
                break;
            }
            case 74: {
                comp = Comp$Sle$.MODULE$;
                break;
            }
            case 75: {
                comp = Comp$Feq$.MODULE$;
                break;
            }
            case 76: {
                comp = Comp$Fne$.MODULE$;
                break;
            }
            case 77: {
                comp = Comp$Fgt$.MODULE$;
                break;
            }
            case 78: {
                comp = Comp$Fge$.MODULE$;
                break;
            }
            case 79: {
                comp = Comp$Flt$.MODULE$;
                break;
            }
            case 80: {
                comp = Comp$Fle$.MODULE$;
                break;
            }
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            }
        }
        return comp;
    }

    private Conv getConv() {
        Conv conv;
        int n = this.buffer.getInt();
        switch (n) {
            case 97: {
                conv = Conv$Trunc$.MODULE$;
                break;
            }
            case 98: {
                conv = Conv$Zext$.MODULE$;
                break;
            }
            case 99: {
                conv = Conv$Sext$.MODULE$;
                break;
            }
            case 100: {
                conv = Conv$Fptrunc$.MODULE$;
                break;
            }
            case 101: {
                conv = Conv$Fpext$.MODULE$;
                break;
            }
            case 102: {
                conv = Conv$Fptoui$.MODULE$;
                break;
            }
            case 103: {
                conv = Conv$Fptosi$.MODULE$;
                break;
            }
            case 104: {
                conv = Conv$Uitofp$.MODULE$;
                break;
            }
            case 105: {
                conv = Conv$Sitofp$.MODULE$;
                break;
            }
            case 106: {
                conv = Conv$Ptrtoint$.MODULE$;
                break;
            }
            case 107: {
                conv = Conv$Inttoptr$.MODULE$;
                break;
            }
            case 108: {
                conv = Conv$Bitcast$.MODULE$;
                break;
            }
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            }
        }
        return conv;
    }

    private scala.collection.Seq<Defn> getDefns() {
        return this.getSeq((Function0 & java.io.Serializable & Serializable)() -> this.getDefn());
    }

    private Defn getDefn() {
        Defn defn;
        Position pos = this.getPosition();
        int n = this.buffer.getInt();
        switch (n) {
            case 129: {
                defn = new Defn.Var(this.getAttrs(), this.getGlobal(), this.getType(), this.getVal(), pos);
                break;
            }
            case 130: {
                defn = new Defn.Const(this.getAttrs(), this.getGlobal(), this.getType(), this.getVal(), pos);
                break;
            }
            case 131: {
                defn = new Defn.Declare(this.getAttrs(), this.getGlobal(), this.getType(), pos);
                break;
            }
            case 132: {
                defn = new Defn.Define(this.getAttrs(), this.getGlobal(), this.getType(), this.getInsts(), pos);
                break;
            }
            case 133: {
                defn = new Defn.Trait(this.getAttrs(), this.getGlobal(), this.getGlobals(), pos);
                break;
            }
            case 134: {
                defn = new Defn.Class(this.getAttrs(), this.getGlobal(), this.getGlobalOpt(), this.getGlobals(), pos);
                break;
            }
            case 135: {
                defn = new Defn.Module(this.getAttrs(), this.getGlobal(), this.getGlobalOpt(), this.getGlobals(), pos);
                break;
            }
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            }
        }
        return defn;
    }

    private scala.collection.Seq<Global> getGlobals() {
        return this.getSeq((Function0 & java.io.Serializable & Serializable)() -> this.getGlobal());
    }

    private Option<Global> getGlobalOpt() {
        return this.getOpt((Function0 & java.io.Serializable & Serializable)() -> this.getGlobal());
    }

    private Global getGlobal() {
        Global global;
        int n = this.buffer.getInt();
        switch (n) {
            case 193: {
                global = Global$None$.MODULE$;
                break;
            }
            case 194: {
                global = new Global.Top(this.getUTF8String());
                break;
            }
            case 195: {
                global = new Global.Member(new Global.Top(this.getUTF8String()), this.getSig());
                break;
            }
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            }
        }
        return global;
    }

    private Sig getSig() {
        Sig sig;
        Sig sig2 = new Sig(this.getUTF8String());
        if (this.usesEncodedMemberNames()) {
            sig = sig2;
        } else {
            Sig sig3;
            Sig.Unmangled unmangled = sig2.unmangled();
            if (unmangled instanceof Sig.Field) {
                Sig.Field field = (Sig.Field)unmangled;
                sig3 = Sig$.MODULE$.unmangledToMangled(field.copy(NameTransformer$.MODULE$.encode(field.id()), field.copy$default$2()));
            } else if (unmangled instanceof Sig.Method) {
                Sig.Method method = (Sig.Method)unmangled;
                sig3 = Sig$.MODULE$.unmangledToMangled(method.copy(NameTransformer$.MODULE$.encode(method.id()), method.copy$default$2(), method.copy$default$3()));
            } else {
                sig3 = Sig$.MODULE$.unmangledToMangled(unmangled);
            }
            sig = sig3;
        }
        return sig;
    }

    private long getLocal() {
        return this.buffer.getLong();
    }

    private scala.collection.Seq<Next> getNexts() {
        return this.getSeq((Function0 & java.io.Serializable & Serializable)() -> this.getNext());
    }

    private Next getNext() {
        Next next;
        int n = this.buffer.getInt();
        if (Tags$.MODULE$.NoneNext() == n) {
            next = Next$None$.MODULE$;
        } else if (Tags$.MODULE$.UnwindNext() == n) {
            next = new Next.Unwind(this.getParam(), this.getNext());
        } else if (Tags$.MODULE$.CaseNext() == n) {
            next = new Next.Case(this.getVal(), this.getNext());
        } else if (Tags$.MODULE$.LabelNext() == n) {
            next = new Next.Label(this.getLocal(), this.getVals());
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
        }
        return next;
    }

    private Op getOp() {
        Op op;
        int n = this.buffer.getInt();
        if (Tags$.MODULE$.CallOp() == n) {
            op = new Op.Call(this.getType(), this.getVal(), this.getVals());
        } else if (Tags$.MODULE$.LoadOp() == n) {
            op = new Op.Load(this.getType(), this.getVal());
        } else if (Tags$.MODULE$.StoreOp() == n) {
            op = new Op.Store(this.getType(), this.getVal(), this.getVal());
        } else if (Tags$.MODULE$.ElemOp() == n) {
            op = new Op.Elem(this.getType(), this.getVal(), this.getVals());
        } else if (Tags$.MODULE$.ExtractOp() == n) {
            op = new Op.Extract(this.getVal(), this.getInts());
        } else if (Tags$.MODULE$.InsertOp() == n) {
            op = new Op.Insert(this.getVal(), this.getVal(), this.getInts());
        } else if (Tags$.MODULE$.StackallocOp() == n) {
            op = new Op.Stackalloc(this.getType(), this.getVal());
        } else if (Tags$.MODULE$.BinOp() == n) {
            op = new Op.Bin(this.getBin(), this.getType(), this.getVal(), this.getVal());
        } else if (Tags$.MODULE$.CompOp() == n) {
            op = new Op.Comp(this.getComp(), this.getType(), this.getVal(), this.getVal());
        } else if (Tags$.MODULE$.ConvOp() == n) {
            op = new Op.Conv(this.getConv(), this.getType(), this.getVal());
        } else if (Tags$.MODULE$.ClassallocOp() == n) {
            op = new Op.Classalloc(this.getGlobal());
        } else if (Tags$.MODULE$.FieldloadOp() == n) {
            op = new Op.Fieldload(this.getType(), this.getVal(), this.getGlobal());
        } else if (Tags$.MODULE$.FieldstoreOp() == n) {
            op = new Op.Fieldstore(this.getType(), this.getVal(), this.getGlobal(), this.getVal());
        } else if (Tags$.MODULE$.FieldOp() == n) {
            op = new Op.Field(this.getVal(), this.getGlobal());
        } else if (Tags$.MODULE$.MethodOp() == n) {
            op = new Op.Method(this.getVal(), this.getSig());
        } else if (Tags$.MODULE$.DynmethodOp() == n) {
            op = new Op.Dynmethod(this.getVal(), this.getSig());
        } else if (Tags$.MODULE$.ModuleOp() == n) {
            op = new Op.Module(this.getGlobal());
        } else if (Tags$.MODULE$.AsOp() == n) {
            op = new Op.As(this.getType(), this.getVal());
        } else if (Tags$.MODULE$.IsOp() == n) {
            op = new Op.Is(this.getType(), this.getVal());
        } else if (Tags$.MODULE$.CopyOp() == n) {
            op = new Op.Copy(this.getVal());
        } else if (Tags$.MODULE$.SizeofOp() == n) {
            op = new Op.Sizeof(this.getType());
        } else if (Tags$.MODULE$.BoxOp() == n) {
            op = new Op.Box(this.getType(), this.getVal());
        } else if (Tags$.MODULE$.UnboxOp() == n) {
            op = new Op.Unbox(this.getType(), this.getVal());
        } else if (Tags$.MODULE$.VarOp() == n) {
            op = new Op.Var(this.getType());
        } else if (Tags$.MODULE$.VarloadOp() == n) {
            op = new Op.Varload(this.getVal());
        } else if (Tags$.MODULE$.VarstoreOp() == n) {
            op = new Op.Varstore(this.getVal(), this.getVal());
        } else if (Tags$.MODULE$.ArrayallocOp() == n) {
            op = new Op.Arrayalloc(this.getType(), this.getVal());
        } else if (Tags$.MODULE$.ArrayloadOp() == n) {
            op = new Op.Arrayload(this.getType(), this.getVal(), this.getVal());
        } else if (Tags$.MODULE$.ArraystoreOp() == n) {
            op = new Op.Arraystore(this.getType(), this.getVal(), this.getVal(), this.getVal());
        } else if (Tags$.MODULE$.ArraylengthOp() == n) {
            op = new Op.Arraylength(this.getVal());
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
        }
        return op;
    }

    private scala.collection.Seq<Val.Local> getParams() {
        return this.getSeq((Function0 & java.io.Serializable & Serializable)() -> this.getParam());
    }

    private Val.Local getParam() {
        return new Val.Local(this.getLocal(), this.getType());
    }

    private scala.collection.Seq<Type> getTypes() {
        return this.getSeq((Function0 & java.io.Serializable & Serializable)() -> this.getType());
    }

    private Type getType() {
        Type type;
        int n = this.buffer.getInt();
        if (Tags$.MODULE$.VarargType() == n) {
            type = Type$Vararg$.MODULE$;
        } else if (Tags$.MODULE$.PtrType() == n) {
            type = Type$Ptr$.MODULE$;
        } else if (Tags$.MODULE$.BoolType() == n) {
            type = Type$Bool$.MODULE$;
        } else if (Tags$.MODULE$.CharType() == n) {
            type = Type$Char$.MODULE$;
        } else if (Tags$.MODULE$.ByteType() == n) {
            type = Type$Byte$.MODULE$;
        } else if (Tags$.MODULE$.ShortType() == n) {
            type = Type$Short$.MODULE$;
        } else if (Tags$.MODULE$.IntType() == n) {
            type = Type$Int$.MODULE$;
        } else if (Tags$.MODULE$.LongType() == n) {
            type = Type$Long$.MODULE$;
        } else if (Tags$.MODULE$.FloatType() == n) {
            type = Type$Float$.MODULE$;
        } else if (Tags$.MODULE$.DoubleType() == n) {
            type = Type$Double$.MODULE$;
        } else if (Tags$.MODULE$.ArrayValueType() == n) {
            type = new Type.ArrayValue(this.getType(), this.buffer.getInt());
        } else if (Tags$.MODULE$.StructValueType() == n) {
            type = new Type.StructValue(this.getTypes());
        } else if (Tags$.MODULE$.FunctionType() == n) {
            type = new Type.Function(this.getTypes(), this.getType());
        } else if (Tags$.MODULE$.NullType() == n) {
            type = Type$Null$.MODULE$;
        } else if (Tags$.MODULE$.NothingType() == n) {
            type = Type$Nothing$.MODULE$;
        } else if (Tags$.MODULE$.VirtualType() == n) {
            type = Type$Virtual$.MODULE$;
        } else if (Tags$.MODULE$.VarType() == n) {
            type = new Type.Var(this.getType());
        } else if (Tags$.MODULE$.UnitType() == n) {
            type = Type$Unit$.MODULE$;
        } else if (Tags$.MODULE$.ArrayType() == n) {
            type = new Type.Array(this.getType(), this.getBool());
        } else if (Tags$.MODULE$.RefType() == n) {
            type = new Type.Ref(this.getGlobal(), this.getBool(), this.getBool());
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
        }
        return type;
    }

    private scala.collection.Seq<Val> getVals() {
        return this.getSeq((Function0 & java.io.Serializable & Serializable)() -> this.getVal());
    }

    private Val getVal() {
        Val val;
        int n = this.buffer.getInt();
        if (Tags$.MODULE$.TrueVal() == n) {
            val = Val$True$.MODULE$;
        } else if (Tags$.MODULE$.FalseVal() == n) {
            val = Val$False$.MODULE$;
        } else if (Tags$.MODULE$.NullVal() == n) {
            val = Val$Null$.MODULE$;
        } else if (Tags$.MODULE$.ZeroVal() == n) {
            val = new Val.Zero(this.getType());
        } else if (Tags$.MODULE$.CharVal() == n) {
            val = new Val.Char((char)this.buffer.getShort());
        } else if (Tags$.MODULE$.ByteVal() == n) {
            val = new Val.Byte(this.buffer.get());
        } else if (Tags$.MODULE$.ShortVal() == n) {
            val = new Val.Short(this.buffer.getShort());
        } else if (Tags$.MODULE$.IntVal() == n) {
            val = new Val.Int(this.buffer.getInt());
        } else if (Tags$.MODULE$.LongVal() == n) {
            val = new Val.Long(this.buffer.getLong());
        } else if (Tags$.MODULE$.FloatVal() == n) {
            val = new Val.Float(this.buffer.getFloat());
        } else if (Tags$.MODULE$.DoubleVal() == n) {
            val = new Val.Double(this.buffer.getDouble());
        } else if (Tags$.MODULE$.StructValueVal() == n) {
            val = new Val.StructValue(this.getVals());
        } else if (Tags$.MODULE$.ArrayValueVal() == n) {
            val = new Val.ArrayValue(this.getType(), this.getVals());
        } else if (Tags$.MODULE$.CharsVal() == n) {
            val = new Val.Chars((scala.collection.Seq<Object>)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(this.getBytes())).toIndexedSeq());
        } else if (Tags$.MODULE$.LocalVal() == n) {
            val = new Val.Local(this.getLocal(), this.getType());
        } else if (Tags$.MODULE$.GlobalVal() == n) {
            val = new Val.Global(this.getGlobal(), this.getType());
        } else if (Tags$.MODULE$.UnitVal() == n) {
            val = Val$Unit$.MODULE$;
        } else if (Tags$.MODULE$.ConstVal() == n) {
            val = new Val.Const(this.getVal());
        } else if (Tags$.MODULE$.StringVal() == n) {
            char[] chars = (char[])Array$.MODULE$.fill(this.buffer.getInt(), (Function0)(JFunction0.mcC.sp & java.io.Serializable & Serializable)() -> $this.buffer.getChar(), ClassTag$.MODULE$.Char());
            val = new Val.String(new String(chars));
        } else if (Tags$.MODULE$.VirtualVal() == n) {
            val = new Val.Virtual(this.buffer.getLong());
        } else if (Tags$.MODULE$.ClassOfVal() == n) {
            val = new Val.ClassOf(this.getGlobal());
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
        }
        return val;
    }

    private LinktimeCondition getLinktimeCondition() {
        Product product;
        int n = this.buffer.getInt();
        switch (n) {
            case 1: {
                product = new LinktimeCondition.SimpleCondition(this.getUTF8String(), this.getComp(), this.getVal(), this.getPosition());
                break;
            }
            case 2: {
                product = new LinktimeCondition.ComplexCondition(this.getBin(), this.getLinktimeCondition(), this.getLinktimeCondition(), this.getPosition());
                break;
            }
            default: {
                throw package$.MODULE$.unsupported(new StringBuilder(32).append("Unknown linktime condition tag: ").append(n).toString());
            }
        }
        return product;
    }

    public Position getPosition() {
        return this.readPosition$1();
    }

    /*
     * WARNING - void declaration
     */
    private final Position readPosition$1() {
        Position position;
        byte first = this.buffer.get();
        if (first == -1) {
            position = Position$.MODULE$.NoPosition();
        } else {
            void var2_11;
            Position result;
            Position position2;
            if ((first & 0xF) == 7) {
                URI file = this.files()[this.buffer.getInt()];
                int line = this.buffer.getInt();
                int column = this.buffer.getInt();
                position2 = new Position(file, line, column);
            } else {
                Position position3 = this.lastPosition;
                Position position4 = Position$.MODULE$.NoPosition();
                Predef$.MODULE$.assert(position3 == null ? position4 != null : !((Object)position3).equals(position4), (Function0 & java.io.Serializable & Serializable)() -> "Position format error: first position must be full");
                if ((first & 1) == 0) {
                    int columnDiff = first >> 1;
                    position2 = new Position(this.lastPosition.source(), this.lastPosition.line(), this.lastPosition.column() + columnDiff);
                } else if ((first & 3) == 1) {
                    int lineDiff = first >> 2;
                    int column = this.buffer.get() & 0xFF;
                    position2 = new Position(this.lastPosition.source(), this.lastPosition.line() + lineDiff, column);
                } else {
                    Predef$.MODULE$.assert((first & 0xF) == 3, (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(60).append("Position format error: first byte ").append(first).append(" does not match any format").toString());
                    short lineDiff = this.buffer.getShort();
                    int column = this.buffer.get() & 0xFF;
                    position2 = new Position(this.lastPosition.source(), this.lastPosition.line() + lineDiff, column);
                }
            }
            this.lastPosition = result = position2;
            position = var2_11;
        }
        return position;
    }

    public BinaryDeserializer(ByteBuffer buffer, String bufferName) {
        this.buffer = buffer;
        this.lastPosition = Position$.MODULE$.NoPosition();
        buffer.position(0);
        Prelude prelude = Prelude$.MODULE$.readFrom(buffer, bufferName);
        URI[] files = (URI[])Array$.MODULE$.fill(buffer.getInt(), (Function0 & java.io.Serializable & Serializable)() -> new URI(this.getUTF8String()), ClassTag$.MODULE$.apply(URI.class));
        scala.collection.Seq pairs = this.getSeq((Function0 & java.io.Serializable & Serializable)() -> new Tuple2((Object)this.getGlobal(), (Object)BoxesRunTime.boxToInteger((int)$this.buffer.getInt())));
        Tuple3 tuple3 = new Tuple3((Object)prelude, pairs, (Object)files);
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        Prelude prelude2 = (Prelude)tuple3._1();
        scala.collection.Seq header = (scala.collection.Seq)tuple3._2();
        URI[] files2 = (URI[])tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)prelude2, (Object)header, (Object)files2);
        this.x$1 = tuple32;
        this.prelude = (Prelude)this.x$1._1();
        this.header = (scala.collection.Seq)this.x$1._2();
        this.files = (URI[])this.x$1._3();
        this.usesEncodedMemberNames = this.prelude().revision() >= 9;
    }
}

