/*
 * Decompiled with CFR 0.152.
 */
package scala.scalanative.nir.serialization;

import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.UnrolledBuffer;
import scala.collection.mutable.UnrolledBuffer$;
import scala.reflect.ClassTag$;
import scala.reflect.NameTransformer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.scalanative.nir.Attr;
import scala.scalanative.nir.Attr$Abstract$;
import scala.scalanative.nir.Attr$AlwaysInline$;
import scala.scalanative.nir.Attr$DidOpt$;
import scala.scalanative.nir.Attr$Dyn$;
import scala.scalanative.nir.Attr$Extern$;
import scala.scalanative.nir.Attr$InlineHint$;
import scala.scalanative.nir.Attr$LinktimeResolved$;
import scala.scalanative.nir.Attr$MayInline$;
import scala.scalanative.nir.Attr$MaySpecialize$;
import scala.scalanative.nir.Attr$NoInline$;
import scala.scalanative.nir.Attr$NoOpt$;
import scala.scalanative.nir.Attr$NoSpecialize$;
import scala.scalanative.nir.Attr$Stub$;
import scala.scalanative.nir.Attr$UnOpt$;
import scala.scalanative.nir.Attrs;
import scala.scalanative.nir.Attrs$;
import scala.scalanative.nir.Bin;
import scala.scalanative.nir.Bin$And$;
import scala.scalanative.nir.Bin$Ashr$;
import scala.scalanative.nir.Bin$Fadd$;
import scala.scalanative.nir.Bin$Fdiv$;
import scala.scalanative.nir.Bin$Fmul$;
import scala.scalanative.nir.Bin$Frem$;
import scala.scalanative.nir.Bin$Fsub$;
import scala.scalanative.nir.Bin$Iadd$;
import scala.scalanative.nir.Bin$Imul$;
import scala.scalanative.nir.Bin$Isub$;
import scala.scalanative.nir.Bin$Lshr$;
import scala.scalanative.nir.Bin$Or$;
import scala.scalanative.nir.Bin$Sdiv$;
import scala.scalanative.nir.Bin$Shl$;
import scala.scalanative.nir.Bin$Srem$;
import scala.scalanative.nir.Bin$Udiv$;
import scala.scalanative.nir.Bin$Urem$;
import scala.scalanative.nir.Bin$Xor$;
import scala.scalanative.nir.Comp;
import scala.scalanative.nir.Comp$Feq$;
import scala.scalanative.nir.Comp$Fge$;
import scala.scalanative.nir.Comp$Fgt$;
import scala.scalanative.nir.Comp$Fle$;
import scala.scalanative.nir.Comp$Flt$;
import scala.scalanative.nir.Comp$Fne$;
import scala.scalanative.nir.Comp$Ieq$;
import scala.scalanative.nir.Comp$Ine$;
import scala.scalanative.nir.Comp$Sge$;
import scala.scalanative.nir.Comp$Sgt$;
import scala.scalanative.nir.Comp$Sle$;
import scala.scalanative.nir.Comp$Slt$;
import scala.scalanative.nir.Comp$Uge$;
import scala.scalanative.nir.Comp$Ugt$;
import scala.scalanative.nir.Comp$Ule$;
import scala.scalanative.nir.Comp$Ult$;
import scala.scalanative.nir.Conv;
import scala.scalanative.nir.Conv$Bitcast$;
import scala.scalanative.nir.Conv$Fpext$;
import scala.scalanative.nir.Conv$Fptosi$;
import scala.scalanative.nir.Conv$Fptoui$;
import scala.scalanative.nir.Conv$Fptrunc$;
import scala.scalanative.nir.Conv$Inttoptr$;
import scala.scalanative.nir.Conv$Ptrtoint$;
import scala.scalanative.nir.Conv$Sext$;
import scala.scalanative.nir.Conv$Sitofp$;
import scala.scalanative.nir.Conv$Trunc$;
import scala.scalanative.nir.Conv$Uitofp$;
import scala.scalanative.nir.Conv$Zext$;
import scala.scalanative.nir.Defn;
import scala.scalanative.nir.Global;
import scala.scalanative.nir.Global$None$;
import scala.scalanative.nir.Inst;
import scala.scalanative.nir.LinktimeCondition;
import scala.scalanative.nir.Next;
import scala.scalanative.nir.Next$None$;
import scala.scalanative.nir.Op;
import scala.scalanative.nir.Position;
import scala.scalanative.nir.Position$;
import scala.scalanative.nir.Prelude;
import scala.scalanative.nir.Prelude$;
import scala.scalanative.nir.Sig;
import scala.scalanative.nir.Sig$;
import scala.scalanative.nir.Type;
import scala.scalanative.nir.Type$Bool$;
import scala.scalanative.nir.Type$Byte$;
import scala.scalanative.nir.Type$Char$;
import scala.scalanative.nir.Type$Double$;
import scala.scalanative.nir.Type$Float$;
import scala.scalanative.nir.Type$Int$;
import scala.scalanative.nir.Type$Long$;
import scala.scalanative.nir.Type$Nothing$;
import scala.scalanative.nir.Type$Null$;
import scala.scalanative.nir.Type$Ptr$;
import scala.scalanative.nir.Type$Short$;
import scala.scalanative.nir.Type$Unit$;
import scala.scalanative.nir.Type$Vararg$;
import scala.scalanative.nir.Type$Virtual$;
import scala.scalanative.nir.Val;
import scala.scalanative.nir.Val$False$;
import scala.scalanative.nir.Val$Null$;
import scala.scalanative.nir.Val$True$;
import scala.scalanative.nir.Val$Unit$;
import scala.scalanative.nir.serialization.Tags$;
import scala.scalanative.util.package$;

@ScalaSignature(bytes="\u0006\u0001\t%c\u0001\u0002\u00180\u0005aB\u0001\"\u0010\u0001\u0003\u0002\u0003\u0006IA\u0010\u0005\t\r\u0002\u0011\t\u0011)A\u0005\u000f\")!\u000b\u0001C\u0001'\"1\u0001\f\u0001Q!\neC!\"\u0018\u0001\u0011\u0002\u0003\r\t\u0015!\u0003_\u0011!y\bA1A\u0005\n\u0005\u0005\u0001bBA\u0002\u0001\u0001\u0006I!\u0019\u0005\n\u0003\u000b\u0001!\u0019!C\u0005\u0003\u000fAq!!\u0003\u0001A\u0003%A\rC\u0005\u0002\f\u0001\u0011\r\u0011\"\u0003\u0002\u000e!9\u0011q\u0002\u0001!\u0002\u00131\b\"CA\t\u0001\t\u0007I\u0011BA\n\u0011!\tY\u0002\u0001Q\u0001\n\u0005U\u0001bBA\u000f\u0001\u0011\u0015\u0011q\u0004\u0005\b\u0003S\u0001A\u0011BA\u0016\u0011\u001d\t\t\u0006\u0001C\u0005\u0003'Bq!!\u001a\u0001\t\u0013\t9\u0007C\u0004\u0002l\u0001!I!!\u001c\t\u000f\u0005=\u0004\u0001\"\u0003\u0002r!9\u00111\u0010\u0001\u0005\n\u0005u\u0004bBA@\u0001\u0011%\u0011\u0011\u0011\u0005\b\u0003\u0013\u0003A\u0011BAF\u0011\u001d\t\u0019\n\u0001C\u0005\u0003+Cq!!(\u0001\t\u0013\ty\nC\u0004\u0002*\u0002!I!a+\t\u000f\u00055\u0006\u0001\"\u0003\u00020\"9\u0011q\u0017\u0001\u0005\n\u0005e\u0006bBAa\u0001\u0011%\u0011q\u0004\u0005\b\u0003\u0007\u0004A\u0011BAc\u0011\u001d\t9\r\u0001C\u0005\u0003\u0013Dq!!4\u0001\t\u0013\ty\rC\u0004\u0002T\u0002!I!!6\t\u000f\u0005]\u0007\u0001\"\u0003\u0002Z\"9\u0011\u0011\u001d\u0001\u0005\n\u0005\r\bbBAv\u0001\u0011%\u0011Q\u001e\u0005\b\u0003o\u0004A\u0011BA}\u0011\u001d\tY\u0010\u0001C\u0005\u0003{DqA!\u0002\u0001\t\u0013\u00119\u0001C\u0004\u0003\u0018\u0001!IA!\u0007\t\u000f\tm\u0001\u0001\"\u0003\u0003\u001e!9!q\u0005\u0001\u0005\n\t%\u0002b\u0002B\u0016\u0001\u0011%!Q\u0006\u0005\b\u0005o\u0001A\u0011\u0002B\u001d\u0011\u001d\u0011Y\u0004\u0001C\u0005\u0005{AqA!\u0012\u0001\t\u0003\u00119E\u0001\nCS:\f'/\u001f#fg\u0016\u0014\u0018.\u00197ju\u0016\u0014(B\u0001\u00192\u00035\u0019XM]5bY&T\u0018\r^5p]*\u0011!gM\u0001\u0004]&\u0014(B\u0001\u001b6\u0003-\u00198-\u00197b]\u0006$\u0018N^3\u000b\u0003Y\nQa]2bY\u0006\u001c\u0001a\u0005\u0002\u0001sA\u0011!hO\u0007\u0002k%\u0011A(\u000e\u0002\u0007\u0003:L(+\u001a4\u0002\r\t,hMZ3s!\tyD)D\u0001A\u0015\t\t%)A\u0002oS>T\u0011aQ\u0001\u0005U\u00064\u0018-\u0003\u0002F\u0001\nQ!)\u001f;f\u0005V4g-\u001a:\u0002\u0015\t,hMZ3s\u001d\u0006lW\r\u0005\u0002I\u001f:\u0011\u0011*\u0014\t\u0003\u0015Vj\u0011a\u0013\u0006\u0003\u0019^\na\u0001\u0010:p_Rt\u0014B\u0001(6\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001+\u0015\u0002\u0007'R\u0014\u0018N\\4\u000b\u00059+\u0014A\u0002\u001fj]&$h\bF\u0002U-^\u0003\"!\u0016\u0001\u000e\u0003=BQ!P\u0002A\u0002yBQAR\u0002A\u0002\u001d\u000bA\u0002\\1tiB{7/\u001b;j_:\u0004\"AW.\u000e\u0003EJ!\u0001X\u0019\u0003\u0011A{7/\u001b;j_:\f1\u0001\u001f\u00132!\u0015Qt,\u00193w\u0013\t\u0001WG\u0001\u0004UkBdWm\r\t\u00035\nL!aY\u0019\u0003\u000fA\u0013X\r\\;eKB\u0019QM[7\u000f\u0005\u0019DgB\u0001&h\u0013\u00051\u0014BA56\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u001b7\u0003\u0007M+\u0017O\u0003\u0002jkA!!H\u001c9t\u0013\tyWG\u0001\u0004UkBdWM\r\t\u00035FL!A]\u0019\u0003\r\u001dcwNY1m!\tQD/\u0003\u0002vk\t\u0019\u0011J\u001c;\u0011\u0007i:\u00180\u0003\u0002yk\t)\u0011I\u001d:bsB\u0011!0`\u0007\u0002w*\u0011APQ\u0001\u0004]\u0016$\u0018B\u0001@|\u0005\r)&+S\u0001\baJ,G.\u001e3f+\u0005\t\u0017\u0001\u00039sK2,H-\u001a\u0011\u0002\r!,\u0017\rZ3s+\u0005!\u0017a\u00025fC\u0012,'\u000fI\u0001\u0006M&dWm]\u000b\u0002m\u00061a-\u001b7fg\u0002\na#^:fg\u0016s7m\u001c3fI6+WNY3s\u001d\u0006lWm]\u000b\u0003\u0003+\u00012AOA\f\u0013\r\tI\"\u000e\u0002\b\u0005>|G.Z1o\u0003])8/Z:F]\u000e|G-\u001a3NK6\u0014WM\u001d(b[\u0016\u001c\b%A\u0006eKN,'/[1mSj,GCAA\u0011!\u0011)'.a\t\u0011\u0007i\u000b)#C\u0002\u0002(E\u0012A\u0001R3g]\u00061q-\u001a;TKF,B!!\f\u00026Q!\u0011qFA$!\u0011)'.!\r\u0011\t\u0005M\u0012Q\u0007\u0007\u0001\t\u001d\t9d\u0004b\u0001\u0003s\u0011\u0011\u0001V\t\u0005\u0003w\t\t\u0005E\u0002;\u0003{I1!a\u00106\u0005\u001dqu\u000e\u001e5j]\u001e\u00042AOA\"\u0013\r\t)%\u000e\u0002\u0004\u0003:L\b\u0002CA%\u001f\u0011\u0005\r!a\u0013\u0002\t\u001d,G\u000f\u0016\t\u0006u\u00055\u0013\u0011G\u0005\u0004\u0003\u001f*$\u0001\u0003\u001fcs:\fW.\u001a \u0002\r\u001d,Go\u00149u+\u0011\t)&a\u0018\u0015\t\u0005]\u0013\u0011\r\t\u0006u\u0005e\u0013QL\u0005\u0004\u00037*$AB(qi&|g\u000e\u0005\u0003\u00024\u0005}CaBA\u001c!\t\u0007\u0011\u0011\b\u0005\t\u0003\u0013\u0002B\u00111\u0001\u0002dA)!(!\u0014\u0002^\u00059q-\u001a;J]R\u001cHCAA5!\r)'n]\u0001\u000eO\u0016$X\u000b\u0016$9'R\u0014\u0018N\\4\u0015\u0003\u001d\u000b\u0001bZ3u\u0005f$Xm\u001d\u000b\u0003\u0003g\u0002BAO<\u0002vA\u0019!(a\u001e\n\u0007\u0005eTG\u0001\u0003CsR,\u0017aB4fi\n{w\u000e\u001c\u000b\u0003\u0003+\t\u0001bZ3u\u0003R$(o\u001d\u000b\u0003\u0003\u0007\u00032AWAC\u0013\r\t9)\r\u0002\u0006\u0003R$(o]\u0001\bO\u0016$\u0018\t\u001e;s)\t\ti\tE\u0002[\u0003\u001fK1!!%2\u0005\u0011\tE\u000f\u001e:\u0002\r\u001d,GOQ5o)\t\t9\nE\u0002[\u00033K1!a'2\u0005\r\u0011\u0015N\\\u0001\tO\u0016$\u0018J\\:ugR\u0011\u0011\u0011\u0015\t\u0005K*\f\u0019\u000bE\u0002[\u0003KK1!a*2\u0005\u0011Ien\u001d;\u0002\u000f\u001d,G/\u00138tiR\u0011\u00111U\u0001\bO\u0016$8i\\7q)\t\t\t\fE\u0002[\u0003gK1!!.2\u0005\u0011\u0019u.\u001c9\u0002\u000f\u001d,GoQ8omR\u0011\u00111\u0018\t\u00045\u0006u\u0016bAA`c\t!1i\u001c8w\u0003!9W\r\u001e#fM:\u001c\u0018aB4fi\u0012+gM\u001c\u000b\u0003\u0003G\t!bZ3u\u000f2|'-\u00197t)\t\tY\rE\u0002fUB\fAbZ3u\u000f2|'-\u00197PaR$\"!!5\u0011\ti\nI\u0006]\u0001\nO\u0016$x\t\\8cC2$\u0012\u0001]\u0001\u0007O\u0016$8+[4\u0015\u0005\u0005m\u0007c\u0001.\u0002^&\u0019\u0011q\\\u0019\u0003\u0007MKw-\u0001\u0005hKRdunY1m)\t\t)\u000fE\u0002[\u0003OL1!!;2\u0005\u0015aunY1m\u0003!9W\r\u001e(fqR\u001cHCAAx!\u0011)'.!=\u0011\u0007i\u000b\u00190C\u0002\u0002vF\u0012AAT3yi\u00069q-\u001a;OKb$HCAAy\u0003\u00159W\r^(q)\t\ty\u0010E\u0002[\u0005\u0003I1Aa\u00012\u0005\ty\u0005/A\u0005hKR\u0004\u0016M]1ngR\u0011!\u0011\u0002\t\u0005K*\u0014Y\u0001\u0005\u0003\u0003\u000e\tMab\u0001.\u0003\u0010%\u0019!\u0011C\u0019\u0002\u0007Y\u000bG.\u0003\u0003\u0002j\nU!b\u0001B\tc\u0005Aq-\u001a;QCJ\fW\u000e\u0006\u0002\u0003\f\u0005Aq-\u001a;UsB,7\u000f\u0006\u0002\u0003 A!QM\u001bB\u0011!\rQ&1E\u0005\u0004\u0005K\t$\u0001\u0002+za\u0016\fqaZ3u)f\u0004X\r\u0006\u0002\u0003\"\u00059q-\u001a;WC2\u001cHC\u0001B\u0018!\u0011)'N!\r\u0011\u0007i\u0013\u0019$C\u0002\u00036E\u00121AV1m\u0003\u00199W\r\u001e,bYR\u0011!\u0011G\u0001\u0015O\u0016$H*\u001b8li&lWmQ8oI&$\u0018n\u001c8\u0015\u0005\t}\u0002c\u0001.\u0003B%\u0019!1I\u0019\u0003#1Kgn\u001b;j[\u0016\u001cuN\u001c3ji&|g.A\u0006hKR\u0004vn]5uS>tG#A-")
public final class BinaryDeserializer {
    private final ByteBuffer buffer;
    private Position lastPosition;
    private final /* synthetic */ Tuple3 x$1;
    private final Prelude prelude;
    private final scala.collection.Seq<Tuple2<Global, Object>> header;
    private final URI[] files;
    private final boolean usesEncodedMemberNames;

    private Prelude prelude() {
        return this.prelude;
    }

    private scala.collection.Seq<Tuple2<Global, Object>> header() {
        return this.header;
    }

    private URI[] files() {
        return this.files;
    }

    private boolean usesEncodedMemberNames() {
        return this.usesEncodedMemberNames;
    }

    public final scala.collection.Seq<Defn> deserialize() {
        UnrolledBuffer allDefns = (UnrolledBuffer)UnrolledBuffer$.MODULE$.empty(ClassTag$.MODULE$.apply(Defn.class));
        this.header().foreach((Function1 & java.io.Serializable & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                int offset = tuple2._2$mcI$sp();
                $this.buffer.position(offset);
                return allDefns.$plus$eq((Object)this.getDefn());
            }
            throw new MatchError((Object)tuple2);
        });
        return allDefns.toSeq();
    }

    private <T> scala.collection.Seq<T> getSeq(Function0<T> getT) {
        return ((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.buffer.getInt()).map((Function1 & java.io.Serializable & Serializable)x$2 -> getT.apply(), IndexedSeq$.MODULE$.canBuildFrom())).toSeq();
    }

    private <T> Option<T> getOpt(Function0<T> getT) {
        if (this.buffer.get() == 0) {
            return None$.MODULE$;
        }
        return new Some(getT.apply());
    }

    private scala.collection.Seq<Object> getInts() {
        return this.getSeq((Function0)(JFunction0.mcI.sp & java.io.Serializable & Serializable)() -> $this.buffer.getInt());
    }

    private String getUTF8String() {
        return new String(this.getBytes(), StandardCharsets.UTF_8);
    }

    private byte[] getBytes() {
        byte[] arr = new byte[this.buffer.getInt()];
        this.buffer.get(arr);
        return arr;
    }

    private boolean getBool() {
        return this.buffer.get() != 0;
    }

    private Attrs getAttrs() {
        return Attrs$.MODULE$.fromSeq(this.getSeq((Function0 & java.io.Serializable & Serializable)() -> this.getAttr()));
    }

    private Attr getAttr() {
        int n = this.buffer.getInt();
        switch (n) {
            case 1: {
                return Attr$MayInline$.MODULE$;
            }
            case 2: {
                return Attr$InlineHint$.MODULE$;
            }
            case 3: {
                return Attr$NoInline$.MODULE$;
            }
            case 4: {
                return Attr$AlwaysInline$.MODULE$;
            }
            case 5: {
                return Attr$MaySpecialize$.MODULE$;
            }
            case 6: {
                return Attr$NoSpecialize$.MODULE$;
            }
            case 7: {
                return Attr$UnOpt$.MODULE$;
            }
            case 8: {
                return Attr$NoOpt$.MODULE$;
            }
            case 9: {
                return Attr$DidOpt$.MODULE$;
            }
            case 10: {
                return new Attr.BailOpt(this.getUTF8String());
            }
            case 13: {
                return Attr$Dyn$.MODULE$;
            }
            case 14: {
                return Attr$Stub$.MODULE$;
            }
            case 11: {
                return Attr$Extern$.MODULE$;
            }
            case 12: {
                return new Attr.Link(this.getUTF8String());
            }
            case 15: {
                return Attr$Abstract$.MODULE$;
            }
            case 16: {
                return Attr$LinktimeResolved$.MODULE$;
            }
        }
        throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
    }

    private Bin getBin() {
        int n = this.buffer.getInt();
        switch (n) {
            case 33: {
                return Bin$Iadd$.MODULE$;
            }
            case 34: {
                return Bin$Fadd$.MODULE$;
            }
            case 35: {
                return Bin$Isub$.MODULE$;
            }
            case 36: {
                return Bin$Fsub$.MODULE$;
            }
            case 37: {
                return Bin$Imul$.MODULE$;
            }
            case 38: {
                return Bin$Fmul$.MODULE$;
            }
            case 39: {
                return Bin$Sdiv$.MODULE$;
            }
            case 40: {
                return Bin$Udiv$.MODULE$;
            }
            case 41: {
                return Bin$Fdiv$.MODULE$;
            }
            case 42: {
                return Bin$Srem$.MODULE$;
            }
            case 43: {
                return Bin$Urem$.MODULE$;
            }
            case 44: {
                return Bin$Frem$.MODULE$;
            }
            case 45: {
                return Bin$Shl$.MODULE$;
            }
            case 46: {
                return Bin$Lshr$.MODULE$;
            }
            case 47: {
                return Bin$Ashr$.MODULE$;
            }
            case 48: {
                return Bin$And$.MODULE$;
            }
            case 49: {
                return Bin$Or$.MODULE$;
            }
            case 50: {
                return Bin$Xor$.MODULE$;
            }
        }
        throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
    }

    private scala.collection.Seq<Inst> getInsts() {
        return this.getSeq((Function0 & java.io.Serializable & Serializable)() -> this.getInst());
    }

    private Inst getInst() {
        Position pos = this.getPosition();
        int n = this.buffer.getInt();
        switch (n) {
            case 161: {
                return new Inst.Label(this.getLocal(), this.getParams(), pos);
            }
            case 162: {
                return new Inst.Let(this.getLocal(), this.getOp(), Next$None$.MODULE$, pos);
            }
            case 163: {
                return new Inst.Let(this.getLocal(), this.getOp(), this.getNext(), pos);
            }
            case 164: {
                return new Inst.Ret(this.getVal(), pos);
            }
            case 165: {
                return new Inst.Jump(this.getNext(), pos);
            }
            case 166: {
                return new Inst.If(this.getVal(), this.getNext(), this.getNext(), pos);
            }
            case 167: {
                return new Inst.Switch(this.getVal(), this.getNext(), this.getNexts(), pos);
            }
            case 168: {
                return new Inst.Throw(this.getVal(), this.getNext(), pos);
            }
            case 169: {
                return new Inst.Unreachable(this.getNext(), pos);
            }
            case 170: {
                return new Inst.LinktimeIf(this.getLinktimeCondition(), this.getNext(), this.getNext(), pos);
            }
        }
        throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
    }

    private Comp getComp() {
        int n = this.buffer.getInt();
        switch (n) {
            case 65: {
                return Comp$Ieq$.MODULE$;
            }
            case 66: {
                return Comp$Ine$.MODULE$;
            }
            case 67: {
                return Comp$Ugt$.MODULE$;
            }
            case 68: {
                return Comp$Uge$.MODULE$;
            }
            case 69: {
                return Comp$Ult$.MODULE$;
            }
            case 70: {
                return Comp$Ule$.MODULE$;
            }
            case 71: {
                return Comp$Sgt$.MODULE$;
            }
            case 72: {
                return Comp$Sge$.MODULE$;
            }
            case 73: {
                return Comp$Slt$.MODULE$;
            }
            case 74: {
                return Comp$Sle$.MODULE$;
            }
            case 75: {
                return Comp$Feq$.MODULE$;
            }
            case 76: {
                return Comp$Fne$.MODULE$;
            }
            case 77: {
                return Comp$Fgt$.MODULE$;
            }
            case 78: {
                return Comp$Fge$.MODULE$;
            }
            case 79: {
                return Comp$Flt$.MODULE$;
            }
            case 80: {
                return Comp$Fle$.MODULE$;
            }
        }
        throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
    }

    private Conv getConv() {
        int n = this.buffer.getInt();
        switch (n) {
            case 97: {
                return Conv$Trunc$.MODULE$;
            }
            case 98: {
                return Conv$Zext$.MODULE$;
            }
            case 99: {
                return Conv$Sext$.MODULE$;
            }
            case 100: {
                return Conv$Fptrunc$.MODULE$;
            }
            case 101: {
                return Conv$Fpext$.MODULE$;
            }
            case 102: {
                return Conv$Fptoui$.MODULE$;
            }
            case 103: {
                return Conv$Fptosi$.MODULE$;
            }
            case 104: {
                return Conv$Uitofp$.MODULE$;
            }
            case 105: {
                return Conv$Sitofp$.MODULE$;
            }
            case 106: {
                return Conv$Ptrtoint$.MODULE$;
            }
            case 107: {
                return Conv$Inttoptr$.MODULE$;
            }
            case 108: {
                return Conv$Bitcast$.MODULE$;
            }
        }
        throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
    }

    private scala.collection.Seq<Defn> getDefns() {
        return this.getSeq((Function0 & java.io.Serializable & Serializable)() -> this.getDefn());
    }

    private Defn getDefn() {
        Position pos = this.getPosition();
        int n = this.buffer.getInt();
        switch (n) {
            case 129: {
                return new Defn.Var(this.getAttrs(), this.getGlobal(), this.getType(), this.getVal(), pos);
            }
            case 130: {
                return new Defn.Const(this.getAttrs(), this.getGlobal(), this.getType(), this.getVal(), pos);
            }
            case 131: {
                return new Defn.Declare(this.getAttrs(), this.getGlobal(), this.getType(), pos);
            }
            case 132: {
                return new Defn.Define(this.getAttrs(), this.getGlobal(), this.getType(), this.getInsts(), pos);
            }
            case 133: {
                return new Defn.Trait(this.getAttrs(), this.getGlobal(), this.getGlobals(), pos);
            }
            case 134: {
                return new Defn.Class(this.getAttrs(), this.getGlobal(), this.getGlobalOpt(), this.getGlobals(), pos);
            }
            case 135: {
                return new Defn.Module(this.getAttrs(), this.getGlobal(), this.getGlobalOpt(), this.getGlobals(), pos);
            }
        }
        throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
    }

    private scala.collection.Seq<Global> getGlobals() {
        return this.getSeq((Function0 & java.io.Serializable & Serializable)() -> this.getGlobal());
    }

    private Option<Global> getGlobalOpt() {
        return this.getOpt((Function0 & java.io.Serializable & Serializable)() -> this.getGlobal());
    }

    private Global getGlobal() {
        int n = this.buffer.getInt();
        switch (n) {
            case 193: {
                return Global$None$.MODULE$;
            }
            case 194: {
                return new Global.Top(this.getUTF8String());
            }
            case 195: {
                return new Global.Member(new Global.Top(this.getUTF8String()), this.getSig());
            }
        }
        throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
    }

    private Sig getSig() {
        Sig sig = new Sig(this.getUTF8String());
        if (this.usesEncodedMemberNames()) {
            return sig;
        }
        Sig.Unmangled unmangled = sig.unmangled();
        if (unmangled instanceof Sig.Field) {
            Sig.Field field = (Sig.Field)unmangled;
            return Sig$.MODULE$.unmangledToMangled(field.copy(NameTransformer$.MODULE$.encode(field.id()), field.copy$default$2()));
        }
        if (unmangled instanceof Sig.Method) {
            Sig.Method method = (Sig.Method)unmangled;
            return Sig$.MODULE$.unmangledToMangled(method.copy(NameTransformer$.MODULE$.encode(method.id()), method.copy$default$2(), method.copy$default$3()));
        }
        return Sig$.MODULE$.unmangledToMangled(unmangled);
    }

    private long getLocal() {
        return this.buffer.getLong();
    }

    private scala.collection.Seq<Next> getNexts() {
        return this.getSeq((Function0 & java.io.Serializable & Serializable)() -> this.getNext());
    }

    private Next getNext() {
        int n = this.buffer.getInt();
        if (Tags$.MODULE$.NoneNext() == n) {
            return Next$None$.MODULE$;
        }
        if (Tags$.MODULE$.UnwindNext() == n) {
            return new Next.Unwind(this.getParam(), this.getNext());
        }
        if (Tags$.MODULE$.CaseNext() == n) {
            return new Next.Case(this.getVal(), this.getNext());
        }
        if (Tags$.MODULE$.LabelNext() == n) {
            return new Next.Label(this.getLocal(), this.getVals());
        }
        throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
    }

    private Op getOp() {
        int n = this.buffer.getInt();
        if (Tags$.MODULE$.CallOp() == n) {
            return new Op.Call(this.getType(), this.getVal(), this.getVals());
        }
        if (Tags$.MODULE$.LoadOp() == n) {
            return new Op.Load(this.getType(), this.getVal());
        }
        if (Tags$.MODULE$.StoreOp() == n) {
            return new Op.Store(this.getType(), this.getVal(), this.getVal());
        }
        if (Tags$.MODULE$.ElemOp() == n) {
            return new Op.Elem(this.getType(), this.getVal(), this.getVals());
        }
        if (Tags$.MODULE$.ExtractOp() == n) {
            return new Op.Extract(this.getVal(), this.getInts());
        }
        if (Tags$.MODULE$.InsertOp() == n) {
            return new Op.Insert(this.getVal(), this.getVal(), this.getInts());
        }
        if (Tags$.MODULE$.StackallocOp() == n) {
            return new Op.Stackalloc(this.getType(), this.getVal());
        }
        if (Tags$.MODULE$.BinOp() == n) {
            return new Op.Bin(this.getBin(), this.getType(), this.getVal(), this.getVal());
        }
        if (Tags$.MODULE$.CompOp() == n) {
            return new Op.Comp(this.getComp(), this.getType(), this.getVal(), this.getVal());
        }
        if (Tags$.MODULE$.ConvOp() == n) {
            return new Op.Conv(this.getConv(), this.getType(), this.getVal());
        }
        if (Tags$.MODULE$.ClassallocOp() == n) {
            return new Op.Classalloc(this.getGlobal());
        }
        if (Tags$.MODULE$.FieldloadOp() == n) {
            return new Op.Fieldload(this.getType(), this.getVal(), this.getGlobal());
        }
        if (Tags$.MODULE$.FieldstoreOp() == n) {
            return new Op.Fieldstore(this.getType(), this.getVal(), this.getGlobal(), this.getVal());
        }
        if (Tags$.MODULE$.FieldOp() == n) {
            return new Op.Field(this.getVal(), this.getGlobal());
        }
        if (Tags$.MODULE$.MethodOp() == n) {
            return new Op.Method(this.getVal(), this.getSig());
        }
        if (Tags$.MODULE$.DynmethodOp() == n) {
            return new Op.Dynmethod(this.getVal(), this.getSig());
        }
        if (Tags$.MODULE$.ModuleOp() == n) {
            return new Op.Module(this.getGlobal());
        }
        if (Tags$.MODULE$.AsOp() == n) {
            return new Op.As(this.getType(), this.getVal());
        }
        if (Tags$.MODULE$.IsOp() == n) {
            return new Op.Is(this.getType(), this.getVal());
        }
        if (Tags$.MODULE$.CopyOp() == n) {
            return new Op.Copy(this.getVal());
        }
        if (Tags$.MODULE$.SizeofOp() == n) {
            return new Op.Sizeof(this.getType());
        }
        if (Tags$.MODULE$.BoxOp() == n) {
            return new Op.Box(this.getType(), this.getVal());
        }
        if (Tags$.MODULE$.UnboxOp() == n) {
            return new Op.Unbox(this.getType(), this.getVal());
        }
        if (Tags$.MODULE$.VarOp() == n) {
            return new Op.Var(this.getType());
        }
        if (Tags$.MODULE$.VarloadOp() == n) {
            return new Op.Varload(this.getVal());
        }
        if (Tags$.MODULE$.VarstoreOp() == n) {
            return new Op.Varstore(this.getVal(), this.getVal());
        }
        if (Tags$.MODULE$.ArrayallocOp() == n) {
            return new Op.Arrayalloc(this.getType(), this.getVal());
        }
        if (Tags$.MODULE$.ArrayloadOp() == n) {
            return new Op.Arrayload(this.getType(), this.getVal(), this.getVal());
        }
        if (Tags$.MODULE$.ArraystoreOp() == n) {
            return new Op.Arraystore(this.getType(), this.getVal(), this.getVal(), this.getVal());
        }
        if (Tags$.MODULE$.ArraylengthOp() == n) {
            return new Op.Arraylength(this.getVal());
        }
        throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
    }

    private scala.collection.Seq<Val.Local> getParams() {
        return this.getSeq((Function0 & java.io.Serializable & Serializable)() -> this.getParam());
    }

    private Val.Local getParam() {
        return new Val.Local(this.getLocal(), this.getType());
    }

    private scala.collection.Seq<Type> getTypes() {
        return this.getSeq((Function0 & java.io.Serializable & Serializable)() -> this.getType());
    }

    private Type getType() {
        int n = this.buffer.getInt();
        if (Tags$.MODULE$.VarargType() == n) {
            return Type$Vararg$.MODULE$;
        }
        if (Tags$.MODULE$.PtrType() == n) {
            return Type$Ptr$.MODULE$;
        }
        if (Tags$.MODULE$.BoolType() == n) {
            return Type$Bool$.MODULE$;
        }
        if (Tags$.MODULE$.CharType() == n) {
            return Type$Char$.MODULE$;
        }
        if (Tags$.MODULE$.ByteType() == n) {
            return Type$Byte$.MODULE$;
        }
        if (Tags$.MODULE$.ShortType() == n) {
            return Type$Short$.MODULE$;
        }
        if (Tags$.MODULE$.IntType() == n) {
            return Type$Int$.MODULE$;
        }
        if (Tags$.MODULE$.LongType() == n) {
            return Type$Long$.MODULE$;
        }
        if (Tags$.MODULE$.FloatType() == n) {
            return Type$Float$.MODULE$;
        }
        if (Tags$.MODULE$.DoubleType() == n) {
            return Type$Double$.MODULE$;
        }
        if (Tags$.MODULE$.ArrayValueType() == n) {
            return new Type.ArrayValue(this.getType(), this.buffer.getInt());
        }
        if (Tags$.MODULE$.StructValueType() == n) {
            return new Type.StructValue(this.getTypes());
        }
        if (Tags$.MODULE$.FunctionType() == n) {
            return new Type.Function(this.getTypes(), this.getType());
        }
        if (Tags$.MODULE$.NullType() == n) {
            return Type$Null$.MODULE$;
        }
        if (Tags$.MODULE$.NothingType() == n) {
            return Type$Nothing$.MODULE$;
        }
        if (Tags$.MODULE$.VirtualType() == n) {
            return Type$Virtual$.MODULE$;
        }
        if (Tags$.MODULE$.VarType() == n) {
            return new Type.Var(this.getType());
        }
        if (Tags$.MODULE$.UnitType() == n) {
            return Type$Unit$.MODULE$;
        }
        if (Tags$.MODULE$.ArrayType() == n) {
            return new Type.Array(this.getType(), this.getBool());
        }
        if (Tags$.MODULE$.RefType() == n) {
            return new Type.Ref(this.getGlobal(), this.getBool(), this.getBool());
        }
        throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
    }

    private scala.collection.Seq<Val> getVals() {
        return this.getSeq((Function0 & java.io.Serializable & Serializable)() -> this.getVal());
    }

    private Val getVal() {
        int n = this.buffer.getInt();
        if (Tags$.MODULE$.TrueVal() == n) {
            return Val$True$.MODULE$;
        }
        if (Tags$.MODULE$.FalseVal() == n) {
            return Val$False$.MODULE$;
        }
        if (Tags$.MODULE$.NullVal() == n) {
            return Val$Null$.MODULE$;
        }
        if (Tags$.MODULE$.ZeroVal() == n) {
            return new Val.Zero(this.getType());
        }
        if (Tags$.MODULE$.CharVal() == n) {
            return new Val.Char((char)this.buffer.getShort());
        }
        if (Tags$.MODULE$.ByteVal() == n) {
            return new Val.Byte(this.buffer.get());
        }
        if (Tags$.MODULE$.ShortVal() == n) {
            return new Val.Short(this.buffer.getShort());
        }
        if (Tags$.MODULE$.IntVal() == n) {
            return new Val.Int(this.buffer.getInt());
        }
        if (Tags$.MODULE$.LongVal() == n) {
            return new Val.Long(this.buffer.getLong());
        }
        if (Tags$.MODULE$.FloatVal() == n) {
            return new Val.Float(this.buffer.getFloat());
        }
        if (Tags$.MODULE$.DoubleVal() == n) {
            return new Val.Double(this.buffer.getDouble());
        }
        if (Tags$.MODULE$.StructValueVal() == n) {
            return new Val.StructValue(this.getVals());
        }
        if (Tags$.MODULE$.ArrayValueVal() == n) {
            return new Val.ArrayValue(this.getType(), this.getVals());
        }
        if (Tags$.MODULE$.CharsVal() == n) {
            return new Val.Chars((scala.collection.Seq<Object>)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(this.getBytes())).toIndexedSeq());
        }
        if (Tags$.MODULE$.LocalVal() == n) {
            return new Val.Local(this.getLocal(), this.getType());
        }
        if (Tags$.MODULE$.GlobalVal() == n) {
            return new Val.Global(this.getGlobal(), this.getType());
        }
        if (Tags$.MODULE$.UnitVal() == n) {
            return Val$Unit$.MODULE$;
        }
        if (Tags$.MODULE$.ConstVal() == n) {
            return new Val.Const(this.getVal());
        }
        if (Tags$.MODULE$.StringVal() == n) {
            char[] chars = (char[])Array$.MODULE$.fill(this.buffer.getInt(), (Function0)(JFunction0.mcC.sp & java.io.Serializable & Serializable)() -> $this.buffer.getChar(), ClassTag$.MODULE$.Char());
            return new Val.String(new String(chars));
        }
        if (Tags$.MODULE$.VirtualVal() == n) {
            return new Val.Virtual(this.buffer.getLong());
        }
        if (Tags$.MODULE$.ClassOfVal() == n) {
            return new Val.ClassOf(this.getGlobal());
        }
        throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
    }

    private LinktimeCondition getLinktimeCondition() {
        int n = this.buffer.getInt();
        switch (n) {
            case 1: {
                return new LinktimeCondition.SimpleCondition(this.getUTF8String(), this.getComp(), this.getVal(), this.getPosition());
            }
            case 2: {
                return new LinktimeCondition.ComplexCondition(this.getBin(), this.getLinktimeCondition(), this.getLinktimeCondition(), this.getPosition());
            }
        }
        throw package$.MODULE$.unsupported(new StringBuilder(32).append("Unknown linktime condition tag: ").append(n).toString());
    }

    public Position getPosition() {
        return this.readPosition$1();
    }

    private final Position readPosition$1() {
        Position result;
        Position position;
        byte first = this.buffer.get();
        if (first == -1) {
            return Position$.MODULE$.NoPosition();
        }
        if ((first & 0xF) == 7) {
            URI file = this.files()[this.buffer.getInt()];
            int line = this.buffer.getInt();
            int column = this.buffer.getInt();
            position = new Position(file, line, column);
        } else {
            Position position2 = this.lastPosition;
            Position position3 = Position$.MODULE$.NoPosition();
            Predef$.MODULE$.assert(position2 == null ? position3 != null : !((Object)position2).equals(position3), (Function0 & java.io.Serializable & Serializable)() -> "Position format error: first position must be full");
            if ((first & 1) == 0) {
                int columnDiff = first >> 1;
                position = new Position(this.lastPosition.source(), this.lastPosition.line(), this.lastPosition.column() + columnDiff);
            } else if ((first & 3) == 1) {
                int lineDiff = first >> 2;
                int column = this.buffer.get() & 0xFF;
                position = new Position(this.lastPosition.source(), this.lastPosition.line() + lineDiff, column);
            } else {
                Predef$.MODULE$.assert((first & 0xF) == 3, (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(60).append("Position format error: first byte ").append(first).append(" does not match any format").toString());
                short lineDiff = this.buffer.getShort();
                int column = this.buffer.get() & 0xFF;
                position = new Position(this.lastPosition.source(), this.lastPosition.line() + lineDiff, column);
            }
        }
        this.lastPosition = result = position;
        return result;
    }

    public BinaryDeserializer(ByteBuffer buffer, String bufferName) {
        this.buffer = buffer;
        this.lastPosition = Position$.MODULE$.NoPosition();
        buffer.position(0);
        Prelude prelude = Prelude$.MODULE$.readFrom(buffer, bufferName);
        URI[] files = (URI[])Array$.MODULE$.fill(buffer.getInt(), (Function0 & java.io.Serializable & Serializable)() -> new URI(this.getUTF8String()), ClassTag$.MODULE$.apply(URI.class));
        scala.collection.Seq pairs = this.getSeq((Function0 & java.io.Serializable & Serializable)() -> new Tuple2((Object)this.getGlobal(), (Object)BoxesRunTime.boxToInteger((int)$this.buffer.getInt())));
        Tuple3 tuple3 = new Tuple3((Object)prelude, pairs, (Object)files);
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        Prelude prelude2 = (Prelude)tuple3._1();
        scala.collection.Seq header = (scala.collection.Seq)tuple3._2();
        URI[] files2 = (URI[])tuple3._3();
        this.x$1 = new Tuple3((Object)prelude2, (Object)header, (Object)files2);
        this.prelude = (Prelude)this.x$1._1();
        this.header = (scala.collection.Seq)this.x$1._2();
        this.files = (URI[])this.x$1._3();
        this.usesEncodedMemberNames = this.prelude().revision() >= 9;
    }
}

