/*
 * Decompiled with CFR 0.152.
 */
package scala.scalanative.nir;

import java.io.DataOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple4;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.scalanative.nir.Prelude;
import scala.scalanative.nir.Versions$;

public final class Prelude$
implements Serializable {
    public static final Prelude$ MODULE$ = new Prelude$();
    private static final int length = 13;

    public int length() {
        return length;
    }

    public Prelude readFrom(ByteBuffer buffer, String bufferName) {
        int magic = buffer.getInt();
        int compat = buffer.getInt();
        int revision = buffer.getInt();
        Predef$.MODULE$.assert(magic == Versions$.MODULE$.magic(), (Function0 & Serializable)() -> "Can't read non-NIR file.");
        Predef$.MODULE$.assert(compat == Versions$.MODULE$.compat() && revision <= Versions$.MODULE$.revision(), (Function0 & Serializable)() -> new StringBuilder(105).append("Can't read binary-incompatible version of NIR from '").append(bufferName).append("' (expected compat=").append(Versions$.MODULE$.compat()).append(", got ").append(compat).append("; expected revision=").append(Versions$.MODULE$.revision()).append(", got ").append(revision).append(").").toString());
        boolean hasEntryPoints = buffer.get() != 0;
        return new Prelude(magic, compat, revision, hasEntryPoints);
    }

    public DataOutputStream writeTo(DataOutputStream out, Prelude prelude) {
        Prelude prelude2 = prelude;
        if (prelude2 == null) {
            throw new MatchError((Object)prelude2);
        }
        int magic = prelude2.magic();
        int compat = prelude2.compat();
        int revision = prelude2.revision();
        boolean hasEntryPoints = prelude2.hasEntryPoints();
        Tuple4 tuple4 = new Tuple4((Object)BoxesRunTime.boxToInteger((int)magic), (Object)BoxesRunTime.boxToInteger((int)compat), (Object)BoxesRunTime.boxToInteger((int)revision), (Object)BoxesRunTime.boxToBoolean((boolean)hasEntryPoints));
        int magic2 = BoxesRunTime.unboxToInt((Object)tuple4._1());
        int compat2 = BoxesRunTime.unboxToInt((Object)tuple4._2());
        int revision2 = BoxesRunTime.unboxToInt((Object)tuple4._3());
        boolean hasEntryPoints2 = BoxesRunTime.unboxToBoolean((Object)tuple4._4());
        out.writeInt(magic2);
        out.writeInt(compat2);
        out.writeInt(revision2);
        out.writeBoolean(hasEntryPoints2);
        return out;
    }

    public Prelude apply(int magic, int compat, int revision, boolean hasEntryPoints) {
        return new Prelude(magic, compat, revision, hasEntryPoints);
    }

    public Option<Tuple4<Object, Object, Object, Object>> unapply(Prelude x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)x$0.magic()), (Object)BoxesRunTime.boxToInteger((int)x$0.compat()), (Object)BoxesRunTime.boxToInteger((int)x$0.revision()), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.hasEntryPoints())));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Prelude$.class);
    }

    private Prelude$() {
    }
}

