/*
 * Decompiled with CFR 0.152.
 */
package scala.scalanative.nir.serialization;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.scalanative.nir.serialization.NIRSectionWriter$;

@ScalaSignature(bytes="\u0006\u0005\u0005\rg!B\u000f\u001f\u0003C9\u0003\u0002\u0003\u0017\u0001\u0005\u0003\u0005\u000b\u0011B\u0017\t\u000bA\u0002A\u0011A\u0019\t\u000fU\u0002!\u0019!C\u0005m!1q\b\u0001Q\u0001\n]Bq\u0001\u0011\u0001C\u0002\u0013%\u0011\t\u0003\u0004F\u0001\u0001\u0006IA\u0011\u0005\u0006\r\u0002!)a\u0012\u0005\u0006\u0011\u0002!)!\u0013\u0005\u0006\u0011\u0002!)!\u0016\u0005\u00061\u0002!)!\u0017\u0005\u0006=\u0002!)a\u0018\u0005\u0006C\u0002!)A\u0019\u0005\u0006O\u0002!)\u0001\u001b\u0005\u0006[\u0002!)A\u001c\u0005\u0006i\u0002!)!\u001e\u0005\u0006o\u0002!)\u0001\u001f\u0005\u0006{\u0002!)A \u0005\b\u0003\u0003\u0001AQAA\u0002\u0011\u001d\ti\u0001\u0001C\u0003\u0003\u001fAq!a\u0005\u0001\t\u000b\t)\u0002C\u0004\u0002\u001a\u0001!)!a\u0007\t\u000f\u0005u\u0003\u0001\"\u0002\u0002`!9\u0011q\u000f\u0001\u0005\u0006\u0005e\u0004bBA?\u0001\u0011\u0015\u0011qP\u0004\n\u0003Gs\u0012\u0011!E\u0001\u0003K3\u0001\"\b\u0010\u0002\u0002#\u0005\u0011q\u0015\u0005\u0007ai!\t!!+\t\u0013\u0005-&$%A\u0005\u0002\u00055&\u0001\u0005(J%N+7\r^5p]^\u0013\u0018\u000e^3s\u0015\ty\u0002%A\u0007tKJL\u0017\r\\5{CRLwN\u001c\u0006\u0003C\t\n1A\\5s\u0015\t\u0019C%A\u0006tG\u0006d\u0017M\\1uSZ,'\"A\u0013\u0002\u000bM\u001c\u0017\r\\1\u0004\u0001M\u0011\u0001\u0001\u000b\t\u0003S)j\u0011\u0001J\u0005\u0003W\u0011\u0012a!\u00118z%\u00164\u0017!E5oSRL\u0017\r\u001c\"vM\u001a,'oU5{KB\u0011\u0011FL\u0005\u0003_\u0011\u00121!\u00138u\u0003\u0019a\u0014N\\5u}Q\u0011!\u0007\u000e\t\u0003g\u0001i\u0011A\b\u0005\bY\t\u0001\n\u00111\u0001.\u0003\u0011\u0011\u0017m\\:\u0016\u0003]\u0002\"\u0001O\u001f\u000e\u0003eR!AO\u001e\u0002\u0005%|'\"\u0001\u001f\u0002\t)\fg/Y\u0005\u0003}e\u0012QCQ=uK\u0006\u0013(/Y=PkR\u0004X\u000f^*ue\u0016\fW.A\u0003cC>\u001c\b%\u0001\u0004pkR\u0004X\u000f^\u000b\u0002\u0005B\u0011\u0001hQ\u0005\u0003\tf\u0012\u0001\u0003R1uC>+H\u000f];u'R\u0014X-Y7\u0002\u000f=,H\u000f];uA\u0005A\u0001o\\:ji&|g\u000eF\u0001.\u0003\r\u0001X\u000f\u001e\u000b\u0003\u00156\u0003\"!K&\n\u00051##\u0001B+oSRDQA\u0014\u0005A\u0002=\u000baA^1mk\u0016\u001c\bcA\u0015Q%&\u0011\u0011\u000b\n\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003SMK!\u0001\u0016\u0013\u0003\t\tKH/\u001a\u000b\u0003\u0015ZCQaV\u0005A\u0002I\u000bQA^1mk\u0016\f\u0001\u0002];u'\"|'\u000f\u001e\u000b\u0003\u0015jCQa\u0016\u0006A\u0002m\u0003\"!\u000b/\n\u0005u##!B*i_J$\u0018A\u00029vi&sG\u000f\u0006\u0002KA\")qk\u0003a\u0001[\u0005A\u0001/\u001e;GY>\fG\u000f\u0006\u0002KG\")q\u000b\u0004a\u0001IB\u0011\u0011&Z\u0005\u0003M\u0012\u0012QA\u00127pCR\f\u0011\u0002];u\t>,(\r\\3\u0015\u0005)K\u0007\"B,\u000e\u0001\u0004Q\u0007CA\u0015l\u0013\taGE\u0001\u0004E_V\u0014G.Z\u0001\baV$(i\\8m)\tQu\u000eC\u0003q\u001d\u0001\u0007\u0011/A\u0001w!\tI#/\u0003\u0002tI\t9!i\\8mK\u0006t\u0017a\u00039vi2+'m\u00155peR$\"A\u0013<\t\u000b]{\u0001\u0019A.\u0002\u0015A,H\u000fT3c\u0007\"\f'\u000f\u0006\u0002Ks\")q\u000b\u0005a\u0001uB\u0011\u0011f_\u0005\u0003y\u0012\u0012Aa\u00115be\u0006\t\u0002/\u001e;MK\n,fn]5h]\u0016$\u0017J\u001c;\u0015\u0005){\b\"\u00029\u0012\u0001\u0004i\u0013A\u00059vi2+'-\u00168tS\u001etW\r\u001a'p]\u001e$2ASA\u0003\u0011\u0019\u0001(\u00031\u0001\u0002\bA\u0019\u0011&!\u0003\n\u0007\u0005-AE\u0001\u0003M_:<\u0017a\u00049vi2+'mU5h]\u0016$\u0017J\u001c;\u0015\u0007)\u000b\t\u0002C\u0003q'\u0001\u0007Q&\u0001\tqkRdUMY*jO:,G\rT8oOR\u0019!*a\u0006\t\rA$\u0002\u0019AA\u0004\u0003\u0019\u0001X\u000f^*fcV!\u0011QDA\u0018)\u0011\ty\"!\u0011\u0015\u0007)\u000b\t\u0003C\u0004\u0002$U\u0001\r!!\n\u0002\tA,H\u000f\u0016\t\u0007S\u0005\u001d\u00121\u0006&\n\u0007\u0005%BEA\u0005Gk:\u001cG/[8ocA!\u0011QFA\u0018\u0019\u0001!q!!\r\u0016\u0005\u0004\t\u0019DA\u0001U#\u0011\t)$a\u000f\u0011\u0007%\n9$C\u0002\u0002:\u0011\u0012qAT8uQ&tw\rE\u0002*\u0003{I1!a\u0010%\u0005\r\te.\u001f\u0005\b\u0003\u0007*\u0002\u0019AA#\u0003\r\u0019X-\u001d\t\u0007\u0003\u000f\n9&a\u000b\u000f\t\u0005%\u00131\u000b\b\u0005\u0003\u0017\n\t&\u0004\u0002\u0002N)\u0019\u0011q\n\u0014\u0002\rq\u0012xn\u001c;?\u0013\u0005)\u0013bAA+I\u00059\u0001/Y2lC\u001e,\u0017\u0002BA-\u00037\u00121aU3r\u0015\r\t)\u0006J\u0001\u0007aV$x\n\u001d;\u0016\t\u0005\u0005\u00141\u000e\u000b\u0005\u0003G\ni\u0007F\u0002K\u0003KBq!a\t\u0017\u0001\u0004\t9\u0007\u0005\u0004*\u0003O\tIG\u0013\t\u0005\u0003[\tY\u0007B\u0004\u00022Y\u0011\r!a\r\t\u000f\u0005=d\u00031\u0001\u0002r\u0005\u0019q\u000e\u001d;\u0011\u000b%\n\u0019(!\u001b\n\u0007\u0005UDE\u0001\u0004PaRLwN\\\u0001\u0007aV$H+Y4\u0015\u0007)\u000bY\bC\u0003X/\u0001\u0007!+\u0001\u0004d_6l\u0017\u000e\u001e\u000b\u0004\u0015\u0006\u0005\u0005B\u0002!\u0019\u0001\u0004\t\u0019\tE\u00029\u0003\u000bK1!a\":\u00051yU\u000f\u001e9viN#(/Z1nS-\u0001\u00111RAJ\u0003/\u000bY*a(\u000b\t\u00055\u0015qR\u0001\u0006\t\u00164gn]\u0005\u0004\u0003#s\"\u0001\u0005\"j]\u0006\u0014\u0018pU3sS\u0006d\u0017N_3s\u0015\u0011\t)*a$\u0002\r!+\u0017\rZ3s\u0015\u0011\tI*a$\u0002\u000b%s7\u000f^:\n\u0007\u0005ueDA\u000eJ]R,'O\\3e\u0005&t\u0017M]=TK\u000e$\u0018n\u001c8Xe&$XM\u001d\u0006\u0005\u0003C\u000by)A\u0004PM\u001a\u001cX\r^:\u0002!9K%kU3di&|gn\u0016:ji\u0016\u0014\bCA\u001a\u001b'\tQ\u0002\u0006\u0006\u0002\u0002&\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIE*\"!a,+\u00075\n\tl\u000b\u0002\u00024B!\u0011QWA`\u001b\t\t9L\u0003\u0003\u0002:\u0006m\u0016!C;oG\",7m[3e\u0015\r\ti\fJ\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAa\u0003o\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public abstract class NIRSectionWriter {
    private final ByteArrayOutputStream baos;
    private final DataOutputStream output;

    public static int $lessinit$greater$default$1() {
        return NIRSectionWriter$.MODULE$.$lessinit$greater$default$1();
    }

    private ByteArrayOutputStream baos() {
        return this.baos;
    }

    private DataOutputStream output() {
        return this.output;
    }

    public final int position() {
        return this.output().size();
    }

    public final void put(byte[] values) {
        this.output().write(values);
    }

    public final void put(byte value) {
        this.output().write(value);
    }

    public final void putShort(short value) {
        this.output().writeShort(value);
    }

    public final void putInt(int value) {
        this.output().writeInt(value);
    }

    public final void putFloat(float value) {
        this.output().writeFloat(value);
    }

    public final void putDouble(double value) {
        this.output().writeDouble(value);
    }

    public final void putBool(boolean v) {
        this.put((byte)(v ? 1 : 0));
    }

    public final void putLebShort(short value) {
        this.putLebSignedInt(value);
    }

    public final void putLebChar(char value) {
        this.putLebUnsignedInt(value);
    }

    public final void putLebUnsignedInt(int v) {
        boolean hasMore;
        Predef$.MODULE$.require(v >= 0, (Function0 & Serializable)() -> new StringBuilder(31).append("Unsigned integer expected, got ").append(v).toString());
        int remaining = v;
        do {
            byte by = (byte)(remaining & 0x7F);
            hasMore = (remaining >>= 7) != 0;
            this.put(hasMore ? (byte)(by | 0x80) : by);
        } while (hasMore);
    }

    public final void putLebUnsignedLong(long v) {
        boolean hasMore;
        Predef$.MODULE$.require(v >= 0L, (Function0 & Serializable)() -> new StringBuilder(31).append("Unsigned integer expected, got ").append(v).toString());
        long remaining = v;
        do {
            byte by = (byte)(remaining & 0x7FL);
            hasMore = (remaining >>= 7) != 0L;
            this.put(hasMore ? (byte)(by | 0x80) : by);
        } while (hasMore);
    }

    public final void putLebSignedInt(int v) {
        int end;
        int value = v;
        int remaining = value >> 7;
        boolean hasMore = true;
        int n = end = (value & Integer.MIN_VALUE) == 0 ? 0 : -1;
        while (hasMore) {
            hasMore = remaining != end || (remaining & 1) != (value >> 6 & 1);
            this.put((byte)(value & 0x7F | (hasMore ? 128 : 0)));
            value = remaining;
            remaining >>= 7;
        }
    }

    public final void putLebSignedLong(long v) {
        long end;
        long value = v;
        long remaining = value >> 7;
        boolean hasMore = true;
        long l = end = (value & Long.MIN_VALUE) == 0L ? 0L : -1L;
        while (hasMore) {
            hasMore = remaining != end || (remaining & 1L) != (value >> 6 & 1L);
            this.put((byte)(value & 0x7FL | (long)(hasMore ? 128 : 0)));
            value = remaining;
            remaining >>= 7;
        }
    }

    public final <T> void putSeq(Seq<T> seq, Function1<T, BoxedUnit> putT) {
        this.putLebUnsignedInt(seq.length());
        seq.foreach(putT);
    }

    public final <T> void putOpt(Option<T> opt, Function1<T, BoxedUnit> putT) {
        Option<T> option = opt;
        if (None$.MODULE$.equals(option)) {
            this.put((byte)0);
            return;
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            Object t = some.value();
            this.put((byte)1);
            BoxedUnit cfr_ignored_0 = (BoxedUnit)putT.apply(t);
            return;
        }
        throw new MatchError(option);
    }

    public final void putTag(byte value) {
        this.put(value);
    }

    public final void commit(OutputStream output) {
        this.baos().writeTo(output);
        output.flush();
    }

    public NIRSectionWriter(int initialBufferSize) {
        this.baos = new ByteArrayOutputStream(initialBufferSize);
        this.output = new DataOutputStream(this.baos());
    }
}

