/*
 * Decompiled with CFR 0.152.
 */
package scala.scalanative.nir;

import java.io.Serializable;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.UnrolledBuffer;
import scala.collection.mutable.UnrolledBuffer$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.scalanative.nir.Bin;
import scala.scalanative.nir.Comp;
import scala.scalanative.nir.Conv;
import scala.scalanative.nir.Fresh;
import scala.scalanative.nir.Global;
import scala.scalanative.nir.Inst;
import scala.scalanative.nir.Inst$If$;
import scala.scalanative.nir.Inst$Jump$;
import scala.scalanative.nir.Inst$Label$;
import scala.scalanative.nir.Inst$Let$;
import scala.scalanative.nir.Inst$LinktimeIf$;
import scala.scalanative.nir.Inst$Ret$;
import scala.scalanative.nir.Inst$Switch$;
import scala.scalanative.nir.Inst$Throw$;
import scala.scalanative.nir.Inst$Unreachable$;
import scala.scalanative.nir.LinktimeCondition;
import scala.scalanative.nir.MemoryOrder;
import scala.scalanative.nir.Next;
import scala.scalanative.nir.Next$Label$;
import scala.scalanative.nir.Next$None$;
import scala.scalanative.nir.Op;
import scala.scalanative.nir.Op$AlignmentOf$;
import scala.scalanative.nir.Op$Arrayalloc$;
import scala.scalanative.nir.Op$Arraylength$;
import scala.scalanative.nir.Op$Arrayload$;
import scala.scalanative.nir.Op$Arraystore$;
import scala.scalanative.nir.Op$As$;
import scala.scalanative.nir.Op$Bin$;
import scala.scalanative.nir.Op$Box$;
import scala.scalanative.nir.Op$Call$;
import scala.scalanative.nir.Op$Classalloc$;
import scala.scalanative.nir.Op$Comp$;
import scala.scalanative.nir.Op$Conv$;
import scala.scalanative.nir.Op$Copy$;
import scala.scalanative.nir.Op$Dynmethod$;
import scala.scalanative.nir.Op$Elem$;
import scala.scalanative.nir.Op$Extract$;
import scala.scalanative.nir.Op$Fence$;
import scala.scalanative.nir.Op$Field$;
import scala.scalanative.nir.Op$Fieldload$;
import scala.scalanative.nir.Op$Fieldstore$;
import scala.scalanative.nir.Op$Insert$;
import scala.scalanative.nir.Op$Is$;
import scala.scalanative.nir.Op$Load$;
import scala.scalanative.nir.Op$Method$;
import scala.scalanative.nir.Op$Module$;
import scala.scalanative.nir.Op$SizeOf$;
import scala.scalanative.nir.Op$Stackalloc$;
import scala.scalanative.nir.Op$Store$;
import scala.scalanative.nir.Op$Unbox$;
import scala.scalanative.nir.Op$Var$;
import scala.scalanative.nir.Op$Varload$;
import scala.scalanative.nir.Op$Varstore$;
import scala.scalanative.nir.Sig;
import scala.scalanative.nir.SourcePosition;
import scala.scalanative.nir.Type;
import scala.scalanative.nir.Val;
import scala.scalanative.nir.Val$Local$;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class InstructionBuilder {
    private final Fresh fresh;
    private final UnrolledBuffer buffer;

    public InstructionBuilder(Fresh fresh) {
        this.fresh = fresh;
        this.buffer = UnrolledBuffer$.MODULE$.empty(ClassTag$.MODULE$.apply(Inst.class));
    }

    private UnrolledBuffer<Inst> buffer() {
        return this.buffer;
    }

    public void $plus$eq(Inst inst) {
        this.buffer().$plus$eq((Object)inst);
    }

    public void $plus$plus$eq(Seq<Inst> insts) {
        this.buffer().$plus$plus$eq(insts);
    }

    public void $plus$plus$eq(InstructionBuilder other) {
        this.buffer().$plus$plus$eq(other.buffer());
    }

    public Seq<Inst> toSeq() {
        return this.buffer().toSeq();
    }

    public int size() {
        return this.buffer().size();
    }

    public void foreach(Function1<Inst, BoxedUnit> fn) {
        this.buffer().foreach(fn);
    }

    public boolean exists(Function1<Inst, Object> pred) {
        return this.buffer().exists(pred);
    }

    public Option<Inst.Let> updateLetInst(long expectedId, Function1<Inst.Let, Inst.Let> fn) {
        int idx = this.buffer().indexWhere((Function1 & Serializable)x$1 -> {
            Inst inst = x$1;
            if (inst instanceof Inst.Let) {
                Inst.Let let = Inst$Let$.MODULE$.unapply((Inst.Let)inst);
                long l = let._1();
                Op op = let._2();
                Next next = let._3();
                long id = l;
                return expectedId == id;
            }
            return false;
        });
        if (idx < 0) {
            return None$.MODULE$;
        }
        Inst.Let inst = (Inst.Let)this.buffer().apply(idx);
        Inst.Let patched = (Inst.Let)fn.apply((Object)inst);
        this.buffer().update(idx, (Object)patched);
        return Some$.MODULE$.apply((Object)patched);
    }

    public void label(long id, SourcePosition pos) {
        this.$plus$eq(Inst$Label$.MODULE$.apply(id, (Seq<Val.Local>)((Seq)package$.MODULE$.Seq().empty()), pos));
    }

    public void label(long id, Seq<Val.Local> params, SourcePosition pos) {
        this.$plus$eq(Inst$Label$.MODULE$.apply(id, params, pos));
    }

    public void unreachable(Next unwind, SourcePosition pos) {
        this.$plus$eq(Inst$Unreachable$.MODULE$.apply(unwind, pos));
    }

    public void ret(Val value, SourcePosition pos) {
        this.$plus$eq(Inst$Ret$.MODULE$.apply(value, pos));
    }

    public void jump(Next next, SourcePosition pos) {
        this.$plus$eq(Inst$Jump$.MODULE$.apply(next, pos));
    }

    public void jump(long to, Seq<Val> args, SourcePosition pos) {
        this.$plus$eq(Inst$Jump$.MODULE$.apply(Next$Label$.MODULE$.apply(to, args), pos));
    }

    public void branch(Val value, Next thenp, Next elsep, SourcePosition pos) {
        this.$plus$eq(Inst$If$.MODULE$.apply(value, thenp, elsep, pos));
    }

    public void branchLinktime(LinktimeCondition condition, Next thenp, Next elsep, SourcePosition pos) {
        this.$plus$eq(Inst$LinktimeIf$.MODULE$.apply(condition, thenp, elsep, pos));
    }

    public void switch(Val value, Next next, Seq<Next> cases, SourcePosition pos) {
        this.$plus$eq(Inst$Switch$.MODULE$.apply(value, next, cases, pos));
    }

    public void raise(Val value, Next unwind, SourcePosition pos) {
        this.$plus$eq(Inst$Throw$.MODULE$.apply(value, unwind, pos));
    }

    public Val.Local let(long id, Op op, Next unwind, SourcePosition pos, int scope) {
        this.$plus$eq(Inst$Let$.MODULE$.apply(id, op, unwind, pos, scope));
        return Val$Local$.MODULE$.apply(id, op.resty());
    }

    public Val.Local let(Op op, Next unwind, SourcePosition pos, int scope) {
        return this.let(this.fresh.apply(), op, unwind, pos, scope);
    }

    public Val.Local call(Type.Function ty, Val ptr, Seq<Val> args, Next unwind, SourcePosition pos, int scope) {
        return this.let(Op$Call$.MODULE$.apply(ty, ptr, args), unwind, pos, scope);
    }

    public Val.Local load(Type ty, Val ptr, Next unwind, Option<MemoryOrder> memoryOrder, SourcePosition pos, int scope) {
        return this.let(Op$Load$.MODULE$.apply(ty, ptr, memoryOrder), unwind, pos, scope);
    }

    public Option<MemoryOrder> load$default$4() {
        return None$.MODULE$;
    }

    public Val.Local store(Type ty, Val ptr, Val value, Next unwind, Option<MemoryOrder> memoryOrder, SourcePosition pos, int scope) {
        return this.let(Op$Store$.MODULE$.apply(ty, ptr, value, memoryOrder), unwind, pos, scope);
    }

    public Option<MemoryOrder> store$default$5() {
        return None$.MODULE$;
    }

    public Val.Local elem(Type ty, Val ptr, Seq<Val> indexes, Next unwind, SourcePosition pos, int scope) {
        return this.let(Op$Elem$.MODULE$.apply(ty, ptr, indexes), unwind, pos, scope);
    }

    public Val.Local extract(Val aggr, Seq<Object> indexes, Next unwind, SourcePosition pos, int scope) {
        return this.let(Op$Extract$.MODULE$.apply(aggr, indexes), unwind, pos, scope);
    }

    public Val.Local insert(Val aggr, Val value, Seq<Object> indexes, Next unwind, SourcePosition pos, int scope) {
        return this.let(Op$Insert$.MODULE$.apply(aggr, value, indexes), unwind, pos, scope);
    }

    public Val.Local stackalloc(Type ty, Val n, Next unwind, SourcePosition pos, int scope) {
        return this.let(Op$Stackalloc$.MODULE$.apply(ty, n), unwind, pos, scope);
    }

    public Val.Local bin(Bin bin, Type ty, Val l, Val r, Next unwind, SourcePosition pos, int scope) {
        return this.let(Op$Bin$.MODULE$.apply(bin, ty, l, r), unwind, pos, scope);
    }

    public Val.Local comp(Comp comp, Type ty, Val l, Val r, Next unwind, SourcePosition pos, int scope) {
        return this.let(Op$Comp$.MODULE$.apply(comp, ty, l, r), unwind, pos, scope);
    }

    public Val.Local conv(Conv conv, Type ty, Val value, Next unwind, SourcePosition pos, int scope) {
        return this.let(Op$Conv$.MODULE$.apply(conv, ty, value), unwind, pos, scope);
    }

    public Val.Local classalloc(Global.Top name, Next unwind, Option<Val> zone, SourcePosition pos, int scope) {
        return this.let(Op$Classalloc$.MODULE$.apply(name, zone), unwind, pos, scope);
    }

    public Option<Val> classalloc$default$3() {
        return None$.MODULE$;
    }

    public Val.Local fieldload(Type ty, Val obj, Global.Member name, Next unwind, SourcePosition pos, int scope) {
        return this.let(Op$Fieldload$.MODULE$.apply(ty, obj, name), unwind, pos, scope);
    }

    public Val.Local fieldstore(Type ty, Val obj, Global.Member name, Val value, Next unwind, SourcePosition pos, int scope) {
        return this.let(Op$Fieldstore$.MODULE$.apply(ty, obj, name, value), unwind, pos, scope);
    }

    public Val.Local field(Val obj, Global.Member name, Next unwind, SourcePosition pos, int scope) {
        return this.let(Op$Field$.MODULE$.apply(obj, name), unwind, pos, scope);
    }

    public Val.Local method(Val obj, Sig sig, Next unwind, SourcePosition pos, int scope) {
        return this.let(Op$Method$.MODULE$.apply(obj, sig), unwind, pos, scope);
    }

    public Val.Local dynmethod(Val obj, Sig sig, Next unwind, SourcePosition pos, int scope) {
        return this.let(Op$Dynmethod$.MODULE$.apply(obj, sig), unwind, pos, scope);
    }

    public Val.Local module(Global.Top name, Next unwind, SourcePosition pos, int scope) {
        return this.let(Op$Module$.MODULE$.apply(name), unwind, pos, scope);
    }

    public Val.Local as(Type ty, Val obj, Next unwind, SourcePosition pos, int scope) {
        return this.let(Op$As$.MODULE$.apply(ty, obj), unwind, pos, scope);
    }

    public Val.Local is(Type ty, Val obj, Next unwind, SourcePosition pos, int scope) {
        return this.let(Op$Is$.MODULE$.apply(ty, obj), unwind, pos, scope);
    }

    public Val.Local copy(Val value, Next unwind, SourcePosition pos, int scope) {
        return this.let(Op$Copy$.MODULE$.apply(value), unwind, pos, scope);
    }

    public Val.Local sizeOf(Type ty, Next unwind, SourcePosition pos, int scope) {
        return this.let(Op$SizeOf$.MODULE$.apply(ty), unwind, pos, scope);
    }

    public Val.Local alignmentOf(Type ty, Next unwind, SourcePosition pos, int scope) {
        return this.let(Op$AlignmentOf$.MODULE$.apply(ty), unwind, pos, scope);
    }

    public Val.Local box(Type ty, Val obj, Next unwind, SourcePosition pos, int scope) {
        return this.let(Op$Box$.MODULE$.apply(ty, obj), unwind, pos, scope);
    }

    public Val.Local unbox(Type ty, Val obj, Next unwind, SourcePosition pos, int scope) {
        return this.let(Op$Unbox$.MODULE$.apply(ty, obj), unwind, pos, scope);
    }

    public Val.Local var_(Type ty, Next unwind, SourcePosition pos, int scope) {
        return this.let(Op$Var$.MODULE$.apply(ty), unwind, pos, scope);
    }

    public Val.Local varload(Val slot, Next unwind, SourcePosition pos, int scope) {
        return this.let(Op$Varload$.MODULE$.apply(slot), unwind, pos, scope);
    }

    public Val.Local varstore(Val slot, Val value, Next unwind, SourcePosition pos, int scope) {
        return this.let(Op$Varstore$.MODULE$.apply(slot, value), unwind, pos, scope);
    }

    public Val.Local arrayalloc(Type ty, Val init, Next unwind, Option<Val> zone, SourcePosition pos, int scope) {
        return this.let(Op$Arrayalloc$.MODULE$.apply(ty, init, zone), unwind, pos, scope);
    }

    public Option<Val> arrayalloc$default$4() {
        return None$.MODULE$;
    }

    public Val.Local arrayload(Type ty, Val arr, Val idx, Next unwind, SourcePosition pos, int scope) {
        return this.let(Op$Arrayload$.MODULE$.apply(ty, arr, idx), unwind, pos, scope);
    }

    public Val.Local arraystore(Type ty, Val arr, Val idx, Val value, Next unwind, SourcePosition pos, int scope) {
        return this.let(Op$Arraystore$.MODULE$.apply(ty, arr, idx, value), unwind, pos, scope);
    }

    public Val.Local arraylength(Val arr, Next unwind, SourcePosition pos, int scope) {
        return this.let(Op$Arraylength$.MODULE$.apply(arr), unwind, pos, scope);
    }

    public Val.Local fence(MemoryOrder memoryOrder, SourcePosition pos, int scope) {
        return this.let(Op$Fence$.MODULE$.apply(memoryOrder), Next$None$.MODULE$, pos, scope);
    }
}

