/*
 * Decompiled with CFR 0.152.
 */
package scala.scalanative.nir;

import scala.Char$;
import scala.MatchError;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Builder;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.scalanative.nir.Global;
import scala.scalanative.nir.Global$Member$;
import scala.scalanative.nir.Global$Top$;
import scala.scalanative.nir.Sig;
import scala.scalanative.nir.Sig$;
import scala.scalanative.nir.Sig$Clinit$;
import scala.scalanative.nir.Sig$Ctor$;
import scala.scalanative.nir.Sig$Duplicate$;
import scala.scalanative.nir.Sig$Extern$;
import scala.scalanative.nir.Sig$Field$;
import scala.scalanative.nir.Sig$Generated$;
import scala.scalanative.nir.Sig$Method$;
import scala.scalanative.nir.Sig$Proxy$;
import scala.scalanative.nir.Sig$Scope$Private$;
import scala.scalanative.nir.Sig$Scope$PrivateStatic$;
import scala.scalanative.nir.Sig$Scope$Public$;
import scala.scalanative.nir.Sig$Scope$PublicStatic$;
import scala.scalanative.nir.Type;
import scala.scalanative.nir.Type$Array$;
import scala.scalanative.nir.Type$ArrayValue$;
import scala.scalanative.nir.Type$Bool$;
import scala.scalanative.nir.Type$Byte$;
import scala.scalanative.nir.Type$Char$;
import scala.scalanative.nir.Type$Double$;
import scala.scalanative.nir.Type$Float$;
import scala.scalanative.nir.Type$Function$;
import scala.scalanative.nir.Type$Int$;
import scala.scalanative.nir.Type$Long$;
import scala.scalanative.nir.Type$Nothing$;
import scala.scalanative.nir.Type$Null$;
import scala.scalanative.nir.Type$Ptr$;
import scala.scalanative.nir.Type$Ref$;
import scala.scalanative.nir.Type$Short$;
import scala.scalanative.nir.Type$Size$;
import scala.scalanative.nir.Type$StructValue$;
import scala.scalanative.nir.Type$Unit$;
import scala.scalanative.nir.Type$Vararg$;
import scala.scalanative.nir.Unmangle$;

public final class Unmangle {
    public static Global unmangleGlobal(String string) {
        return Unmangle$.MODULE$.unmangleGlobal(string);
    }

    public static Sig.Unmangled unmangleSig(String string) {
        return Unmangle$.MODULE$.unmangleSig(string);
    }

    public static Type unmangleType(String string) {
        return Unmangle$.MODULE$.unmangleType(string);
    }

    public static class Impl {
        private final String s;
        private final char[] chars;
        private int pos;

        public Impl(String s) {
            this.s = s;
            this.chars = (char[])StringOps$.MODULE$.toArray$extension(Predef$.MODULE$.augmentString(s), ClassTag$.MODULE$.apply(Character.TYPE));
            this.pos = 0;
        }

        public char[] chars() {
            return this.chars;
        }

        public int pos() {
            return this.pos;
        }

        public void pos_$eq(int x$1) {
            this.pos = x$1;
        }

        public Global readGlobal() {
            Global global;
            int n = this.read();
            if (84 == n) {
                global = Global$Top$.MODULE$.apply(this.readIdent());
            } else if (77 == n) {
                global = Global$Member$.MODULE$.apply(Global$Top$.MODULE$.apply(this.readIdent()), this.readUnmangledSig().mangled());
            } else {
                int ch = n;
                throw this.error(new StringBuilder(25).append("expected global, but got ").append(ch).toString());
            }
            return global;
        }

        public Sig.Scope readSigScope() {
            Sig.Scope scope;
            int n = this.read();
            switch (n) {
                case 79: {
                    scope = Sig$Scope$Public$.MODULE$;
                    break;
                }
                case 111: {
                    scope = Sig$Scope$PublicStatic$.MODULE$;
                    break;
                }
                case 80: {
                    scope = Sig$Scope$Private$.MODULE$.apply(this.readGlobal());
                    break;
                }
                case 112: {
                    scope = Sig$Scope$PrivateStatic$.MODULE$.apply(this.readGlobal());
                    break;
                }
                default: {
                    throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
                }
            }
            return scope;
        }

        public Sig.Unmangled readUnmangledSig() {
            Sig.Unmangled unmangled;
            int n = this.read();
            switch (n) {
                case 70: {
                    unmangled = Sig$Field$.MODULE$.apply(this.readIdent(), this.readSigScope());
                    break;
                }
                case 82: {
                    unmangled = Sig$Ctor$.MODULE$.apply(this.readTypes());
                    break;
                }
                case 73: {
                    unmangled = Sig$Clinit$.MODULE$;
                    break;
                }
                case 68: {
                    unmangled = Sig$Method$.MODULE$.apply(this.readIdent(), this.readTypes(), this.readSigScope());
                    break;
                }
                case 80: {
                    unmangled = Sig$Proxy$.MODULE$.apply(this.readIdent(), this.readTypes());
                    break;
                }
                case 67: {
                    unmangled = Sig$Extern$.MODULE$.apply(this.readIdent());
                    break;
                }
                case 71: {
                    unmangled = Sig$Generated$.MODULE$.apply(this.readIdent());
                    break;
                }
                case 75: {
                    unmangled = Sig$Duplicate$.MODULE$.apply(Sig$.MODULE$.unmangledToMangled(this.readUnmangledSig()), this.readTypes());
                    break;
                }
                default: {
                    int ch = n;
                    throw this.error(new StringBuilder(22).append("expected sig, but got ").append(ch).toString());
                }
            }
            return unmangled;
        }

        public Type readType() {
            char c = this.peek();
            switch (c) {
                case 'v': {
                    this.next();
                    return Type$Vararg$.MODULE$;
                }
                case 'R': {
                    Type type;
                    this.next();
                    char c2 = this.peek();
                    if ('_' == c2) {
                        this.next();
                        type = Type$Ptr$.MODULE$;
                    } else {
                        Seq<Type> types = this.readTypes();
                        type = Type$Function$.MODULE$.apply((Seq<Type>)((Seq)types.init()), (Type)types.last());
                    }
                    return type;
                }
                case 'z': {
                    this.next();
                    return Type$Bool$.MODULE$;
                }
                case 'c': {
                    this.next();
                    return Type$Char$.MODULE$;
                }
                case 'b': {
                    this.next();
                    return Type$Byte$.MODULE$;
                }
                case 's': {
                    this.next();
                    return Type$Short$.MODULE$;
                }
                case 'i': {
                    this.next();
                    return Type$Int$.MODULE$;
                }
                case 'j': {
                    this.next();
                    return Type$Long$.MODULE$;
                }
                case 'w': {
                    this.next();
                    return Type$Size$.MODULE$;
                }
                case 'f': {
                    this.next();
                    return Type$Float$.MODULE$;
                }
                case 'd': {
                    this.next();
                    return Type$Double$.MODULE$;
                }
                case 'l': {
                    this.next();
                    return Type$Null$.MODULE$;
                }
                case 'n': {
                    this.next();
                    return Type$Nothing$.MODULE$;
                }
                case 'u': {
                    this.next();
                    return Type$Unit$.MODULE$;
                }
                case 'A': {
                    Type type;
                    this.next();
                    Type ty = this.readType();
                    char c3 = this.peek();
                    if ('_' == c3) {
                        this.next();
                        type = Type$Array$.MODULE$.apply(ty, false);
                    } else {
                        char n = c3;
                        if ('0' <= n && n <= '9') {
                            Type.ArrayValue res = Type$ArrayValue$.MODULE$.apply(ty, this.readNumber());
                            this.accept('_');
                            type = res;
                        } else {
                            char ch = c3;
                            throw this.error(new StringBuilder(29).append("expected digit or _, but got ").append(ch).toString());
                        }
                    }
                    return type;
                }
                case 'S': {
                    this.next();
                    return Type$StructValue$.MODULE$.apply(this.readTypes());
                }
                case 'L': {
                    this.next();
                    return this.readNullableType();
                }
                case 'X': {
                    this.next();
                    return Type$Ref$.MODULE$.apply(Global$Top$.MODULE$.apply(this.readIdent()), true, false);
                }
            }
            char n = c;
            if ('0' <= n && n <= '9') {
                return Type$Ref$.MODULE$.apply(Global$Top$.MODULE$.apply(this.readIdent()), false, false);
            }
            char ch = c;
            throw this.error(new StringBuilder(23).append("expected type, but got ").append(ch).toString());
        }

        public Type readNullableType() {
            Type.RefKind refKind;
            char c = this.peek();
            if ('A' == c) {
                this.next();
                Type ty = this.readType();
                this.accept('_');
                refKind = Type$Array$.MODULE$.apply(ty, true);
            } else if ('X' == c) {
                this.next();
                refKind = Type$Ref$.MODULE$.apply(Global$Top$.MODULE$.apply(this.readIdent()), true, true);
            } else {
                char n = c;
                if ('0' <= n && n <= '9') {
                    refKind = Type$Ref$.MODULE$.apply(Global$Top$.MODULE$.apply(this.readIdent()), false, true);
                } else {
                    char ch = c;
                    throw this.error(new StringBuilder(37).append("expected nullable qualifier, but got ").append(ch).toString());
                }
            }
            return refKind;
        }

        public Seq<Type> readTypes() {
            Builder buf = package$.MODULE$.Seq().newBuilder();
            while (this.peek() != 'E') {
                buf.$plus$eq((Object)this.readType());
            }
            this.next();
            return (Seq)buf.result();
        }

        public String readIdent() {
            int len = this.readNumber();
            if (this.s.charAt(this.pos()) == '-') {
                this.pos_$eq(this.pos() + 1);
            }
            int start = this.pos();
            this.pos_$eq(this.pos() + len);
            return this.s.substring(start, this.pos());
        }

        public int readNumber() {
            int start = this.pos();
            char c = this.peek();
            while ('0' <= c && c <= '9') {
                this.next();
                c = this.peek();
            }
            return Integer.parseInt(this.s.substring(start, this.pos()));
        }

        public char peek() {
            return this.chars()[this.pos()];
        }

        public void next() {
            this.pos_$eq(this.pos() + 1);
        }

        public void accept(char expected) {
            char got = this.peek();
            if (got != expected) {
                throw this.error(new StringBuilder(18).append("expected ").append(expected).append(" but got ").append(got).toString());
            }
            this.next();
        }

        public Nothing$ error(String msg) {
            throw new Exception(new StringBuilder(5).append("at ").append(this.pos()).append(": ").append(msg).toString());
        }

        public int read() {
            char value = this.chars()[this.pos()];
            this.pos_$eq(this.pos() + 1);
            return Char$.MODULE$.char2int(value);
        }
    }
}

