/*
 * Decompiled with CFR 0.152.
 */
package scala.scalanative.build;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.EnumSet;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.runtime.BoxedUnit;

public final class IO$ {
    public static IO$ MODULE$;

    static {
        new IO$();
    }

    public Path RichPath(Path path) {
        return path;
    }

    public void write(Path file, byte[] bytes) {
        Files.createDirectories(file.getParent(), new FileAttribute[0]);
        Files.write(file, bytes, new OpenOption[0]);
    }

    /*
     * WARNING - void declaration
     */
    public Seq<Path> getAll(Path base, String pattern) {
        void var3_3;
        ArrayBuffer out = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        PathMatcher matcher = FileSystems.getDefault().getPathMatcher(pattern);
        SimpleFileVisitor<Path> visitor = new SimpleFileVisitor<Path>(out, matcher){
            private final ArrayBuffer out$1;
            private final PathMatcher matcher$1;

            public FileVisitResult preVisitDirectory(Path directory, BasicFileAttributes attributes) {
                return FileVisitResult.CONTINUE;
            }

            public FileVisitResult postVisitDirectory(Path directory, IOException exception) {
                return FileVisitResult.CONTINUE;
            }

            public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) {
                Object object = this.matcher$1.matches(file) ? this.out$1.$plus$eq((Object)file) : BoxedUnit.UNIT;
                return FileVisitResult.CONTINUE;
            }

            public FileVisitResult visitFileFailed(Path file, IOException exception) {
                return FileVisitResult.CONTINUE;
            }
            {
                this.out$1 = out$1;
                this.matcher$1 = matcher$1;
            }
        };
        Files.walkFileTree(base, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)visitor);
        return var3_3;
    }

    public void deleteRecursive(Path directory) {
        block0: {
            if (!Files.exists(directory, new LinkOption[0])) break block0;
            Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    public byte[] sha1(Path path, int bufSize) {
        MessageDigest digest = MessageDigest.getInstance("SHA-1");
        InputStream stream = Files.newInputStream(path, new OpenOption[0]);
        DigestInputStream digestStream = new DigestInputStream(stream, digest);
        byte[] buf = new byte[bufSize];
        while (digestStream.read(buf, 0, bufSize) == 1024) {
        }
        return digest.digest();
    }

    public int sha1$default$2() {
        return 1024;
    }

    public void unzip(Path archive, Path target) {
        Files.createDirectories(target, new FileAttribute[0]);
        try (FileSystem zipFS = FileSystems.newFileSystem(archive, null);){
            for (Path root : zipFS.getRootDirectories()) {
                Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(target){
                    private final Path target$1;

                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                        Path dest = Paths.get(((Object)this.target$1).toString(), ((Object)file).toString());
                        Files.copy(file, dest, StandardCopyOption.REPLACE_EXISTING);
                        return FileVisitResult.CONTINUE;
                    }

                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                        Path dest = Paths.get(((Object)this.target$1).toString(), ((Object)dir).toString());
                        Files.createDirectories(dest, new FileAttribute[0]);
                        return FileVisitResult.CONTINUE;
                    }
                    {
                        this.target$1 = target$1;
                    }
                });
            }
        }
    }

    private IO$() {
        MODULE$ = this;
    }
}

