/*
 * Decompiled with CFR 0.152.
 */
package scala.scalanative.build;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.Optional;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenSet;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Set$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.scalanative.build.Config;
import scala.scalanative.build.IO$;
import scala.scalanative.build.LLVM$;
import scala.scalanative.build.NativeConfig;
import scala.scalanative.build.NativeLib;
import scala.scalanative.build.NativeLib$;
import scala.scalanative.build.Platform$;
import scala.scalanative.build.ScalaNative$;
import scala.scalanative.build.Validator$;
import scala.scalanative.linker.Class;
import scala.scalanative.linker.Info;
import scala.scalanative.linker.ReachabilityAnalysis;
import scala.scalanative.nir.Global;
import scala.scalanative.util.Scope;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class Build$ {
    public static Build$ MODULE$;

    static {
        new Build$();
    }

    public Future<Path> buildCached(Config config, Scope scope, ExecutionContext ec) {
        Path checksumPath = config.workDir().resolve("build-checksum");
        if (Files.exists(config.artifactPath(), new LinkOption[0]) && IO$.MODULE$.readFully(checksumPath).contains((Object)Integer.toString(this.scala$scalanative$build$Build$$checkSum(config)))) {
            config.logger().info("Build skipped: No changes detected in build configuration and class path contents since last build.");
            return Future$.MODULE$.successful((Object)config.artifactPath());
        }
        return this.build(config, scope, ec).andThen((PartialFunction)new Serializable(checksumPath, config){
            public static final long serialVersionUID = 0L;
            private final Path checksumPath$1;
            private final Config config$1;

            public final <A1 extends Try<Path>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof Success) {
                    IO$.MODULE$.write(this.checksumPath$1, Integer.toString(Build$.MODULE$.scala$scalanative$build$Build$$checkSum(this.config$1)));
                    return (B1)BoxedUnit.UNIT;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Try<Path> x1) {
                Try<Path> try_ = x1;
                return try_ instanceof Success;
            }
            {
                this.checksumPath$1 = checksumPath$1;
                this.config$1 = config$1;
            }
        }, ec);
    }

    public Future<Path> build(Config config, Scope scope, ExecutionContext ec) {
        Config initialConfig = config;
        return config.logger().timeAsync("Total", (Function0 & java.io.Serializable & Serializable)() -> {
            MODULE$.checkWorkdirExists(initialConfig);
            ObjectRef config = ObjectRef.create((Object)Validator$.MODULE$.validate(initialConfig));
            ((Config)config.elem).logger().debug(((Config)config.elem).toString());
            return Build$.linkNIRForEntries$1(config, scope, ec).flatMap((Function1 & java.io.Serializable & Serializable)linkerResult -> {
                Tuple2<Config, Object> tuple2 = MODULE$.postRechabilityAnalysisConfigUpdate((Config)config$2.elem, (ReachabilityAnalysis.Result)linkerResult);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                Config updatedConfig = (Config)tuple2._1();
                boolean needsToReload = tuple2._2$mcZ$sp();
                Tuple2 tuple22 = new Tuple2((Object)updatedConfig, (Object)BoxesRunTime.boxToBoolean((boolean)needsToReload));
                Config updatedConfig2 = (Config)tuple22._1();
                boolean needsToReload2 = tuple22._2$mcZ$sp();
                config$2.elem = updatedConfig2;
                if (needsToReload2) {
                    return Build$.linkNIRForEntries$1(config, scope, ec);
                }
                return Future$.MODULE$.successful(linkerResult);
            }, ec).flatMap((Function1 & java.io.Serializable & Serializable)x$2 -> ScalaNative$.MODULE$.optimize((Config)config$2.elem, (ReachabilityAnalysis.Result)x$2, ec), ec).flatMap((Function1 & java.io.Serializable & Serializable)linkerResult -> ScalaNative$.MODULE$.codegen((Config)config$2.elem, (ReachabilityAnalysis.Result)linkerResult, ec).flatMap((Function1 & java.io.Serializable & Serializable)irGenerators -> MODULE$.compile((Config)config$2.elem, (ReachabilityAnalysis.Result)linkerResult, (Seq<Future<Path>>)irGenerators, ec), ec).map((Function1 & java.io.Serializable & Serializable)objects -> MODULE$.link((Config)config$2.elem, (ReachabilityAnalysis.Result)linkerResult, (Seq<Path>)objects), ec).map((Function1 & java.io.Serializable & Serializable)artifact -> MODULE$.postProcess((Config)config$2.elem, (Path)artifact), ec), ec).andThen((PartialFunction)new Serializable(config){
                public static final long serialVersionUID = 0L;
                private final ObjectRef config$2;

                public final <A1 extends Try<Path>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 instanceof Success) {
                        Build$.MODULE$.dumpUserConfigHash((Config)this.config$2.elem);
                        return (B1)BoxedUnit.UNIT;
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(Try<Path> x1) {
                    Try<Path> try_ = x1;
                    return try_ instanceof Success;
                }
                {
                    this.config$2 = config$2;
                }
            }, ec);
        }, ec);
    }

    private Future<Seq<Path>> compile(Config config, ReachabilityAnalysis.Result analysis, Seq<Future<Path>> irGenerators, ExecutionContext ec) {
        return config.logger().timeAsync("Compiling to native code", (Function0 & java.io.Serializable & Serializable)() -> {
            Future compileGeneratedIR = Future$.MODULE$.sequence((TraversableOnce)irGenerators.map((Function1 & java.io.Serializable & Serializable)irGenerator -> irGenerator.flatMap((Function1 & java.io.Serializable & Serializable)generatedIR -> LLVM$.MODULE$.compile(config, (Path)generatedIR, ec), ec), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom(), ec);
            Future<Seq<Path>> compileNativeLibs = MODULE$.findAndCompileNativeLibraries(config, analysis, ec);
            return Future$.MODULE$.reduceLeft((Iterable)new .colon.colon((Object)compileGeneratedIR, (List)new .colon.colon(compileNativeLibs, (List)Nil$.MODULE$)), (Function2 & java.io.Serializable & Serializable)(x$3, x$4) -> (Seq)x$3.$plus$plus((GenTraversableOnce)x$4, Seq$.MODULE$.canBuildFrom()), ec);
        }, ec);
    }

    private Path link(Config config, ReachabilityAnalysis.Result analysis, Seq<Path> compiled) {
        return (Path)config.logger().time(new StringBuilder(31).append("Linking native code (").append(config.gc().name()).append(" gc, ").append(config.LTO().name()).append(" lto)").toString(), (Function0 & java.io.Serializable & Serializable)() -> LLVM$.MODULE$.link(config, analysis, compiled));
    }

    private Tuple2<Config, Object> postRechabilityAnalysisConfigUpdate(Config config, ReachabilityAnalysis.Result analysis) {
        BoxedUnit boxedUnit;
        Config currentConfig = config;
        boolean needsToReload = false;
        if (config.compilerConfig().multithreading().isEmpty()) {
            Global.Top jlThread = new Global.Top("java.lang.Thread");
            Global.Top jlMainThread = new Global.Top("java.lang.Thread$MainThread$");
            Global.Top jlVirtualThread = new Global.Top("java.lang.VirtualThread");
            boolean usesSystemThreads = BoxesRunTime.unboxToBoolean((Object)analysis.infos().get((Object)jlThread).collect((PartialFunction)new Serializable(jlMainThread, jlVirtualThread){
                public static final long serialVersionUID = 0L;
                private final Global.Top jlMainThread$1;
                private final Global.Top jlVirtualThread$1;

                public final <A1 extends Info, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 instanceof Class) {
                        Class clazz = (Class)A1;
                        return (B1)BoxesRunTime.boxToBoolean((clazz.subclasses().size() > 2 || ((SetLike)clazz.subclasses().map((Function1 & java.io.Serializable & Serializable)x$5 -> x$5.name(), Set$.MODULE$.canBuildFrom())).diff((GenSet)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Global.Top[]{this.jlMainThread$1, this.jlVirtualThread$1}))).nonEmpty() || clazz.allocations() > 4 ? 1 : 0) != 0);
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(Info x1) {
                    Info info = x1;
                    return info instanceof Class;
                }
                {
                    this.jlMainThread$1 = jlMainThread$1;
                    this.jlVirtualThread$1 = jlVirtualThread$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(scala.scalanative.linker.Class )}, serializedLambda);
                }
            }).getOrElse((Function0)(JFunction0.mcZ.sp & java.io.Serializable & Serializable)() -> false));
            if (!usesSystemThreads) {
                config.logger().info("Multithreading was not explicitly enabled - initial class loading has not detected any usage of system threads. Multithreading support will be disabled to improve performance.");
                currentConfig = currentConfig.withCompilerConfig((Function1<NativeConfig, NativeConfig>)(Function1 & java.io.Serializable & Serializable)x$6 -> x$6.withMultithreading(false));
                needsToReload = true;
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Predef$.MODULE$.locally((Object)boxedUnit);
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)currentConfig), (Object)BoxesRunTime.boxToBoolean((boolean)needsToReload));
    }

    private Path postProcess(Config config, Path artifact) {
        return (Path)config.logger().time("Postprocessing", (Function0 & java.io.Serializable & Serializable)() -> {
            block0: {
                if (!Platform$.MODULE$.isMac() || !config.compilerConfig().sourceLevelDebuggingConfig().generateFunctionSourcePositions()) break block0;
                LLVM$.MODULE$.dsymutil(config, artifact);
            }
            return artifact;
        });
    }

    public int scala$scalanative$build$Build$$checkSum(Config config) {
        return new Tuple3((Object)config, config.classPath().map((Function1 & java.io.Serializable & Serializable)x$7 -> MODULE$.getLastModifiedChild((Path)x$7), Seq$.MODULE$.canBuildFrom()), (Object)this.getLastModified(config.artifactPath())).hashCode();
    }

    public Future<Seq<Path>> findAndCompileNativeLibraries(Config config, ReachabilityAnalysis.Result analysis, ExecutionContext ec) {
        return Future$.MODULE$.traverse(NativeLib$.MODULE$.findNativeLibs(config), (Function1 & java.io.Serializable & Serializable)x$8 -> NativeLib$.MODULE$.compileNativeLibrary(config, analysis, (NativeLib)x$8, ec), Seq$.MODULE$.canBuildFrom(), ec).map((Function1 & java.io.Serializable & Serializable)x$9 -> (Seq)x$9.flatten((Function1)Predef$.MODULE$.$conforms()), ec);
    }

    private void checkWorkdirExists(Config config) {
        Path workDir = config.workDir();
        if (Files.notExists(workDir, new LinkOption[0])) {
            Files.createDirectories(workDir, new FileAttribute[0]);
            return;
        }
    }

    private FileTime getLastModified(Path path) {
        if (Files.exists(path, new LinkOption[0])) {
            return (FileTime)Try$.MODULE$.apply((Function0 & java.io.Serializable & Serializable)() -> Files.getLastModifiedTime(path, new LinkOption[0])).getOrElse((Function0 & java.io.Serializable & Serializable)() -> FileTime.fromMillis(0L));
        }
        return FileTime.fromMillis(0L);
    }

    private Optional<FileTime> getLastModifiedChild(Path path) {
        if (Files.exists(path, new LinkOption[0])) {
            return Files.walk(path, FileVisitOption.FOLLOW_LINKS).map(x$10 -> MODULE$.getLastModified((Path)x$10)).max((x$11, x$12) -> x$11.compareTo((FileTime)x$12));
        }
        return Optional.empty();
    }

    public final String userConfigHashFile() {
        return "userConfigHash";
    }

    public boolean userConfigHasChanged(Config config) {
        return IO$.MODULE$.readFully(config.workDir().resolve("userConfigHash")).forall((Function1 & java.io.Serializable & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)Build$.$anonfun$userConfigHasChanged$1(config, x$13)));
    }

    public void dumpUserConfigHash(Config config) {
        IO$.MODULE$.write(config.workDir().resolve("userConfigHash"), Integer.toString(Statics.anyHash((Object)config.compilerConfig())));
    }

    private static final Future linkNIRForEntries$1(ObjectRef config$2, Scope scope$1, ExecutionContext ec$1) {
        return ScalaNative$.MODULE$.link((Config)config$2.elem, ScalaNative$.MODULE$.entries((Config)config$2.elem), scope$1, ec$1);
    }

    public static final /* synthetic */ boolean $anonfun$userConfigHasChanged$1(Config config$7, String x$13) {
        String string = x$13.trim();
        String string2 = Integer.toString(Statics.anyHash((Object)config$7.compilerConfig()));
        return string == null ? string2 != null : !string.equals(string2);
    }

    private Build$() {
        MODULE$ = this;
    }
}

