/*
 * Decompiled with CFR 0.152.
 */
package scala.scalanative.build;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Stream$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;
import scala.scalanative.build.BuildException;
import scala.scalanative.build.Discover;
import scala.scalanative.build.Discover$cache$;
import scala.scalanative.build.GC;
import scala.scalanative.build.GC$;
import scala.scalanative.build.IO$;
import scala.scalanative.build.IO$RichPath$;
import scala.scalanative.build.LTO;
import scala.scalanative.build.LTO$;
import scala.scalanative.build.LTO$None$;
import scala.scalanative.build.Mode;
import scala.scalanative.build.Mode$;
import scala.scalanative.build.NativeConfig;
import scala.scalanative.build.Platform$;
import scala.sys.package$;
import scala.sys.process.Process$;
import scala.sys.process.ProcessLogger;
import scala.sys.process.ProcessLogger$;
import scala.util.Try;
import scala.util.Try$;

public final class Discover$ {
    public static Discover$ MODULE$;
    private String llvmConfigCLI;
    private final String docSetup;
    private volatile boolean bitmap$0;

    static {
        new Discover$();
    }

    public Mode mode() {
        return (Mode)this.getenv("SCALANATIVE_MODE").filterNot((Function1 & java.io.Serializable & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isEmpty())).map((Function1 & java.io.Serializable & Serializable)x$2 -> Mode$.MODULE$.apply((String)x$2)).getOrElse((Function0 & java.io.Serializable & Serializable)() -> Mode$.MODULE$.default());
    }

    public boolean optimize() {
        return this.getenv("SCALANATIVE_OPTIMIZE").forall((Function1 & java.io.Serializable & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)Discover$.$anonfun$optimize$1(x$3)));
    }

    public LTO LTO() {
        return (LTO)this.getenv("SCALANATIVE_LTO").filterNot((Function1 & java.io.Serializable & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.isEmpty())).map((Function1 & java.io.Serializable & Serializable)x$5 -> LTO$.MODULE$.apply((String)x$5)).getOrElse((Function0 & java.io.Serializable & Serializable)() -> LTO$None$.MODULE$);
    }

    public GC GC() {
        return (GC)this.getenv("SCALANATIVE_GC").filterNot((Function1 & java.io.Serializable & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.isEmpty())).map((Function1 & java.io.Serializable & Serializable)x$7 -> GC$.MODULE$.apply((String)x$7)).getOrElse((Function0 & java.io.Serializable & Serializable)() -> GC$.MODULE$.default());
    }

    public Path clang() {
        Path path = this.discover("clang", "LLVM_BIN");
        this.checkClangVersion(path);
        return path;
    }

    public Path clangpp() {
        Path path = this.discover("clang++", "LLVM_BIN");
        this.checkClangVersion(path);
        return path;
    }

    private String llvmConfigCLI$lzycompute() {
        Discover$ discover$ = this;
        synchronized (discover$) {
            if (!this.bitmap$0) {
                this.llvmConfigCLI = (String)this.tryDiscover("llvm-config", "LLVM_BIN").map((Function1 & java.io.Serializable & Serializable)x$8 -> ((Object)x$8.toAbsolutePath()).toString()).getOrElse((Function0 & java.io.Serializable & Serializable)() -> "llvm-config");
                this.bitmap$0 = true;
            }
        }
        return this.llvmConfigCLI;
    }

    private String llvmConfigCLI() {
        if (!this.bitmap$0) {
            return this.llvmConfigCLI$lzycompute();
        }
        return this.llvmConfigCLI;
    }

    private Seq<String> filterExisting(Seq<String> paths) {
        return (Seq)paths.filter((Function1 & java.io.Serializable & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)Discover$.$anonfun$filterExisting$1(x$9)));
    }

    public Seq<String> compileOptions() {
        Seq llvmIncludeDir = (Seq)Try$.MODULE$.apply((Function0 & java.io.Serializable & Serializable)() -> Process$.MODULE$.apply(new StringBuilder(13).append(MODULE$.llvmConfigCLI()).append(" --includedir").toString()).lineStream_$bang().toSeq()).getOrElse((Function0 & java.io.Serializable & Serializable)() -> (Seq)Nil$.MODULE$);
        Seq includeDirs = (Seq)this.getenv("SCALANATIVE_INCLUDE_DIRS").map((Function1 & java.io.Serializable & Serializable)x$10 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(x$10)).split(File.pathSeparatorChar))).toSeq()).getOrElse((Function0 & java.io.Serializable & Serializable)() -> MODULE$.filterExisting((Seq<String>)((Seq)new .colon.colon((Object)"/usr/local/include", (List)new .colon.colon((Object)"/opt/local/include", (List)new .colon.colon((Object)"/opt/homebrew/include", (List)Nil$.MODULE$))))));
        Seq includes = (Seq)((TraversableLike)includeDirs.$plus$plus((GenTraversableOnce)llvmIncludeDir, Seq$.MODULE$.canBuildFrom())).map((Function1 & java.io.Serializable & Serializable)s -> new StringBuilder(2).append("-I").append((String)s).toString(), Seq$.MODULE$.canBuildFrom());
        return (Seq)includes.$colon$plus((Object)"-Qunused-arguments", Seq$.MODULE$.canBuildFrom());
    }

    public Seq<String> linkingOptions() {
        Seq llvmLibDir = (Seq)Try$.MODULE$.apply((Function0 & java.io.Serializable & Serializable)() -> Process$.MODULE$.apply(new StringBuilder(9).append(MODULE$.llvmConfigCLI()).append(" --libdir").toString()).lineStream_$bang().toSeq()).getOrElse((Function0 & java.io.Serializable & Serializable)() -> (Seq)Nil$.MODULE$);
        Seq libDirs = (Seq)this.getenv("SCALANATIVE_LIB_DIRS").map((Function1 & java.io.Serializable & Serializable)x$11 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(x$11)).split(File.pathSeparatorChar))).toSeq()).getOrElse((Function0 & java.io.Serializable & Serializable)() -> MODULE$.filterExisting((Seq<String>)((Seq)new .colon.colon((Object)"/usr/local/lib", (List)new .colon.colon((Object)"/opt/local/lib", (List)new .colon.colon((Object)"/opt/homebrew/lib", (List)Nil$.MODULE$))))));
        Seq libs = (Seq)((TraversableLike)libDirs.$plus$plus((GenTraversableOnce)llvmLibDir, Seq$.MODULE$.canBuildFrom())).map((Function1 & java.io.Serializable & Serializable)s -> new StringBuilder(2).append("-L").append((String)s).toString(), Seq$.MODULE$.canBuildFrom());
        return libs;
    }

    public Discover.ClangInfo scala$scalanative$build$Discover$$clangInfo(NativeConfig config2) {
        return (Discover.ClangInfo)Discover$cache$.MODULE$.apply("clang-info", (Function1 & java.io.Serializable & Serializable)config -> MODULE$.clangInfo(config.clang()), ClassTag$.MODULE$.apply(Discover.ClangInfo.class), config2);
    }

    private Discover.ClangInfo clangInfo(Path clang) {
        Discover.ClangInfo clangInfo;
        List list;
        String version;
        Seq versionCommand;
        block7: {
            String cmdString;
            block6: {
                versionCommand = (Seq)new .colon.colon((Object)IO$RichPath$.MODULE$.abs$extension(IO$.MODULE$.RichPath(clang)), (List)new .colon.colon((Object)"--version", (List)Nil$.MODULE$));
                cmdString = versionCommand.mkString(" ");
                List processLines = Process$.MODULE$.apply(versionCommand).lineStream_$bang(this.silentLogger()).toList();
                List list2 = processLines;
                if (!(list2 instanceof .colon.colon)) break block6;
                .colon.colon colon2 = (.colon.colon)list2;
                version = (String)colon2.head();
                list = colon2.tl$access$1();
                if (list instanceof .colon.colon) break block7;
            }
            throw new BuildException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(72).append("Problem running '").append(cmdString).append("'. Please check clang setup.\n              |Refer to (").append(this.docSetup()).append(")").toString())).stripMargin());
        }
        .colon.colon colon3 = (.colon.colon)list;
        String target = (String)colon3.head();
        Tuple2 tuple2 = new Tuple2((Object)version, (Object)target);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String versionString = (String)tuple2._1();
        String targetString = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)versionString, (Object)targetString);
        String versionString2 = (String)tuple22._1();
        String targetString2 = (String)tuple22._2();
        try {
            String[] versionArray = versionString2.split(" ");
            int versionIndex = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])versionArray)).indexWhere((Function1 & java.io.Serializable & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)x$13.equals("version")));
            String version2 = versionArray[versionIndex + 1];
            clangInfo = new Discover.ClangInfo(new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(version2)).takeWhile((Function1 & java.io.Serializable & Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)RichChar$.MODULE$.isDigit$extension(Predef$.MODULE$.charWrapper(BoxesRunTime.unboxToChar((Object)x$14))))))).toInt(), version2, (String)new StringOps(Predef$.MODULE$.augmentString(targetString2)).drop(new StringOps(Predef$.MODULE$.augmentString("Target: ")).size()));
        }
        catch (Throwable t) {
            throw new BuildException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(132).append("Output from '").append(versionCommand).append("' unexpected.\n                |Was expecting '... version n.n.n ...'.\n                |Got '").append(versionString2).append("'.\n                |Cause: ").append(t).toString())).stripMargin());
        }
        return clangInfo;
    }

    public void checkClangVersion(Path pathToClangBinary) {
        Discover.ClangInfo clangInfo = this.clangInfo(pathToClangBinary);
        if (clangInfo == null) {
            throw new MatchError((Object)clangInfo);
        }
        int majorVersion = clangInfo.majorVersion();
        String version = clangInfo.fullVersion();
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)majorVersion), (Object)version);
        int majorVersion2 = tuple2._1$mcI$sp();
        String version2 = (String)tuple2._2();
        if (majorVersion2 < 6) {
            throw new BuildException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(101).append("Minimum version of clang is '").append(6).append("'.\n             |Discovered version '").append(version2).append("'.\n             |Please refer to (").append(this.docSetup()).append(")").toString())).stripMargin());
        }
    }

    public final int clangMinVersion() {
        return 6;
    }

    public String docSetup() {
        return this.docSetup;
    }

    public Try<Path> tryDiscover(String binaryName, String envPath) {
        return Try$.MODULE$.apply((Function0 & java.io.Serializable & Serializable)() -> MODULE$.discover(binaryName, envPath));
    }

    public Try<Path> tryDiscover(String binaryName) {
        return Try$.MODULE$.apply((Function0 & java.io.Serializable & Serializable)() -> MODULE$.discover(binaryName));
    }

    public Path discover(String binaryName, Option<String> envPath) {
        Seq seq;
        Option binPath = envPath.flatMap((Function1 & java.io.Serializable & Serializable)x$16 -> package$.MODULE$.env().get(x$16));
        if (Platform$.MODULE$.isWindows()) {
            String binName = new StringBuilder(4).append(binaryName).append(".exe").toString();
            String arg = (String)binPath.fold((Function0 & java.io.Serializable & Serializable)() -> binName, (Function1 & java.io.Serializable & Serializable)p -> new StringBuilder(1).append((String)p).append(":").append(binName).toString());
            seq = (Seq)new .colon.colon((Object)"where", (List)new .colon.colon((Object)arg, (List)Nil$.MODULE$));
        } else {
            String arg = (String)binPath.fold((Function0 & java.io.Serializable & Serializable)() -> binaryName, (Function1 & java.io.Serializable & Serializable)p -> ((Object)Paths.get(p, binaryName)).toString());
            seq = (Seq)new .colon.colon((Object)"which", (List)new .colon.colon((Object)arg, (List)Nil$.MODULE$));
        }
        Seq command = seq;
        Path path = (Path)((TraversableLike)Process$.MODULE$.apply(command).lineStream_$bang(this.silentLogger()).map((Function1 & java.io.Serializable & Serializable)p -> Paths.get(p, new String[0]), Stream$.MODULE$.canBuildFrom())).headOption().getOrElse((Function0 & java.io.Serializable & Serializable)() -> {
            String envMessage = (String)envPath.map((Function1 & java.io.Serializable & Serializable)envPath -> new StringBuilder(30).append("or via '").append((String)envPath).append("' environment variable").toString()).getOrElse((Function0 & java.io.Serializable & Serializable)() -> "");
            throw new BuildException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(54).append("'").append(binaryName).append("' not found in PATH ").append(envMessage).append(".\n            |Please refer to (").append(MODULE$.docSetup()).append(")").toString())).stripMargin());
        });
        return path;
    }

    public Path discover(String binaryName, String envPath) {
        return this.discover(binaryName, (Option<String>)new Some((Object)envPath));
    }

    public Path discover(String binaryName) {
        return this.discover(binaryName, (Option<String>)None$.MODULE$);
    }

    public String targetTriple(Path clang) {
        return this.clangInfo(clang).targetTriple();
    }

    public String targetTriple(NativeConfig config) {
        return (String)Discover$cache$.MODULE$.apply("target-triple", (Function1 & java.io.Serializable & Serializable)x$17 -> MODULE$.scala$scalanative$build$Discover$$clangInfo(config).targetTriple(), ClassTag$.MODULE$.apply(String.class), config);
    }

    private ProcessLogger silentLogger() {
        return ProcessLogger$.MODULE$.apply((Function1 & java.io.Serializable & Serializable)x$18 -> {
            Discover$.$anonfun$silentLogger$1(x$18);
            return BoxedUnit.UNIT;
        }, (Function1 & java.io.Serializable & Serializable)x$19 -> {
            Discover$.$anonfun$silentLogger$2(x$19);
            return BoxedUnit.UNIT;
        });
    }

    private Option<String> getenv(String key) {
        return Option$.MODULE$.apply((Object)System.getenv().get(key));
    }

    public static final /* synthetic */ boolean $anonfun$optimize$1(String x$3) {
        return new StringOps(Predef$.MODULE$.augmentString(x$3)).toBoolean();
    }

    public static final /* synthetic */ boolean $anonfun$filterExisting$1(String x$9) {
        return new File(x$9).exists();
    }

    public static final /* synthetic */ void $anonfun$silentLogger$1(String x$18) {
    }

    public static final /* synthetic */ void $anonfun$silentLogger$2(String x$19) {
    }

    private Discover$() {
        MODULE$ = this;
        this.docSetup = "http://www.scala-native.org/en/latest/user/setup.html";
    }
}

