/*
 * Decompiled with CFR 0.152.
 */
package scala.scalanative.build;

import java.io.File;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;
import scala.scalanative.build.Build$;
import scala.scalanative.build.BuildException;
import scala.scalanative.build.BuildTarget;
import scala.scalanative.build.BuildTarget$Application$;
import scala.scalanative.build.BuildTarget$LibraryDynamic$;
import scala.scalanative.build.BuildTarget$LibraryStatic$;
import scala.scalanative.build.Config;
import scala.scalanative.build.Discover$;
import scala.scalanative.build.Discover$features$;
import scala.scalanative.build.IO$;
import scala.scalanative.build.IO$RichPath$;
import scala.scalanative.build.LTO;
import scala.scalanative.build.LTO$None$;
import scala.scalanative.build.Logger$;
import scala.scalanative.build.Mode;
import scala.scalanative.build.Mode$Debug$;
import scala.scalanative.build.Mode$ReleaseFast$;
import scala.scalanative.build.Mode$ReleaseFull$;
import scala.scalanative.build.Mode$ReleaseSize$;
import scala.scalanative.build.NativeConfig;
import scala.scalanative.build.Sanitizer;
import scala.scalanative.linker.ReachabilityAnalysis;
import scala.sys.process.Process$;
import scala.sys.process.ProcessBuilder;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public final class LLVM$ {
    public static LLVM$ MODULE$;
    private Seq<String> msysExtras;
    private final String oExt;
    private final String cppExt;
    private final String llExt;
    private final Seq<String> srcExtensions;
    private volatile boolean bitmap$0;

    static {
        new LLVM$();
    }

    public String oExt() {
        return this.oExt;
    }

    public String cppExt() {
        return this.cppExt;
    }

    public String llExt() {
        return this.llExt;
    }

    public Seq<String> srcExtensions() {
        return this.srcExtensions;
    }

    public Future<Path> compile(Config config, Path path, ExecutionContext ec) {
        Config _config = config;
        String inpath = IO$RichPath$.MODULE$.abs$extension(IO$.MODULE$.RichPath(path));
        String outpath = new StringBuilder(0).append(inpath).append(this.oExt()).toString();
        Path objPath = Paths.get(outpath, new String[0]);
        if (this.needsCompiling(path, objPath, _config)) {
            return this.compileFile(path, objPath, _config, ec);
        }
        return Future$.MODULE$.successful((Object)objPath);
    }

    private Future<Path> compileFile(Path srcPath, Path objPath, Config config, ExecutionContext ec) {
        return Future$.MODULE$.apply((Function0 & java.io.Serializable & Serializable)() -> {
            String compiler;
            String inpath = IO$RichPath$.MODULE$.abs$extension(IO$.MODULE$.RichPath(srcPath));
            String outpath = IO$RichPath$.MODULE$.abs$extension(IO$.MODULE$.RichPath(objPath));
            boolean isCpp = inpath.endsWith(MODULE$.cppExt());
            boolean isLl = inpath.endsWith(MODULE$.llExt());
            Path workDir = config.workDir();
            String string = compiler = isCpp ? IO$RichPath$.MODULE$.abs$extension(IO$.MODULE$.RichPath(config.clangPP())) : IO$RichPath$.MODULE$.abs$extension(IO$.MODULE$.RichPath(config.clang()));
            Seq stdflag = isLl ? MODULE$.llvmIrFeatures(config) : (isCpp ? (config.targetsWindows() ? (Seq)new .colon.colon((Object)"-std=c++14", (List)Nil$.MODULE$) : (Seq)new .colon.colon((Object)"-std=c++11", (List)Nil$.MODULE$)) : (Seq)new .colon.colon((Object)"-std=gnu11", (List)Nil$.MODULE$));
            Seq<String> platformFlags = config.targetsMsys() ? MODULE$.msysExtras() : Nil$.MODULE$;
            Nil$ multithreadingEnabled = config.compilerConfig().multithreadingSupport() ? (Seq)new .colon.colon((Object)"-DSCALANATIVE_MULTITHREADING_ENABLED", (List)Nil$.MODULE$) : Nil$.MODULE$;
            Option allowTargetOverrrides = config.compilerConfig().targetTriple().map((Function1 & java.io.Serializable & Serializable)x$1 -> "-Wno-override-module");
            Seq configFlags = (Seq)multithreadingEnabled.$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(allowTargetOverrrides), Seq$.MODULE$.canBuildFrom());
            Nil$ opt = isCpp ? new .colon.colon((Object)"-fcxx-exceptions", (List)Nil$.MODULE$) : Nil$.MODULE$;
            .colon.colon colon2 = new .colon.colon((Object)"-fexceptions", (List)new .colon.colon((Object)"-funwind-tables", (List)Nil$.MODULE$));
            List exceptionsHandling = opt.$colon$colon$colon((List)colon2);
            Nil$ debugFlags = config.compilerConfig().sourceLevelDebuggingConfig().enabled() || config.targetsWindows() ? (Seq)new .colon.colon((Object)"-g", (List)Nil$.MODULE$) : Nil$.MODULE$;
            Seq flags = (Seq)((TraversableLike)((TraversableLike)((TraversableLike)((TraversableLike)((TraversableLike)((TraversableLike)((TraversableLike)((TraversableLike)((TraversableLike)((TraversableLike)MODULE$.buildTargetCompileOpts(config).$plus$plus(MODULE$.flto(config), Seq$.MODULE$.canBuildFrom())).$plus$plus(MODULE$.sanitizer(config), Seq$.MODULE$.canBuildFrom())).$plus$plus(MODULE$.target(config), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)stdflag, Seq$.MODULE$.canBuildFrom())).$plus$plus(platformFlags, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)debugFlags, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)exceptionsHandling, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)configFlags, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)new .colon.colon((Object)"-fvisibility=hidden", (List)new .colon.colon((Object)MODULE$.opt(config), (List)Nil$.MODULE$)), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)new .colon.colon((Object)"-fomit-frame-pointer", (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom())).$plus$plus(config.compileOptions(), Seq$.MODULE$.canBuildFrom());
            Seq compilec = (Seq)((TraversableLike)new .colon.colon((Object)compiler, (List)new .colon.colon((Object)"-c", (List)new .colon.colon((Object)inpath, (List)new .colon.colon((Object)"-o", (List)new .colon.colon((Object)outpath, (List)Nil$.MODULE$)))))).$plus$plus((GenTraversableOnce)flags, Seq$.MODULE$.canBuildFrom());
            config.logger().running((Seq<String>)compilec);
            int result = Process$.MODULE$.apply(compilec, workDir.toFile(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0])).$bang(Logger$.MODULE$.toProcessLogger(config.logger()));
            if (result != 0) {
                throw new BuildException(new StringBuilder(18).append("Failed to compile ").append(inpath).toString());
            }
            return objPath;
        }, ec);
    }

    public Path link(Config config, ReachabilityAnalysis.Result analysis, Seq<Path> objectsPaths) {
        ProcessBuilder processBuilder;
        Config _config = config;
        Path buildPath = config.buildPath();
        if (!this.needsLinking(objectsPaths, buildPath)) {
            return this.copyOutput(config, buildPath);
        }
        BuildTarget buildTarget = config.compilerConfig().buildTarget();
        if (BuildTarget$Application$.MODULE$.equals(buildTarget) ? true : BuildTarget$LibraryDynamic$.MODULE$.equals(buildTarget)) {
            processBuilder = this.prepareLinkCommand(objectsPaths, analysis, _config);
        } else if (BuildTarget$LibraryStatic$.MODULE$.equals(buildTarget)) {
            processBuilder = this.prepareArchiveCommand(objectsPaths, _config);
        } else {
            throw new MatchError((Object)buildTarget);
        }
        ProcessBuilder command = processBuilder;
        int result = command.$bang(Logger$.MODULE$.toProcessLogger(config.logger()));
        if (result != 0) {
            throw new BuildException(new StringBuilder(15).append("Failed to link ").append(buildPath).toString());
        }
        return this.copyOutput(config, buildPath);
    }

    public void dsymutil(Config config, Path path) {
        Try try_ = Discover$.MODULE$.tryDiscover("dsymutil", "LLVM_BIN").flatMap((Function1 & java.io.Serializable & Serializable)dsymutil -> {
            ProcessBuilder proc = Process$.MODULE$.apply((Seq)new .colon.colon((Object)IO$RichPath$.MODULE$.abs$extension(IO$.MODULE$.RichPath((Path)dsymutil)), (List)new .colon.colon((Object)IO$RichPath$.MODULE$.abs$extension(IO$.MODULE$.RichPath(path)), (List)Nil$.MODULE$)), config.workDir().toFile(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
            int result = proc.$bang(Logger$.MODULE$.toProcessLogger(config.logger()));
            if (result != 0) {
                return new Failure((Throwable)new BuildException("Failed to link the debug information."));
            }
            return new Success((Object)BoxedUnit.UNIT);
        });
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            config.logger().warn(e.getMessage());
            return;
        }
        if (try_ instanceof Success) {
            return;
        }
        throw new MatchError((Object)try_);
    }

    private Path copyOutput(Config config, Path buildPath) {
        Path outPath = config.artifactPath();
        BuildTarget buildTarget = config.compilerConfig().buildTarget();
        if (BuildTarget$Application$.MODULE$.equals(buildTarget)) {
            return Files.copy(buildPath, outPath, StandardCopyOption.REPLACE_EXISTING);
        }
        if (buildTarget instanceof BuildTarget.Library) {
            return outPath;
        }
        throw new MatchError((Object)buildTarget);
    }

    private ProcessBuilder prepareLinkCommand(Seq<Path> objectsPaths, ReachabilityAnalysis.Result analysis, Config config) {
        BoxedUnit boxedUnit;
        LTO lTO;
        Nil$ ltoSupport;
        Nil$ debugFlags;
        Path workDir = config.workDir();
        Seq srclinks = (Seq)analysis.links().map((Function1 & java.io.Serializable & Serializable)x$3 -> x$3.name(), Seq$.MODULE$.canBuildFrom());
        Seq<String> gclinks = config.gc().links();
        Seq platformsLinks = config.targetsWindows() ? (Seq)new .colon.colon((Object)"dbghelp", (List)Nil$.MODULE$) : (config.targetsOpenBSD() || config.targetsNetBSD() ? (Seq)new .colon.colon((Object)"pthread", (List)Nil$.MODULE$) : (Seq)new .colon.colon((Object)"pthread", (List)new .colon.colon((Object)"dl", (List)Nil$.MODULE$)));
        Seq links = (Seq)((SeqLike)((TraversableLike)platformsLinks.$plus$plus((GenTraversableOnce)srclinks, Seq$.MODULE$.canBuildFrom())).$plus$plus(gclinks, Seq$.MODULE$.canBuildFrom())).distinct();
        config.logger().info(new StringBuilder(15).append("Linking with [").append(links.mkString(", ")).append("]").toString());
        Seq linkopts = (Seq)config.linkingOptions().$plus$plus((GenTraversableOnce)links.map((Function1 & java.io.Serializable & Serializable)x$4 -> new StringBuilder(2).append("-l").append((String)x$4).toString(), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        Object object = debugFlags = config.compilerConfig().sourceLevelDebuggingConfig().enabled() || config.targetsWindows() ? (Seq)new .colon.colon((Object)"-g", (List)Nil$.MODULE$) : Nil$.MODULE$;
        Nil$ platformFlags = !config.targetsWindows() ? Nil$.MODULE$ : (ltoSupport = LTO$None$.MODULE$.equals(lTO = config.compilerConfig().lto()) ? Nil$.MODULE$ : (Seq)new .colon.colon((Object)"-fuse-ld=lld", (List)new .colon.colon((Object)"-Wl,/force:multiple", (List)Nil$.MODULE$)));
        BuildTarget buildTarget = config.compilerConfig().buildTarget();
        BuildTarget$LibraryDynamic$ buildTarget$LibraryDynamic$ = BuildTarget$LibraryDynamic$.MODULE$;
        Nil$ linkNameFlags = !(buildTarget != null ? !buildTarget.equals(buildTarget$LibraryDynamic$) : buildTarget$LibraryDynamic$ != null) ? (config.targetsLinux() ? new .colon.colon((Object)new StringBuilder(12).append("-Wl,-soname,").append(config.artifactName()).toString(), (List)Nil$.MODULE$) : (config.targetsMac() ? new .colon.colon((Object)new StringBuilder(18).append("-Wl,-install_name,").append(config.artifactName()).toString(), (List)Nil$.MODULE$) : Nil$.MODULE$)) : Nil$.MODULE$;
        Seq output = (Seq)new .colon.colon((Object)"-o", (List)new .colon.colon((Object)IO$RichPath$.MODULE$.abs$extension(IO$.MODULE$.RichPath(config.buildPath())), (List)Nil$.MODULE$));
        Seq flags = (Seq)((TraversableLike)((TraversableLike)((TraversableLike)((TraversableLike)((TraversableLike)((TraversableLike)this.buildTargetLinkOpts(config).$plus$plus(this.flto(config), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)debugFlags, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)platformFlags, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)linkNameFlags, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)output, Seq$.MODULE$.canBuildFrom())).$plus$plus(this.sanitizer(config), Seq$.MODULE$.canBuildFrom())).$plus$plus(this.target(config), Seq$.MODULE$.canBuildFrom());
        Seq paths = (Seq)objectsPaths.map((Function1 & java.io.Serializable & Serializable)x$5 -> IO$RichPath$.MODULE$.abs$extension(IO$.MODULE$.RichPath((Path)x$5)), Seq$.MODULE$.canBuildFrom());
        Seq llvmLinkInfo = (Seq)((TraversableLike)flags.$plus$plus((GenTraversableOnce)paths, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)linkopts, Seq$.MODULE$.canBuildFrom());
        File configFile = workDir.resolve("llvmLinkInfo").toFile();
        try (PrintWriter pw = new PrintWriter(configFile);){
            llvmLinkInfo.foreach((Function1 & java.io.Serializable & Serializable)str -> {
                pw.println(LLVM$.MODULE$.escapeWhitespaces(str.replace("\\", "/")));
                return BoxedUnit.UNIT;
            });
            boxedUnit = BoxedUnit.UNIT;
        }
        Predef$.MODULE$.locally((Object)boxedUnit);
        Seq command = (Seq)new .colon.colon((Object)IO$RichPath$.MODULE$.abs$extension(IO$.MODULE$.RichPath(config.clangPP())), (List)new .colon.colon((Object)new StringBuilder(1).append("@").append(configFile.getAbsolutePath()).toString(), (List)Nil$.MODULE$));
        config.logger().running((Seq<String>)command);
        return Process$.MODULE$.apply(command, config.workDir().toFile(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
    }

    private ProcessBuilder prepareArchiveCommand(Seq<Path> objectPaths, Config config) {
        Path workDir = config.workDir();
        Option MRICompatibleAR = Discover$.MODULE$.tryDiscover("llvm-ar", "LLVM_BIN").toOption().orElse((Function0 & java.io.Serializable & Serializable)() -> Discover$.MODULE$.tryDiscover("ar").toOption().filter((Function1 & java.io.Serializable & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)config.targetsLinux())));
        Option option = MRICompatibleAR;
        if (None$.MODULE$.equals(option)) {
            Path ar = Discover$.MODULE$.discover("ar");
            Seq command = (Seq)((TraversableLike)new .colon.colon((Object)IO$RichPath$.MODULE$.abs$extension(IO$.MODULE$.RichPath(ar)), (List)new .colon.colon((Object)"rc", (List)new .colon.colon((Object)IO$RichPath$.MODULE$.abs$extension(IO$.MODULE$.RichPath(config.buildPath())), (List)Nil$.MODULE$)))).$plus$plus((GenTraversableOnce)LLVM$.stageFiles$1(objectPaths, workDir), Seq$.MODULE$.canBuildFrom());
            config.logger().running((Seq<String>)command);
            return Process$.MODULE$.apply(command, config.workDir().toFile(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            Path path = (Path)some.value();
            return this.useMRIScript$1(path, workDir, config, objectPaths);
        }
        throw new MatchError((Object)option);
    }

    private boolean needsCompiling(Path in, Path out, Config config) {
        return in.toFile().lastModified() > out.toFile().lastModified() || Build$.MODULE$.userConfigHasChanged(config);
    }

    private boolean needsLinking(Seq<Path> in, Path out) {
        long outmax;
        long inmax = BoxesRunTime.unboxToLong((Object)((TraversableOnce)in.map((Function1 & java.io.Serializable & Serializable)x$7 -> BoxesRunTime.boxToLong((long)LLVM$.$anonfun$needsLinking$1(x$7)), Seq$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Long$.MODULE$));
        return inmax > (outmax = out.toFile().lastModified());
    }

    private Seq<String> flto(Config config) {
        LTO lTO = config.compilerConfig().lto();
        if (LTO$None$.MODULE$.equals(lTO)) {
            return (Seq)Nil$.MODULE$;
        }
        return (Seq)new .colon.colon((Object)new StringBuilder(6).append("-flto=").append(lTO.name()).toString(), (List)Nil$.MODULE$);
    }

    private Seq<String> sanitizer(Config config) {
        Option<Sanitizer> option = config.compilerConfig().sanitizer();
        if (option instanceof Some) {
            Some some = (Some)option;
            Sanitizer sanitizer = (Sanitizer)some.value();
            return (Seq)new .colon.colon((Object)new StringBuilder(11).append("-fsanitize=").append(sanitizer.name()).toString(), (List)new .colon.colon((Object)"-fno-omit-frame-pointer", (List)Nil$.MODULE$));
        }
        return (Seq)Nil$.MODULE$;
    }

    private Seq<String> target(Config config) {
        Option<String> option = config.compilerConfig().targetTriple();
        if (option instanceof Some) {
            Some some = (Some)option;
            String tt = (String)some.value();
            return (Seq)new .colon.colon((Object)"-target", (List)new .colon.colon((Object)tt, (List)Nil$.MODULE$));
        }
        if (None$.MODULE$.equals(option)) {
            return (Seq)new .colon.colon((Object)"-Wno-override-module", (List)Nil$.MODULE$);
        }
        throw new MatchError(option);
    }

    private String opt(Config config) {
        Mode mode = config.mode();
        if (Mode$Debug$.MODULE$.equals(mode)) {
            return "-O0";
        }
        if (Mode$ReleaseFast$.MODULE$.equals(mode)) {
            return "-O2";
        }
        if (Mode$ReleaseSize$.MODULE$.equals(mode)) {
            return "-Oz";
        }
        if (Mode$ReleaseFull$.MODULE$.equals(mode)) {
            return "-O3";
        }
        throw new MatchError((Object)mode);
    }

    private Seq<String> llvmIrFeatures(Config config) {
        List opaquePointers = (List)Discover$features$.MODULE$.opaquePointers(LLVM$.nativeConfig$1(config)).requiredFlag().toList().flatMap((Function1 & java.io.Serializable & Serializable)x$8 -> (Seq)new .colon.colon((Object)"-mllvm", (List)new .colon.colon(x$8, (List)Nil$.MODULE$)), List$.MODULE$.canBuildFrom());
        return opaquePointers;
    }

    private Seq<String> buildTargetCompileOpts(Config config) {
        BuildTarget buildTarget = config.compilerConfig().buildTarget();
        if (BuildTarget$Application$.MODULE$.equals(buildTarget)) {
            return Nil$.MODULE$;
        }
        if (BuildTarget$LibraryStatic$.MODULE$.equals(buildTarget)) {
            return (Seq)this.optionalPICflag(config).$plus$plus((GenTraversableOnce)new .colon.colon((Object)"--emit-static-lib", (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom());
        }
        if (BuildTarget$LibraryDynamic$.MODULE$.equals(buildTarget)) {
            return (Seq)this.optionalPICflag(config).$colon$plus((Object)"-DSCALANATIVE_DYLIB", Seq$.MODULE$.canBuildFrom());
        }
        throw new MatchError((Object)buildTarget);
    }

    private Seq<String> buildTargetLinkOpts(Config config) {
        Nil$ optRdynamic = config.targetsWindows() ? Nil$.MODULE$ : (Seq)new .colon.colon((Object)"-rdynamic", (List)Nil$.MODULE$);
        BuildTarget buildTarget = config.compilerConfig().buildTarget();
        if (BuildTarget$Application$.MODULE$.equals(buildTarget)) {
            return optRdynamic;
        }
        if (BuildTarget$LibraryStatic$.MODULE$.equals(buildTarget)) {
            return (Seq)this.optionalPICflag(config).$plus$plus((GenTraversableOnce)new .colon.colon((Object)"--emit-static-lib", (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom());
        }
        if (BuildTarget$LibraryDynamic$.MODULE$.equals(buildTarget)) {
            String libFlag = config.targetsMac() ? "-dynamiclib" : "-shared";
            return (Seq)((TraversableLike)((TraversableLike)new .colon.colon((Object)libFlag, (List)Nil$.MODULE$)).$plus$plus(this.optionalPICflag(config), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)optRdynamic, Seq$.MODULE$.canBuildFrom());
        }
        throw new MatchError((Object)buildTarget);
    }

    private Seq<String> optionalPICflag(Config config) {
        if (config.targetsWindows()) {
            return Nil$.MODULE$;
        }
        return (Seq)new .colon.colon((Object)"-fPIC", (List)Nil$.MODULE$);
    }

    private String escapeWhitespaces(String str) {
        if (new StringOps(Predef$.MODULE$.augmentString(str)).exists((Function1 & java.io.Serializable & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)RichChar$.MODULE$.isWhitespace$extension(Predef$.MODULE$.charWrapper(BoxesRunTime.unboxToChar((Object)x$9)))))) {
            return new StringBuilder(2).append("\"").append(str).append("\"").toString();
        }
        return str;
    }

    private Seq<String> msysExtras$lzycompute() {
        LLVM$ lLVM$ = this;
        synchronized (lLVM$) {
            if (!this.bitmap$0) {
                this.msysExtras = (Seq)new .colon.colon((Object)"-D_WIN64", (List)new .colon.colon((Object)"-D__MINGW64__", (List)new .colon.colon((Object)"-D_X86_64_ -D__X86_64__ -D__x86_64", (List)new .colon.colon((Object)"-D__USING_SJLJ_EXCEPTIONS__", (List)new .colon.colon((Object)"-DNO_OLDNAMES", (List)new .colon.colon((Object)"-D_LIBUNWIND_BUILD_ZERO_COST_APIS", (List)Nil$.MODULE$))))));
                this.bitmap$0 = true;
            }
        }
        return this.msysExtras;
    }

    public Seq<String> msysExtras() {
        if (!this.bitmap$0) {
            return this.msysExtras$lzycompute();
        }
        return this.msysExtras;
    }

    private static final Seq stageFiles$1(Seq objectPaths$1, Path workDir$1) {
        return (Seq)objectPaths$1.map((Function1 & java.io.Serializable & Serializable)path -> {
            String uniqueName = ((Object)workDir$1.relativize((Path)path)).toString().replace(File.separator, "_");
            Path newPath = workDir$1.resolve(uniqueName);
            Files.move(path, newPath, StandardCopyOption.REPLACE_EXISTING);
            return IO$RichPath$.MODULE$.abs$extension(IO$.MODULE$.RichPath(newPath));
        }, Seq$.MODULE$.canBuildFrom());
    }

    private final ProcessBuilder useMRIScript$1(Path ar, Path workDir$1, Config config$3, Seq objectPaths$1) {
        File MIRScriptFile = workDir$1.resolve("MIRScript").toFile();
        try (PrintWriter pw = new PrintWriter(MIRScriptFile);){
            pw.println(new StringBuilder(7).append("CREATE ").append(this.escapeWhitespaces(IO$RichPath$.MODULE$.abs$extension(IO$.MODULE$.RichPath(config$3.buildPath())))).toString());
            LLVM$.stageFiles$1(objectPaths$1, workDir$1).foreach((Function1 & java.io.Serializable & Serializable)path -> {
                pw.println(new StringBuilder(7).append("ADDMOD ").append(LLVM$.MODULE$.escapeWhitespaces(path)).toString());
                return BoxedUnit.UNIT;
            });
            pw.println("SAVE");
            pw.println("END");
        }
        Seq command = (Seq)new .colon.colon((Object)IO$RichPath$.MODULE$.abs$extension(IO$.MODULE$.RichPath(ar)), (List)new .colon.colon((Object)"-M", (List)Nil$.MODULE$));
        config$3.logger().running((Seq<String>)command);
        return Process$.MODULE$.apply(command, config$3.workDir().toFile(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0])).$hash$less(MIRScriptFile);
    }

    public static final /* synthetic */ long $anonfun$needsLinking$1(Path x$7) {
        return x$7.toFile().lastModified();
    }

    private static final NativeConfig nativeConfig$1(Config config$4) {
        return config$4.compilerConfig();
    }

    private LLVM$() {
        MODULE$ = this;
        this.oExt = ".o";
        this.cppExt = ".cpp";
        this.llExt = ".ll";
        this.srcExtensions = (Seq)new .colon.colon((Object)".c", (List)new .colon.colon((Object)this.cppExt(), (List)new .colon.colon((Object)".S", (List)Nil$.MODULE$)));
    }
}

