/*
 * Decompiled with CFR 0.152.
 */
package scala.scalanative.build;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import scala.Function1;
import scala.MatchError;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Builder;
import scala.runtime.BoxedUnit;
import scala.scalanative.build.BuildException;
import scala.scalanative.build.BuildTarget;
import scala.scalanative.build.BuildTarget$Application$;
import scala.scalanative.build.Config;
import scala.scalanative.build.LTO;
import scala.scalanative.build.LTO$;
import scala.scalanative.build.NativeConfig;
import scala.scalanative.build.NativeLib$;

public final class Validator$ {
    public static Validator$ MODULE$;

    static {
        new Validator$();
    }

    public Config validate(Config config2) {
        return (Config)((Function1 & java.io.Serializable & Serializable)(Function1 & java.io.Serializable & Serializable)config -> MODULE$.validateMainClass((Config)config)).andThen((Function1 & java.io.Serializable & Serializable)config -> MODULE$.validateClasspath((Config)config)).andThen((Function1 & java.io.Serializable & Serializable)config -> MODULE$.validateCompileConfig((Config)config)).apply((Object)config2);
    }

    private Config validateMainClass(Config config) {
        NativeConfig nativeConfig = config.compilerConfig();
        BuildTarget buildTarget = nativeConfig.buildTarget();
        if (BuildTarget$Application$.MODULE$.equals(buildTarget)) {
            if (config.mainClass().isEmpty()) {
                throw new BuildException("No main class detected with Application selected.");
            }
        } else if (buildTarget instanceof BuildTarget.Library) {
        } else {
            throw new MatchError((Object)buildTarget);
        }
        return config;
    }

    private Config validateClasspath(Config config) {
        Seq<Path> fclasspath = NativeLib$.MODULE$.filterClasspath(config.classPath());
        return config.withClassPath(fclasspath);
    }

    private Config validateCompileConfig(Config config) {
        List list;
        NativeConfig c = config.compilerConfig();
        Builder issues = List$.MODULE$.newBuilder();
        Object object = !Files.exists(c.clang(), new LinkOption[0]) ? issues.$plus$eq((Object)new StringBuilder(136).append("Provided clang path '").append(c.clang().toAbsolutePath()).append("' does not exist, specify a valid path to LLVM Toolchain distribution using config or LLVM_BIN environment variable").toString()) : BoxedUnit.UNIT;
        Object object2 = !Files.exists(c.clangPP(), new LinkOption[0]) ? issues.$plus$eq((Object)new StringBuilder(138).append("Provided clang++ path '").append(c.clangPP().toAbsolutePath()).append("' does not exist, specify a valid path to LLVM Toolchain distribution using config or LLVM_BIN environment variable").toString()) : BoxedUnit.UNIT;
        Object object3 = config.baseName().trim().isEmpty() ? issues.$plus$eq((Object)"Provided baseName is blank, provide a name of target artifact without extensions to allow for determinstic builds") : BoxedUnit.UNIT;
        if (config.targetsMac()) {
            LTO lTO = c.lto();
            LTO lTO2 = LTO$.MODULE$.thin();
            if (!(lTO != null ? !lTO.equals(lTO2) : lTO2 != null)) {
                Validator$.warn$1("LTO.thin is unstable on MacOS, it can lead to compilation errors. Consider using LTO.full (legacy, slower) or LTO.none (disabled)", config);
            }
        }
        if (Nil$.MODULE$.equals(list = (List)issues.result())) {
            return config;
        }
        String string = new StringBuilder(43).append("Found ").append(list.size()).append(" issue within provided confguration: ").toString();
        throw new BuildException(list.$colon$colon((Object)string).mkString("\n  - "));
    }

    private static final void warn$1(String msg, Config config$1) {
        config$1.logger().warn(msg);
    }

    private Validator$() {
        MODULE$ = this;
    }
}

