/*
 * Decompiled with CFR 0.152.
 */
package scala.scalanative.build.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import scala.Function1;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.function.JProcedure1;
import scala.scalanative.build.core.IO$RichPath$;
import scala.scalanative.build.core.IO$RichString$;

public final class IO$
implements Serializable {
    public static final IO$RichPath$ RichPath;
    public static final IO$RichString$ RichString;
    public static final IO$ MODULE$;

    private IO$() {
    }

    static {
        MODULE$ = new IO$();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(IO$.class);
    }

    public final Path RichPath(Path path) {
        return path;
    }

    public final String RichString(String s) {
        return s;
    }

    public void write(Path file, byte[] bytes) {
        Files.createDirectories(file.getParent(), new FileAttribute[0]);
        Files.write(file, bytes, new OpenOption[0]);
    }

    public Seq<Path> getAll(Path base, String pattern) {
        ArrayBuffer out = ArrayBuffer$.MODULE$.empty();
        PathMatcher matcher = FileSystems.getDefault().getPathMatcher(pattern);
        SimpleFileVisitor<Path> visitor = new SimpleFileVisitor<Path>(out, matcher){
            private final ArrayBuffer out$1;
            private final PathMatcher matcher$1;
            {
                this.out$1 = out$3;
                this.matcher$1 = matcher$3;
            }

            public FileVisitResult preVisitDirectory(Path directory, BasicFileAttributes attributes) {
                return FileVisitResult.CONTINUE;
            }

            public FileVisitResult postVisitDirectory(Path directory, IOException exception) {
                return FileVisitResult.CONTINUE;
            }

            public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) {
                if (this.matcher$1.matches(file)) {
                    this.out$1.$plus$eq((Object)file);
                }
                return FileVisitResult.CONTINUE;
            }

            public FileVisitResult visitFileFailed(Path file, IOException exception) {
                return FileVisitResult.CONTINUE;
            }
        };
        Files.walkFileTree(base, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)visitor);
        return out.toSeq();
    }

    public boolean existsInDir(Path base, String pattern) {
        BooleanRef out = BooleanRef.create((boolean)false);
        PathMatcher matcher = FileSystems.getDefault().getPathMatcher(pattern);
        SimpleFileVisitor<Path> visitor = new SimpleFileVisitor<Path>(out, matcher){
            private final BooleanRef out$2;
            private final PathMatcher matcher$2;
            {
                this.out$2 = out$4;
                this.matcher$2 = matcher$4;
            }

            public FileVisitResult preVisitDirectory(Path directory, BasicFileAttributes attributes) {
                return FileVisitResult.CONTINUE;
            }

            public FileVisitResult postVisitDirectory(Path directory, IOException exception) {
                return FileVisitResult.CONTINUE;
            }

            public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) {
                FileVisitResult fileVisitResult;
                if (this.matcher$2.matches(file)) {
                    boolean bl;
                    this.out$2.elem = bl = true;
                    fileVisitResult = FileVisitResult.TERMINATE;
                } else {
                    fileVisitResult = FileVisitResult.CONTINUE;
                }
                return fileVisitResult;
            }

            public FileVisitResult visitFileFailed(Path file, IOException exception) {
                return FileVisitResult.CONTINUE;
            }
        };
        Files.walkFileTree(base, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)visitor);
        return out.elem;
    }

    public boolean existsInJar(Path path, Function1<String, Object> matcher) {
        ZipFile zf = new ZipFile(path.toFile());
        Enumeration<? extends ZipEntry> it = zf.entries();
        while (it.hasMoreElements()) {
            if (!BoxesRunTime.unboxToBoolean((Object)matcher.apply((Object)it.nextElement().getName()))) continue;
            return true;
        }
        return false;
    }

    public void deleteRecursive(Path directory) {
        if (Files.exists(directory, new LinkOption[0])) {
            Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    public byte[] sha1(Path path, int bufSize) {
        byte[] byArray;
        MessageDigest digest = MessageDigest.getInstance("SHA-1");
        InputStream stream = Files.newInputStream(path, new OpenOption[0]);
        try (DigestInputStream digestStream = new DigestInputStream(stream, digest);){
            byte[] buf = new byte[bufSize];
            while (digestStream.read(buf, 0, bufSize) != -1) {
            }
            byArray = digest.digest();
        }
        return byArray;
    }

    public int sha1$default$2() {
        return 1024;
    }

    public byte[] sha1files(Seq<Path> files, int bufSize) {
        MessageDigest digest = MessageDigest.getInstance("SHA-1");
        files.foreach((Function1)(JProcedure1 & Serializable)file -> {
            InputStream stream = Files.newInputStream(file, new OpenOption[0]);
            byte[] buf = new byte[bufSize];
            try (DigestInputStream digestStream = new DigestInputStream(stream, digest);){
                while (digestStream.read(buf, 0, bufSize) != -1) {
                }
            }
        });
        return digest.digest();
    }

    public int sha1files$default$2() {
        return 1024;
    }

    public void unzip(Path archive, Path target) {
        Files.createDirectories(target, new FileAttribute[0]);
        try (FileSystem zipFS = FileSystems.newFileSystem(archive, null);){
            for (Path root : zipFS.getRootDirectories()) {
                this.copyRecursive(root, target);
            }
        }
    }

    public void copyDirectory(Path source, Path target) {
        Files.createDirectories(target, new FileAttribute[0]);
        this.copyRecursive(source, target);
    }

    private Path copyRecursive(Path source, Path target) {
        return Files.walkFileTree(source, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(source, target){
            private final Path source$1;
            private final Path target$1;
            {
                this.source$1 = source$2;
                this.target$1 = target$2;
            }

            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                Path dest = Paths.get(this.target$1.toString(), this.source$1.relativize(file).toString());
                Files.copy(file, dest, StandardCopyOption.REPLACE_EXISTING);
                return FileVisitResult.CONTINUE;
            }

            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                Path dest = Paths.get(this.target$1.toString(), this.source$1.relativize(dir).toString());
                Files.createDirectories(dest, new FileAttribute[0]);
                return FileVisitResult.CONTINUE;
            }
        });
    }
}

