/*
 * Decompiled with CFR 0.152.
 */
package scala.scalanative.build.core;

import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.NameTransformer$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;
import scala.runtime.function.JProcedure1;
import scala.scalanative.build.BuildException;
import scala.scalanative.build.Config;
import scala.scalanative.build.LLVM$;
import scala.scalanative.build.core.IO$;
import scala.scalanative.checker.Check;
import scala.scalanative.checker.Check$;
import scala.scalanative.codegen.CodeGen$;
import scala.scalanative.interflow.Interflow$;
import scala.scalanative.linker.Link$;
import scala.scalanative.linker.Result;
import scala.scalanative.nir.Defn;
import scala.scalanative.nir.Global;
import scala.scalanative.nir.Rt$;
import scala.scalanative.nir.Show$;
import scala.scalanative.nir.Sig;
import scala.scalanative.util.Scope;

public final class ScalaNative$
implements Serializable {
    public static final ScalaNative$ MODULE$ = new ScalaNative$();

    private ScalaNative$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ScalaNative$.class);
    }

    public Seq<Global> entries(Config config) {
        Option entry = this.encodedMainClass(config).map((Function1 & Serializable)_$1 -> _$1.member((Sig.Unmangled)Rt$.MODULE$.ScalaMainSig()));
        Seq dependencies = (Seq)CodeGen$.MODULE$.depends().$plus$plus(Interflow$.MODULE$.depends());
        return (Seq)dependencies.$plus$plus$colon((IterableOnce)entry);
    }

    public Result link(Config config, Seq<Global> entries, Scope scope) {
        return this.dump(config, "linked", this.check(config, true, (Result)config.logger().time("Linking", () -> this.link$$anonfun$1(config, entries, scope))));
    }

    public void logLinked(Config config, Result linked) {
        if (linked.unavailable().nonEmpty()) {
            throw this.showLinkingErrors$1(config, linked);
        }
        this.showStats$1(config, linked);
    }

    public Result optimize(Config config, Result linked) {
        return this.dump(config, "optimized", this.check(config, config.compilerConfig().optimize() ? (Result)config.logger().time(new StringBuilder(18).append("Optimizing (").append(config.mode()).append(" mode)").toString(), () -> this.optimize$$anonfun$1(config, linked)) : (Result)config.logger().time("Optimizing (skipped)", () -> this.optimize$$anonfun$2(linked))));
    }

    /*
     * WARNING - void declaration
     */
    public Seq<Path> codegen(Config config, Result linked) {
        void var3_3;
        Seq llPaths = (Seq)config.logger().time("Generating intermediate code", () -> this.$anonfun$4(config, linked));
        config.logger().info(new StringBuilder(15).append("Produced ").append(llPaths.length()).append(" files").toString());
        return var3_3;
    }

    public Result check(Config config, Result linked) {
        return this.check(config, false, linked);
    }

    private Result check(Config config, boolean forceQuickCheck, Result linked) {
        String checkMode;
        boolean performFullCheck = config.check();
        String string = checkMode = performFullCheck ? "full" : "quick";
        if (config.check() || forceQuickCheck) {
            config.logger().time(new StringBuilder(29).append("Checking intermediate code (").append(checkMode).append(")").toString(), (Function0 & Serializable)() -> {
                this.check$$anonfun$1(config, linked, performFullCheck);
                return BoxedUnit.UNIT;
            });
        }
        return linked;
    }

    private void showErrors(Function1<String, BoxedUnit> log, boolean showContext, Seq<Check.Error> errors, Result linked) {
        errors.groupBy((Function1 & Serializable)_$6 -> _$6.name()).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Global name = (Global)tuple2._1();
                Seq errs = (Seq)tuple2._2();
                log.apply((Object)new StringBuilder(20).append("\nFound ").append(errs.length()).append(" errors on ").append(name.show()).append(" :").toString());
                if (showContext) {
                    linked.defns().collectFirst((PartialFunction)new Serializable(name){
                        private final Global name$1;
                        {
                            this.name$1 = name$2;
                        }

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final boolean isDefinedAt(Defn x) {
                            Defn defn = x;
                            Defn defn2 = defn;
                            if (defn2 == null) return false;
                            Global global = defn2.name();
                            Global global2 = this.name$1;
                            if (global != null) {
                                if (!global.equals(global2)) return false;
                                return true;
                            }
                            if (global2 == null) return true;
                            return false;
                        }

                        /*
                         * Enabled aggressive block sorting
                         */
                        public final Object applyOrElse(Defn x, Function1 function1) {
                            Object object;
                            Defn defn = x;
                            Defn defn2 = defn;
                            if (defn2 != null) {
                                Global global = defn2.name();
                                Global global2 = this.name$1;
                                if (!(global != null ? !global.equals(global2) : global2 != null)) {
                                    object = defn2;
                                    return object;
                                }
                            }
                            object = function1.apply((Object)x);
                            return object;
                        }
                    }).foreach((Function1)(JProcedure1 & Serializable)defn -> {
                        String str = defn.show();
                        Object[] lines = str.split("\n");
                        Object object = Predef$.MODULE$.refArrayOps(lines);
                        Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(object));
                        ArrayOps$.MODULE$.foreach$extension(object2, (Function1)(JProcedure1 & Serializable)x$1 -> {
                            Tuple2 tuple2 = x$1;
                            if (tuple2 == null) {
                                throw new MatchError((Object)tuple2);
                            }
                            String line = (String)tuple2._1();
                            int idx = BoxesRunTime.unboxToInt((Object)tuple2._2());
                            log.apply((Object)new StringBuilder(0).append(String.format("  %04d  ", idx)).append(line).toString());
                        });
                    });
                    log.apply((Object)"");
                    errs.foreach((Function1)(JProcedure1 & Serializable)err -> {
                        log.apply((Object)new StringBuilder(8).append("  in ").append(err.ctx().reverse().mkString(" / ")).append(" : ").toString());
                        this.showError$1(log, (Check.Error)err);
                    });
                } else {
                    errs.foreach((Function1)(JProcedure1 & Serializable)err -> this.showError$1(log, (Check.Error)err));
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
        });
        log.apply((Object)new StringBuilder(14).append("\n").append(errors.size()).append(" errors found").toString());
    }

    public Result dump(Config config, String phase, Result linked) {
        this.dumpDefns(config, phase, linked.defns());
        return linked;
    }

    public void dumpDefns(Config config, String phase, Seq<Defn> defns) {
        if (config.dump()) {
            config.logger().time(new StringBuilder(28).append("Dumping intermediate code (").append(phase).append(")").toString(), (Function0 & Serializable)() -> {
                this.dumpDefns$$anonfun$1(config, phase, defns);
                return BoxedUnit.UNIT;
            });
        }
    }

    public Option<Global.Top> encodedMainClass(Config config) {
        return config.selectedMainClass().map((Function1 & Serializable)mainClass -> {
            Object object = Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(mainClass), '.'));
            String encoded = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)name -> NameTransformer$.MODULE$.encode(name), ClassTag$.MODULE$.apply(String.class))).mkString(".");
            return Global.Top$.MODULE$.apply(encoded);
        });
    }

    public Seq<Path> genBuildInfo(Config config) {
        return LLVM$.MODULE$.generateLLVMIdent(config);
    }

    private final Result link$$anonfun$1(Config config$1, Seq entries$1, Scope scope$1) {
        return Link$.MODULE$.apply(config$1, (Seq<Global>)entries$1, scope$1);
    }

    private final Nothing$ showLinkingErrors$1(Config config$2, Result linked$1) {
        config$2.logger().error("missing symbols:");
        ((IterableOnceOps)linked$1.unavailable().sortBy((Function1 & Serializable)_$2 -> _$2.show(), (Ordering)Ordering.String$.MODULE$)).foreach((Function1)(JProcedure1 & Serializable)name -> {
            config$2.logger().error(new StringBuilder(2).append("* ").append(name.mangle()).toString());
            Map<Global, Global> from = linked$1.referencedFrom();
            Global current = (Global)from.apply(name);
            while (from.contains((Object)current)) {
                Global global = current;
                Global.None$ none$ = Global.None$.MODULE$;
                if (!(global == null ? none$ != null : !global.equals(none$))) break;
                config$2.logger().error(new StringBuilder(9).append("  - from ").append(current.mangle()).toString());
                current = (Global)from.apply((Object)current);
            }
        });
        throw new BuildException("unable to link");
    }

    private final void showStats$1(Config config$4, Result linked$3) {
        int classCount = linked$3.defns().count((Function1 & Serializable)x$1 -> {
            Defn defn = x$1;
            return defn instanceof Defn.Class || defn instanceof Defn.Module;
        });
        int methodCount = linked$3.defns().count((Function1 & Serializable)_$3 -> _$3 instanceof Defn.Define);
        config$4.logger().info(new StringBuilder(32).append("Discovered ").append(classCount).append(" classes and ").append(methodCount).append(" methods").toString());
    }

    private final Result optimize$$anonfun$1(Config config$5, Result linked$4) {
        Seq<Defn> optimized = Interflow$.MODULE$.apply(config$5, linked$4);
        return Link$.MODULE$.apply(config$5, linked$4.entries(), optimized);
    }

    private final Result optimize$$anonfun$2(Result linked$5) {
        return linked$5;
    }

    private final Seq $anonfun$4(Config config$6, Result linked$6) {
        IO$.MODULE$.getAll(config$6.workdir(), "glob:**.ll").foreach((Function1)(JProcedure1 & Serializable)x$0 -> Files.delete(x$0));
        return CodeGen$.MODULE$.apply(config$6, linked$6);
    }

    private final void check$$anonfun$1(Config config$7, Result linked$7, boolean performFullCheck$1) {
        Seq<Check.Error> errors;
        boolean fatalWarnings = config$7.compilerConfig().checkFatalWarnings();
        Seq<Check.Error> seq = errors = performFullCheck$1 ? Check$.MODULE$.apply(linked$7) : Check$.MODULE$.quick(linked$7);
        if (errors.nonEmpty()) {
            this.showErrors((Function1<String, BoxedUnit>)(fatalWarnings ? (JProcedure1 & Serializable)_$4 -> config$7.logger().error((String)_$4) : (JProcedure1 & Serializable)_$5 -> config$7.logger().warn((String)_$5)), performFullCheck$1, errors, linked$7);
            if (fatalWarnings) {
                throw new BuildException("Fatal warning(s) found; see the error output for details.");
            }
        }
    }

    private final void showError$1(Function1 log$2, Check.Error err) {
        log$2.apply((Object)new StringBuilder(4).append("    ").append(err.msg()).toString());
    }

    private final void dumpDefns$$anonfun$1(Config config$10, String phase$1, Seq defns$1) {
        Path path = config$10.workdir().resolve(new StringBuilder(5).append(phase$1).append(".hnir").toString());
        Show$.MODULE$.dump(defns$1, path.toFile().getAbsolutePath());
    }
}

