/*
 * Decompiled with CFR 0.152.
 */
package scala.scalanative.build;

import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import scala.Function1;
import scala.MatchError;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Builder;
import scala.package$;
import scala.runtime.ModuleSerializationProxy;
import scala.scalanative.build.BuildException;
import scala.scalanative.build.BuildTarget;
import scala.scalanative.build.BuildTarget$Application$;
import scala.scalanative.build.Config;
import scala.scalanative.build.LTO;
import scala.scalanative.build.LTO$;
import scala.scalanative.build.NativeConfig;
import scala.scalanative.build.NativeLib$;

public final class Validator$
implements Serializable {
    public static final Validator$ MODULE$ = new Validator$();

    private Validator$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Validator$.class);
    }

    public Config validate(Config config2) {
        return (Config)((Function1 & Serializable)(Function1 & Serializable)config -> this.validateMainClass((Config)config)).andThen((Function1 & Serializable)config -> this.validateClasspath((Config)config)).andThen((Function1 & Serializable)config -> this.validateCompileConfig((Config)config)).apply((Object)config2);
    }

    private Config validateMainClass(Config config) {
        NativeConfig nativeConfig = config.compilerConfig();
        BuildTarget buildTarget = nativeConfig.buildTarget();
        if (BuildTarget$Application$.MODULE$.equals(buildTarget)) {
            if (config.mainClass().isEmpty()) {
                throw new BuildException("No main class detected with Application selected.");
            }
        } else if (!(buildTarget instanceof BuildTarget.Library)) {
            throw new MatchError((Object)buildTarget);
        }
        return config;
    }

    private Config validateClasspath(Config config) {
        Seq<Path> fclasspath = NativeLib$.MODULE$.filterClasspath(config.classPath());
        return config.withClassPath(fclasspath);
    }

    private Config validateCompileConfig(Config config) {
        block9: {
            List list;
            block10: {
                List list2;
                Nil$ nil$;
                block8: {
                    NativeConfig c = config.compilerConfig();
                    Builder issues = package$.MODULE$.List().newBuilder();
                    if (!Files.exists(c.clang(), new LinkOption[0])) {
                        issues.$plus$eq((Object)new StringBuilder(136).append("Provided clang path '").append(c.clang().toAbsolutePath()).append("' does not exist, specify a valid path to LLVM Toolchain distribution using config or LLVM_BIN environment variable").toString());
                    }
                    if (!Files.exists(c.clangPP(), new LinkOption[0])) {
                        issues.$plus$eq((Object)new StringBuilder(138).append("Provided clang++ path '").append(c.clangPP().toAbsolutePath()).append("' does not exist, specify a valid path to LLVM Toolchain distribution using config or LLVM_BIN environment variable").toString());
                    }
                    if (config.baseName().trim().isEmpty()) {
                        issues.$plus$eq((Object)"Provided baseName is blank, provide a name of target artifact without extensions to allow for determinstic builds");
                    }
                    if (config.targetsMac()) {
                        LTO lTO = c.lto();
                        LTO lTO2 = LTO$.MODULE$.thin();
                        if (!(lTO != null ? !lTO.equals(lTO2) : lTO2 != null)) {
                            this.warn$1(config, "LTO.thin is unstable on MacOS, it can lead to compilation errors. Consider using LTO.full (legacy, slower) or LTO.none (disabled)");
                        }
                    }
                    list = (List)issues.result();
                    nil$ = package$.MODULE$.Nil();
                    list2 = list;
                    if (nil$ != null) break block8;
                    if (list2 == null) break block9;
                    break block10;
                }
                if (nil$.equals(list2)) break block9;
            }
            List issues = list;
            String string = new StringBuilder(43).append("Found ").append(issues.size()).append(" issue within provided confguration: ").toString();
            throw new BuildException(issues.$colon$colon((Object)string).mkString("\n  - "));
        }
        return config;
    }

    private final void warn$1(Config config$1, String msg) {
        config$1.logger().warn(msg);
    }
}

