/*
 * Decompiled with CFR 0.152.
 */
package com.google.ical.compat.javautil;

import com.google.ical.compat.javautil.DateIterable;
import com.google.ical.compat.javautil.DateIterator;
import com.google.ical.iter.RecurrenceIterable;
import com.google.ical.iter.RecurrenceIterator;
import com.google.ical.iter.RecurrenceIteratorFactory;
import com.google.ical.util.TimeUtils;
import com.google.ical.values.DateTimeValueImpl;
import com.google.ical.values.DateValue;
import com.google.ical.values.DateValueImpl;
import com.google.ical.values.TimeValue;
import java.text.ParseException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class DateIteratorFactory {
    public static DateIterator createDateIterator(String string, Date date, TimeZone timeZone, boolean bl) throws ParseException {
        return new RecurrenceIteratorWrapper(RecurrenceIteratorFactory.createRecurrenceIterator(string, DateIteratorFactory.dateToDateValue(date, true), timeZone, bl));
    }

    public static DateIterable createDateIterable(String string, Date date, TimeZone timeZone, boolean bl) throws ParseException {
        return new RecurrenceIterableWrapper(RecurrenceIteratorFactory.createRecurrenceIterable(string, DateIteratorFactory.dateToDateValue(date, true), timeZone, bl));
    }

    public static DateIterator createDateIterator(RecurrenceIterator recurrenceIterator) {
        return new RecurrenceIteratorWrapper(recurrenceIterator);
    }

    static Date dateValueToDate(DateValue dateValue) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeUtils.utcTimezone());
        gregorianCalendar.clear();
        if (dateValue instanceof TimeValue) {
            TimeValue timeValue = (TimeValue)((Object)dateValue);
            gregorianCalendar.set(dateValue.year(), dateValue.month() - 1, dateValue.day(), timeValue.hour(), timeValue.minute(), timeValue.second());
        } else {
            gregorianCalendar.set(dateValue.year(), dateValue.month() - 1, dateValue.day(), 0, 0, 0);
        }
        return gregorianCalendar.getTime();
    }

    static DateValue dateToDateValue(Date date, boolean bl) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeUtils.utcTimezone());
        gregorianCalendar.setTime(date);
        int n = gregorianCalendar.get(11);
        int n2 = gregorianCalendar.get(12);
        int n3 = gregorianCalendar.get(13);
        if (bl && 0 == (n | n2 | n3)) {
            return new DateValueImpl(gregorianCalendar.get(1), gregorianCalendar.get(2) + 1, gregorianCalendar.get(5));
        }
        return new DateTimeValueImpl(gregorianCalendar.get(1), gregorianCalendar.get(2) + 1, gregorianCalendar.get(5), n, n2, n3);
    }

    private DateIteratorFactory() {
    }

    private static final class RecurrenceIteratorWrapper
    implements DateIterator {
        private final RecurrenceIterator it;

        RecurrenceIteratorWrapper(RecurrenceIterator recurrenceIterator) {
            this.it = recurrenceIterator;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public Date next() {
            return DateIteratorFactory.dateValueToDate(this.it.next());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void advanceTo(Date date) {
            this.it.advanceTo(DateIteratorFactory.dateToDateValue(date, true));
        }
    }

    private static final class RecurrenceIterableWrapper
    implements DateIterable {
        private final RecurrenceIterable it;

        public RecurrenceIterableWrapper(RecurrenceIterable recurrenceIterable) {
            this.it = recurrenceIterable;
        }

        @Override
        public DateIterator iterator() {
            return new RecurrenceIteratorWrapper(this.it.iterator());
        }
    }
}

