/*
 * Decompiled with CFR 0.152.
 */
package com.google.ical.compat.jodatime;

import com.google.ical.compat.jodatime.DateTimeIterable;
import com.google.ical.compat.jodatime.DateTimeIterator;
import com.google.ical.compat.jodatime.TimeZoneConverter;
import com.google.ical.iter.RecurrenceIterable;
import com.google.ical.iter.RecurrenceIterator;
import com.google.ical.iter.RecurrenceIteratorFactory;
import com.google.ical.values.DateTimeValueImpl;
import com.google.ical.values.DateValue;
import com.google.ical.values.TimeValue;
import java.text.ParseException;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableDateTime;

public class DateTimeIteratorFactory {
    public static DateTimeIterator createDateTimeIterator(String string, ReadableDateTime readableDateTime, DateTimeZone dateTimeZone, boolean bl) throws ParseException {
        return new RecurrenceIteratorWrapper(RecurrenceIteratorFactory.createRecurrenceIterator(string, DateTimeIteratorFactory.dateTimeToDateValue((ReadableDateTime)readableDateTime.toDateTime().withZone(dateTimeZone)), TimeZoneConverter.toTimeZone(dateTimeZone), bl));
    }

    public static DateTimeIterable createDateTimeIterable(String string, ReadableDateTime readableDateTime, DateTimeZone dateTimeZone, boolean bl) throws ParseException {
        return new RecurrenceIterableWrapper(RecurrenceIteratorFactory.createRecurrenceIterable(string, DateTimeIteratorFactory.dateTimeToDateValue((ReadableDateTime)readableDateTime.toDateTime().withZone(dateTimeZone)), TimeZoneConverter.toTimeZone(dateTimeZone), bl));
    }

    public static DateTimeIterator createDateTimeIterator(RecurrenceIterator recurrenceIterator) {
        return new RecurrenceIteratorWrapper(recurrenceIterator);
    }

    static DateTime dateValueToDateTime(DateValue dateValue) {
        if (dateValue instanceof TimeValue) {
            TimeValue timeValue = (TimeValue)((Object)dateValue);
            return new DateTime(dateValue.year(), dateValue.month(), dateValue.day(), timeValue.hour(), timeValue.minute(), timeValue.second(), 0, DateTimeZone.UTC);
        }
        return new DateTime(dateValue.year(), dateValue.month(), dateValue.day(), 0, 0, 0, 0, DateTimeZone.UTC);
    }

    static DateValue dateTimeToDateValue(ReadableDateTime readableDateTime) {
        return new DateTimeValueImpl(readableDateTime.getYear(), readableDateTime.getMonthOfYear(), readableDateTime.getDayOfMonth(), readableDateTime.getHourOfDay(), readableDateTime.getMinuteOfHour(), readableDateTime.getSecondOfMinute());
    }

    private DateTimeIteratorFactory() {
    }

    private static final class RecurrenceIteratorWrapper
    implements DateTimeIterator {
        private final RecurrenceIterator it;

        RecurrenceIteratorWrapper(RecurrenceIterator recurrenceIterator) {
            this.it = recurrenceIterator;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public DateTime next() {
            return DateTimeIteratorFactory.dateValueToDateTime(this.it.next());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void advanceTo(ReadableDateTime readableDateTime) {
            DateTime dateTime = readableDateTime.toDateTime().withZone(DateTimeZone.UTC);
            this.it.advanceTo(DateTimeIteratorFactory.dateTimeToDateValue((ReadableDateTime)dateTime));
        }
    }

    private static final class RecurrenceIterableWrapper
    implements DateTimeIterable {
        private final RecurrenceIterable it;

        public RecurrenceIterableWrapper(RecurrenceIterable recurrenceIterable) {
            this.it = recurrenceIterable;
        }

        @Override
        public DateTimeIterator iterator() {
            return new RecurrenceIteratorWrapper(this.it.iterator());
        }
    }
}

