/*
 * Decompiled with CFR 0.152.
 */
package com.google.ical.compat.jodatime;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

final class TimeZoneConverter {
    static final int MILLISECONDS_PER_SECOND = 1000;
    static final int MILLISECONDS_PER_MINUTE = 60000;
    static final int MILLISECONDS_PER_HOUR = 3600000;
    private static final Pattern HOUR_MINUTE = Pattern.compile("^[+-]?[0-9]{1,2}:[0-9]{2}(:[0-9]{2})?$");
    private static final TimeZone UTC = new SimpleTimeZone(0, "UTC");
    private static final long MILLIS_SINCE_1_JAN_2000_UTC;

    public static TimeZone toTimeZone(final DateTimeZone dateTimeZone) {
        TimeZone timeZone = new TimeZone(){
            private static final long serialVersionUID = 58752546800455L;

            @Override
            public void setRawOffset(int n) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean useDaylightTime() {
                long l = MILLIS_SINCE_1_JAN_2000_UTC;
                return l != dateTimeZone.nextTransition(l);
            }

            @Override
            public boolean inDaylightTime(Date date) {
                long l = date.getTime();
                return dateTimeZone.getStandardOffset(l) != dateTimeZone.getOffset(l);
            }

            @Override
            public int getRawOffset() {
                return dateTimeZone.getStandardOffset(0L);
            }

            @Override
            public int getOffset(long l) {
                return dateTimeZone.getOffset(l);
            }

            @Override
            public int getOffset(int n, int n2, int n3, int n4, int n5, int n6) {
                GregorianCalendar gregorianCalendar;
                int n7 = n6;
                int n8 = n7 / 3600000;
                int n9 = (n7 %= 3600000) / 60000;
                int n10 = (n7 %= 60000) / 1000;
                n7 %= 1000;
                if (n == 0) {
                    n2 = -(n2 - 1);
                }
                DateTime dateTime = null;
                try {
                    dateTime = new DateTime(n2, n3 + 1, n4, n8, n9, n10, n7, dateTimeZone);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (n8 < 23) {
                        dateTime = new DateTime(n2, n3 + 1, n4, n8 + 1, n9, n10, n7, dateTimeZone);
                    }
                    gregorianCalendar = new GregorianCalendar();
                    gregorianCalendar.clear();
                    ((Calendar)gregorianCalendar).setTimeZone(TimeZone.getTimeZone("UTC"));
                    gregorianCalendar.set(n2, n3, n4, n8, n9, n10);
                    ((Calendar)gregorianCalendar).add(11, 1);
                    int n11 = gregorianCalendar.get(1);
                    int n12 = gregorianCalendar.get(2);
                    int n13 = gregorianCalendar.get(5);
                    int n14 = gregorianCalendar.get(11);
                    dateTime = new DateTime(n11, n12 + 1, n13, n14, n9, n10, n7, dateTimeZone);
                }
                int n15 = dateTimeZone.getStandardOffset(dateTime.getMillis());
                gregorianCalendar = new DateTime(n2, n3 + 1, n4, n8, n9, n10, n7, DateTimeZone.forOffsetMillis((int)n15));
                return this.getOffset(gregorianCalendar.getMillis());
            }

            public String toString() {
                return dateTimeZone.toString();
            }

            public boolean equals(Object object) {
                if (!(object instanceof TimeZone)) {
                    return false;
                }
                TimeZone timeZone = (TimeZone)object;
                return this.getID().equals(timeZone.getID()) && this.hasSameRules(timeZone);
            }

            public int hashCode() {
                return this.getID().hashCode();
            }
        };
        String string = TimeZoneConverter.cleanUpTzid(dateTimeZone.getID());
        timeZone.setID(string);
        return timeZone;
    }

    static String cleanUpTzid(String string) {
        Matcher matcher = HOUR_MINUTE.matcher(string);
        return matcher.matches() ? "GMT" + (string.startsWith("-") || string.startsWith("+") ? "" : "+") + string : string;
    }

    private TimeZoneConverter() {
    }

    static {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(UTC);
        gregorianCalendar.set(2000, 0, 1, 0, 0, 0);
        MILLIS_SINCE_1_JAN_2000_UTC = gregorianCalendar.getTimeInMillis();
    }
}

