/*
 * Decompiled with CFR 0.152.
 */
package com.google.ical.iter;

import com.google.ical.iter.Generator;
import com.google.ical.iter.IntSet;
import com.google.ical.iter.SingleValueGenerator;
import com.google.ical.iter.ThrottledGenerator;
import com.google.ical.iter.Util;
import com.google.ical.util.DTBuilder;
import com.google.ical.util.TimeUtils;
import com.google.ical.values.DateValue;
import com.google.ical.values.DateValueImpl;
import com.google.ical.values.TimeValue;
import com.google.ical.values.Weekday;
import com.google.ical.values.WeekdayNum;
import java.util.Arrays;

final class Generators {
    private static final int MAX_YEARS_BETWEEN_INSTANCES = 100;

    static ThrottledGenerator serialYearGenerator(final int n, final DateValue dateValue) {
        return new ThrottledGenerator(){
            int year;
            int throttle;
            {
                this.year = dateValue.year() - n;
                this.throttle = 100;
            }

            @Override
            boolean generate(DTBuilder dTBuilder) throws Generator.IteratorShortCircuitingException {
                if (--this.throttle < 0) {
                    throw Generator.IteratorShortCircuitingException.instance();
                }
                dTBuilder.year = this.year += n;
                return true;
            }

            @Override
            void workDone() {
                this.throttle = 100;
            }

            public String toString() {
                return "serialYearGenerator:" + n;
            }
        };
    }

    static Generator serialMonthGenerator(final int n, final DateValue dateValue) {
        return new Generator(){
            int year;
            int month;
            {
                this.year = dateValue.year();
                this.month = dateValue.month() - n;
                while (this.month < 1) {
                    this.month += 12;
                    --this.year;
                }
            }

            @Override
            boolean generate(DTBuilder dTBuilder) {
                int n3;
                if (this.year != dTBuilder.year) {
                    int n2 = (dTBuilder.year - this.year) * 12 - (this.month - 1);
                    n3 = (n - n2 % n) % n + 1;
                    if (n3 > 12) {
                        return false;
                    }
                    this.year = dTBuilder.year;
                } else {
                    n3 = this.month + n;
                    if (n3 > 12) {
                        return false;
                    }
                }
                this.month = dTBuilder.month = n3;
                return true;
            }

            public String toString() {
                return "serialMonthGenerator:" + n;
            }
        };
    }

    static Generator serialDayGenerator(final int n, final DateValue dateValue) {
        return new Generator(){
            int year;
            int month;
            int date;
            int nDays;
            {
                DTBuilder dTBuilder = new DTBuilder(dateValue);
                dTBuilder.day -= n;
                DateValue dateValue2 = dTBuilder.toDate();
                this.year = dateValue2.year();
                this.month = dateValue2.month();
                this.date = dateValue2.day();
                this.nDays = TimeUtils.monthLength(this.year, this.month);
            }

            @Override
            boolean generate(DTBuilder dTBuilder) {
                int n3;
                if (this.year == dTBuilder.year && this.month == dTBuilder.month) {
                    n3 = this.date + n;
                    if (n3 > this.nDays) {
                        return false;
                    }
                } else {
                    this.nDays = TimeUtils.monthLength(dTBuilder.year, dTBuilder.month);
                    if (n != 1) {
                        int n2 = TimeUtils.daysBetween(new DateValueImpl(dTBuilder.year, dTBuilder.month, 1), new DateValueImpl(this.year, this.month, this.date));
                        n3 = (n - n2 % n) % n + 1;
                        if (n3 > this.nDays) {
                            return false;
                        }
                    } else {
                        n3 = 1;
                    }
                    this.year = dTBuilder.year;
                    this.month = dTBuilder.month;
                }
                this.date = dTBuilder.day = n3;
                return true;
            }

            public String toString() {
                return "serialDayGenerator:" + n;
            }
        };
    }

    static Generator serialHourGenerator(final int n, final DateValue dateValue) {
        return new Generator(){
            int hour;
            int day;
            int month;
            int year;
            {
                this.hour = (dateValue instanceof TimeValue ? ((TimeValue)((Object)dateValue)).hour() : 0) - n;
                this.day = dateValue.day();
                this.month = dateValue.month();
                this.year = dateValue.year();
            }

            @Override
            boolean generate(DTBuilder dTBuilder) {
                int n3;
                if (this.day != dTBuilder.day || this.month != dTBuilder.month || this.year != dTBuilder.year) {
                    int n2 = Generators.daysBetween(dTBuilder, this.year, this.month, this.day) * 24 - this.hour;
                    n3 = (n - n2 % n) % n;
                    if (n3 > 23) {
                        return false;
                    }
                    this.day = dTBuilder.day;
                    this.month = dTBuilder.month;
                    this.year = dTBuilder.year;
                } else {
                    n3 = this.hour + n;
                    if (n3 > 23) {
                        return false;
                    }
                }
                this.hour = dTBuilder.hour = n3;
                return true;
            }

            public String toString() {
                return "serialHourGenerator:" + n;
            }
        };
    }

    static Generator serialMinuteGenerator(final int n, final DateValue dateValue) {
        return new Generator(){
            int minute;
            int hour;
            int day;
            int month;
            int year;
            {
                this.minute = (dateValue instanceof TimeValue ? ((TimeValue)((Object)dateValue)).minute() : 0) - n;
                this.hour = dateValue instanceof TimeValue ? ((TimeValue)((Object)dateValue)).hour() : 0;
                this.day = dateValue.day();
                this.month = dateValue.month();
                this.year = dateValue.year();
            }

            @Override
            boolean generate(DTBuilder dTBuilder) {
                int n3;
                if (this.hour != dTBuilder.hour || this.day != dTBuilder.day || this.month != dTBuilder.month || this.year != dTBuilder.year) {
                    int n2 = (Generators.daysBetween(dTBuilder, this.year, this.month, this.day) * 24 + dTBuilder.hour - this.hour) * 60 - this.minute;
                    n3 = (n - n2 % n) % n;
                    if (n3 > 59) {
                        return false;
                    }
                    this.hour = dTBuilder.hour;
                    this.day = dTBuilder.day;
                    this.month = dTBuilder.month;
                    this.year = dTBuilder.year;
                } else {
                    n3 = this.minute + n;
                    if (n3 > 59) {
                        return false;
                    }
                }
                this.minute = dTBuilder.minute = n3;
                return true;
            }

            public String toString() {
                return "serialMinuteGenerator:" + n;
            }
        };
    }

    static Generator serialSecondGenerator(final int n, final DateValue dateValue) {
        return new Generator(){
            int second;
            int minute;
            int hour;
            int day;
            int month;
            int year;
            {
                this.second = (dateValue instanceof TimeValue ? ((TimeValue)((Object)dateValue)).second() : 0) - n;
                this.minute = dateValue instanceof TimeValue ? ((TimeValue)((Object)dateValue)).minute() : 0;
                this.hour = dateValue instanceof TimeValue ? ((TimeValue)((Object)dateValue)).hour() : 0;
                this.day = dateValue.day();
                this.month = dateValue.month();
                this.year = dateValue.year();
            }

            @Override
            boolean generate(DTBuilder dTBuilder) {
                int n3;
                if (this.minute != dTBuilder.minute || this.hour != dTBuilder.hour || this.day != dTBuilder.day || this.month != dTBuilder.month || this.year != dTBuilder.year) {
                    int n2 = ((Generators.daysBetween(dTBuilder, this.year, this.month, this.day) * 24 + dTBuilder.hour - this.hour) * 60 + dTBuilder.minute - this.minute) * 60 - this.second;
                    n3 = (n - n2 % n) % n;
                    if (n3 > 59) {
                        return false;
                    }
                    this.minute = dTBuilder.minute;
                    this.hour = dTBuilder.hour;
                    this.day = dTBuilder.day;
                    this.month = dTBuilder.month;
                    this.year = dTBuilder.year;
                } else {
                    n3 = this.second + n;
                    if (n3 > 59) {
                        return false;
                    }
                }
                this.second = dTBuilder.second = n3;
                return true;
            }

            public String toString() {
                return "serialSecondGenerator:" + n;
            }
        };
    }

    static Generator byYearGenerator(int[] nArray, final DateValue dateValue) {
        final int[] nArray2 = Util.uniquify(nArray);
        return new Generator(){
            int i;
            {
                while (this.i < nArray2.length && dateValue.year() > nArray2[this.i]) {
                    ++this.i;
                }
            }

            @Override
            boolean generate(DTBuilder dTBuilder) {
                if (this.i >= nArray2.length) {
                    return false;
                }
                dTBuilder.year = nArray2[this.i++];
                return true;
            }

            public String toString() {
                return "byYearGenerator";
            }
        };
    }

    static Generator byMonthGenerator(int[] nArray, final DateValue dateValue) {
        final int[] nArray2 = Util.uniquify(nArray);
        return new Generator(){
            int i;
            int year;
            {
                this.year = dateValue.year();
            }

            @Override
            boolean generate(DTBuilder dTBuilder) {
                if (this.year != dTBuilder.year) {
                    this.i = 0;
                    this.year = dTBuilder.year;
                }
                if (this.i >= nArray2.length) {
                    return false;
                }
                dTBuilder.month = nArray2[this.i++];
                return true;
            }

            public String toString() {
                return "byMonthGenerator:" + Arrays.toString(nArray2);
            }
        };
    }

    static Generator byHourGenerator(int[] nArray, final DateValue dateValue) {
        int[] nArray2;
        int n = dateValue instanceof TimeValue ? ((TimeValue)((Object)dateValue)).hour() : 0;
        if ((nArray = Util.uniquify(nArray)).length == 0) {
            nArray = new int[]{n};
        }
        if ((nArray2 = nArray).length == 1) {
            final int n2 = nArray2[0];
            return new SingleValueGenerator(){
                int year;
                int month;
                int day;

                @Override
                boolean generate(DTBuilder dTBuilder) {
                    if (this.year != dTBuilder.year || this.month != dTBuilder.month || this.day != dTBuilder.day) {
                        this.year = dTBuilder.year;
                        this.month = dTBuilder.month;
                        this.day = dTBuilder.day;
                        dTBuilder.hour = n2;
                        return true;
                    }
                    return false;
                }

                @Override
                int getValue() {
                    return n2;
                }

                public String toString() {
                    return "byHourGenerator:" + n2;
                }
            };
        }
        return new Generator(){
            int i;
            int year;
            int month;
            int day;
            {
                int n;
                this.year = dateValue.year();
                this.month = dateValue.month();
                this.day = dateValue.day();
                int n2 = n = dateValue instanceof TimeValue ? ((TimeValue)((Object)dateValue)).hour() : 0;
                while (this.i < nArray2.length && nArray2[this.i] < n) {
                    ++this.i;
                }
            }

            @Override
            boolean generate(DTBuilder dTBuilder) {
                if (this.year != dTBuilder.year || this.month != dTBuilder.month || this.day != dTBuilder.day) {
                    this.i = 0;
                    this.year = dTBuilder.year;
                    this.month = dTBuilder.month;
                    this.day = dTBuilder.day;
                }
                if (this.i >= nArray2.length) {
                    return false;
                }
                dTBuilder.hour = nArray2[this.i++];
                return true;
            }

            public String toString() {
                return "byHourGenerator:" + Arrays.toString(nArray2);
            }
        };
    }

    static Generator byMinuteGenerator(int[] nArray, final DateValue dateValue) {
        int[] nArray2;
        if ((nArray = Util.uniquify(nArray)).length == 0) {
            nArray = new int[]{dateValue instanceof TimeValue ? ((TimeValue)((Object)dateValue)).minute() : 0};
        }
        if ((nArray2 = nArray).length == 1) {
            final int n = nArray2[0];
            return new SingleValueGenerator(){
                int year;
                int month;
                int day;
                int hour;

                @Override
                boolean generate(DTBuilder dTBuilder) {
                    if (this.year != dTBuilder.year || this.month != dTBuilder.month || this.day != dTBuilder.day || this.hour != dTBuilder.hour) {
                        this.year = dTBuilder.year;
                        this.month = dTBuilder.month;
                        this.day = dTBuilder.day;
                        this.hour = dTBuilder.hour;
                        dTBuilder.minute = n;
                        return true;
                    }
                    return false;
                }

                @Override
                int getValue() {
                    return n;
                }

                public String toString() {
                    return "byMinuteGenerator:" + n;
                }
            };
        }
        return new Generator(){
            int i;
            int year;
            int month;
            int day;
            int hour;
            {
                int n;
                this.year = dateValue.year();
                this.month = dateValue.month();
                this.day = dateValue.day();
                this.hour = dateValue instanceof TimeValue ? ((TimeValue)((Object)dateValue)).hour() : 0;
                int n2 = n = dateValue instanceof TimeValue ? ((TimeValue)((Object)dateValue)).minute() : 0;
                while (this.i < nArray2.length && nArray2[this.i] < n) {
                    ++this.i;
                }
            }

            @Override
            boolean generate(DTBuilder dTBuilder) {
                if (this.year != dTBuilder.year || this.month != dTBuilder.month || this.day != dTBuilder.day || this.hour != dTBuilder.hour) {
                    this.i = 0;
                    this.year = dTBuilder.year;
                    this.month = dTBuilder.month;
                    this.day = dTBuilder.day;
                    this.hour = dTBuilder.hour;
                }
                if (this.i >= nArray2.length) {
                    return false;
                }
                dTBuilder.minute = nArray2[this.i++];
                return true;
            }

            public String toString() {
                return "byMinuteGenerator:" + Arrays.toString(nArray2);
            }
        };
    }

    static Generator bySecondGenerator(int[] nArray, final DateValue dateValue) {
        int[] nArray2;
        if ((nArray = Util.uniquify(nArray)).length == 0) {
            nArray = new int[]{dateValue instanceof TimeValue ? ((TimeValue)((Object)dateValue)).second() : 0};
        }
        if ((nArray2 = nArray).length == 1) {
            final int n = nArray2[0];
            return new SingleValueGenerator(){
                int year;
                int month;
                int day;
                int hour;
                int minute;

                @Override
                boolean generate(DTBuilder dTBuilder) {
                    if (this.year != dTBuilder.year || this.month != dTBuilder.month || this.day != dTBuilder.day || this.hour != dTBuilder.hour || this.minute != dTBuilder.minute) {
                        this.year = dTBuilder.year;
                        this.month = dTBuilder.month;
                        this.day = dTBuilder.day;
                        this.hour = dTBuilder.hour;
                        this.minute = dTBuilder.minute;
                        dTBuilder.second = n;
                        return true;
                    }
                    return false;
                }

                @Override
                int getValue() {
                    return n;
                }

                public String toString() {
                    return "bySecondGenerator:" + n;
                }
            };
        }
        return new Generator(){
            int i;
            int year;
            int month;
            int day;
            int hour;
            int minute;
            {
                int n;
                this.year = dateValue.year();
                this.month = dateValue.month();
                this.day = dateValue.day();
                this.hour = dateValue instanceof TimeValue ? ((TimeValue)((Object)dateValue)).hour() : 0;
                this.minute = dateValue instanceof TimeValue ? ((TimeValue)((Object)dateValue)).minute() : 0;
                int n2 = n = dateValue instanceof TimeValue ? ((TimeValue)((Object)dateValue)).second() : 0;
                while (this.i < nArray2.length && nArray2[this.i] < n) {
                    ++this.i;
                }
            }

            @Override
            boolean generate(DTBuilder dTBuilder) {
                if (this.year != dTBuilder.year || this.month != dTBuilder.month || this.day != dTBuilder.day || this.hour != dTBuilder.hour || this.minute != dTBuilder.minute) {
                    this.i = 0;
                    this.year = dTBuilder.year;
                    this.month = dTBuilder.month;
                    this.day = dTBuilder.day;
                    this.hour = dTBuilder.hour;
                    this.minute = dTBuilder.minute;
                }
                if (this.i >= nArray2.length) {
                    return false;
                }
                dTBuilder.second = nArray2[this.i++];
                return true;
            }

            public String toString() {
                return "bySecondGenerator:" + Arrays.toString(nArray2);
            }
        };
    }

    static Generator byMonthDayGenerator(int[] nArray, final DateValue dateValue) {
        final int[] nArray2 = Util.uniquify(nArray);
        return new Generator(){
            int year;
            int month;
            int[] posDates;
            int i;
            {
                this.year = dateValue.year();
                this.month = dateValue.month();
                this.i = 0;
                this.convertDatesToAbsolute();
            }

            private void convertDatesToAbsolute() {
                IntSet intSet = new IntSet();
                int n = TimeUtils.monthLength(this.year, this.month);
                for (int i = 0; i < nArray2.length; ++i) {
                    int n2 = nArray2[i];
                    if (n2 < 0) {
                        n2 += n + 1;
                    }
                    if (n2 < 1 || n2 > n) continue;
                    intSet.add(n2);
                }
                this.posDates = intSet.toIntArray();
            }

            @Override
            boolean generate(DTBuilder dTBuilder) {
                if (this.year != dTBuilder.year || this.month != dTBuilder.month) {
                    this.year = dTBuilder.year;
                    this.month = dTBuilder.month;
                    this.convertDatesToAbsolute();
                    this.i = 0;
                }
                if (this.i >= this.posDates.length) {
                    return false;
                }
                dTBuilder.day = this.posDates[this.i++];
                return true;
            }

            public String toString() {
                return "byMonthDayGenerator";
            }
        };
    }

    static Generator byDayGenerator(WeekdayNum[] weekdayNumArray, final boolean bl, final DateValue dateValue) {
        final WeekdayNum[] weekdayNumArray2 = (WeekdayNum[])weekdayNumArray.clone();
        return new Generator(){
            int year;
            int month;
            int[] dates;
            int i;
            {
                this.year = dateValue.year();
                this.month = dateValue.month();
                this.i = 0;
                this.generateDates();
                int n = dateValue.day();
                while (this.i < this.dates.length && this.dates[this.i] < n) {
                    ++this.i;
                }
            }

            void generateDates() {
                int n;
                Weekday weekday;
                int n2;
                int n3 = TimeUtils.monthLength(this.year, this.month);
                if (bl) {
                    n2 = TimeUtils.yearLength(this.year);
                    weekday = Weekday.firstDayOfWeekInMonth(this.year, 1);
                    n = TimeUtils.dayOfYear(this.year, this.month, 1);
                } else {
                    n2 = n3;
                    weekday = Weekday.firstDayOfWeekInMonth(this.year, this.month);
                    n = 0;
                }
                int n4 = n / 7;
                IntSet intSet = new IntSet();
                for (int i = 0; i < weekdayNumArray2.length; ++i) {
                    int n5;
                    WeekdayNum weekdayNum = weekdayNumArray2[i];
                    if (0 != weekdayNum.num) {
                        n5 = Util.dayNumToDate(weekday, n2, weekdayNum.num, weekdayNum.wday, n, n3);
                        if (0 == n5) continue;
                        intSet.add(n5);
                        continue;
                    }
                    n5 = n4 + 6;
                    for (int j = n4; j <= n5; ++j) {
                        int n6 = Util.dayNumToDate(weekday, n2, j, weekdayNum.wday, n, n3);
                        if (0 == n6) continue;
                        intSet.add(n6);
                    }
                }
                this.dates = intSet.toIntArray();
            }

            @Override
            boolean generate(DTBuilder dTBuilder) {
                if (this.year != dTBuilder.year || this.month != dTBuilder.month) {
                    this.year = dTBuilder.year;
                    this.month = dTBuilder.month;
                    this.generateDates();
                    this.i = 0;
                }
                if (this.i >= this.dates.length) {
                    return false;
                }
                dTBuilder.day = this.dates[this.i++];
                return true;
            }

            public String toString() {
                return "byDayGenerator:" + Arrays.toString(weekdayNumArray2) + " by " + (bl ? "year" : "week");
            }
        };
    }

    static Generator byWeekNoGenerator(int[] nArray, final Weekday weekday, final DateValue dateValue) {
        final int[] nArray2 = Util.uniquify(nArray);
        return new Generator(){
            int year;
            int month;
            int weeksInYear;
            int[] dates;
            int i;
            int doyOfStartOfWeek1;
            {
                this.year = dateValue.year();
                this.month = dateValue.month();
                this.i = 0;
                this.checkYear();
                this.checkMonth();
            }

            void checkYear() {
                Weekday weekday2 = Weekday.firstDayOfWeekInMonth(this.year, 1);
                int n = 7 - (7 + weekday2.javaDayNum - weekday.javaDayNum) % 7;
                int n2 = 0;
                if (n < 4) {
                    n2 = n;
                    n = 7;
                }
                this.doyOfStartOfWeek1 = n - 7 + n2;
                this.weeksInYear = (TimeUtils.yearLength(this.year) - n2 + 6) / 7;
            }

            void checkMonth() {
                int n = TimeUtils.dayOfYear(this.year, this.month, 1);
                int n2 = (n - this.doyOfStartOfWeek1) / 7 + 1;
                int n3 = TimeUtils.monthLength(this.year, this.month);
                IntSet intSet = new IntSet();
                for (int i = 0; i < nArray2.length; ++i) {
                    int n4 = nArray2[i];
                    if (n4 < 0) {
                        n4 += this.weeksInYear + 1;
                    }
                    if (n4 < n2 - 1 || n4 > n2 + 6) continue;
                    for (int j = 0; j < 7; ++j) {
                        int n5 = (n4 - 1) * 7 + j + this.doyOfStartOfWeek1 - n + 1;
                        if (n5 < 1 || n5 > n3) continue;
                        intSet.add(n5);
                    }
                }
                this.dates = intSet.toIntArray();
            }

            @Override
            boolean generate(DTBuilder dTBuilder) {
                if (this.year != dTBuilder.year || this.month != dTBuilder.month) {
                    if (this.year != dTBuilder.year) {
                        this.year = dTBuilder.year;
                        this.checkYear();
                    }
                    this.month = dTBuilder.month;
                    this.checkMonth();
                    this.i = 0;
                }
                if (this.i >= this.dates.length) {
                    return false;
                }
                dTBuilder.day = this.dates[this.i++];
                return true;
            }

            public String toString() {
                return "byWeekNoGenerator";
            }
        };
    }

    static Generator byYearDayGenerator(int[] nArray, final DateValue dateValue) {
        final int[] nArray2 = Util.uniquify(nArray);
        return new Generator(){
            int year;
            int month;
            int[] dates;
            int i;
            {
                this.year = dateValue.year();
                this.month = dateValue.month();
                this.i = 0;
                this.checkMonth();
            }

            void checkMonth() {
                int n = TimeUtils.dayOfYear(this.year, this.month, 1);
                int n2 = TimeUtils.monthLength(this.year, this.month);
                int n3 = TimeUtils.yearLength(this.year);
                IntSet intSet = new IntSet();
                for (int i = 0; i < nArray2.length; ++i) {
                    int n4;
                    int n5 = nArray2[i];
                    if (n5 < 0) {
                        n5 += n3 + 1;
                    }
                    if ((n4 = n5 - n) < 1 || n4 > n2) continue;
                    intSet.add(n4);
                }
                this.dates = intSet.toIntArray();
            }

            @Override
            boolean generate(DTBuilder dTBuilder) {
                if (this.year != dTBuilder.year || this.month != dTBuilder.month) {
                    this.year = dTBuilder.year;
                    this.month = dTBuilder.month;
                    this.checkMonth();
                    this.i = 0;
                }
                if (this.i >= this.dates.length) {
                    return false;
                }
                dTBuilder.day = this.dates[this.i++];
                return true;
            }

            public String toString() {
                return "byYearDayGenerator";
            }
        };
    }

    private static int daysBetween(DTBuilder dTBuilder, int n, int n2, int n3) {
        if (n == dTBuilder.year && n2 == dTBuilder.month) {
            return dTBuilder.day - n3;
        }
        return TimeUtils.daysBetween(dTBuilder.year, dTBuilder.month, dTBuilder.day, n, n2, n3);
    }

    private Generators() {
    }
}

