/*
 * Decompiled with CFR 0.152.
 */
package com.google.ical.iter;

import com.google.ical.iter.Generator;
import com.google.ical.iter.InstanceGenerators;
import com.google.ical.iter.RecurrenceIterator;
import com.google.ical.iter.SingleValueGenerator;
import com.google.ical.iter.ThrottledGenerator;
import com.google.ical.util.DTBuilder;
import com.google.ical.util.Predicate;
import com.google.ical.util.TimeUtils;
import com.google.ical.values.DateValue;
import com.google.ical.values.DateValueImpl;
import com.google.ical.values.TimeValue;
import java.util.TimeZone;

final class RRuleIteratorImpl
implements RecurrenceIterator {
    private final Predicate<? super DateValue> condition_;
    private final Generator instanceGenerator_;
    private final ThrottledGenerator yearGenerator_;
    private final Generator monthGenerator_;
    private DateValue pendingUtc_;
    private DTBuilder builder_;
    private boolean done_;
    private final DateValue dtStart_;
    private final boolean canShortcutAdvance_;
    private final TimeZone tzid_;
    private static final DateValue MIN_DATE = new DateValueImpl(Integer.MIN_VALUE, 1, 1);
    private DateValue lastUtc_ = RRuleIteratorImpl.MIN_DATE;

    /*
     * Unable to fully structure code
     */
    RRuleIteratorImpl(DateValue var1_1, TimeZone var2_2, Predicate<? super DateValue> var3_3, Generator var4_4, ThrottledGenerator var5_5, Generator var6_6, Generator var7_7, Generator var8_8, Generator var9_9, Generator var10_10, boolean var11_11) {
        super();
        this.condition_ = var3_3;
        this.instanceGenerator_ = var4_4;
        this.yearGenerator_ = var5_5;
        this.monthGenerator_ = var6_6;
        this.dtStart_ = var1_1;
        this.tzid_ = var2_2;
        this.canShortcutAdvance_ = var11_11;
        var12_12 = 1000;
        this.builder_ = var13_13 = new DTBuilder(var1_1);
        try {
            if (InstanceGenerators.skipSubDayGenerators(var8_8, var9_9, var10_10)) {
                var14_14 = new Generator[]{var5_5, var6_6};
                var13_13.hour = ((SingleValueGenerator)var8_8).getValue();
                var13_13.minute = ((SingleValueGenerator)var9_9).getValue();
                var13_13.second = ((SingleValueGenerator)var10_10).getValue();
            } else {
                var14_14 = new Generator[]{var5_5, var6_6, var7_7, var8_8, var9_9};
            }
            var15_16 = 0;
            while (var15_16 != var14_14.length) {
                block11: {
                    if (!var14_14[var15_16].generate(var13_13)) break block11;
                    ++var15_16;
                    ** GOTO lbl-1000
                }
                if (--var15_16 < 0) {
                    this.done_ = true;
                } else lbl-1000:
                // 2 sources

                {
                    if (--var12_12 != 0) continue;
                    this.done_ = true;
                }
                break;
            }
        }
        catch (Generator.IteratorShortCircuitingException var14_15) {
            this.done_ = true;
        }
        while (!this.done_) {
            this.pendingUtc_ = this.generateInstance();
            if (null == this.pendingUtc_) {
                this.done_ = true;
                break;
            }
            if (this.pendingUtc_.compareTo(TimeUtils.toUtc(var1_1, var2_2)) >= 0) {
                if (this.condition_.apply(this.pendingUtc_)) break;
                this.done_ = true;
                this.pendingUtc_ = null;
                break;
            }
            if (--var12_12 != 0) continue;
            this.done_ = true;
            break;
        }
    }

    @Override
    public boolean hasNext() {
        if (null == this.pendingUtc_) {
            this.fetchNext();
        }
        return null != this.pendingUtc_;
    }

    @Override
    public DateValue next() {
        if (null == this.pendingUtc_) {
            this.fetchNext();
        }
        DateValue dateValue = this.pendingUtc_;
        this.pendingUtc_ = null;
        return dateValue;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void advanceTo(DateValue dateValue) {
        if (this.pendingUtc_ != null && dateValue.compareTo(this.pendingUtc_) <= 0) {
            return;
        }
        DateValue dateValue2 = TimeUtils.fromUtc(dateValue, this.tzid_);
        if (dateValue2.compareTo(this.builder_.toDate()) <= 0) {
            return;
        }
        this.pendingUtc_ = null;
        try {
            if (this.canShortcutAdvance_) {
                if (this.builder_.year < dateValue2.year()) {
                    do {
                        if (this.yearGenerator_.generate(this.builder_)) continue;
                        this.done_ = true;
                        return;
                    } while (this.builder_.year < dateValue2.year());
                    while (!this.monthGenerator_.generate(this.builder_)) {
                        if (this.yearGenerator_.generate(this.builder_)) continue;
                        this.done_ = true;
                        return;
                    }
                }
                while (this.builder_.year == dateValue2.year() && this.builder_.month < dateValue2.month()) {
                    while (!this.monthGenerator_.generate(this.builder_)) {
                        if (this.yearGenerator_.generate(this.builder_)) continue;
                        this.done_ = true;
                        return;
                    }
                }
            }
            while (!this.done_) {
                DateValue dateValue3 = this.generateInstance();
                if (null == dateValue3) {
                    this.done_ = true;
                    continue;
                }
                if (!this.condition_.apply(dateValue3)) {
                    this.done_ = true;
                    continue;
                }
                if (dateValue3.compareTo(dateValue) < 0) continue;
                this.pendingUtc_ = dateValue3;
                break;
            }
        }
        catch (Generator.IteratorShortCircuitingException iteratorShortCircuitingException) {
            this.done_ = true;
        }
    }

    private void fetchNext() {
        if (null != this.pendingUtc_ || this.done_) {
            return;
        }
        DateValue dateValue = this.generateInstance();
        if (null != dateValue && this.condition_.apply(dateValue)) {
            this.pendingUtc_ = dateValue;
            this.yearGenerator_.workDone();
        } else {
            this.done_ = true;
        }
    }

    private DateValue generateInstance() {
        try {
            DateValue dateValue;
            do {
                if (this.instanceGenerator_.generate(this.builder_)) continue;
                return null;
            } while ((dateValue = this.dtStart_ instanceof TimeValue ? TimeUtils.toUtc(this.builder_.toDateTime(), this.tzid_) : this.builder_.toDate()).compareTo(this.lastUtc_) <= 0);
            return dateValue;
        }
        catch (Generator.IteratorShortCircuitingException iteratorShortCircuitingException) {
            return null;
        }
    }
}

