/*
 * Decompiled with CFR 0.152.
 */
package com.google.ical.iter;

import com.google.ical.iter.CompoundIteratorImpl;
import com.google.ical.iter.Conditions;
import com.google.ical.iter.Filters;
import com.google.ical.iter.Generator;
import com.google.ical.iter.Generators;
import com.google.ical.iter.InstanceGenerators;
import com.google.ical.iter.IntSet;
import com.google.ical.iter.RDateIteratorImpl;
import com.google.ical.iter.RRuleIteratorImpl;
import com.google.ical.iter.RecurrenceIterable;
import com.google.ical.iter.RecurrenceIterator;
import com.google.ical.iter.ThrottledGenerator;
import com.google.ical.iter.Util;
import com.google.ical.util.Predicate;
import com.google.ical.util.Predicates;
import com.google.ical.util.TimeUtils;
import com.google.ical.values.DateTimeValueImpl;
import com.google.ical.values.DateValue;
import com.google.ical.values.DateValueImpl;
import com.google.ical.values.Frequency;
import com.google.ical.values.IcalObject;
import com.google.ical.values.RDateList;
import com.google.ical.values.RRule;
import com.google.ical.values.TimeValue;
import com.google.ical.values.Weekday;
import com.google.ical.values.WeekdayNum;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class RecurrenceIteratorFactory {
    private static final Logger LOGGER = Logger.getLogger(RecurrenceIteratorFactory.class.getName());
    private static final Pattern FOLD = Pattern.compile("(?:\\r\\n?|\\n)[ \t]");
    private static final Pattern NEWLINE = Pattern.compile("[\\r\\n]+");
    private static final Pattern RULE = Pattern.compile("^(?:R|EX)RULE[:;]", 2);
    private static final Pattern DATE = Pattern.compile("^(?:R|EX)DATE[:;]", 2);
    private static final int[] NO_INTS = new int[0];
    private static final WeekdayNum[] NO_DAYS = new WeekdayNum[0];

    public static RecurrenceIterator createRecurrenceIterator(String string, DateValue dateValue, TimeZone timeZone, boolean bl) throws ParseException {
        return RecurrenceIteratorFactory.createRecurrenceIterable(string, dateValue, timeZone, bl).iterator();
    }

    public static RecurrenceIterable createRecurrenceIterable(String string, final DateValue dateValue, final TimeZone timeZone, final boolean bl) throws ParseException {
        final IcalObject[] icalObjectArray = RecurrenceIteratorFactory.parseContentLines(string, timeZone, bl);
        return new RecurrenceIterable(){

            @Override
            public RecurrenceIterator iterator() {
                ArrayList<RecurrenceIterator> arrayList = new ArrayList<RecurrenceIterator>();
                ArrayList<RecurrenceIterator> arrayList2 = new ArrayList<RecurrenceIterator>();
                arrayList.add(new RDateIteratorImpl(new DateValue[]{TimeUtils.toUtc(dateValue, timeZone)}));
                for (IcalObject icalObject : icalObjectArray) {
                    try {
                        String string = icalObject.getName();
                        if ("rrule".equalsIgnoreCase(string)) {
                            arrayList.add(RecurrenceIteratorFactory.createRecurrenceIterator((RRule)icalObject, dateValue, timeZone));
                            continue;
                        }
                        if ("rdate".equalsIgnoreCase(string)) {
                            arrayList.add(RecurrenceIteratorFactory.createRecurrenceIterator((RDateList)icalObject));
                            continue;
                        }
                        if ("exrule".equalsIgnoreCase(string)) {
                            arrayList2.add(RecurrenceIteratorFactory.createRecurrenceIterator((RRule)icalObject, dateValue, timeZone));
                            continue;
                        }
                        if (!"exdate".equalsIgnoreCase(string)) continue;
                        arrayList2.add(RecurrenceIteratorFactory.createRecurrenceIterator((RDateList)icalObject));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        if (bl) {
                            throw illegalArgumentException;
                        }
                        LOGGER.log(Level.SEVERE, "Dropping bad recurrence rule line: " + icalObject.toIcal(), illegalArgumentException);
                    }
                }
                return new CompoundIteratorImpl(arrayList, arrayList2);
            }
        };
    }

    public static RecurrenceIterator createRecurrenceIterator(String string, DateValue dateValue, TimeZone timeZone) throws ParseException {
        return RecurrenceIteratorFactory.createRecurrenceIterator(string, dateValue, timeZone, true);
    }

    public static RecurrenceIterator createRecurrenceIterator(RDateList rDateList) {
        Object[] objectArray = rDateList.getDatesUtc();
        Arrays.sort(objectArray);
        int n = 0;
        for (int i = 1; i < objectArray.length; ++i) {
            if (objectArray[i].equals(objectArray[n])) continue;
            objectArray[++n] = objectArray[i];
        }
        if (++n < objectArray.length) {
            DateValue[] dateValueArray = new DateValue[n];
            System.arraycopy(objectArray, 0, dateValueArray, 0, n);
            objectArray = dateValueArray;
        }
        return new RDateIteratorImpl((DateValue[])objectArray);
    }

    public static RecurrenceIterator createRecurrenceIterator(RRule rRule, DateValue dateValue, TimeZone timeZone) {
        Predicate predicate;
        Predicate<DateValue> predicate2;
        assert (null != timeZone);
        assert (null != dateValue);
        Frequency frequency = rRule.getFreq();
        Weekday weekday = rRule.getWkSt();
        DateValue dateValue2 = rRule.getUntil();
        int n = rRule.getCount();
        int n2 = rRule.getInterval();
        WeekdayNum[] weekdayNumArray = rRule.getByDay().toArray(new WeekdayNum[0]);
        int[] nArray = rRule.getByMonth();
        int[] nArray2 = rRule.getByMonthDay();
        int[] nArray3 = rRule.getByWeekNo();
        int[] nArray4 = rRule.getByYearDay();
        int[] nArray5 = rRule.getBySetPos();
        int[] nArray6 = rRule.getByHour();
        int[] nArray7 = rRule.getByMinute();
        int[] nArray8 = rRule.getBySecond();
        if (n2 <= 0) {
            n2 = 1;
        }
        if (null == weekday) {
            weekday = Weekday.MO;
        }
        if (nArray5.length != 0) {
            switch (frequency) {
                case HOURLY: {
                    if (nArray6.length != 0 && nArray7.length <= 1 && nArray8.length <= 1) {
                        nArray6 = RecurrenceIteratorFactory.filterBySetPos(nArray6, nArray5);
                    }
                    nArray5 = NO_INTS;
                    break;
                }
                case MINUTELY: {
                    if (nArray7.length != 0 && nArray8.length <= 1) {
                        nArray7 = RecurrenceIteratorFactory.filterBySetPos(nArray7, nArray5);
                    }
                    nArray5 = NO_INTS;
                    break;
                }
                case SECONDLY: {
                    if (nArray8.length != 0) {
                        nArray8 = RecurrenceIteratorFactory.filterBySetPos(nArray8, nArray5);
                    }
                    nArray5 = NO_INTS;
                    break;
                }
            }
        }
        DateValue dateValue3 = dateValue;
        if (nArray5.length != 0) {
            switch (frequency) {
                case YEARLY: {
                    dateValue3 = dateValue instanceof TimeValue ? new DateTimeValueImpl(dateValue3.year(), 1, 1, 0, 0, 0) : new DateValueImpl(dateValue3.year(), 1, 1);
                    break;
                }
                case MONTHLY: {
                    dateValue3 = dateValue instanceof TimeValue ? new DateTimeValueImpl(dateValue3.year(), dateValue3.month(), 1, 0, 0, 0) : new DateValueImpl(dateValue3.year(), dateValue3.month(), 1);
                    break;
                }
                case WEEKLY: {
                    int n3 = (7 + weekday.ordinal() - Weekday.valueOf(dateValue).ordinal()) % 7;
                    dateValue3 = TimeUtils.add(dateValue, new DateValueImpl(0, 0, -n3));
                    break;
                }
            }
        }
        ThrottledGenerator throttledGenerator = Generators.serialYearGenerator(frequency == Frequency.YEARLY ? n2 : 1, dateValue);
        Generator generator = null;
        Generator generator2 = null;
        Generator generator3 = null;
        Generator generator4 = null;
        Generator generator5 = null;
        ArrayList arrayList = new ArrayList();
        switch (frequency) {
            case SECONDLY: {
                if (nArray8.length != 0 && n2 == 1) break;
                generator3 = Generators.serialSecondGenerator(n2, dateValue);
                if (nArray8.length == 0) break;
                arrayList.add(Filters.bySecondFilter(nArray8));
                break;
            }
            case MINUTELY: {
                if (nArray7.length != 0 && n2 == 1) break;
                generator4 = Generators.serialMinuteGenerator(n2, dateValue);
                if (nArray7.length == 0) break;
                arrayList.add(Filters.byMinuteFilter(nArray7));
                break;
            }
            case HOURLY: {
                if (nArray6.length != 0 && n2 == 1) break;
                generator5 = Generators.serialHourGenerator(n2, dateValue);
                if (nArray6.length == 0) break;
                arrayList.add(Filters.byHourFilter(nArray8));
                break;
            }
            case DAILY: {
                break;
            }
            case WEEKLY: {
                if (0 != weekdayNumArray.length) {
                    generator2 = Generators.byDayGenerator(weekdayNumArray, false, dateValue3);
                    weekdayNumArray = NO_DAYS;
                    if (n2 <= 1) break;
                    arrayList.add(Filters.weekIntervalFilter(n2, weekday, dateValue));
                    break;
                }
                generator2 = Generators.serialDayGenerator(n2 * 7, dateValue);
                break;
            }
            case YEARLY: {
                if (0 != nArray4.length) {
                    generator2 = Generators.byYearDayGenerator(nArray4, dateValue3);
                    break;
                }
            }
            case MONTHLY: {
                if (0 != nArray2.length) {
                    generator2 = Generators.byMonthDayGenerator(nArray2, dateValue3);
                    nArray2 = NO_INTS;
                    break;
                }
                if (0 != nArray3.length && Frequency.YEARLY == frequency) {
                    generator2 = Generators.byWeekNoGenerator(nArray3, weekday, dateValue3);
                    nArray3 = NO_INTS;
                    break;
                }
                if (0 != weekdayNumArray.length) {
                    generator2 = Generators.byDayGenerator(weekdayNumArray, Frequency.YEARLY == frequency && 0 == nArray.length, dateValue3);
                    weekdayNumArray = NO_DAYS;
                    break;
                }
                if (Frequency.YEARLY == frequency) {
                    generator = Generators.byMonthGenerator(new int[]{dateValue.month()}, dateValue3);
                }
                generator2 = Generators.byMonthDayGenerator(new int[]{dateValue.day()}, dateValue3);
            }
        }
        if (generator3 == null) {
            generator3 = Generators.bySecondGenerator(nArray8, dateValue3);
        }
        if (generator4 == null) {
            generator4 = nArray7.length == 0 && frequency.compareTo(Frequency.MINUTELY) < 0 ? Generators.serialMinuteGenerator(1, dateValue) : Generators.byMinuteGenerator(nArray7, dateValue3);
        }
        if (generator5 == null) {
            generator5 = nArray6.length == 0 && frequency.compareTo(Frequency.HOURLY) < 0 ? Generators.serialHourGenerator(1, dateValue) : Generators.byHourGenerator(nArray6, dateValue3);
        }
        if (generator2 == null) {
            boolean bl;
            boolean bl2 = bl = frequency.compareTo(Frequency.DAILY) <= 0;
            if (nArray2.length != 0) {
                generator2 = Generators.byMonthDayGenerator(nArray2, dateValue3);
                nArray2 = NO_INTS;
            } else if (weekdayNumArray.length != 0) {
                generator2 = Generators.byDayGenerator(weekdayNumArray, Frequency.YEARLY == frequency, dateValue3);
                weekdayNumArray = NO_DAYS;
            } else {
                generator2 = bl ? Generators.serialDayGenerator(Frequency.DAILY == frequency ? n2 : 1, dateValue) : Generators.byMonthDayGenerator(new int[]{dateValue.day()}, dateValue3);
            }
        }
        if (0 != weekdayNumArray.length) {
            arrayList.add(Filters.byDayFilter(weekdayNumArray, Frequency.YEARLY == frequency, weekday));
            weekdayNumArray = NO_DAYS;
        }
        if (0 != nArray2.length) {
            arrayList.add(Filters.byMonthDayFilter(nArray2));
        }
        if (0 != nArray.length) {
            generator = Generators.byMonthGenerator(nArray, dateValue3);
        } else if (null == generator) {
            generator = Generators.serialMonthGenerator(frequency == Frequency.MONTHLY ? n2 : 1, dateValue);
        }
        boolean bl = true;
        if (0 != n) {
            predicate2 = Conditions.countCondition(n);
            bl = false;
        } else if (null != dateValue2) {
            if (dateValue2 instanceof TimeValue != dateValue instanceof TimeValue) {
                dateValue2 = dateValue instanceof TimeValue ? TimeUtils.dayStart(dateValue2) : TimeUtils.toDateValue(dateValue2);
            }
            predicate2 = Conditions.untilCondition(dateValue2);
        } else {
            predicate2 = Predicates.alwaysTrue();
        }
        switch (arrayList.size()) {
            case 0: {
                predicate = Predicates.alwaysTrue();
                break;
            }
            case 1: {
                predicate = (Predicate)arrayList.get(0);
                break;
            }
            default: {
                predicate = Predicates.and(arrayList);
            }
        }
        Generator generator6 = null;
        generator6 = 0 != nArray5.length ? InstanceGenerators.bySetPosInstanceGenerator(nArray5, frequency, weekday, predicate, throttledGenerator, generator, generator2, generator5, generator4, generator3) : InstanceGenerators.serialInstanceGenerator(predicate, throttledGenerator, generator, generator2, generator5, generator4, generator3);
        return new RRuleIteratorImpl(dateValue, timeZone, predicate2, generator6, throttledGenerator, generator, generator2, generator5, generator4, generator3, bl);
    }

    public static RecurrenceIterator join(RecurrenceIterator recurrenceIterator, RecurrenceIterator ... recurrenceIteratorArray) {
        ArrayList<RecurrenceIterator> arrayList = new ArrayList<RecurrenceIterator>();
        arrayList.add(recurrenceIterator);
        arrayList.addAll(Arrays.asList(recurrenceIteratorArray));
        return new CompoundIteratorImpl(arrayList, Collections.emptyList());
    }

    public static RecurrenceIterator except(RecurrenceIterator recurrenceIterator, RecurrenceIterator recurrenceIterator2) {
        return new CompoundIteratorImpl(Collections.singleton(recurrenceIterator), Collections.singleton(recurrenceIterator2));
    }

    private static IcalObject[] parseContentLines(String string, TimeZone timeZone, boolean bl) throws ParseException {
        String string2 = FOLD.matcher(string).replaceAll("").trim();
        if ("".equals(string2)) {
            return new IcalObject[0];
        }
        String[] stringArray = NEWLINE.split(string2);
        IcalObject[] icalObjectArray = new IcalObject[stringArray.length];
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i].trim();
            try {
                if (RULE.matcher(string3).find()) {
                    icalObjectArray[i] = new RRule(string3);
                    continue;
                }
                if (DATE.matcher(string3).find()) {
                    icalObjectArray[i] = new RDateList(string3, timeZone);
                    continue;
                }
                throw new ParseException(stringArray[i], i);
            }
            catch (ParseException parseException) {
                if (bl) {
                    throw parseException;
                }
                LOGGER.log(Level.SEVERE, "Dropping bad recurrence rule line: " + string3, parseException);
                ++n;
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (bl) {
                    throw illegalArgumentException;
                }
                LOGGER.log(Level.SEVERE, "Dropping bad recurrence rule line: " + string3, illegalArgumentException);
                ++n;
            }
        }
        if (0 != n) {
            IcalObject[] icalObjectArray2 = new IcalObject[icalObjectArray.length - n];
            int n2 = 0;
            int n3 = 0;
            while (n2 < icalObjectArray2.length) {
                if (null != icalObjectArray[n3]) {
                    icalObjectArray2[n2++] = icalObjectArray[n3];
                }
                ++n3;
            }
            icalObjectArray = icalObjectArray2;
        }
        return icalObjectArray;
    }

    private static int[] filterBySetPos(int[] nArray, int[] nArray2) {
        nArray = Util.uniquify(nArray);
        IntSet intSet = new IntSet();
        for (int n : nArray2) {
            if (n == 0) continue;
            n = n < 0 ? (n += nArray.length) : --n;
            if (n < 0 || n >= nArray.length) continue;
            intSet.add(nArray[n]);
        }
        return intSet.toIntArray();
    }

    private RecurrenceIteratorFactory() {
    }
}

