/*
 * Decompiled with CFR 0.152.
 */
package com.google.ical.util;

import com.google.ical.util.Predicate;
import java.io.Serializable;
import java.util.Collection;

public class Predicates {
    private static final Predicate<?> ALWAYS_TRUE = new AlwaysTruePredicate();
    private static final Predicate<?> ALWAYS_FALSE = new AlwaysFalsePredicate();

    private Predicates() {
    }

    public static <T> Predicate<T> alwaysTrue() {
        return ALWAYS_TRUE;
    }

    public static <T> Predicate<T> alwaysFalse() {
        return ALWAYS_FALSE;
    }

    public static <T> Predicate<T> not(Predicate<? super T> predicate) {
        assert (null != predicate);
        return new NotPredicate(predicate);
    }

    public static <T> Predicate<T> and(Predicate<? super T> ... predicateArray) {
        assert (null != predicateArray);
        predicateArray = (Predicate[])predicateArray.clone();
        int n = predicateArray.length;
        for (int i = 0; i < n; ++i) {
            Predicate<? super T> predicate = predicateArray[i];
            if (predicate == ALWAYS_FALSE) {
                return Predicates.alwaysFalse();
            }
            if (predicate != ALWAYS_TRUE) continue;
            predicateArray[i] = predicateArray[n - 1];
            --i;
            --n;
        }
        if (n == 0) {
            return Predicates.alwaysTrue();
        }
        if (n != predicateArray.length) {
            Predicate[] predicateArray2 = new Predicate[n];
            System.arraycopy(predicateArray2, 0, predicateArray, 0, n);
            predicateArray = predicateArray2;
        }
        return new AndPredicate((Predicate[])predicateArray);
    }

    public static <T> Predicate<T> and(Collection<Predicate<? super T>> collection) {
        int n = collection.size();
        Predicate[] predicateArray = new Predicate[n];
        collection.toArray(predicateArray);
        return Predicates.and(predicateArray);
    }

    public static <T> Predicate<T> or(Predicate<? super T> ... predicateArray) {
        assert (predicateArray != null);
        predicateArray = (Predicate[])predicateArray.clone();
        int n = predicateArray.length;
        for (int i = 0; i < n; ++i) {
            Predicate<? super T> predicate = predicateArray[i];
            if (predicate == ALWAYS_TRUE) {
                return Predicates.alwaysTrue();
            }
            if (predicate != ALWAYS_FALSE) continue;
            predicateArray[i] = predicateArray[n - 1];
            --i;
            --n;
        }
        if (predicateArray.length == 0) {
            return Predicates.alwaysFalse();
        }
        if (n != predicateArray.length) {
            Predicate[] predicateArray2 = new Predicate[n];
            System.arraycopy(predicateArray2, 0, predicateArray, 0, n);
            predicateArray = predicateArray2;
        }
        return new OrPredicate((Predicate[])predicateArray);
    }

    private static class OrPredicate<T>
    implements Predicate<T>,
    Serializable {
        private static final long serialVersionUID = -7942366790698074803L;
        private final Predicate<? super T>[] components;

        private OrPredicate(Predicate<? super T> ... predicateArray) {
            this.components = predicateArray;
        }

        @Override
        public boolean apply(T t) {
            for (Predicate<T> predicate : this.components) {
                if (!predicate.apply(t)) continue;
                return true;
            }
            return false;
        }
    }

    private static class AndPredicate<T>
    implements Predicate<T>,
    Serializable {
        private static final long serialVersionUID = 1022358602593297546L;
        private final Predicate<? super T>[] components;

        private AndPredicate(Predicate<? super T> ... predicateArray) {
            this.components = predicateArray;
        }

        @Override
        public boolean apply(T t) {
            for (Predicate<T> predicate : this.components) {
                if (predicate.apply(t)) continue;
                return false;
            }
            return true;
        }
    }

    private static class NotPredicate<T>
    implements Predicate<T>,
    Serializable {
        private static final long serialVersionUID = -5113445916422049953L;
        private final Predicate<? super T> predicate;

        private NotPredicate(Predicate<? super T> predicate) {
            this.predicate = predicate;
        }

        @Override
        public boolean apply(T t) {
            return !this.predicate.apply(t);
        }
    }

    private static class AlwaysFalsePredicate<T>
    implements Predicate<T>,
    Serializable {
        private static final long serialVersionUID = -565481022115659695L;

        private AlwaysFalsePredicate() {
        }

        @Override
        public boolean apply(T t) {
            return false;
        }

        public String toString() {
            return "false";
        }
    }

    private static class AlwaysTruePredicate<T>
    implements Predicate<T>,
    Serializable {
        private static final long serialVersionUID = 8759914710239461322L;

        private AlwaysTruePredicate() {
        }

        @Override
        public boolean apply(T t) {
            return true;
        }

        public String toString() {
            return "true";
        }
    }
}

