/*
 * Decompiled with CFR 0.152.
 */
package com.google.ical.values;

import com.google.ical.util.DTBuilder;
import com.google.ical.util.TimeUtils;
import com.google.ical.values.DateValue;
import com.google.ical.values.PeriodValue;
import com.google.ical.values.PeriodValueImpl;
import com.google.ical.values.TimeValue;
import java.text.ParseException;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class IcalParseUtil {
    private static final Pattern DATE_VALUE = Pattern.compile("(\\d{4,})(\\d\\d)(\\d\\d)(?:T([0-1]\\d|2[0-3])([0-5]\\d)([0-5]\\d)(Z)?)?");
    private static final Pattern IGNORABLE_ICAL_WHITESPACE = Pattern.compile("(?:\\r\\n?|\\n)[ \t]");

    public static DateValue parseDateValue(String string) throws ParseException {
        return IcalParseUtil.parseDateValue(string, null);
    }

    public static DateValue parseDateValue(String string, TimeZone timeZone) throws ParseException {
        Matcher matcher = DATE_VALUE.matcher(string);
        if (!matcher.matches()) {
            throw new ParseException(string, 0);
        }
        int n = Integer.parseInt(matcher.group(1));
        int n2 = Integer.parseInt(matcher.group(2));
        int n3 = Integer.parseInt(matcher.group(3));
        if (null != matcher.group(4)) {
            int n4 = Integer.parseInt(matcher.group(4));
            int n5 = Integer.parseInt(matcher.group(5));
            int n6 = Integer.parseInt(matcher.group(6));
            boolean bl = null != matcher.group(7);
            DateValue dateValue = new DTBuilder(n, n2, n3, n4, n5, n6).toDateTime();
            if (!bl && null != timeZone) {
                dateValue = TimeUtils.toUtc(dateValue, timeZone);
            }
            return dateValue;
        }
        return new DTBuilder(n, n2, n3).toDate();
    }

    public static PeriodValue parsePeriodValue(String string) throws ParseException {
        return IcalParseUtil.parsePeriodValue(string, null);
    }

    public static PeriodValue parsePeriodValue(String string, TimeZone timeZone) throws ParseException {
        DateValue dateValue;
        int n = string.indexOf(47);
        if (n < 0) {
            throw new ParseException(string, string.length());
        }
        DateValue dateValue2 = IcalParseUtil.parseDateValue(string.substring(0, n), timeZone);
        if (dateValue2 instanceof TimeValue != (dateValue = IcalParseUtil.parseDateValue(string.substring(n + 1), timeZone)) instanceof TimeValue) {
            throw new ParseException(string, 0);
        }
        try {
            return PeriodValueImpl.create(dateValue2, dateValue);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw (ParseException)new ParseException(string, n + 1).initCause(illegalArgumentException);
        }
    }

    public static String unfoldIcal(String string) {
        return IGNORABLE_ICAL_WHITESPACE.matcher(string).replaceAll("");
    }

    private IcalParseUtil() {
    }
}

