/*
 * Decompiled with CFR 0.152.
 */
package com.google.ical.values;

import com.google.ical.values.IcalObject;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

class IcalSchema {
    private final Map<String, ParamRule> paramRules;
    private final Map<String, ContentRule> contentRules;
    private final Map<String, ObjectRule> objectRules;
    private final Map<String, XformRule> xformRules;
    private final List<String> ruleStack = new ArrayList<String>();
    private static final Pattern EXTENSION_PARAM_NAME_RE = Pattern.compile("^X-[A-Z0-9\\-]+$", 2);

    IcalSchema(Map<String, ParamRule> map, Map<String, ContentRule> map2, Map<String, ObjectRule> map3, Map<String, XformRule> map4) {
        this.paramRules = map;
        this.contentRules = map2;
        this.objectRules = map3;
        this.xformRules = map4;
    }

    public void applyParamsSchema(String string, Map<String, String> map, IcalObject icalObject) throws ParseException {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string2 = entry.getKey();
            this.applyParamSchema(string, string2, entry.getValue(), icalObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyParamSchema(String string, String string2, String string3, IcalObject icalObject) throws ParseException {
        if (EXTENSION_PARAM_NAME_RE.matcher(string2).find()) {
            icalObject.getExtParams().put(string2, string3);
            return;
        }
        this.ruleStack.add(string);
        try {
            this.paramRules.get(string).apply(this, string2, string3, icalObject);
        }
        finally {
            this.ruleStack.remove(this.ruleStack.get(this.ruleStack.size() - 1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyContentSchema(String string, String string2, IcalObject icalObject) throws ParseException {
        this.ruleStack.add(string);
        try {
            try {
                this.contentRules.get(string).apply(this, string2, icalObject);
            }
            catch (NumberFormatException numberFormatException) {
                this.badContent(string2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.badContent(string2);
            }
        }
        finally {
            this.ruleStack.remove(this.ruleStack.get(this.ruleStack.size() - 1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyObjectSchema(String string, Map<String, String> map, String string2, IcalObject icalObject) throws ParseException {
        this.ruleStack.add(string);
        try {
            this.objectRules.get(string).apply(this, map, string2, icalObject);
        }
        finally {
            this.ruleStack.remove(this.ruleStack.get(this.ruleStack.size() - 1));
        }
    }

    public Object applyXformSchema(String string, String string2) throws ParseException {
        this.ruleStack.add(string);
        try {
            Object object = this.xformRules.get(string).apply(this, string2);
            return object;
        }
        catch (NumberFormatException numberFormatException) {
            this.badContent(string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.badContent(string2);
        }
        {
            throw new AssertionError();
        }
        finally {
            this.ruleStack.remove(this.ruleStack.get(this.ruleStack.size() - 1));
        }
    }

    public void badParam(String string, String string2) throws ParseException {
        throw new ParseException("parameter " + string + " has bad value [[" + string2 + "]] in " + this.ruleStack, 0);
    }

    public void badPart(String string, String string2) throws ParseException {
        string2 = null != string2 ? " : " + string2 : "";
        throw new ParseException("cannot parse [[" + string + "]] in " + this.ruleStack + string2, 0);
    }

    public void dupePart(String string) throws ParseException {
        throw new ParseException("duplicate part [[" + string + "]] in " + this.ruleStack, 0);
    }

    public void missingPart(String string, String string2) throws ParseException {
        throw new ParseException("missing part " + string + " from [[" + string2 + "]] in " + this.ruleStack, 0);
    }

    public void badContent(String string) throws ParseException {
        throw new ParseException("cannot parse content line [[" + string + "]] in " + this.ruleStack, 0);
    }

    public static interface XformRule {
        public Object apply(IcalSchema var1, String var2) throws ParseException;
    }

    public static interface ContentRule {
        public void apply(IcalSchema var1, String var2, IcalObject var3) throws ParseException;
    }

    public static interface ParamRule {
        public void apply(IcalSchema var1, String var2, String var3, IcalObject var4) throws ParseException;
    }

    public static interface ObjectRule {
        public void apply(IcalSchema var1, Map<String, String> var2, String var3, IcalObject var4) throws ParseException;
    }
}

