/*
 * Decompiled with CFR 0.152.
 */
package com.google.ical.values;

import com.google.ical.util.TimeUtils;
import com.google.ical.values.DateValue;
import com.google.ical.values.PeriodValue;
import com.google.ical.values.TimeValue;

public class PeriodValueImpl
implements PeriodValue {
    private DateValue start;
    private DateValue end;

    public static PeriodValue create(DateValue dateValue, DateValue dateValue2) {
        return new PeriodValueImpl(dateValue, dateValue2);
    }

    public static PeriodValue createFromDuration(DateValue dateValue, DateValue dateValue2) {
        DateValue dateValue3 = TimeUtils.add(dateValue, dateValue2);
        if (dateValue3 instanceof TimeValue && !(dateValue instanceof TimeValue)) {
            dateValue = TimeUtils.dayStart(dateValue);
        }
        return new PeriodValueImpl(dateValue, dateValue3);
    }

    protected PeriodValueImpl(DateValue dateValue, DateValue dateValue2) {
        if (dateValue.compareTo(dateValue2) > 0) {
            throw new IllegalArgumentException("Start (" + dateValue + ") must precede end (" + dateValue2 + ")");
        }
        if (dateValue instanceof TimeValue ^ dateValue2 instanceof TimeValue) {
            throw new IllegalArgumentException("Start (" + dateValue + ") and end (" + dateValue2 + ") must both have times or neither have times.");
        }
        this.start = dateValue;
        this.end = dateValue2;
    }

    @Override
    public DateValue start() {
        return this.start;
    }

    @Override
    public DateValue end() {
        return this.end;
    }

    @Override
    public boolean intersects(PeriodValue periodValue) {
        DateValue dateValue = this.start;
        DateValue dateValue2 = this.end;
        DateValue dateValue3 = periodValue.start();
        DateValue dateValue4 = periodValue.end();
        return dateValue.compareTo(dateValue4) < 0 && dateValue3.compareTo(dateValue2) < 0;
    }

    @Override
    public boolean contains(PeriodValue periodValue) {
        DateValue dateValue = this.start;
        DateValue dateValue2 = this.end;
        DateValue dateValue3 = periodValue.start();
        DateValue dateValue4 = periodValue.end();
        return dateValue3.compareTo(dateValue) >= 0 && dateValue2.compareTo(dateValue4) >= 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof PeriodValue)) {
            return false;
        }
        PeriodValue periodValue = (PeriodValue)object;
        return this.start().equals(periodValue.start()) && this.end().equals(periodValue.end());
    }

    public int hashCode() {
        return this.start.hashCode() ^ 31 * this.end.hashCode();
    }

    public String toString() {
        return this.start().toString() + "/" + this.end().toString();
    }
}

