/*
 * Decompiled with CFR 0.152.
 */
package com.google.ical.values;

import com.google.ical.values.AbstractIcalObject;
import com.google.ical.values.DateValue;
import com.google.ical.values.Frequency;
import com.google.ical.values.RRuleSchema;
import com.google.ical.values.TimeValue;
import com.google.ical.values.VcalRewriter;
import com.google.ical.values.Weekday;
import com.google.ical.values.WeekdayNum;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class RRule
extends AbstractIcalObject {
    private Frequency freq;
    private Weekday wkst;
    private DateValue until;
    private int count;
    private int interval;
    private List<WeekdayNum> byDay = new ArrayList<WeekdayNum>();
    private int[] byMonth = NO_INTS;
    private int[] byMonthDay = NO_INTS;
    private int[] byWeekNo = NO_INTS;
    private int[] byYearDay = NO_INTS;
    private int[] byHour = NO_INTS;
    private int[] byMinute = NO_INTS;
    private int[] bySecond = NO_INTS;
    private int[] bySetPos = NO_INTS;
    private static final int[] NO_INTS = new int[0];

    public RRule() {
        this.freq = Frequency.DAILY;
        this.setName("RRULE");
    }

    public RRule(String string) throws ParseException {
        this.parse(VcalRewriter.rewriteRule(string), RRuleSchema.instance());
    }

    @Override
    public String toIcal() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getName());
        if (this.hasExtParams()) {
            for (Map.Entry object : this.getExtParams().entrySet()) {
                String string = (String)object.getKey();
                String string2 = (String)object.getValue();
                if (ICAL_SPECIALS.matcher(string2).find()) {
                    string2 = "\"" + string2 + "\"";
                }
                stringBuilder.append(';').append(string).append('=').append(string2);
            }
        }
        stringBuilder.append(":FREQ=").append((Object)this.freq);
        if (null != this.wkst) {
            stringBuilder.append(";WKST=").append(this.wkst.toString());
        }
        if (null != this.until) {
            stringBuilder.append(";UNTIL=").append(this.until);
            if (this.until instanceof TimeValue) {
                stringBuilder.append('Z');
            }
        }
        if (this.count != 0) {
            stringBuilder.append(";COUNT=").append(this.count);
        }
        if (this.interval != 0) {
            stringBuilder.append(";INTERVAL=").append(this.interval);
        }
        if (0 != this.byYearDay.length) {
            stringBuilder.append(";BYYEARDAY=");
            RRule.writeIntList(this.byYearDay, stringBuilder);
        }
        if (0 != this.byMonth.length) {
            stringBuilder.append(";BYMONTH=");
            RRule.writeIntList(this.byMonth, stringBuilder);
        }
        if (0 != this.byMonthDay.length) {
            stringBuilder.append(";BYMONTHDAY=");
            RRule.writeIntList(this.byMonthDay, stringBuilder);
        }
        if (0 != this.byWeekNo.length) {
            stringBuilder.append(";BYWEEKNO=");
            RRule.writeIntList(this.byWeekNo, stringBuilder);
        }
        if (!this.byDay.isEmpty()) {
            stringBuilder.append(";BYDAY=");
            boolean bl = true;
            for (WeekdayNum weekdayNum : this.byDay) {
                if (!bl) {
                    stringBuilder.append(',');
                } else {
                    bl = false;
                }
                stringBuilder.append(weekdayNum);
            }
        }
        if (0 != this.byHour.length) {
            stringBuilder.append(";BYHOUR=");
            RRule.writeIntList(this.byHour, stringBuilder);
        }
        if (0 != this.byMinute.length) {
            stringBuilder.append(";BYMINUTE=");
            RRule.writeIntList(this.byMinute, stringBuilder);
        }
        if (0 != this.bySecond.length) {
            stringBuilder.append(";BYSECOND=");
            RRule.writeIntList(this.bySecond, stringBuilder);
        }
        if (0 != this.bySetPos.length) {
            stringBuilder.append(";BYSETPOS=");
            RRule.writeIntList(this.bySetPos, stringBuilder);
        }
        return stringBuilder.toString();
    }

    private static void writeIntList(int[] nArray, StringBuilder stringBuilder) {
        for (int i = 0; i < nArray.length; ++i) {
            if (0 != i) {
                stringBuilder.append(',');
            }
            stringBuilder.append(nArray[i]);
        }
    }

    public int approximateIntervalInDays() {
        int n;
        int n2 = 0;
        switch (this.freq) {
            case DAILY: {
                n = 1;
                break;
            }
            case WEEKLY: {
                n = 7;
                if (this.byDay.isEmpty()) break;
                n2 = this.byDay.size();
                break;
            }
            case MONTHLY: {
                n = 30;
                if (!this.byDay.isEmpty()) {
                    for (WeekdayNum weekdayNum : this.byDay) {
                        n2 += 0 != weekdayNum.num ? 1 : 4;
                    }
                    break;
                }
                n2 = this.byMonthDay.length;
                break;
            }
            case YEARLY: {
                n = 365;
                int n3 = 12;
                if (0 != this.byMonth.length) {
                    n3 = this.byMonth.length;
                }
                if (!this.byDay.isEmpty()) {
                    for (WeekdayNum weekdayNum : this.byDay) {
                        n2 += (0 != weekdayNum.num ? 1 : 4) * n3;
                    }
                    break;
                }
                if (0 != this.byMonthDay.length) {
                    n2 += n3 * this.byMonthDay.length;
                    break;
                }
                n2 += this.byYearDay.length;
                break;
            }
            default: {
                n = 0;
            }
        }
        if (0 == n2) {
            n2 = 1;
        }
        return n / n2 * this.interval;
    }

    public Frequency getFreq() {
        return this.freq;
    }

    public void setFreq(Frequency frequency) {
        this.freq = frequency;
    }

    public Weekday getWkSt() {
        return this.wkst;
    }

    public void setWkSt(Weekday weekday) {
        this.wkst = weekday;
    }

    public DateValue getUntil() {
        return this.until;
    }

    public void setUntil(DateValue dateValue) {
        this.until = dateValue;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int n) {
        this.count = n;
    }

    public int getInterval() {
        return this.interval;
    }

    public void setInterval(int n) {
        this.interval = n;
    }

    public List<WeekdayNum> getByDay() {
        return this.byDay;
    }

    public void setByDay(List<WeekdayNum> list) {
        this.byDay = new ArrayList<WeekdayNum>(list);
    }

    public int[] getByMonth() {
        return this.byMonth;
    }

    public void setByMonth(int[] nArray) {
        this.byMonth = (int[])nArray.clone();
    }

    public int[] getByMonthDay() {
        return this.byMonthDay;
    }

    public void setByMonthDay(int[] nArray) {
        this.byMonthDay = (int[])nArray.clone();
    }

    public int[] getByWeekNo() {
        return this.byWeekNo;
    }

    public void setByWeekNo(int[] nArray) {
        this.byWeekNo = (int[])nArray.clone();
    }

    public int[] getByYearDay() {
        return this.byYearDay;
    }

    public void setByYearDay(int[] nArray) {
        this.byYearDay = (int[])nArray.clone();
    }

    public int[] getBySetPos() {
        return this.bySetPos;
    }

    public void setBySetPos(int[] nArray) {
        this.bySetPos = (int[])nArray.clone();
    }

    public int[] getByHour() {
        return this.byHour;
    }

    public void setByHour(int[] nArray) {
        this.byHour = (int[])nArray.clone();
    }

    public int[] getByMinute() {
        return this.byMinute;
    }

    public void setByMinute(int[] nArray) {
        this.byMinute = (int[])nArray.clone();
    }

    public int[] getBySecond() {
        return this.bySecond;
    }

    public void setBySecond(int[] nArray) {
        this.bySecond = (int[])nArray.clone();
    }
}

