/*
 * Decompiled with CFR 0.152.
 */
package com.google.ical.values;

import com.google.ical.values.Frequency;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class VcalRewriter {
    private static final String DATE = "[0-9]{8,}(?:T[0-9]{6}Z?)?";
    private static final Pattern VCAL_RRULE = Pattern.compile("^((?:RRULE|EXRULE)(?:;[\\w-]+=(?:\"[^\"]*\"|[^;:\"]*))*:)(D|W|M[DP]|Y[DM])([0-9]*)((?:\\s+(?:MO|TU|WE|TH|FR|SA|SU|LD|(?:[0-9]{1,3}[+-]?)))*)(?:\\s+(?:#([0-9]+)|([0-9]{8,}(?:T[0-9]{6}Z?)?)))?$", 2);
    private static final Pattern WHITESPACE = Pattern.compile("\\s+");

    static String rewriteRule(String string) {
        Frequency frequency;
        Matcher matcher = VCAL_RRULE.matcher(string.trim());
        if (!matcher.matches()) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = matcher.group(1);
        String string3 = matcher.group(2).toUpperCase();
        String string4 = matcher.group(3);
        String string5 = matcher.group(4).trim().toUpperCase();
        String string6 = matcher.group(5);
        String string7 = matcher.group(6);
        stringBuilder.append(string2);
        switch (string3.charAt(0)) {
            case 'Y': {
                frequency = Frequency.YEARLY;
                break;
            }
            case 'M': {
                frequency = Frequency.MONTHLY;
                break;
            }
            case 'W': {
                frequency = Frequency.WEEKLY;
                break;
            }
            case 'D': {
                frequency = Frequency.DAILY;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        stringBuilder.append("FREQ=").append(frequency.name());
        if (!"".equals(string4) && !"1".equals(string4)) {
            stringBuilder.append(";INTERVAL=").append(string4);
        }
        if (!"".equals(string5)) {
            int n;
            int n2;
            String[] stringArray = WHITESPACE.split(string5);
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                String string8 = stringArray[n2];
                n = string8.charAt(string8.length() - 1);
                switch (n) {
                    case 43: {
                        stringArray[n2] = string8.substring(0, string8.length() - 1);
                        break;
                    }
                    case 45: {
                        stringArray[n2] = (char)n + string8.substring(0, string8.length() - 1);
                    }
                }
                if (!string8.equals("LD")) continue;
                stringArray[n2] = "-1";
            }
            switch (frequency) {
                case YEARLY: {
                    if ('D' == string3.charAt(1)) {
                        stringBuilder.append(";BYYEARDAY=");
                        VcalRewriter.join(stringBuilder, ",", stringArray);
                        break;
                    }
                    stringBuilder.append(";BYMONTH=");
                    VcalRewriter.join(stringBuilder, ",", stringArray);
                    break;
                }
                case MONTHLY: {
                    if ('P' == string3.charAt(1)) {
                        n2 = 0;
                        boolean bl = false;
                        stringBuilder.append(";BYDAY=");
                        for (n = 0; n < stringArray.length; ++n) {
                            if (!Character.isLetter(stringArray[n].charAt(0))) continue;
                            if (n > n2) {
                                for (int i = n2; i < n; ++i) {
                                    if (bl) {
                                        stringBuilder.append(',');
                                    } else {
                                        bl = true;
                                    }
                                    stringBuilder.append(stringArray[i]).append(stringArray[n]);
                                }
                            } else {
                                if (bl) {
                                    stringBuilder.append(',');
                                } else {
                                    bl = true;
                                }
                                stringBuilder.append(stringArray[n]);
                            }
                            n2 = n + 1;
                        }
                        break;
                    }
                    stringBuilder.append(";BYMONTHDAY=");
                    VcalRewriter.join(stringBuilder, ",", stringArray);
                    break;
                }
                case WEEKLY: {
                    stringBuilder.append(";BYDAY=");
                    VcalRewriter.join(stringBuilder, ",", stringArray);
                    break;
                }
            }
        }
        if (null != string6) {
            if (!"0".equals(string6)) {
                stringBuilder.append(";COUNT=").append(string6);
            }
        } else if (null != string7) {
            string7 = string7.toUpperCase();
            stringBuilder.append(";UNTIL=").append(string7);
            if (!string7.endsWith("Z") && string7.indexOf(84) >= 0) {
                stringBuilder.append('Z');
            }
        }
        return stringBuilder.toString();
    }

    private static void join(StringBuilder stringBuilder, String string, String[] stringArray) {
        if (0 != stringArray.length) {
            stringBuilder.append(stringArray[0]);
            for (int i = 1; i < stringArray.length; ++i) {
                stringBuilder.append(string).append(stringArray[i]);
            }
        }
    }

    private VcalRewriter() {
    }
}

