/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.object;

import java.lang.reflect.Array;
import java.math.BigInteger;
import ncsa.hdf.object.Datatype;
import ncsa.hdf.object.Metadata;

public class Attribute
implements Metadata {
    private static final long serialVersionUID = 2072473407027648309L;
    private final String name;
    private final Datatype type;
    private int rank;
    private long[] dims;
    private Object value;
    private boolean isUnsigned;
    protected boolean isScalar = false;

    public Attribute(String string, Datatype datatype, long[] lArray) {
        this(string, datatype, lArray, null);
    }

    public Attribute(String string, Datatype datatype, long[] lArray, Object object) {
        this.name = string;
        this.type = datatype;
        this.dims = lArray;
        this.value = null;
        this.rank = 0;
        if (this.dims != null) {
            this.rank = this.dims.length;
        } else {
            this.isScalar = true;
            this.rank = 1;
            this.dims = new long[]{1L};
        }
        if (object != null) {
            this.value = object;
        }
        this.isUnsigned = this.type.getDatatypeSign() == 0;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void setValue(Object object) {
        this.value = object;
    }

    public String getName() {
        return this.name;
    }

    public int getRank() {
        return this.rank;
    }

    public long[] getDataDims() {
        return this.dims;
    }

    public Datatype getType() {
        return this.type;
    }

    public boolean isScalar() {
        return this.isScalar;
    }

    public boolean isUnsigned() {
        return this.isUnsigned;
    }

    public String toString() {
        return this.name;
    }

    public String toString(String string) {
        StringBuffer stringBuffer;
        block23: {
            int n;
            block22: {
                boolean bl;
                if (this.value == null) {
                    return null;
                }
                Class<?> clazz = this.value.getClass();
                if (!clazz.isArray()) {
                    return this.value.toString();
                }
                stringBuffer = new StringBuffer();
                n = Array.getLength(this.value);
                boolean bl2 = bl = this.getType().getDatatypeSign() == 0;
                if (!bl) break block22;
                String string2 = clazz.getName();
                char c = string2.charAt(string2.lastIndexOf("[") + 1);
                switch (c) {
                    case 'B': {
                        byte[] byArray = (byte[])this.value;
                        short s = byArray[0];
                        if (s < 0) {
                            s = (short)(s + 256);
                        }
                        stringBuffer.append(s);
                        for (int i = 1; i < n; ++i) {
                            stringBuffer.append(string);
                            s = byArray[i];
                            if (s < 0) {
                                s = (short)(s + 256);
                            }
                            stringBuffer.append(s);
                        }
                        break block23;
                    }
                    case 'S': {
                        short[] sArray = (short[])this.value;
                        int n2 = sArray[0];
                        if (n2 < 0) {
                            n2 += 65536;
                        }
                        stringBuffer.append(n2);
                        for (int i = 1; i < n; ++i) {
                            stringBuffer.append(string);
                            n2 = sArray[i];
                            if (n2 < 0) {
                                n2 += 65536;
                            }
                            stringBuffer.append(n2);
                        }
                        break block23;
                    }
                    case 'I': {
                        int[] nArray = (int[])this.value;
                        long l = nArray[0];
                        if (l < 0L) {
                            l += 0x100000000L;
                        }
                        stringBuffer.append(l);
                        for (int i = 1; i < n; ++i) {
                            stringBuffer.append(string);
                            l = nArray[i];
                            if (l < 0L) {
                                l += 0x100000000L;
                            }
                            stringBuffer.append(l);
                        }
                        break block23;
                    }
                    case 'J': {
                        BigInteger bigInteger;
                        BigInteger bigInteger2;
                        String string3 = "";
                        long[] lArray = (long[])this.value;
                        Long l = lArray[0];
                        if (l < 0L) {
                            l = l << 1 >>> 1;
                            BigInteger bigInteger3 = new BigInteger("9223372036854775808");
                            bigInteger2 = new BigInteger(l.toString());
                            bigInteger = bigInteger3.add(bigInteger2);
                            string3 = bigInteger.toString();
                        }
                        stringBuffer.append(string3);
                        for (int i = 1; i < n; ++i) {
                            stringBuffer.append(string);
                            l = lArray[i];
                            if (l < 0L) {
                                l = l << 1 >>> 1;
                                bigInteger2 = new BigInteger("9223372036854775808");
                                bigInteger = new BigInteger(l.toString());
                                BigInteger bigInteger4 = bigInteger2.add(bigInteger);
                                string3 = bigInteger4.toString();
                            }
                            stringBuffer.append(string3);
                        }
                        break block23;
                    }
                    default: {
                        stringBuffer.append(Array.get(this.value, 0));
                        for (int i = 1; i < n; ++i) {
                            stringBuffer.append(string);
                            stringBuffer.append(Array.get(this.value, i));
                        }
                        break block23;
                    }
                }
            }
            stringBuffer.append(Array.get(this.value, 0));
            for (int i = 1; i < n; ++i) {
                stringBuffer.append(string);
                stringBuffer.append(Array.get(this.value, i));
            }
        }
        return stringBuffer.toString();
    }
}

