/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.object;

import ncsa.hdf.object.Dataset;
import ncsa.hdf.object.FileFormat;

public abstract class ScalarDS
extends Dataset {
    private static final long serialVersionUID = 8925371455928203981L;
    public static final int INTERLACE_PIXEL = 0;
    public static final int INTERLACE_LINE = 1;
    public static final int INTERLACE_PLANE = 2;
    protected int interlace = -1;
    protected double[] imageDataRange;
    protected byte[][] palette = null;
    protected boolean isImage = false;
    protected boolean isTrueColor = false;
    protected boolean isText = false;
    protected boolean isUnsigned = false;
    protected boolean unsignedConverted;
    protected Object fillValue = null;
    protected boolean isImageDisplay;
    protected boolean isDefaultImageOrder;
    public boolean isFillValueConverted;

    public ScalarDS(FileFormat fileFormat, String string, String string2) {
        this(fileFormat, string, string2, null);
    }

    @Deprecated
    public ScalarDS(FileFormat fileFormat, String string, String string2, long[] lArray) {
        super(fileFormat, string, string2, lArray);
        this.datatype = null;
        this.imageDataRange = null;
        this.isImageDisplay = false;
        this.isDefaultImageOrder = true;
        this.isFillValueConverted = false;
    }

    @Override
    public void clearData() {
        super.clearData();
        this.unsignedConverted = false;
    }

    public Object convertFromUnsignedC() {
        if (this.data != null && this.isUnsigned && !this.unsignedConverted) {
            this.originalBuf = this.data;
            this.data = this.convertedBuf = ScalarDS.convertFromUnsignedC(this.originalBuf, this.convertedBuf);
            this.unsignedConverted = true;
            if (this.fillValue != null && !this.isFillValueConverted) {
                this.fillValue = ScalarDS.convertFromUnsignedC(this.fillValue, null);
                this.isFillValueConverted = true;
            }
        }
        return this.data;
    }

    public Object convertToUnsignedC() {
        if (this.data != null && this.isUnsigned) {
            this.convertedBuf = this.data;
            this.data = this.originalBuf = ScalarDS.convertToUnsignedC(this.convertedBuf, this.originalBuf);
        }
        return this.data;
    }

    public abstract byte[][] getPalette();

    public final void setPalette(byte[][] byArray) {
        this.palette = byArray;
    }

    public abstract byte[][] readPalette(int var1);

    public String getPaletteName(int n) {
        String string = "Default ";
        if (n != 0) {
            string = "Default " + n;
        }
        return string;
    }

    public abstract byte[] getPaletteRefs();

    public final boolean isImage() {
        return this.isImage;
    }

    public final boolean isImageDisplay() {
        return this.isImageDisplay;
    }

    public final boolean isDefaultImageOrder() {
        return this.isDefaultImageOrder;
    }

    public final void setIsImageDisplay(boolean bl) {
        this.isImageDisplay = bl;
        if (this.isImageDisplay) {
            this.enumConverted = false;
        }
    }

    public final void setIsImage(boolean bl) {
        this.isImage = bl;
        if (this.isImage) {
            this.enumConverted = false;
        }
    }

    public final boolean isTrueColor() {
        return this.isTrueColor;
    }

    public final boolean isText() {
        return this.isText;
    }

    public final int getInterlace() {
        return this.interlace;
    }

    public final boolean isUnsigned() {
        return this.isUnsigned;
    }

    public double[] getImageDataRange() {
        return this.imageDataRange;
    }

    public final Object getFillValue() {
        return this.fillValue;
    }
}

