/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.object.h4;

import java.util.List;
import java.util.Vector;
import ncsa.hdf.hdflib.HDFException;
import ncsa.hdf.hdflib.HDFLibrary;
import ncsa.hdf.object.Attribute;
import ncsa.hdf.object.CompoundDS;
import ncsa.hdf.object.Dataset;
import ncsa.hdf.object.Datatype;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.h4.H4Datatype;

public class H4Vdata
extends CompoundDS {
    private static final long serialVersionUID = -5978700886955419959L;
    private List attributeList;
    private int numberOfRecords = 0;
    private int[] memberTIDs;
    private int nAttributes = -1;

    public H4Vdata(FileFormat fileFormat, String string, String string2) {
        this(fileFormat, string, string2, null);
    }

    public H4Vdata(FileFormat fileFormat, String string, String string2, long[] lArray) {
        super(fileFormat, string, string2, lArray);
        this.numberOfMembers = 0;
        this.memberOrders = null;
    }

    @Override
    public boolean hasAttribute() {
        if (this.nAttributes < 0) {
            int n = this.open();
            try {
                this.nAttributes = HDFLibrary.VSnattrs(n);
            }
            catch (Exception exception) {
                this.nAttributes = 0;
            }
            this.close(n);
        }
        return this.nAttributes > 0;
    }

    @Override
    public Datatype getDatatype() {
        if (this.datatype == null) {
            this.datatype = new H4Datatype(-1);
        }
        return this.datatype;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] readBytes() throws HDFException {
        byte[] byArray = null;
        if (this.rank <= 0) {
            this.init();
        }
        if (this.numberOfMembers <= 0) {
            return null;
        }
        int n = this.open();
        if (n < 0) {
            return null;
        }
        String string = this.memberNames[0];
        for (int i = 0; i < this.numberOfMembers; ++i) {
            string = string + "," + this.memberNames[i];
        }
        try {
            HDFLibrary.VSseek(n, (int)this.startDims[0]);
            HDFLibrary.VSsetfields(n, string);
            int[] nArray = new int[]{0};
            HDFLibrary.VSQueryvsize(n, nArray);
            int n2 = nArray[0] * (int)this.selectedDims[0];
            byArray = new byte[n2];
            int n3 = HDFLibrary.VSread(n, byArray, (int)this.selectedDims[0], 0);
        }
        finally {
            this.close(n);
        }
        return byArray;
    }

    @Override
    public Object read() throws HDFException {
        Vector<String[]> vector = null;
        if (this.rank <= 0) {
            this.init();
        }
        if (this.numberOfMembers <= 0) {
            return null;
        }
        int n = this.open();
        if (n < 0) {
            return null;
        }
        vector = new Vector<String[]>();
        HDFLibrary.HXsetdir(this.getFileFormat().getParent());
        Object object = null;
        for (int i = 0; i < this.numberOfMembers; ++i) {
            block12: {
                if (!this.isMemberSelected[i]) continue;
                try {
                    HDFLibrary.VSseek(n, (int)this.startDims[0]);
                    HDFLibrary.VSsetfields(n, this.memberNames[i]);
                }
                catch (HDFException hDFException) {
                    this.isMemberSelected[i] = false;
                    continue;
                }
                int n2 = this.memberOrders[i] * (int)this.selectedDims[0];
                object = H4Datatype.allocateArray(this.memberTIDs[i], n2);
                if (object == null) {
                    String[] stringArray = new String[n2];
                    for (int j = 0; j < n2; ++j) {
                        stringArray[j] = "*error*";
                    }
                    vector.add(stringArray);
                    continue;
                }
                try {
                    int n3 = HDFLibrary.VSread(n, object, (int)this.selectedDims[0], 0);
                    if (this.memberTIDs[i] == 4 || this.memberTIDs[i] == 3) {
                        object = Dataset.byteToString((byte[])object, this.memberOrders[i]);
                        this.memberTypes[i] = new H4Datatype(3, this.memberOrders[i], -1, -1);
                        this.memberOrders[i] = 1;
                        break block12;
                    }
                    if (!H4Datatype.isUnsigned(this.memberTIDs[i])) break block12;
                    object = Dataset.convertFromUnsignedC(object);
                }
                catch (HDFException hDFException) {
                    String[] stringArray = new String[n2];
                    for (int j = 0; j < n2; ++j) {
                        stringArray[j] = "*error*";
                    }
                    vector.add(stringArray);
                    continue;
                }
            }
            vector.add((String[])object);
        }
        this.close(n);
        return vector;
    }

    @Override
    public void write(Object object) throws HDFException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getMetadata() throws HDFException {
        if (this.attributeList != null) {
            return this.attributeList;
        }
        int n = this.open();
        if (n < 0) {
            return this.attributeList;
        }
        int n2 = 0;
        try {
            n2 = HDFLibrary.VSnattrs(n);
            if (n2 <= 0) {
                List list = this.attributeList;
                return list;
            }
            this.attributeList = new Vector(n2, 5);
            boolean bl = false;
            String[] stringArray = new String[1];
            int[] nArray = new int[3];
            for (int i = 0; i < n2; ++i) {
                stringArray[0] = "";
                try {
                    bl = HDFLibrary.VSattrinfo(n, -1, i, stringArray, nArray);
                    nArray[0] = nArray[0] & 0xFFFFBFFF;
                }
                catch (HDFException hDFException) {
                    bl = false;
                }
                if (!bl) continue;
                long[] lArray = new long[]{nArray[1]};
                Attribute attribute = new Attribute(stringArray[0], new H4Datatype(nArray[0]), lArray);
                this.attributeList.add(attribute);
                String[] stringArray2 = H4Datatype.allocateArray(nArray[0], nArray[1]);
                try {
                    HDFLibrary.VSgetattr(n, -1, i, stringArray2);
                }
                catch (HDFException hDFException) {
                    stringArray2 = null;
                }
                if (stringArray2 == null) continue;
                if (nArray[0] == 4 || nArray[0] == 3) {
                    stringArray2 = Dataset.byteToString((byte[])stringArray2, nArray[1]);
                }
                attribute.setValue(stringArray2);
            }
        }
        finally {
            this.close(n);
        }
        return this.attributeList;
    }

    @Override
    public void writeMetadata(Object object) throws Exception {
        if (!(object instanceof Attribute)) {
            return;
        }
        this.getFileFormat().writeAttribute(this, (Attribute)object, true);
        if (this.attributeList == null) {
            this.attributeList = new Vector();
        }
        this.attributeList.add(object);
    }

    @Override
    public void removeMetadata(Object object) throws HDFException {
    }

    @Override
    public int open() {
        int n = -1;
        try {
            n = HDFLibrary.VSattach(this.getFID(), (int)this.oid[1], "w");
        }
        catch (HDFException hDFException) {
            n = -1;
        }
        if (n < 0) {
            try {
                n = HDFLibrary.VSattach(this.getFID(), (int)this.oid[1], "r");
            }
            catch (HDFException hDFException) {
                n = -1;
            }
        }
        return n;
    }

    @Override
    public void close(int n) {
        try {
            HDFLibrary.VSdetach(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void init() {
        if (this.rank > 0) {
            return;
        }
        int n = this.open();
        if (n < 0) {
            return;
        }
        try {
            this.numberOfMembers = HDFLibrary.VFnfields(n);
            this.numberOfRecords = HDFLibrary.VSelts(n);
        }
        catch (HDFException hDFException) {
            this.numberOfMembers = 0;
            this.numberOfRecords = 0;
        }
        this.rank = 1;
        this.dims = new long[1];
        this.dims[0] = this.numberOfRecords;
        this.selectedDims = new long[1];
        this.selectedDims[0] = this.numberOfRecords;
        this.selectedIndex[0] = 0;
        this.startDims = new long[1];
        this.startDims[0] = 0L;
        this.memberNames = new String[this.numberOfMembers];
        this.memberTIDs = new int[this.numberOfMembers];
        this.memberTypes = new Datatype[this.numberOfMembers];
        this.memberOrders = new int[this.numberOfMembers];
        this.isMemberSelected = new boolean[this.numberOfMembers];
        for (int i = 0; i < this.numberOfMembers; ++i) {
            this.isMemberSelected[i] = true;
            try {
                this.memberNames[i] = HDFLibrary.VFfieldname(n, i);
                this.memberTIDs[i] = HDFLibrary.VFfieldtype(n, i);
                this.memberTypes[i] = new H4Datatype(this.memberTIDs[i]);
                this.memberTIDs[i] = this.memberTIDs[i] & 0xFFFFBFFF;
                this.memberOrders[i] = HDFLibrary.VFfieldorder(n, i);
                continue;
            }
            catch (HDFException hDFException) {
                // empty catch block
            }
        }
        this.close(n);
    }

    public int getRecordCount() {
        return this.numberOfRecords;
    }

    public int getFieldCount() {
        return this.numberOfMembers;
    }

    public int[] getFieldOrders() {
        return this.memberOrders;
    }

    public List getMetadata(int ... nArray) throws Exception {
        throw new UnsupportedOperationException("getMetadata(int... attrPropList) is not supported");
    }
}

