/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.object.h5;

import java.lang.reflect.Array;
import java.util.List;
import java.util.Vector;
import ncsa.hdf.hdf5lib.H5;
import ncsa.hdf.hdf5lib.HDF5Constants;
import ncsa.hdf.hdf5lib.HDFNativeData;
import ncsa.hdf.hdf5lib.exceptions.HDF5Exception;
import ncsa.hdf.hdf5lib.structs.H5O_info_t;
import ncsa.hdf.object.Attribute;
import ncsa.hdf.object.CompoundDS;
import ncsa.hdf.object.Dataset;
import ncsa.hdf.object.Datatype;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.Group;
import ncsa.hdf.object.h5.H5Datatype;
import ncsa.hdf.object.h5.H5File;

public class H5CompoundDS
extends CompoundDS {
    private static final long serialVersionUID = -5968625125574032736L;
    private List<Attribute> attributeList;
    private int nAttributes = -1;
    private H5O_info_t obj_info = new H5O_info_t(-1L, -1L, 0, 0, -1L, 0L, 0L, 0L, 0L, null, null, null);
    private List<String> flatNameList;
    private List<Integer> flatTypeList;
    private boolean isExternal = false;

    public H5CompoundDS(FileFormat fileFormat, String string, String string2) {
        this(fileFormat, string, string2, null);
    }

    @Deprecated
    public H5CompoundDS(FileFormat fileFormat, String string, String string2, long[] lArray) {
        super(fileFormat, string, string2, lArray);
        if (lArray == null && fileFormat != null) {
            try {
                byte[] byArray = H5.H5Rcreate(fileFormat.getFID(), this.getFullName(), HDF5Constants.H5R_OBJECT, -1);
                this.oid = new long[1];
                this.oid[0] = HDFNativeData.byteToLong(byArray, 0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean hasAttribute() {
        this.obj_info.num_attrs = this.nAttributes;
        if (this.obj_info.num_attrs < 0L) {
            int n = -1;
            try {
                n = H5.H5Dopen(this.getFID(), this.getPath() + this.getName(), HDF5Constants.H5P_DEFAULT);
                this.obj_info = H5.H5Oget_info(n);
                this.nAttributes = (int)this.obj_info.num_attrs;
            }
            catch (Exception exception) {
                this.obj_info.num_attrs = 0L;
            }
            this.close(n);
        }
        return this.obj_info.num_attrs > 0L;
    }

    @Override
    public Datatype getDatatype() {
        if (this.datatype == null) {
            this.datatype = new H5Datatype(6, -1, -1, -1);
        }
        return this.datatype;
    }

    @Override
    public void clear() {
        super.clear();
        if (this.attributeList != null) {
            ((Vector)this.attributeList).setSize(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] readBytes() throws HDF5Exception {
        byte[] byArray = null;
        if (this.rank <= 0) {
            this.init();
        }
        int n = this.open();
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        try {
            int n5;
            long[] lArray = new long[]{1L};
            for (n5 = 0; n5 < this.selectedDims.length; ++n5) {
                lArray[0] = lArray[0] * this.selectedDims[n5];
            }
            n2 = H5.H5Dget_space(n);
            n3 = H5.H5Screate_simple(this.rank, this.selectedDims, null);
            if ((long)this.rank * this.dims[0] > 1L) {
                H5.H5Sselect_hyperslab(n2, HDF5Constants.H5S_SELECT_SET, this.startDims, this.selectedStride, this.selectedDims, null);
            }
            n4 = H5.H5Dget_type(n);
            n5 = H5.H5Tget_size(n4) * (int)lArray[0];
            byArray = new byte[n5];
            H5.H5Dread(n, n4, n3, n2, HDF5Constants.H5P_DEFAULT, byArray);
        }
        finally {
            try {
                H5.H5Sclose(n2);
            }
            catch (Exception exception) {}
            try {
                H5.H5Sclose(n3);
            }
            catch (Exception exception) {}
            try {
                H5.H5Tclose(n4);
            }
            catch (HDF5Exception hDF5Exception) {}
            this.close(n);
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object read() throws HDF5Exception {
        int n7;
        Vector<Object> vector = null;
        String[] stringArray = null;
        String string = null;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = 0;
        int[] nArray = new int[]{-1, -1};
        if (this.rank <= 0) {
            this.init();
        }
        if (this.numberOfMembers <= 0) {
            return null;
        }
        if (this.isExternal) {
            String string2 = this.getFileFormat().getAbsoluteFile().getParent();
            if (string2 == null) {
                string2 = ".";
            }
            H5.H5Dchdir_ext(string2);
        }
        int n = this.open();
        vector = new Vector<Object>(this.flatNameList.size());
        Vector<Integer> vector2 = new Vector<Integer>();
        try {
            int n2;
            long[] lArray = new long[]{1L};
            lArray[0] = this.selectHyperslab(n, nArray);
            n7 = this.flatNameList.size();
            n3 = H5.H5Dget_type(n);
            int n8 = H5.H5Tget_class(n3);
            if (n8 == HDF5Constants.H5T_ARRAY) {
                n2 = n3;
                n3 = H5.H5Tget_super(n2);
                try {
                    H5.H5Tclose(n2);
                }
                catch (HDF5Exception hDF5Exception) {
                    // empty catch block
                }
            }
            this.extractCompoundInfo(n3, null, null, vector2);
            for (n2 = 0; n2 < n7; ++n2) {
                Object object;
                boolean bl = false;
                if (!this.isMemberSelected[n2]) continue;
                string = new String(this.memberNames[n2]);
                n4 = vector2.get(n2);
                try {
                    n5 = H5.H5Tget_class(n4);
                    n6 = H5.H5Tget_size(n4);
                    stringArray = H5Datatype.allocateArray(n4, (int)lArray[0]);
                }
                catch (Exception exception) {
                    stringArray = null;
                }
                if (stringArray == null || H5.H5Tequal(n4, HDF5Constants.H5T_STD_REF_DSETREG)) {
                    String[] stringArray2 = new String[(int)lArray[0]];
                    object = "*unsupported*";
                    int n9 = 0;
                    while ((long)n9 < lArray[0]) {
                        stringArray2[n9] = object;
                        ++n9;
                    }
                    vector.add(stringArray2);
                    continue;
                }
                if (n5 == HDF5Constants.H5T_ARRAY) {
                    int n10 = H5.H5Tget_super(n4);
                    bl = H5.H5Tis_variable_str(n10);
                    n5 = H5.H5Tget_class(n10);
                    try {
                        H5.H5Tclose(n10);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                int n11 = -1;
                object = new int[]{n5, n6, 0};
                try {
                    n11 = this.createCompoundFieldType(n4, string, (int[])object);
                    try {
                        bl = bl || H5.H5Tis_variable_str(n4);
                        bl = bl || H5.H5Tdetect_class(n4, HDF5Constants.H5T_VLEN);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (bl) {
                        H5.H5DreadVL(n, n11, nArray[0], nArray[1], HDF5Constants.H5P_DEFAULT, stringArray);
                    } else {
                        H5.H5Dread(n, n11, nArray[0], nArray[1], HDF5Constants.H5P_DEFAULT, stringArray);
                    }
                }
                catch (HDF5Exception hDF5Exception) {
                    String[] stringArray3 = new String[(int)lArray[0]];
                    int n12 = 0;
                    while ((long)n12 < lArray[0]) {
                        stringArray3[n12] = "";
                        ++n12;
                    }
                    vector.add(stringArray3);
                    continue;
                }
                finally {
                    try {
                        H5.H5Tclose(n11);
                    }
                    catch (Exception exception) {}
                }
                if (!bl) {
                    String string3 = stringArray.getClass().getName();
                    char c = string3.charAt(string3.lastIndexOf("[") + 1);
                    if (n5 == HDF5Constants.H5T_STRING && this.convertByteToString) {
                        if (c == 'B') {
                            stringArray = H5CompoundDS.byteToString((byte[])stringArray, n6 / this.memberOrders[n2]);
                        }
                    } else if (n5 == HDF5Constants.H5T_REFERENCE) {
                        if (c == 'B') {
                            stringArray = (String[])HDFNativeData.byteToLong((byte[])stringArray);
                        }
                    } else if (object[2] != false) {
                        stringArray = Dataset.convertFromUnsignedC(stringArray, null);
                    } else if (n5 == HDF5Constants.H5T_ENUM && this.enumConverted) {
                        try {
                            String[] stringArray4 = H5Datatype.convertEnumValueToName(n4, stringArray, null);
                            if (stringArray4 != null) {
                                stringArray = stringArray4;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                vector.add(stringArray);
            }
        }
        catch (Throwable throwable) {
            try {
                H5.H5Sclose(nArray[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                H5.H5Sclose(nArray[1]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                H5.H5Tclose(n3);
            }
            catch (Exception exception) {
                // empty catch block
            }
            int n14 = vector2.size();
            int i = 0;
            while (true) {
                if (i >= n14) {
                    this.close(n);
                    throw throwable;
                }
                n4 = (Integer)vector2.get(i);
                try {
                    H5.H5Tclose(n4);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++i;
            }
        }
        try {
            H5.H5Sclose(nArray[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            H5.H5Sclose(nArray[1]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            H5.H5Tclose(n3);
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n13 = vector2.size();
        n7 = 0;
        while (true) {
            if (n7 >= n13) {
                this.close(n);
                return vector;
            }
            n4 = vector2.get(n7);
            try {
                H5.H5Tclose(n4);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n7;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void write(Object object) throws HDF5Exception {
        int n6;
        if (object == null || this.numberOfMembers <= 0 || !(object instanceof List)) {
            return;
        }
        List list = (List)object;
        Object object2 = null;
        String string = null;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = 0;
        int[] nArray = new int[]{-1, -1};
        int n = this.open();
        Vector<Integer> vector = new Vector<Integer>();
        try {
            long[] lArray = new long[]{1L};
            lArray[0] = this.selectHyperslab(n, nArray);
            n6 = 0;
            int n7 = this.flatNameList.size();
            boolean bl = false;
            n2 = H5.H5Dget_type(n);
            this.extractCompoundInfo(n2, null, null, vector);
            for (int i = 0; i < n7; ++i) {
                if (!this.isMemberSelected[i]) continue;
                string = new String(this.memberNames[i]);
                n3 = vector.get(i);
                if ((object2 = (Object)list.get(n6++)) == null) continue;
                boolean bl2 = false;
                try {
                    bl2 = H5.H5Tdetect_class(n3, HDF5Constants.H5T_VLEN);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (bl2) continue;
                try {
                    n4 = H5.H5Tget_class(n3);
                    n5 = H5.H5Tget_size(n3);
                    bl = n4 == HDF5Constants.H5T_ENUM;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Object object3 = object2;
                int n8 = -1;
                int[] nArray2 = new int[]{n4, n5, 0};
                try {
                    n8 = this.createCompoundFieldType(n3, string, nArray2);
                    if (nArray2[2] != 0) {
                        object3 = H5CompoundDS.convertToUnsignedC(object2, null);
                    } else if (n4 == HDF5Constants.H5T_STRING && Array.get(object2, 0) instanceof String) {
                        object3 = H5CompoundDS.stringToByte((String[])object2, n5);
                    } else if (bl && Array.get(object2, 0) instanceof String) {
                        object3 = H5Datatype.convertEnumNameToValue(n3, (String[])object2, null);
                    }
                    if (object3 == null) continue;
                    H5.H5Dwrite(n, n8, nArray[0], nArray[1], HDF5Constants.H5P_DEFAULT, object3);
                    continue;
                }
                finally {
                    try {
                        H5.H5Tclose(n8);
                    }
                    catch (Exception exception) {}
                }
            }
        }
        catch (Throwable throwable) {
            try {
                H5.H5Sclose(nArray[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                H5.H5Sclose(nArray[1]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                H5.H5Tclose(n2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            int n10 = vector.size();
            int i = 0;
            while (true) {
                if (i >= n10) {
                    throw throwable;
                }
                n3 = (Integer)vector.get(i);
                try {
                    H5.H5Tclose(n3);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++i;
            }
        }
        try {
            H5.H5Sclose(nArray[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            H5.H5Sclose(nArray[1]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            H5.H5Tclose(n2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n9 = vector.size();
        n6 = 0;
        while (true) {
            if (n6 >= n9) {
                this.close(n);
                return;
            }
            n3 = vector.get(n6);
            try {
                H5.H5Tclose(n3);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n6;
        }
    }

    private long selectHyperslab(int n, int[] nArray) throws HDF5Exception {
        long l = 1L;
        boolean bl = true;
        for (int i = 0; i < this.rank; ++i) {
            l *= this.selectedDims[i];
            if (this.selectedDims[i] >= this.dims[i]) continue;
            bl = false;
        }
        if (bl) {
            nArray[0] = HDF5Constants.H5S_ALL;
            nArray[1] = HDF5Constants.H5S_ALL;
        } else {
            nArray[1] = H5.H5Dget_space(n);
            nArray[0] = H5.H5Screate_simple(this.rank, this.selectedDims, null);
            H5.H5Sselect_hyperslab(nArray[1], HDF5Constants.H5S_SELECT_SET, this.startDims, this.selectedStride, this.selectedDims, null);
        }
        return l;
    }

    @Override
    public List<Attribute> getMetadata() throws HDF5Exception {
        return this.getMetadata(this.fileFormat.getIndexType(null), this.fileFormat.getIndexOrder(null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Attribute> getMetadata(int ... nArray) throws HDF5Exception {
        if (this.rank <= 0) {
            this.init();
        }
        try {
            this.linkTargetObjName = H5File.getLinkTargetName(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.attributeList != null) {
            return this.attributeList;
        }
        int n = -1;
        int n2 = -1;
        int n3 = this.fileFormat.getIndexType(null);
        int n4 = this.fileFormat.getIndexOrder(null);
        if (nArray.length > 0) {
            n3 = nArray[0];
            if (nArray.length > 1) {
                n4 = nArray[1];
            }
        }
        try {
            n = this.open();
            this.attributeList = H5File.getAttribute(n, n3, n4);
            n2 = H5.H5Dget_create_plist(n);
            if (H5.H5Pget_layout(n2) == HDF5Constants.H5D_CHUNKED) {
                this.chunkSize = new long[this.rank];
                H5.H5Pget_chunk(n2, this.rank, this.chunkSize);
            } else {
                this.chunkSize = null;
            }
            int[] nArray2 = new int[]{0, 0};
            long[] lArray = new long[]{2L};
            int[] nArray3 = new int[]{0, 0};
            String[] stringArray = new String[]{"", ""};
            int n5 = H5.H5Pget_nfilters(n2);
            int n6 = -1;
            int[] nArray4 = new int[]{1};
            this.compression = "";
            for (int i = 0; i < n5; ++i) {
                if (i > 0) {
                    this.compression = this.compression + ", ";
                }
                try {
                    n6 = H5.H5Pget_filter(n2, i, nArray2, lArray, nArray3, 120L, stringArray, nArray4);
                }
                catch (Throwable throwable) {
                    this.compression = this.compression + "ERROR";
                    continue;
                }
                if (n6 == HDF5Constants.H5Z_FILTER_DEFLATE) {
                    this.compression = this.compression + "GZIP: level = " + nArray3[0];
                    continue;
                }
                if (n6 == HDF5Constants.H5Z_FILTER_FLETCHER32) {
                    this.compression = this.compression + "Error detection filter";
                    continue;
                }
                if (n6 == HDF5Constants.H5Z_FILTER_SHUFFLE) {
                    this.compression = this.compression + "SHUFFLE: Nbytes = " + nArray3[0];
                    continue;
                }
                if (n6 != HDF5Constants.H5Z_FILTER_SZIP) continue;
                this.compression = this.compression + "SZIP: Pixels per block = " + nArray3[1];
                int n7 = -1;
                try {
                    n7 = H5.H5Zget_filter_info(n6);
                }
                catch (Exception exception) {
                    n7 = -1;
                }
                if (n7 == HDF5Constants.H5Z_FILTER_CONFIG_DECODE_ENABLED) {
                    this.compression = this.compression + ": H5Z_FILTER_CONFIG_DECODE_ENABLED";
                    continue;
                }
                if (n7 != HDF5Constants.H5Z_FILTER_CONFIG_ENCODE_ENABLED && n7 < HDF5Constants.H5Z_FILTER_CONFIG_ENCODE_ENABLED + HDF5Constants.H5Z_FILTER_CONFIG_DECODE_ENABLED) continue;
                this.compression = this.compression + ": H5Z_FILTER_CONFIG_ENCODE_ENABLED";
            }
            if (this.compression.length() == 0) {
                this.compression = "NONE";
            }
            try {
                int[] nArray5 = new int[]{0};
                H5.H5Pget_alloc_time(n2, nArray5);
                this.compression = this.compression + ",         Storage allocation time: ";
                if (nArray5[0] == HDF5Constants.H5D_ALLOC_TIME_EARLY) {
                    this.compression = this.compression + "Early";
                } else if (nArray5[0] == HDF5Constants.H5D_ALLOC_TIME_INCR) {
                    this.compression = this.compression + "Incremental";
                } else if (nArray5[0] == HDF5Constants.H5D_ALLOC_TIME_LATE) {
                    this.compression = this.compression + "Late";
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        finally {
            try {
                H5.H5Pclose(n2);
            }
            catch (Exception exception) {}
            this.close(n);
        }
        return this.attributeList;
    }

    @Override
    public void writeMetadata(Object object) throws Exception {
        if (!(object instanceof Attribute)) {
            return;
        }
        boolean bl = false;
        Attribute attribute = (Attribute)object;
        if (this.attributeList == null) {
            this.getMetadata();
        }
        if (this.attributeList != null) {
            bl = this.attributeList.contains(attribute);
        }
        this.getFileFormat().writeAttribute(this, attribute, bl);
        if (!bl) {
            this.attributeList.add(attribute);
            this.nAttributes = this.attributeList.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMetadata(Object object) throws HDF5Exception {
        if (!(object instanceof Attribute)) {
            return;
        }
        Attribute attribute = (Attribute)object;
        int n = this.open();
        try {
            H5.H5Adelete(n, attribute.getName());
            List<Attribute> list = this.getMetadata();
            list.remove(attribute);
            this.nAttributes = list.size();
        }
        finally {
            this.close(n);
        }
    }

    @Override
    public int open() {
        int n = -1;
        try {
            n = H5.H5Dopen(this.getFID(), this.getPath() + this.getName(), HDF5Constants.H5P_DEFAULT);
        }
        catch (HDF5Exception hDF5Exception) {
            n = -1;
        }
        return n;
    }

    @Override
    public void close(int n) {
        try {
            H5.H5Fflush(n, HDF5Constants.H5F_SCOPE_LOCAL);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            H5.H5Dclose(n);
        }
        catch (HDF5Exception hDF5Exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        int n;
        block48: {
            if (this.rank > 0) {
                this.resetSelection();
                return;
            }
            n = -1;
            int n2 = -1;
            int n3 = -1;
            int n4 = -1;
            String string = this.getPath() + this.getName();
            this.flatNameList = new Vector<String>();
            this.flatTypeList = new Vector<Integer>();
            int[] nArray = null;
            n = this.open();
            int n5 = -1;
            try {
                n5 = H5.H5Dget_create_plist(n);
                int n6 = H5.H5Pget_external_count(n5);
                this.isExternal = n6 > 0;
            }
            catch (Exception exception) {
            }
            finally {
                try {
                    H5.H5Pclose(n5);
                }
                catch (Exception exception) {}
            }
            try {
                n2 = H5.H5Dget_space(n);
                this.rank = H5.H5Sget_simple_extent_ndims(n2);
                if (this.rank == 0) {
                    this.rank = 1;
                    this.dims = new long[1];
                    this.dims[0] = 1L;
                } else {
                    this.dims = new long[this.rank];
                    this.maxDims = new long[this.rank];
                    H5.H5Sget_simple_extent_dims(n2, this.dims, this.maxDims);
                }
                this.startDims = new long[this.rank];
                this.selectedDims = new long[this.rank];
                n3 = H5.H5Dget_type(n);
                n4 = H5.H5Tget_class(n3);
                int n7 = 0;
                if (n4 == HDF5Constants.H5T_ARRAY) {
                    n7 = n3;
                    n3 = H5.H5Tget_super(n7);
                    try {
                        H5.H5Tclose(n7);
                    }
                    catch (HDF5Exception hDF5Exception) {
                        // empty catch block
                    }
                }
                this.extractCompoundInfo(n3, "", this.flatNameList, this.flatTypeList);
                this.numberOfMembers = this.flatNameList.size();
                this.memberNames = new String[this.numberOfMembers];
                nArray = new int[this.numberOfMembers];
                this.memberTypes = new Datatype[this.numberOfMembers];
                this.memberOrders = new int[this.numberOfMembers];
                this.isMemberSelected = new boolean[this.numberOfMembers];
                this.memberDims = new Object[this.numberOfMembers];
                for (int i = 0; i < this.numberOfMembers; ++i) {
                    this.isMemberSelected[i] = true;
                    nArray[i] = this.flatTypeList.get(i);
                    this.memberTypes[i] = new H5Datatype(nArray[i]);
                    this.memberNames[i] = this.flatNameList.get(i);
                    this.memberOrders[i] = 1;
                    this.memberDims[i] = null;
                    try {
                        n4 = H5.H5Tget_class(nArray[i]);
                    }
                    catch (HDF5Exception hDF5Exception) {
                        // empty catch block
                    }
                    if (n4 != HDF5Constants.H5T_ARRAY) continue;
                    int n8 = H5.H5Tget_array_ndims(nArray[i]);
                    long[] lArray = new long[n8];
                    H5.H5Tget_array_dims(nArray[i], lArray);
                    int[] nArray2 = new int[n8];
                    for (int j = 0; j < n8; ++j) {
                        nArray2[j] = (int)lArray[j];
                    }
                    this.memberDims[i] = nArray2;
                    n7 = H5.H5Tget_super(nArray[i]);
                    this.memberOrders[i] = H5.H5Tget_size(nArray[i]) / H5.H5Tget_size(n7);
                    try {
                        H5.H5Tclose(n7);
                        continue;
                    }
                    catch (HDF5Exception hDF5Exception) {
                        // empty catch block
                    }
                }
            }
            catch (HDF5Exception hDF5Exception) {
                this.numberOfMembers = 0;
                this.memberNames = null;
                this.memberTypes = null;
                this.memberOrders = null;
            }
            finally {
                try {
                    H5.H5Tclose(n3);
                }
                catch (HDF5Exception hDF5Exception) {}
                try {
                    H5.H5Sclose(n2);
                }
                catch (HDF5Exception hDF5Exception) {}
                if (nArray == null) break block48;
                for (int i = 0; i < nArray.length; ++i) {
                    try {
                        H5.H5Tclose((int)nArray[i]);
                        continue;
                    }
                    catch (Exception exception) {}
                }
            }
        }
        this.close(n);
        this.resetSelection();
    }

    @Override
    public void setName(String string) throws Exception {
        H5File.renameObject(this, string);
        super.setName(string);
    }

    private void resetSelection() {
        for (int i = 0; i < this.rank; ++i) {
            this.startDims[i] = 0L;
            this.selectedDims[i] = 1L;
            if (this.selectedStride == null) continue;
            this.selectedStride[i] = 1L;
        }
        if (this.rank == 1) {
            this.selectedIndex[0] = 0;
            this.selectedDims[0] = this.dims[0];
        } else if (this.rank == 2) {
            this.selectedIndex[0] = 0;
            this.selectedIndex[1] = 1;
            this.selectedDims[0] = this.dims[0];
            this.selectedDims[1] = this.dims[1];
        } else if (this.rank > 2) {
            this.selectedIndex[0] = this.rank - 2;
            this.selectedIndex[1] = this.rank - 1;
            this.selectedIndex[2] = this.rank - 3;
            this.selectedDims[this.rank - 1] = this.dims[this.rank - 1];
            this.selectedDims[this.rank - 2] = this.dims[this.rank - 2];
        }
        this.isDataLoaded = false;
        this.setMemberSelection(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractCompoundInfo(int n, String string, List<String> list, List<Integer> list2) {
        int n2 = 0;
        int n3 = -1;
        int n4 = -1;
        String string2 = null;
        try {
            n2 = H5.H5Tget_nmembers(n);
        }
        catch (Exception exception) {
            n2 = 0;
        }
        if (n2 <= 0) {
            return;
        }
        int n5 = -1;
        for (int i = 0; i < n2; ++i) {
            try {
                n4 = H5.H5Tget_member_type(n, i);
            }
            catch (Exception exception) {
                continue;
            }
            try {
                n5 = n4;
                n4 = H5.H5Tget_native_type(n5);
            }
            catch (HDF5Exception hDF5Exception) {
                continue;
            }
            finally {
                try {
                    H5.H5Tclose(n5);
                }
                catch (HDF5Exception hDF5Exception) {}
            }
            try {
                n3 = H5.H5Tget_class(n4);
            }
            catch (HDF5Exception hDF5Exception) {
                continue;
            }
            if (list != null) {
                string2 = string + H5.H5Tget_member_name(n, i);
            }
            if (n3 == HDF5Constants.H5T_COMPOUND) {
                this.extractCompoundInfo(n4, string2 + "\u0095", list, list2);
                continue;
            }
            if (n3 == HDF5Constants.H5T_ARRAY) {
                try {
                    n5 = H5.H5Tget_super(n4);
                    int n6 = H5.H5Tget_class(n5);
                    if (n6 == HDF5Constants.H5T_COMPOUND || n6 == HDF5Constants.H5T_ARRAY) {
                        continue;
                    }
                }
                catch (Exception exception) {
                    continue;
                }
                finally {
                    try {
                        H5.H5Tclose(n5);
                    }
                    catch (Exception exception) {}
                }
            }
            if (list != null) {
                list.add(string2);
            }
            list2.add(new Integer(n4));
        }
    }

    @Deprecated
    public static Dataset create(String string, Group group, long[] lArray, String[] stringArray, Datatype[] datatypeArray, int[] nArray, Object object) throws Exception {
        if (group == null || string == null || lArray == null || stringArray == null || datatypeArray == null || nArray == null) {
            return null;
        }
        int n = stringArray.length;
        int[] nArray2 = new int[n];
        long[][] lArray2 = new long[n][1];
        for (int i = 0; i < n; ++i) {
            nArray2[i] = 1;
            lArray2[i][0] = nArray[i];
        }
        return H5CompoundDS.create(string, group, lArray, stringArray, datatypeArray, nArray2, lArray2, object);
    }

    @Deprecated
    public static Dataset create(String string, Group group, long[] lArray, String[] stringArray, Datatype[] datatypeArray, int[] nArray, long[][] lArray2, Object object) throws Exception {
        return H5CompoundDS.create(string, group, lArray, null, null, -1, stringArray, datatypeArray, nArray, lArray2, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Dataset create(String string, Group group, long[] lArray, long[] lArray2, long[] lArray3, int n, String[] stringArray, Datatype[] datatypeArray, int[] nArray, long[][] lArray4, Object object) throws Exception {
        int n2;
        int n3;
        int n4;
        H5CompoundDS h5CompoundDS = null;
        String string2 = null;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        int n8 = -1;
        if (group == null || string == null || lArray == null || stringArray == null || datatypeArray == null || nArray == null || lArray4 == null) {
            return null;
        }
        H5File h5File = (H5File)group.getFileFormat();
        if (h5File == null) {
            return null;
        }
        String string3 = "/";
        if (!group.isRoot()) {
            string3 = group.getPath() + group.getName() + "/";
            if (string.endsWith("/")) {
                string = string.substring(0, string.length() - 1);
            }
            if ((n4 = string.lastIndexOf("/")) >= 0) {
                string = string.substring(n4 + 1);
            }
        }
        string2 = string3 + string;
        n4 = 0;
        int n9 = stringArray.length;
        int[] nArray2 = new int[n9];
        int n10 = 1;
        int n11 = lArray.length;
        for (n3 = 0; n3 < n9; ++n3) {
            n10 = 1;
            for (n2 = 0; n2 < nArray[n3]; ++n2) {
                n10 = (int)((long)n10 * lArray4[n3][n2]);
            }
            if (n10 > 1 && datatypeArray[n3].getDatatypeClass() != 3) {
                n2 = -1;
                try {
                    n2 = datatypeArray[n3].toNative();
                    nArray2[n3] = H5.H5Tarray_create(n2, nArray[n3], lArray4[n3]);
                }
                finally {
                    try {
                        H5.H5Tclose(n2);
                    }
                    catch (Exception exception) {}
                }
            }
            nArray2[n3] = datatypeArray[n3].toNative();
            n4 += H5.H5Tget_size(nArray2[n3]);
        }
        try {
            n7 = H5.H5Tcreate(HDF5Constants.H5T_COMPOUND, n4);
            n3 = 0;
            for (n2 = 0; n2 < n9; ++n2) {
                H5.H5Tinsert(n7, stringArray[n2], n3, nArray2[n2]);
                n3 += H5.H5Tget_size(nArray2[n2]);
            }
            n6 = H5.H5Screate_simple(n11, lArray, lArray2);
            n2 = 0;
            if (lArray2 != null) {
                for (int i = 0; i < lArray2.length; ++i) {
                    if (lArray2[i] == 0L) {
                        lArray2[i] = lArray[i];
                    } else if (lArray2[i] < 0L) {
                        lArray2[i] = HDF5Constants.H5S_UNLIMITED;
                    }
                    if (lArray2[i] == lArray[i]) continue;
                    n2 = 1;
                }
            }
            if (lArray3 == null && n2 != 0) {
                lArray3 = lArray;
            }
            n8 = HDF5Constants.H5P_DEFAULT;
            if (lArray3 != null) {
                n8 = H5.H5Pcreate(HDF5Constants.H5P_DATASET_CREATE);
                H5.H5Pset_layout(n8, HDF5Constants.H5D_CHUNKED);
                H5.H5Pset_chunk(n8, n11, lArray3);
                if (n > 0) {
                    H5.H5Pset_deflate(n8, n);
                }
            }
            int n12 = h5File.getFID();
            n5 = H5.H5Dcreate(n12, string2, n7, n6, HDF5Constants.H5P_DEFAULT, n8, HDF5Constants.H5P_DEFAULT);
        }
        finally {
            try {
                H5.H5Pclose(n8);
            }
            catch (HDF5Exception hDF5Exception) {}
            try {
                H5.H5Sclose(n6);
            }
            catch (HDF5Exception hDF5Exception) {}
            try {
                H5.H5Tclose(n7);
            }
            catch (HDF5Exception hDF5Exception) {}
            try {
                H5.H5Dclose(n5);
            }
            catch (HDF5Exception hDF5Exception) {}
            for (int i = 0; i < n9; ++i) {
                try {
                    H5.H5Tclose(nArray2[i]);
                    continue;
                }
                catch (HDF5Exception hDF5Exception) {}
            }
        }
        h5CompoundDS = new H5CompoundDS(h5File, string, string3);
        if (h5CompoundDS != null) {
            group.addToMemberList(h5CompoundDS);
            if (object != null) {
                h5CompoundDS.init();
                long[] lArray5 = h5CompoundDS.getSelectedDims();
                for (int i = 0; i < n11; ++i) {
                    lArray5[i] = lArray[i];
                }
                h5CompoundDS.write(object);
            }
        }
        return h5CompoundDS;
    }

    @Override
    public boolean isString(int n) {
        boolean bl = false;
        try {
            bl = HDF5Constants.H5T_STRING == H5.H5Tget_class(n);
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    @Override
    public int getSize(int n) {
        int n2 = -1;
        try {
            n2 = H5.H5Tget_size(n);
        }
        catch (Exception exception) {
            n2 = -1;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int createCompoundFieldType(int n, String string, int[] nArray) throws HDF5Exception {
        int n2;
        int n3 = -1;
        int n4 = n2 = n;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        int n8 = -1;
        try {
            int n9 = nArray[0];
            int n10 = nArray[1];
            if (n9 == HDF5Constants.H5T_ARRAY) {
                int n11 = H5.H5Tget_array_ndims(n);
                long[] lArray = new long[n11];
                H5.H5Tget_array_dims(n, lArray);
                n6 = n4 = H5.H5Tget_super(n);
                n8 = H5.H5Tget_native_type(n4);
                n7 = n2 = H5.H5Tarray_create(n8, n11, lArray);
            }
            try {
                if (H5Datatype.isUnsigned(n4)) {
                    nArray[2] = 1;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            n10 = H5.H5Tget_size(n);
            String string2 = string;
            n5 = H5.H5Tcopy(n2);
            int n12 = string.lastIndexOf("\u0095");
            while (n12 > 0) {
                string2 = string.substring(n12 + 1);
                n3 = H5.H5Tcreate(HDF5Constants.H5T_COMPOUND, n10);
                H5.H5Tinsert(n3, string2, 0L, n5);
                try {
                    H5.H5Tclose(n5);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                n5 = n3;
                string = string.substring(0, n12);
                n12 = string.lastIndexOf("\u0095");
            }
            n3 = H5.H5Tcreate(HDF5Constants.H5T_COMPOUND, n10);
            H5.H5Tinsert(n3, string, 0L, n5);
        }
        finally {
            try {
                H5.H5Tclose(n5);
            }
            catch (HDF5Exception hDF5Exception) {}
            try {
                H5.H5Tclose(n6);
            }
            catch (HDF5Exception hDF5Exception) {}
            try {
                H5.H5Tclose(n7);
            }
            catch (HDF5Exception hDF5Exception) {}
            try {
                H5.H5Tclose(n8);
            }
            catch (HDF5Exception hDF5Exception) {}
        }
        return n3;
    }
}

