/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.object.h5;

import java.lang.reflect.Array;
import java.util.List;
import java.util.Vector;
import ncsa.hdf.hdf5lib.H5;
import ncsa.hdf.hdf5lib.HDF5Constants;
import ncsa.hdf.hdf5lib.HDFNativeData;
import ncsa.hdf.hdf5lib.exceptions.HDF5Exception;
import ncsa.hdf.hdf5lib.structs.H5O_info_t;
import ncsa.hdf.object.Attribute;
import ncsa.hdf.object.Dataset;
import ncsa.hdf.object.Datatype;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.Group;
import ncsa.hdf.object.HObject;
import ncsa.hdf.object.ScalarDS;
import ncsa.hdf.object.h5.H5Datatype;
import ncsa.hdf.object.h5.H5File;

public class H5ScalarDS
extends ScalarDS {
    private static final long serialVersionUID = 2887517608230611642L;
    private List attributeList;
    private byte[] paletteRefs;
    private boolean isVLEN = false;
    private boolean isEnum = false;
    private boolean isExternal = false;
    private boolean isArrayOfCompound = false;
    private boolean isArrayOfVLEN = false;
    private boolean isNativeDatatype = true;
    private boolean isRegRef = false;
    private int nAttributes = -1;
    private H5O_info_t obj_info;

    public H5ScalarDS(FileFormat fileFormat, String string, String string2) {
        this(fileFormat, string, string2, null);
    }

    @Deprecated
    public H5ScalarDS(FileFormat fileFormat, String string, String string2, long[] lArray) {
        super(fileFormat, string, string2, lArray);
        this.unsignedConverted = false;
        this.paletteRefs = null;
        this.obj_info = new H5O_info_t(-1L, -1L, 0, 0, -1L, 0L, 0L, 0L, 0L, null, null, null);
        if (lArray == null && fileFormat != null) {
            try {
                byte[] byArray = H5.H5Rcreate(fileFormat.getFID(), this.getFullName(), HDF5Constants.H5R_OBJECT, -1);
                this.oid = new long[1];
                this.oid[0] = HDFNativeData.byteToLong(byArray, 0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasAttribute() {
        this.obj_info.num_attrs = this.nAttributes;
        if (this.obj_info.num_attrs < 0L) {
            int n;
            block56: {
                int n2;
                n = this.open();
                this.obj_info.num_attrs = 0L;
                int n3 = -1;
                int n4 = -1;
                int n5 = 0;
                try {
                    this.obj_info = H5.H5Oget_info(n);
                    this.nAttributes = (int)this.obj_info.num_attrs;
                    n5 = H5.H5Dget_type(n);
                    int n6 = H5.H5Tget_class(n5);
                    this.isText = n6 == HDF5Constants.H5T_STRING;
                    this.isVLEN = n6 == HDF5Constants.H5T_VLEN || H5.H5Tis_variable_str(n5);
                    this.isEnum = n6 == HDF5Constants.H5T_ENUM;
                    n3 = H5.H5Aopen_by_name(n, ".", "CLASS", HDF5Constants.H5P_DEFAULT, HDF5Constants.H5P_DEFAULT);
                    n4 = H5.H5Aget_type(n3);
                    n2 = H5.H5Tget_class(n4);
                    if (n2 == HDF5Constants.H5T_STRING) {
                        int n7 = H5.H5Tget_size(n4);
                        byte[] byArray = new byte[n7];
                        H5.H5Aread(n3, n4, byArray);
                        String string = new String(byArray).trim();
                        this.isImageDisplay = this.isImage = string.equalsIgnoreCase("IMAGE");
                    }
                }
                catch (Exception exception) {
                }
                finally {
                    try {
                        H5.H5Tclose(n4);
                    }
                    catch (HDF5Exception hDF5Exception) {}
                    try {
                        H5.H5Aclose(n3);
                    }
                    catch (HDF5Exception hDF5Exception) {}
                    try {
                        H5.H5Tclose(n5);
                    }
                    catch (HDF5Exception hDF5Exception) {}
                }
                int n8 = -1;
                try {
                    n3 = H5.H5Aopen_by_name(n, ".", "IMAGE_MINMAXRANGE", HDF5Constants.H5P_DEFAULT, HDF5Constants.H5P_DEFAULT);
                    if (n3 <= 0) break block56;
                    n2 = n4 = H5.H5Aget_type(n3);
                    n4 = H5.H5Tget_native_type(n2);
                    try {
                        H5.H5Tclose(n2);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    n8 = H5.H5Aget_space(n3);
                    long[] lArray = null;
                    int n9 = H5.H5Sget_simple_extent_ndims(n8);
                    if (n9 > 0) {
                        lArray = new long[n9];
                        H5.H5Sget_simple_extent_dims(n8, lArray, null);
                    }
                    long l = 1L;
                    for (int i = 0; i < lArray.length; ++i) {
                        l *= lArray[i];
                    }
                    Object object = H5Datatype.allocateArray(n4, (int)l);
                    if (object == null) break block56;
                    H5.H5Aread(n3, n4, object);
                    double d = 0.0;
                    double d2 = 0.0;
                    try {
                        d = Double.valueOf(Array.get(object, 0).toString());
                        d2 = Double.valueOf(Array.get(object, 1).toString());
                    }
                    catch (Exception exception) {
                        d2 = 0.0;
                        d = 0.0;
                    }
                    if (d2 > d) {
                        this.imageDataRange = new double[2];
                        this.imageDataRange[0] = d;
                        this.imageDataRange[1] = d2;
                    }
                }
                catch (Exception exception) {
                }
                finally {
                    try {
                        H5.H5Tclose(n4);
                    }
                    catch (HDF5Exception hDF5Exception) {}
                    try {
                        H5.H5Sclose(n8);
                    }
                    catch (HDF5Exception hDF5Exception) {}
                    try {
                        H5.H5Aclose(n3);
                    }
                    catch (HDF5Exception hDF5Exception) {}
                }
            }
            this.close(n);
        }
        return this.obj_info.num_attrs > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        if (this.rank > 0) {
            this.resetSelection();
            return;
        }
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        n = this.open();
        this.paletteRefs = this.getPaletteRefs(n);
        int n4 = -1;
        try {
            int n5;
            n2 = H5.H5Dget_space(n);
            n3 = H5.H5Dget_type(n);
            int n6 = H5.H5Tget_class(n3);
            this.rank = H5.H5Sget_simple_extent_ndims(n2);
            this.isText = n6 == HDF5Constants.H5T_STRING;
            this.isVLEN = n6 == HDF5Constants.H5T_VLEN || H5.H5Tis_variable_str(n3);
            this.isEnum = n6 == HDF5Constants.H5T_ENUM;
            this.isUnsigned = H5Datatype.isUnsigned(n3);
            this.isRegRef = H5.H5Tequal(n3, HDF5Constants.H5T_STD_REF_DSETREG);
            if (n6 == HDF5Constants.H5T_ARRAY) {
                n5 = H5.H5Tget_super(n3);
                int n7 = H5.H5Tget_class(n5);
                this.isArrayOfCompound = n7 == HDF5Constants.H5T_COMPOUND;
                this.isArrayOfVLEN = n7 == HDF5Constants.H5T_VLEN;
            }
            try {
                n4 = H5.H5Dget_create_plist(n);
                n5 = H5.H5Pget_external_count(n4);
                this.isExternal = n5 > 0;
            }
            catch (Exception exception) {
                // empty catch block
            }
            int n8 = 0;
            try {
                n8 = H5.H5Tget_native_type(n3);
                this.isNativeDatatype = H5.H5Tequal(n3, n8);
                int[] nArray = new int[]{0};
                if (H5.H5Pfill_value_defined(n4, nArray) >= 0 && nArray[0] == HDF5Constants.H5D_FILL_VALUE_USER_DEFINED) {
                    this.fillValue = H5Datatype.allocateArray(n8, 1);
                    try {
                        H5.H5Pget_fill_value(n4, n8, this.fillValue);
                    }
                    catch (Exception exception) {
                        this.fillValue = null;
                    }
                }
            }
            catch (HDF5Exception hDF5Exception) {
            }
            finally {
                try {
                    H5.H5Tclose(n8);
                }
                catch (HDF5Exception hDF5Exception) {}
                try {
                    H5.H5Pclose(n4);
                }
                catch (Exception exception) {}
            }
            if (this.rank == 0) {
                this.rank = 1;
                this.dims = new long[1];
                this.dims[0] = 1L;
            } else {
                this.dims = new long[this.rank];
                this.maxDims = new long[this.rank];
                H5.H5Sget_simple_extent_dims(n2, this.dims, this.maxDims);
            }
        }
        catch (HDF5Exception hDF5Exception) {
        }
        finally {
            try {
                H5.H5Tclose(n3);
            }
            catch (HDF5Exception hDF5Exception) {}
            try {
                H5.H5Sclose(n2);
            }
            catch (HDF5Exception hDF5Exception) {}
        }
        if (this.rank >= 3 && this.isImage) {
            this.interlace = -1;
            this.isTrueColor = this.isStringAttributeOf(n, "IMAGE_SUBCLASS", "IMAGE_TRUECOLOR");
            if (this.isTrueColor) {
                this.interlace = 0;
                if (this.isStringAttributeOf(n, "INTERLACE_MODE", "INTERLACE_PLANE")) {
                    this.interlace = 2;
                }
            }
        }
        this.close(n);
        this.startDims = new long[this.rank];
        this.selectedDims = new long[this.rank];
        this.resetSelection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isStringAttributeOf(int n, String string, String string2) {
        boolean bl = false;
        int n2 = -1;
        int n3 = -1;
        try {
            n2 = H5.H5Aopen_by_name(n, ".", string, HDF5Constants.H5P_DEFAULT, HDF5Constants.H5P_DEFAULT);
            n3 = H5.H5Aget_type(n2);
            int n4 = H5.H5Tget_size(n3);
            byte[] byArray = new byte[n4];
            H5.H5Aread(n2, n3, byArray);
            String string3 = new String(byArray).trim();
            bl = string3.equalsIgnoreCase(string2);
        }
        catch (Exception exception) {
        }
        finally {
            try {
                H5.H5Tclose(n3);
            }
            catch (HDF5Exception hDF5Exception) {}
            try {
                H5.H5Aclose(n2);
            }
            catch (HDF5Exception hDF5Exception) {}
        }
        return bl;
    }

    private void resetSelection() {
        for (int i = 0; i < this.rank; ++i) {
            this.startDims[i] = 0L;
            this.selectedDims[i] = 1L;
            if (this.selectedStride == null) continue;
            this.selectedStride[i] = 1L;
        }
        if (this.interlace == 0) {
            this.selectedDims[2] = 3L;
            this.selectedDims[0] = this.dims[0];
            this.selectedDims[1] = this.dims[1];
            this.selectedIndex[0] = 0;
            this.selectedIndex[1] = 1;
            this.selectedIndex[2] = 2;
        } else if (this.interlace == 2) {
            this.selectedDims[0] = 3L;
            this.selectedDims[1] = this.dims[1];
            this.selectedDims[2] = this.dims[2];
            this.selectedIndex[0] = 1;
            this.selectedIndex[1] = 2;
            this.selectedIndex[2] = 0;
        } else if (this.rank == 1) {
            this.selectedIndex[0] = 0;
            this.selectedDims[0] = this.dims[0];
        } else if (this.rank == 2) {
            this.selectedIndex[0] = 0;
            this.selectedIndex[1] = 1;
            this.selectedDims[0] = this.dims[0];
            this.selectedDims[1] = this.dims[1];
        } else if (this.rank > 2) {
            if (this.isImage) {
                this.selectedIndex[1] = this.rank - 1;
                this.selectedIndex[0] = this.rank - 2;
                this.selectedIndex[2] = this.rank - 3;
            } else {
                this.selectedIndex[0] = 0;
                this.selectedIndex[1] = 1;
                this.selectedIndex[2] = 2;
            }
            this.selectedDims[this.selectedIndex[0]] = this.dims[this.selectedIndex[0]];
            this.selectedDims[this.selectedIndex[1]] = this.dims[this.selectedIndex[1]];
        }
        if (this.rank > 1 && this.isText) {
            this.selectedIndex[0] = this.rank - 1;
            this.selectedIndex[1] = 0;
            this.selectedDims[0] = 1L;
            this.selectedDims[this.selectedIndex[0]] = this.dims[this.selectedIndex[0]];
        }
        this.isDataLoaded = false;
        this.isDefaultImageOrder = true;
    }

    @Override
    public void clear() {
        super.clear();
        if (this.attributeList != null) {
            ((Vector)this.attributeList).setSize(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dataset copy(Group group, String string, long[] lArray, Object object) throws Exception {
        if (group == null) {
            return null;
        }
        H5ScalarDS h5ScalarDS = null;
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        String string2 = null;
        String string3 = null;
        string3 = group.isRoot() ? "/" : group.getPath() + group.getName() + "/";
        string2 = string3 + string;
        try {
            n = this.open();
            n3 = H5.H5Dget_type(n);
            n4 = H5.H5Screate_simple(lArray.length, lArray, null);
            n5 = H5.H5Dget_create_plist(n);
            long[] lArray2 = new long[lArray.length];
            boolean bl = false;
            try {
                H5.H5Pget_chunk(n5, lArray.length, lArray2);
                for (int i = 0; i < lArray.length; ++i) {
                    if (lArray[i] >= lArray2[i]) continue;
                    bl = true;
                    lArray2[i] = lArray[i] == 1L ? 1L : lArray[i] / 2L;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (bl) {
                H5.H5Pset_chunk(n5, lArray.length, lArray2);
            }
            try {
                n2 = H5.H5Dcreate(group.getFID(), string2, n3, n4, HDF5Constants.H5P_DEFAULT, n5, HDF5Constants.H5P_DEFAULT);
            }
            catch (Exception exception) {
            }
            finally {
                try {
                    H5.H5Dclose(n2);
                }
                catch (Exception exception) {}
            }
            h5ScalarDS = new H5ScalarDS(group.getFileFormat(), string, string3);
            if (object != null) {
                ((Dataset)h5ScalarDS).init();
                ((Dataset)h5ScalarDS).write(object);
            }
            n2 = ((HObject)h5ScalarDS).open();
            H5File.copyAttributes(n, n2);
        }
        finally {
            try {
                H5.H5Pclose(n5);
            }
            catch (Exception exception) {}
            try {
                H5.H5Sclose(n4);
            }
            catch (Exception exception) {}
            try {
                H5.H5Tclose(n3);
            }
            catch (Exception exception) {}
            try {
                H5.H5Dclose(n);
            }
            catch (Exception exception) {}
            try {
                H5.H5Dclose(n2);
            }
            catch (Exception exception) {}
        }
        group.addToMemberList(h5ScalarDS);
        ((ScalarDS)h5ScalarDS).setIsImage(this.isImage);
        return h5ScalarDS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] readBytes() throws HDF5Exception {
        byte[] byArray = null;
        if (this.rank <= 0) {
            this.init();
        }
        int n = this.open();
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        try {
            int n5;
            long[] lArray = new long[]{1L};
            for (n5 = 0; n5 < this.selectedDims.length; ++n5) {
                lArray[0] = lArray[0] * this.selectedDims[n5];
            }
            n2 = H5.H5Dget_space(n);
            n3 = H5.H5Screate_simple(this.rank, this.selectedDims, null);
            if ((long)this.rank * this.dims[0] > 1L) {
                H5.H5Sselect_hyperslab(n2, HDF5Constants.H5S_SELECT_SET, this.startDims, this.selectedStride, this.selectedDims, null);
            }
            n4 = H5.H5Dget_type(n);
            n5 = H5.H5Tget_size(n4) * (int)lArray[0];
            byArray = new byte[n5];
            H5.H5Dread(n, n4, n3, n2, HDF5Constants.H5P_DEFAULT, byArray);
        }
        finally {
            try {
                H5.H5Sclose(n2);
            }
            catch (Exception exception) {}
            try {
                H5.H5Sclose(n3);
            }
            catch (Exception exception) {}
            try {
                H5.H5Tclose(n4);
            }
            catch (HDF5Exception hDF5Exception) {}
            this.close(n);
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object read() throws HDF5Exception {
        Object object;
        String[] stringArray = null;
        int n = -1;
        int n2 = -1;
        int[] nArray = new int[]{-1, -1};
        if (this.rank <= 0) {
            this.init();
        }
        if (this.isArrayOfCompound) {
            throw new HDF5Exception("Cannot show data with datatype of ARRAY of COMPOUND.");
        }
        if (this.isArrayOfVLEN) {
            throw new HDF5Exception("Cannot show data with datatype of ARRAY of VL.");
        }
        if (this.isExternal) {
            object = this.getFileFormat().getAbsoluteFile().getParent();
            if (object == null) {
                object = ".";
            }
            H5.H5Dchdir_ext((String)object);
        }
        object = new long[]{1L};
        try {
            n = this.open();
            object[0] = this.selectHyperslab(n, nArray);
            if (object[0] == 0L) {
                throw new HDF5Exception("No data to read.\nEither the dataset or the selected subset is empty.");
            }
            try {
                long l = H5.H5Dget_storage_size(n);
                if (l <= 0L) {
                    throw new HDF5Exception("Storage space is not allocated.");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            n2 = H5.H5Dget_type(n);
            if (!this.isNativeDatatype) {
                int n3 = -1;
                try {
                    n3 = n2;
                    n2 = H5.H5Tget_native_type(n3);
                }
                finally {
                    try {
                        H5.H5Tclose(n3);
                    }
                    catch (Exception exception) {}
                }
            }
            boolean bl = H5.H5Tequal(n2, HDF5Constants.H5T_STD_REF_OBJ);
            if (this.originalBuf == null || this.isText || bl || this.originalBuf != null && object[0] != this.nPoints) {
                try {
                    stringArray = H5Datatype.allocateArray(n2, (int)object[0]);
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    throw new HDF5Exception("Out Of Memory.");
                }
            } else {
                stringArray = this.originalBuf;
            }
            if (stringArray != null) {
                if (this.isVLEN) {
                    H5.H5DreadVL(n, n2, nArray[0], nArray[1], HDF5Constants.H5P_DEFAULT, stringArray);
                } else {
                    H5.H5Dread(n, n2, nArray[0], nArray[1], HDF5Constants.H5P_DEFAULT, stringArray);
                    if (this.isText && this.convertByteToString) {
                        stringArray = H5ScalarDS.byteToString((byte[])stringArray, H5.H5Tget_size(n2));
                    } else if (bl) {
                        stringArray = (String[])HDFNativeData.byteToLong((byte[])stringArray);
                    } else if (this.isEnum && this.isEnumConverted()) {
                        stringArray = H5Datatype.convertEnumValueToName(n2, stringArray, null);
                    }
                }
            }
        }
        finally {
            try {
                H5.H5Sclose(nArray[0]);
            }
            catch (Exception exception) {}
            try {
                H5.H5Sclose(nArray[1]);
            }
            catch (Exception exception) {}
            try {
                H5.H5Tclose(n2);
            }
            catch (Exception exception) {}
            this.close(n);
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(Object object) throws HDF5Exception {
        int n = -1;
        int n2 = -1;
        int[] nArray = new int[]{-1, -1};
        Object object2 = null;
        if (object == null) {
            return;
        }
        if (this.isVLEN && !this.isText) {
            throw new HDF5Exception("Writing non-string variable-length data is not supported");
        }
        if (this.isRegRef) {
            throw new HDF5Exception("Writing region references data is not supported");
        }
        long[] lArray = new long[]{1L};
        try {
            int n3;
            n = this.open();
            lArray[0] = this.selectHyperslab(n, nArray);
            n2 = H5.H5Dget_type(n);
            if (!this.isNativeDatatype) {
                n3 = -1;
                try {
                    n3 = n2;
                    n2 = H5.H5Tget_native_type(n3);
                }
                finally {
                    try {
                        H5.H5Tclose(n3);
                    }
                    catch (Exception exception) {}
                }
            }
            this.isText = H5.H5Tget_class(n2) == HDF5Constants.H5T_STRING;
            n3 = H5.H5Tget_size(n2);
            String string = object.getClass().getName();
            char c = string.charAt(string.lastIndexOf("[") + 1);
            boolean bl = n3 == 1 && c == 'S' || n3 == 2 && c == 'I' || n3 == 4 && c == 'J' || this.isUnsigned && this.unsignedConverted;
            object2 = object;
            if (bl) {
                object2 = H5ScalarDS.convertToUnsignedC(object, null);
            } else if (this.isText && this.convertByteToString && !H5.H5Tis_variable_str(n2)) {
                object2 = H5ScalarDS.stringToByte((String[])object, H5.H5Tget_size(n2));
            } else if (this.isEnum && Array.get(object, 0) instanceof String) {
                object2 = H5Datatype.convertEnumNameToValue(n2, (String[])object, null);
            }
            H5.H5Dwrite(n, n2, nArray[0], nArray[1], HDF5Constants.H5P_DEFAULT, object2);
        }
        finally {
            object2 = null;
            try {
                H5.H5Sclose(nArray[0]);
            }
            catch (Exception exception) {}
            try {
                H5.H5Sclose(nArray[1]);
            }
            catch (Exception exception) {}
            try {
                H5.H5Tclose(n2);
            }
            catch (Exception exception) {}
            this.close(n);
        }
    }

    private long selectHyperslab(int n, int[] nArray) throws HDF5Exception {
        long l = 1L;
        boolean bl = true;
        for (int i = 0; i < this.rank; ++i) {
            l *= this.selectedDims[i];
            if (this.selectedDims[i] >= this.dims[i]) continue;
            bl = false;
        }
        if (bl) {
            nArray[0] = HDF5Constants.H5S_ALL;
            nArray[1] = HDF5Constants.H5S_ALL;
        } else {
            nArray[1] = H5.H5Dget_space(n);
            nArray[0] = H5.H5Screate_simple(this.rank, this.selectedDims, null);
            H5.H5Sselect_hyperslab(nArray[1], HDF5Constants.H5S_SELECT_SET, this.startDims, this.selectedStride, this.selectedDims, null);
        }
        this.isDefaultImageOrder = this.rank <= 1 || this.selectedIndex[0] <= this.selectedIndex[1];
        return l;
    }

    @Override
    public List getMetadata() throws HDF5Exception {
        return this.getMetadata(this.fileFormat.getIndexType(null), this.fileFormat.getIndexOrder(null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getMetadata(int ... nArray) throws HDF5Exception {
        if (this.rank <= 0) {
            this.init();
        }
        try {
            this.linkTargetObjName = H5File.getLinkTargetName(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.attributeList != null) {
            return this.attributeList;
        }
        int n = -1;
        int n2 = -1;
        int n3 = this.fileFormat.getIndexType(null);
        int n4 = this.fileFormat.getIndexOrder(null);
        if (nArray.length > 0) {
            n3 = nArray[0];
            if (nArray.length > 1) {
                n4 = nArray[1];
            }
        }
        try {
            n = this.open();
            this.attributeList = H5File.getAttribute(n, n3, n4);
            n2 = H5.H5Dget_create_plist(n);
            if (H5.H5Pget_layout(n2) == HDF5Constants.H5D_CHUNKED) {
                this.chunkSize = new long[this.rank];
                H5.H5Pget_chunk(n2, this.rank, this.chunkSize);
            } else {
                this.chunkSize = null;
            }
            int[] nArray2 = new int[]{0, 0};
            long[] lArray = new long[]{2L};
            int[] nArray3 = new int[]{0, 0};
            String[] stringArray = new String[]{"", ""};
            int n5 = H5.H5Pget_nfilters(n2);
            int n6 = -1;
            int[] nArray4 = new int[]{1};
            this.compression = "";
            for (int i = 0; i < n5; ++i) {
                if (i > 0) {
                    this.compression = this.compression + ", ";
                }
                try {
                    n6 = H5.H5Pget_filter(n2, i, nArray2, lArray, nArray3, 120L, stringArray, nArray4);
                }
                catch (Throwable throwable) {
                    this.compression = this.compression + "ERROR";
                    continue;
                }
                if (n6 == HDF5Constants.H5Z_FILTER_DEFLATE) {
                    this.compression = this.compression + "GZIP: level = " + nArray3[0];
                    continue;
                }
                if (n6 == HDF5Constants.H5Z_FILTER_FLETCHER32) {
                    this.compression = this.compression + "Error detection filter";
                    continue;
                }
                if (n6 == HDF5Constants.H5Z_FILTER_SHUFFLE) {
                    this.compression = this.compression + "SHUFFLE: Nbytes = " + nArray3[0];
                    continue;
                }
                if (n6 != HDF5Constants.H5Z_FILTER_SZIP) continue;
                this.compression = this.compression + "SZIP: Pixels per block = " + nArray3[1];
                int n7 = -1;
                try {
                    n7 = H5.H5Zget_filter_info(n6);
                }
                catch (Exception exception) {
                    n7 = -1;
                }
                if (n7 == HDF5Constants.H5Z_FILTER_CONFIG_DECODE_ENABLED) {
                    this.compression = this.compression + ": H5Z_FILTER_CONFIG_DECODE_ENABLED";
                    continue;
                }
                if (n7 != HDF5Constants.H5Z_FILTER_CONFIG_ENCODE_ENABLED && n7 < HDF5Constants.H5Z_FILTER_CONFIG_ENCODE_ENABLED + HDF5Constants.H5Z_FILTER_CONFIG_DECODE_ENABLED) continue;
                this.compression = this.compression + ": H5Z_FILTER_CONFIG_ENCODE_ENABLED";
            }
            if (this.compression.length() == 0) {
                this.compression = "NONE";
            }
            try {
                int[] nArray5 = new int[]{0};
                H5.H5Pget_alloc_time(n2, nArray5);
                this.compression = this.compression + ",         Storage allocation time: ";
                if (nArray5[0] == HDF5Constants.H5D_ALLOC_TIME_EARLY) {
                    this.compression = this.compression + "Early";
                } else if (nArray5[0] == HDF5Constants.H5D_ALLOC_TIME_INCR) {
                    this.compression = this.compression + "Incremental";
                } else if (nArray5[0] == HDF5Constants.H5D_ALLOC_TIME_LATE) {
                    this.compression = this.compression + "Late";
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        finally {
            try {
                H5.H5Pclose(n2);
            }
            catch (Exception exception) {}
            this.close(n);
        }
        return this.attributeList;
    }

    @Override
    public void writeMetadata(Object object) throws Exception {
        if (!(object instanceof Attribute)) {
            return;
        }
        boolean bl = false;
        Attribute attribute = (Attribute)object;
        String string = attribute.getName();
        if (this.attributeList == null) {
            this.getMetadata();
        }
        if (this.attributeList != null) {
            bl = this.attributeList.contains(attribute);
        }
        this.getFileFormat().writeAttribute(this, attribute, bl);
        if (!bl) {
            this.attributeList.add(attribute);
            this.nAttributes = this.attributeList.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMetadata(Object object) throws HDF5Exception {
        if (!(object instanceof Attribute)) {
            return;
        }
        Attribute attribute = (Attribute)object;
        int n = this.open();
        try {
            H5.H5Adelete(n, attribute.getName());
            List list = this.getMetadata();
            list.remove(attribute);
            this.nAttributes = this.attributeList.size();
        }
        finally {
            this.close(n);
        }
    }

    @Override
    public int open() {
        int n = -1;
        try {
            n = H5.H5Dopen(this.getFID(), this.getPath() + this.getName(), HDF5Constants.H5P_DEFAULT);
        }
        catch (HDF5Exception hDF5Exception) {
            n = -1;
        }
        return n;
    }

    @Override
    public void close(int n) {
        try {
            H5.H5Fflush(n, HDF5Constants.H5F_SCOPE_LOCAL);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            H5.H5Dclose(n);
        }
        catch (HDF5Exception hDF5Exception) {
            // empty catch block
        }
    }

    @Override
    public byte[][] getPalette() {
        if (this.palette == null) {
            this.palette = this.readPalette(0);
        }
        return this.palette;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getPaletteName(int n) {
        byte[] byArray = this.getPaletteRefs();
        int n2 = -1;
        int n3 = -1;
        String[] stringArray = new String[]{""};
        long l = 100L;
        if (byArray == null) {
            return null;
        }
        byte[] byArray2 = new byte[8];
        try {
            System.arraycopy(byArray, n * 8, byArray2, 0, 8);
        }
        catch (Throwable throwable) {
            return null;
        }
        try {
            n2 = this.open();
            n3 = H5.H5Rdereference(this.getFID(), HDF5Constants.H5R_OBJECT, byArray2);
            H5.H5Iget_name(n3, stringArray, l);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            this.close(n3);
            this.close(n2);
        }
        return stringArray[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[][] readPalette(int n) {
        byte[][] byArray = null;
        byte[] byArray2 = this.getPaletteRefs();
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        if (byArray2 == null) {
            return null;
        }
        byte[] byArray3 = null;
        byte[] byArray4 = new byte[8];
        try {
            System.arraycopy(byArray2, n * 8, byArray4, 0, 8);
        }
        catch (Throwable throwable) {
            return null;
        }
        try {
            n2 = this.open();
            n3 = H5.H5Rdereference(this.getFID(), HDF5Constants.H5R_OBJECT, byArray4);
            n4 = H5.H5Dget_type(n3);
            if (H5.H5Dget_storage_size(n3) <= 768L) {
                byArray3 = new byte[768];
                H5.H5Dread(n3, n4, HDF5Constants.H5S_ALL, HDF5Constants.H5S_ALL, HDF5Constants.H5P_DEFAULT, byArray3);
            }
        }
        catch (HDF5Exception hDF5Exception) {
            byArray3 = null;
        }
        finally {
            try {
                H5.H5Tclose(n4);
            }
            catch (HDF5Exception hDF5Exception) {}
            this.close(n3);
            this.close(n2);
        }
        if (byArray3 != null) {
            byArray = new byte[3][256];
            for (int i = 0; i < 256; ++i) {
                byArray[0][i] = byArray3[i * 3];
                byArray[1][i] = byArray3[i * 3 + 1];
                byArray[2][i] = byArray3[i * 3 + 2];
            }
        }
        return byArray;
    }

    private static byte[] parseFillValue(Datatype datatype, Object object) throws Exception {
        byte[] byArray = null;
        if (datatype == null || object == null) {
            return null;
        }
        int n = datatype.getDatatypeClass();
        int n2 = datatype.getDatatypeSize();
        double d = 0.0;
        String string = null;
        if (object instanceof String) {
            string = (String)object;
        } else if (object.getClass().isArray()) {
            string = Array.get(object, 0).toString();
        }
        if (n != 3) {
            try {
                d = Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        try {
            switch (n) {
                case 0: 
                case 2: 
                case 8: {
                    if (n2 == 1) {
                        byArray = new byte[]{(byte)d};
                        break;
                    }
                    if (n2 == 2) {
                        byArray = HDFNativeData.shortToByte((short)d);
                        break;
                    }
                    if (n2 == 8) {
                        byArray = HDFNativeData.longToByte((long)d);
                        break;
                    }
                    byArray = HDFNativeData.intToByte((int)d);
                    break;
                }
                case 1: {
                    if (n2 == 8) {
                        byArray = HDFNativeData.doubleToByte(d);
                        break;
                    }
                    byArray = HDFNativeData.floatToByte((float)d);
                    break;
                }
                case 3: {
                    byArray = string.getBytes();
                    break;
                }
                case 7: {
                    byArray = HDFNativeData.longToByte((long)d);
                }
            }
        }
        catch (Exception exception) {
            byArray = null;
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static H5ScalarDS create(String string, Group group, Datatype datatype, long[] lArray, long[] lArray2, long[] lArray3, int n, Object object, Object object2) throws Exception {
        int n2;
        int n3;
        H5ScalarDS h5ScalarDS = null;
        String string2 = null;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        if (group == null || string == null || lArray == null || n > 0 && lArray3 == null) {
            return null;
        }
        H5File h5File = (H5File)group.getFileFormat();
        if (h5File == null) {
            return null;
        }
        String string3 = "/";
        if (!group.isRoot()) {
            string3 = group.getPath() + group.getName() + "/";
            if (string.endsWith("/")) {
                string = string.substring(0, string.length() - 1);
            }
            if ((n3 = string.lastIndexOf("/")) >= 0) {
                string = string.substring(n3 + 1);
            }
        }
        string2 = string3 + string;
        n3 = 0;
        if (lArray2 != null) {
            for (n2 = 0; n2 < lArray2.length; ++n2) {
                if (lArray2[n2] == 0L) {
                    lArray2[n2] = lArray[n2];
                } else if (lArray2[n2] < 0L) {
                    lArray2[n2] = HDF5Constants.H5S_UNLIMITED;
                }
                if (lArray2[n2] == lArray[n2]) continue;
                n3 = 1;
            }
        }
        if (lArray3 == null && n3 != 0) {
            lArray3 = new long[lArray.length];
            for (n2 = 0; n2 < lArray.length; ++n2) {
                lArray3[n2] = Math.min(lArray[n2], 64L);
            }
        }
        n2 = lArray.length;
        try {
            n5 = datatype.toNative();
            n6 = H5.H5Screate_simple(n2, lArray, lArray2);
            n7 = HDF5Constants.H5P_DEFAULT;
            byte[] byArray = null;
            try {
                byArray = H5ScalarDS.parseFillValue(datatype, object);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (lArray3 != null || byArray != null) {
                n7 = H5.H5Pcreate(HDF5Constants.H5P_DATASET_CREATE);
                if (lArray3 != null) {
                    H5.H5Pset_layout(n7, HDF5Constants.H5D_CHUNKED);
                    H5.H5Pset_chunk(n7, n2, lArray3);
                }
                if (byArray != null) {
                    H5.H5Pset_fill_value(n7, n5, byArray);
                }
            }
            if (n > 0) {
                H5.H5Pset_deflate(n7, n);
            }
            int n8 = h5File.getFID();
            n4 = H5.H5Dcreate(n8, string2, n5, n6, HDF5Constants.H5P_DEFAULT, n7, HDF5Constants.H5P_DEFAULT);
            h5ScalarDS = new H5ScalarDS(h5File, string, string3);
        }
        finally {
            try {
                H5.H5Pclose(n7);
            }
            catch (HDF5Exception hDF5Exception) {}
            try {
                H5.H5Sclose(n6);
            }
            catch (HDF5Exception hDF5Exception) {}
            try {
                H5.H5Tclose(n5);
            }
            catch (HDF5Exception hDF5Exception) {}
            try {
                H5.H5Dclose(n4);
            }
            catch (HDF5Exception hDF5Exception) {}
        }
        if (h5ScalarDS != null) {
            group.addToMemberList(h5ScalarDS);
            if (object2 != null) {
                h5ScalarDS.write(object2);
            }
        }
        return h5ScalarDS;
    }

    public static H5ScalarDS create(String string, Group group, Datatype datatype, long[] lArray, long[] lArray2, long[] lArray3, int n, Object object) throws Exception {
        return H5ScalarDS.create(string, group, datatype, lArray, lArray2, lArray3, n, null, object);
    }

    @Override
    public byte[] getPaletteRefs() {
        if (this.rank <= 0) {
            this.init();
        }
        return this.paletteRefs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getPaletteRefs(int n) {
        int n2 = -1;
        int n3 = -1;
        int n4 = 0;
        int n5 = 0;
        int n6 = -1;
        byte[] byArray = null;
        try {
            n2 = H5.H5Aopen_by_name(n, ".", "PALETTE", HDF5Constants.H5P_DEFAULT, HDF5Constants.H5P_DEFAULT);
            n3 = H5.H5Aget_space(n2);
            n5 = H5.H5Sget_simple_extent_ndims(n3);
            n4 = 1;
            if (n5 > 0) {
                long[] lArray = new long[n5];
                H5.H5Sget_simple_extent_dims(n3, lArray, null);
                for (int i = 0; i < n5; ++i) {
                    n4 *= (int)lArray[i];
                }
            }
            byArray = new byte[n4 * 8];
            n6 = H5.H5Aget_type(n2);
            H5.H5Aread(n2, n6, byArray);
        }
        catch (HDF5Exception hDF5Exception) {
            byArray = null;
        }
        finally {
            try {
                H5.H5Tclose(n6);
            }
            catch (HDF5Exception hDF5Exception) {}
            try {
                H5.H5Sclose(n3);
            }
            catch (HDF5Exception hDF5Exception) {}
            try {
                H5.H5Aclose(n2);
            }
            catch (HDF5Exception hDF5Exception) {}
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Datatype getDatatype() {
        if (this.datatype == null) {
            int n = -1;
            int n2 = -1;
            n = this.open();
            try {
                n2 = H5.H5Dget_type(n);
                if (!this.isNativeDatatype) {
                    int n3 = -1;
                    try {
                        n3 = n2;
                        n2 = H5.H5Tget_native_type(n3);
                    }
                    finally {
                        try {
                            H5.H5Tclose(n3);
                        }
                        catch (Exception exception) {}
                    }
                }
                this.datatype = new H5Datatype(n2);
            }
            catch (Exception exception) {
            }
            finally {
                try {
                    H5.H5Tclose(n2);
                }
                catch (HDF5Exception hDF5Exception) {}
                try {
                    H5.H5Dclose(n);
                }
                catch (HDF5Exception hDF5Exception) {}
            }
        }
        return this.datatype;
    }

    @Override
    public void setName(String string) throws Exception {
        H5File.renameObject(this, string);
        super.setName(string);
    }

    public void extend(long[] lArray) throws HDF5Exception {
        int n = -1;
        int n2 = -1;
        n = this.open();
        try {
            H5.H5Dset_extent(n, lArray);
            H5.H5Fflush(n, HDF5Constants.H5F_SCOPE_GLOBAL);
            n2 = H5.H5Dget_space(n);
            long[] lArray2 = new long[this.rank];
            H5.H5Sget_simple_extent_dims(n2, lArray2, null);
            for (int i = 0; i < this.rank; ++i) {
                if (lArray2[i] == lArray[i]) continue;
                throw new HDF5Exception("error extending dataset " + this.getName());
            }
            this.dims = lArray2;
        }
        catch (Exception exception) {
            throw new HDF5Exception(exception.getMessage());
        }
        finally {
            if (n2 > 0) {
                H5.H5Sclose(n2);
            }
            this.close(n);
        }
    }
}

