/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.object.nc2;

import java.util.List;
import java.util.Vector;
import ncsa.hdf.object.Dataset;
import ncsa.hdf.object.Datatype;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.Group;
import ncsa.hdf.object.ScalarDS;
import ncsa.hdf.object.nc2.NC2Datatype;
import ncsa.hdf.object.nc2.NC2File;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.Variable;

public class NC2Dataset
extends ScalarDS {
    private static final long serialVersionUID = -6031051694304457461L;
    private List attributeList;
    private Variable nativeDataset;

    public NC2Dataset(FileFormat fileFormat, Variable variable, long[] lArray) {
        super(fileFormat, variable.getName(), "/", lArray);
        this.unsignedConverted = false;
        this.nativeDataset = variable;
    }

    @Override
    public boolean hasAttribute() {
        return false;
    }

    @Override
    public Dataset copy(Group group, String string, long[] lArray, Object object) throws Exception {
        throw new UnsupportedOperationException("Unsupported operation for NetCDF.");
    }

    @Override
    public byte[] readBytes() throws Exception {
        throw new UnsupportedOperationException("Unsupported operation for NetCDF.");
    }

    @Override
    public Object read() throws Exception {
        String[] stringArray = null;
        if (this.nativeDataset == null) {
            return null;
        }
        int[] nArray = new int[this.rank];
        int[] nArray2 = new int[this.rank];
        for (int i = 0; i < this.rank; ++i) {
            nArray[i] = (int)this.startDims[i];
            nArray2[i] = (int)this.selectedDims[i];
        }
        Array array = null;
        try {
            array = this.nativeDataset.read(nArray, nArray2);
        }
        catch (Exception exception) {
            array = this.nativeDataset.read();
        }
        String[] stringArray2 = array.copyTo1DJavaArray();
        if (stringArray2 == null) {
            return null;
        }
        if (stringArray2.getClass().getName().startsWith("[C")) {
            char[] cArray = (char[])stringArray2;
            int n = (int)this.selectedDims[this.selectedIndex[1]];
            int n2 = (int)this.selectedDims[this.selectedIndex[0]];
            String[] stringArray3 = new String[n2];
            String string = new String(cArray);
            int n3 = 0;
            for (int i = 0; i < n2; ++i) {
                n3 = i * n;
                stringArray3[i] = string.substring(n3, n3 + n);
            }
            stringArray = stringArray3;
        } else {
            stringArray = stringArray2;
        }
        return stringArray;
    }

    @Override
    public void write(Object object) throws Exception {
        throw new UnsupportedOperationException("Unsupported operation for NetCDF.");
    }

    @Override
    public List getMetadata() throws Exception {
        if (this.attributeList != null) {
            return this.attributeList;
        }
        if (this.nativeDataset == null) {
            this.attributeList = null;
            return null;
        }
        List list = this.nativeDataset.getAttributes();
        if (list == null) {
            this.attributeList = null;
            return null;
        }
        int n = list.size();
        this.attributeList = new Vector(n);
        Attribute attribute = null;
        for (int i = 0; i < n; ++i) {
            attribute = (Attribute)list.get(i);
            this.attributeList.add(NC2File.convertAttribute(attribute));
        }
        return this.attributeList;
    }

    @Override
    public void writeMetadata(Object object) throws Exception {
        throw new UnsupportedOperationException("Unsupported operation for NetCDF.");
    }

    @Override
    public void removeMetadata(Object object) throws Exception {
        throw new UnsupportedOperationException("Unsupported operation for NetCDF.");
    }

    @Override
    public int open() {
        return -1;
    }

    @Override
    public void close(int n) {
    }

    @Override
    public void init() {
        int n;
        if (this.nativeDataset == null) {
            return;
        }
        if (this.rank > 0) {
            return;
        }
        this.isText = this.nativeDataset.getDataType().equals((Object)DataType.STRING);
        boolean bl = this.nativeDataset.getDataType().equals((Object)DataType.CHAR);
        this.rank = this.nativeDataset.getRank();
        if (this.rank == 0) {
            this.rank = 1;
            this.dims = new long[1];
            this.dims[0] = 1L;
        } else {
            this.dims = new long[this.rank];
            for (n = 0; n < this.rank; ++n) {
                this.dims[n] = this.nativeDataset.getDimension(n).getLength();
            }
        }
        this.startDims = new long[this.rank];
        this.selectedDims = new long[this.rank];
        for (n = 0; n < this.rank; ++n) {
            this.startDims[n] = 0L;
            this.selectedDims[n] = 1L;
        }
        if (this.rank == 1) {
            this.selectedIndex[0] = 0;
            this.selectedDims[0] = this.dims[0];
        } else if (this.rank == 2) {
            this.selectedIndex[0] = 0;
            this.selectedIndex[1] = 1;
            this.selectedDims[0] = this.dims[0];
            this.selectedDims[1] = this.dims[1];
        } else if (this.rank > 2) {
            this.selectedIndex[0] = 0;
            this.selectedIndex[1] = 1;
            this.selectedIndex[2] = 2;
            this.selectedDims[0] = this.dims[0];
            this.selectedDims[1] = this.dims[1];
        }
        if (this.rank > 1 && this.isText) {
            this.selectedDims[1] = 1L;
        }
    }

    @Override
    public byte[][] getPalette() {
        if (this.palette == null) {
            this.palette = this.readPalette(0);
        }
        return this.palette;
    }

    @Override
    public byte[][] readPalette(int n) {
        return null;
    }

    public static NC2Dataset create(String string, Group group, Datatype datatype, long[] lArray, long[] lArray2, long[] lArray3, int n, Object object) throws Exception {
        throw new UnsupportedOperationException("Unsupported operation for NetCDF.");
    }

    @Override
    public byte[] getPaletteRefs() {
        return null;
    }

    @Override
    public Datatype getDatatype() {
        if (this.datatype == null) {
            this.datatype = new NC2Datatype(this.nativeDataset.getDataType());
        }
        return this.datatype;
    }

    @Override
    public void setName(String string) throws Exception {
        throw new UnsupportedOperationException("Unsupported operation for NetCDF.");
    }

    public List getMetadata(int ... nArray) throws Exception {
        throw new UnsupportedOperationException("getMetadata(int... attrPropList) is not supported");
    }
}

