/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.object.nc2;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Iterator;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import ncsa.hdf.object.Attribute;
import ncsa.hdf.object.Dataset;
import ncsa.hdf.object.Datatype;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.Group;
import ncsa.hdf.object.HObject;
import ncsa.hdf.object.nc2.NC2Dataset;
import ncsa.hdf.object.nc2.NC2Datatype;
import ncsa.hdf.object.nc2.NC2Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;

public class NC2File
extends FileFormat {
    private static final long serialVersionUID = 6941235662108358451L;
    private int fid;
    private int flag;
    private MutableTreeNode rootNode;
    private NetcdfFile ncFile;
    private static boolean isFileOpen;

    public NC2File() {
        this("");
    }

    public NC2File(String string) {
        super(string);
        this.isReadOnly = true;
        isFileOpen = false;
        this.fid = -1;
        try {
            this.ncFile = new NetcdfFile(this.fullFileName);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean isThisType(FileFormat fileFormat) {
        return fileFormat instanceof NC2File;
    }

    @Override
    public boolean isThisType(String string) {
        boolean bl = false;
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(string, "r");
        }
        catch (Exception exception) {
            randomAccessFile = null;
        }
        if (randomAccessFile == null) {
            try {
                randomAccessFile.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
        byte[] byArray = new byte[4];
        try {
            randomAccessFile.read(byArray);
        }
        catch (Exception exception) {
            byArray = null;
        }
        if (byArray != null) {
            bl = byArray[0] == 67 && byArray[1] == 68 && byArray[2] == 70 && byArray[3] < 4;
        }
        try {
            randomAccessFile.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    @Override
    public FileFormat createInstance(String string, int n) throws Exception {
        return new NC2File(string);
    }

    @Override
    public int open() throws Exception {
        if (!isFileOpen) {
            isFileOpen = true;
            this.rootNode = this.loadTree();
        }
        return 0;
    }

    private MutableTreeNode loadTree() {
        long[] lArray = new long[]{0L};
        NC2Group nC2Group = new NC2Group(this, "/", null, null, lArray);
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(nC2Group){
            private static final long serialVersionUID = -9190644912409119072L;

            @Override
            public boolean isLeaf() {
                return false;
            }
        };
        if (this.ncFile == null) {
            return defaultMutableTreeNode;
        }
        Iterator iterator = this.ncFile.getVariables().iterator();
        Variable variable = null;
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        NC2Dataset nC2Dataset = null;
        while (iterator.hasNext()) {
            variable = (Variable)iterator.next();
            lArray[0] = variable.hashCode();
            nC2Dataset = new NC2Dataset((FileFormat)this, variable, lArray);
            defaultMutableTreeNode2 = new DefaultMutableTreeNode(nC2Dataset);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            nC2Group.addToMemberList(nC2Dataset);
        }
        return defaultMutableTreeNode;
    }

    @Override
    public void close() throws IOException {
        if (this.ncFile != null) {
            this.ncFile.close();
        }
    }

    @Override
    public TreeNode getRootNode() {
        return this.rootNode;
    }

    public NetcdfFile getNetcdfFile() {
        return this.ncFile;
    }

    @Override
    public Group createGroup(String string, Group group) throws Exception {
        throw new UnsupportedOperationException("Unsupported operation.");
    }

    @Override
    public Datatype createDatatype(int n, int n2, int n3, int n4) throws Exception {
        throw new UnsupportedOperationException("Unsupported operation.");
    }

    @Override
    public Datatype createDatatype(int n, int n2, int n3, int n4, String string) throws Exception {
        throw new UnsupportedOperationException("Unsupported operation.");
    }

    @Override
    public Dataset createScalarDS(String string, Group group, Datatype datatype, long[] lArray, long[] lArray2, long[] lArray3, int n, Object object, Object object2) throws Exception {
        throw new UnsupportedOperationException("Unsupported operation.");
    }

    @Override
    public Dataset createImage(String string, Group group, Datatype datatype, long[] lArray, long[] lArray2, long[] lArray3, int n, int n2, int n3, Object object) throws Exception {
        throw new UnsupportedOperationException("Unsupported operation.");
    }

    @Override
    public void delete(HObject hObject) throws Exception {
        throw new UnsupportedOperationException("Unsupported operation.");
    }

    @Override
    public TreeNode copy(HObject hObject, Group group, String string) throws Exception {
        throw new UnsupportedOperationException("Unsupported operation.");
    }

    private TreeNode copyDataset(Dataset dataset, NC2Group nC2Group) throws Exception {
        throw new UnsupportedOperationException("Unsupported operation.");
    }

    private TreeNode copyGroup(NC2Group nC2Group, NC2Group nC2Group2) throws Exception {
        throw new UnsupportedOperationException("Unsupported operation.");
    }

    public void copyAttributes(HObject hObject, HObject hObject2) {
        throw new UnsupportedOperationException("Unsupported operation.");
    }

    public void copyAttributes(int n, int n2) {
        throw new UnsupportedOperationException("Unsupported operation.");
    }

    @Override
    public void writeAttribute(HObject hObject, Attribute attribute, boolean bl) throws Exception {
        throw new UnsupportedOperationException("Unsupported operation.");
    }

    public static Attribute convertAttribute(ucar.nc2.Attribute attribute) {
        Attribute attribute2 = null;
        if (attribute == null) {
            return null;
        }
        String string = attribute.getName();
        long[] lArray = new long[]{attribute.getLength()};
        NC2Datatype nC2Datatype = new NC2Datatype(attribute.getDataType());
        attribute2 = new Attribute(string, nC2Datatype, lArray);
        attribute2.setValue(attribute.getValues());
        return attribute2;
    }

    @Override
    public String getLibversion() {
        String string = "NetCDF Java (version 2.4)";
        return string;
    }

    @Override
    public HObject get(String string) throws Exception {
        throw new UnsupportedOperationException("get() is not supported");
    }
}

