/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.object.nc2;

import java.util.List;
import java.util.Vector;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.Group;
import ncsa.hdf.object.nc2.NC2File;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFile;

public class NC2Group
extends Group {
    private static final long serialVersionUID = -1261533010442193447L;
    private List attributeList;
    private static final long[] DEFAULT_OID = new long[]{0L};

    public NC2Group(FileFormat fileFormat, String string, String string2, Group group, long[] lArray) {
        super(fileFormat, string, string2, group, lArray == null ? DEFAULT_OID : lArray);
    }

    @Override
    public boolean hasAttribute() {
        return false;
    }

    @Override
    public List getMetadata() throws Exception {
        if (!this.isRoot()) {
            return null;
        }
        if (this.attributeList != null) {
            return this.attributeList;
        }
        NC2File nC2File = (NC2File)this.getFileFormat();
        NetcdfFile netcdfFile = nC2File.getNetcdfFile();
        List list = netcdfFile.getGlobalAttributes();
        if (list == null) {
            return null;
        }
        int n = list.size();
        this.attributeList = new Vector(n);
        Attribute attribute = null;
        for (int i = 0; i < n; ++i) {
            attribute = (Attribute)list.get(i);
            this.attributeList.add(NC2File.convertAttribute(attribute));
        }
        return this.attributeList;
    }

    @Override
    public void writeMetadata(Object object) throws Exception {
        throw new UnsupportedOperationException("Unsupported operation for NetCDF.");
    }

    @Override
    public void removeMetadata(Object object) throws Exception {
        throw new UnsupportedOperationException("Unsupported operation for NetCDF.");
    }

    @Override
    public int open() {
        throw new UnsupportedOperationException("Unsupported operation for NetCDF.");
    }

    @Override
    public void close(int n) {
        throw new UnsupportedOperationException("Unsupported operation for NetCDF.");
    }

    public static NC2Group create(String string, Group group) throws Exception {
        throw new UnsupportedOperationException("Unsupported operation for NetCDF.");
    }

    public List getMetadata(int ... nArray) throws Exception {
        throw new UnsupportedOperationException("getMetadata(int... attrPropList) is not supported");
    }
}

