/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import java.util.BitSet;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import ncsa.hdf.object.CompoundDS;
import ncsa.hdf.object.Dataset;
import ncsa.hdf.object.Datatype;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.ScalarDS;
import ncsa.hdf.view.HDFView;
import ncsa.hdf.view.Tools;
import ncsa.hdf.view.ViewManager;
import ncsa.hdf.view.ViewProperties;

public class DataOptionDialog
extends JDialog
implements ActionListener,
ItemListener {
    private static final long serialVersionUID = -1078411885690696784L;
    private final ViewManager viewer;
    private Dataset dataset;
    private int rank;
    private long[] start;
    private long[] dims;
    private long[] selected;
    private long[] stride;
    private int[] selectedIndex;
    private int[] currentIndex;
    private JRadioButton spreadsheetButton;
    private JRadioButton imageButton;
    private JRadioButton base1Button;
    private JRadioButton base0Button;
    private JRadioButton[] bitmaskButtons;
    private JCheckBox applyBitmaskButton;
    private JCheckBox extractBitButton;
    private JCheckBox charCheckbox;
    private BitSet bitmask;
    private JButton bitmaskHelp;
    private JComboBox choiceTextView;
    private JComboBox choiceTableView;
    private JComboBox choiceImageView;
    private JComboBox choicePalette;
    private JComboBox[] choices;
    private JComboBox transposeChoice;
    private boolean isSelectionCancelled;
    private boolean isTrueColorImage;
    private boolean isText;
    private boolean isH5;
    private JLabel[] maxLabels;
    private JLabel selLabel;
    private JTextField[] startFields;
    private JTextField[] endFields;
    private JTextField[] strideFields;
    private JList fieldList;
    private final Toolkit toolkit;
    private final PreviewNavigator navigator;
    private int numberOfPalettes;
    private boolean performJComboBoxEvent = false;

    public DataOptionDialog(ViewManager viewManager, Dataset dataset) {
        super((Frame)((JFrame)((Object)viewManager)), true);
        Serializable serializable;
        JPanel jPanel;
        JComponent jComponent;
        Object object;
        Object object2;
        Serializable serializable2;
        int n;
        Object object3;
        byte[] byArray;
        this.setDefaultCloseOperation(2);
        this.viewer = viewManager;
        this.dataset = dataset;
        this.isSelectionCancelled = true;
        this.isTrueColorImage = false;
        this.isText = false;
        this.bitmask = null;
        this.numberOfPalettes = 1;
        this.toolkit = Toolkit.getDefaultToolkit();
        if (this.dataset == null) {
            this.dispose();
        } else {
            this.setTitle("Dataset Selection - " + this.dataset.getPath() + this.dataset.getName());
        }
        this.isH5 = this.dataset.getFileFormat().isThisType(FileFormat.getFileFormat("HDF5"));
        this.rank = this.dataset.getRank();
        if (this.rank <= 0) {
            this.dataset.init();
        }
        if (this.isH5 && this.dataset instanceof ScalarDS && (byArray = ((ScalarDS)this.dataset).getPaletteRefs()) != null && byArray.length > 8) {
            this.numberOfPalettes = byArray.length / 8;
        }
        this.rank = this.dataset.getRank();
        this.dims = this.dataset.getDims();
        this.selected = this.dataset.getSelectedDims();
        this.start = this.dataset.getStartDims();
        this.selectedIndex = this.dataset.getSelectedIndex();
        this.stride = this.dataset.getStride();
        this.fieldList = null;
        int n2 = 1;
        int n3 = 1;
        n2 = (int)this.dims[this.selectedIndex[0]];
        if (this.rank > 1) {
            n3 = (int)this.dims[this.selectedIndex[1]];
        }
        this.transposeChoice = new JComboBox();
        this.transposeChoice.addItem("Reshape");
        this.transposeChoice.addItem("Transpose");
        this.selLabel = new JLabel("", 0);
        this.navigator = new PreviewNavigator(n3, n2);
        this.currentIndex = new int[Math.min(3, this.rank)];
        this.choicePalette = new JComboBox();
        this.choiceTextView = new JComboBox((Vector)HDFView.getListOfTextView());
        this.choiceImageView = new JComboBox((Vector)HDFView.getListOfImageView());
        this.choiceTableView = new JComboBox((Vector)HDFView.getListOfTableView());
        this.choicePalette.addItem("Select palette");
        if (this.dataset instanceof ScalarDS) {
            object3 = ((ScalarDS)this.dataset).getPaletteName(0);
            if (object3 == null) {
                object3 = "Default";
            }
            this.choicePalette.addItem(object3);
            for (n = 2; n <= this.numberOfPalettes; ++n) {
                object3 = ((ScalarDS)this.dataset).getPaletteName(n - 1);
                this.choicePalette.addItem(object3);
            }
        }
        this.choicePalette.addItem("Gray");
        this.choicePalette.addItem("ReverseGray");
        this.choicePalette.addItem("GrayWave");
        this.choicePalette.addItem("Rainbow");
        this.choicePalette.addItem("Nature");
        this.choicePalette.addItem("Wave");
        this.spreadsheetButton = new JRadioButton("Spreadsheet ", true);
        this.spreadsheetButton.setMnemonic(83);
        this.imageButton = new JRadioButton("Image ");
        this.imageButton.setMnemonic(73);
        this.charCheckbox = new JCheckBox("Show As Char", false);
        this.charCheckbox.setMnemonic(67);
        this.charCheckbox.setEnabled(false);
        this.charCheckbox.addItemListener(this);
        this.extractBitButton = new JCheckBox("Show Value of Selected Bits", false);
        this.extractBitButton.setMnemonic(86);
        this.extractBitButton.setEnabled(false);
        this.extractBitButton.addItemListener(this);
        this.applyBitmaskButton = new JCheckBox("Apply Bitmask", false);
        this.applyBitmaskButton.setMnemonic(65);
        this.applyBitmaskButton.setEnabled(false);
        this.applyBitmaskButton.addItemListener(this);
        this.bitmaskHelp = new JButton(ViewProperties.getHelpIcon());
        this.bitmaskHelp.setToolTipText("Help on how to set bitmask");
        this.bitmaskHelp.setMargin(new Insets(0, 0, 0, 0));
        this.bitmaskHelp.addActionListener(this);
        this.bitmaskHelp.setActionCommand("Help on how to set bitmask");
        object3 = (JPanel)this.getContentPane();
        ((Container)object3).setLayout(new BorderLayout(5, 5));
        ((JComponent)object3).setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        n = 700 + (ViewProperties.getFontSize() - 12) * 15;
        int n4 = 350 + (ViewProperties.getFontSize() - 12) * 10;
        ((JComponent)object3).setPreferredSize(new Dimension(n, n4));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.setBorder(new TitledBorder("Dimension and Subset Selection"));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)this.navigator, "Center");
        jPanel3.add((Component)this.selLabel, "South");
        jPanel3.setBorder(new EtchedBorder(1));
        this.performJComboBoxEvent = true;
        if (this.dataset instanceof CompoundDS) {
            serializable2 = (CompoundDS)this.dataset;
            object2 = ((CompoundDS)serializable2).getMemberNames();
            this.fieldList = new JList<String>((E[])object2);
            this.fieldList.addSelectionInterval(0, ((String[])object2).length - 1);
            object = new JPanel();
            ((Container)object).setLayout(new BorderLayout());
            n = 150 + (ViewProperties.getFontSize() - 12) * 10;
            n4 = 250 + (ViewProperties.getFontSize() - 12) * 15;
            ((JComponent)object).setPreferredSize(new Dimension(n, n4));
            jComponent = new JScrollPane(this.fieldList);
            ((Container)object).add(jComponent);
            ((JComponent)object).setBorder(new TitledBorder("Select Members"));
            ((Container)object3).add((Component)object, "West");
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout(new BorderLayout());
            jPanel4.add((Component)new JLabel("        TableView:  "), "West");
            jPanel4.add((Component)this.choiceTableView, "Center");
            jPanel4.setBorder(new LineBorder(Color.LIGHT_GRAY));
            jPanel2.add((Component)jPanel4, "South");
        } else if (this.dataset instanceof ScalarDS) {
            serializable2 = (ScalarDS)this.dataset;
            this.isText = ((ScalarDS)serializable2).isText();
            if (this.isText) {
                n = 700 + (ViewProperties.getFontSize() - 12) * 15;
                n4 = 280 + (ViewProperties.getFontSize() - 12) * 10;
                ((JComponent)object3).setPreferredSize(new Dimension(n, n4));
                object2 = new JPanel();
                ((Container)object2).setLayout(new BorderLayout());
                ((Container)object2).add((Component)new JLabel("          TextView:  "), "West");
                ((Container)object2).add((Component)this.choiceTextView, "Center");
                ((JComponent)object2).setBorder(new LineBorder(Color.LIGHT_GRAY));
                jPanel2.add((Component)object2, "South");
            } else {
                n = 680 + (ViewProperties.getFontSize() - 12) * 15;
                n4 = 400 + (ViewProperties.getFontSize() - 12) * 10;
                ((JComponent)object3).setPreferredSize(new Dimension(n, n4));
                if (this.rank > 1) {
                    jPanel2.add((Component)jPanel3, "West");
                }
                this.imageButton.addItemListener(this);
                this.spreadsheetButton.addItemListener(this);
                object2 = new ButtonGroup();
                ((ButtonGroup)object2).add(this.spreadsheetButton);
                ((ButtonGroup)object2).add(this.imageButton);
                object = new JPanel();
                ((Container)object).setLayout(new GridLayout(2, 1, 5, 5));
                ((JComponent)object).setBorder(new TitledBorder("Display As"));
                jComponent = new JPanel();
                jComponent.setLayout(new GridLayout(1, 2, 25, 5));
                jComponent.add(this.spreadsheetButton);
                int n5 = ((Dataset)serializable2).getDatatype().getDatatypeClass();
                if (n5 == 2 || n5 == 0 && ((Dataset)serializable2).getDatatype().getDatatypeSize() == 1) {
                    jComponent.add(this.charCheckbox);
                }
                jPanel = new JPanel();
                jPanel.setLayout(new BorderLayout());
                jPanel.add((Component)new JLabel("TableView:   "), "West");
                jPanel.add((Component)this.choiceTableView, "Center");
                serializable = new JPanel();
                serializable.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
                serializable.setLayout(new GridLayout(2, 1, 5, 5));
                serializable.add(jComponent);
                serializable.add(jPanel);
                ((Container)object).add((Component)serializable);
                JPanel jPanel5 = new JPanel();
                jPanel5.setLayout(new BorderLayout(5, 5));
                jPanel5.add((Component)this.imageButton, "West");
                jPanel5.add((Component)this.choicePalette, "Center");
                JPanel jPanel6 = new JPanel();
                jPanel6.setLayout(new BorderLayout());
                jPanel6.add((Component)new JLabel("ImageView: "), "West");
                jPanel6.add((Component)this.choiceImageView, "Center");
                JPanel jPanel7 = new JPanel();
                jPanel7.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
                jPanel7.setLayout(new GridLayout(2, 1, 5, 5));
                jPanel7.add(jPanel5);
                jPanel7.add(jPanel6);
                ((Container)object).add(jPanel7);
                JPanel jPanel8 = new JPanel();
                jPanel8.setLayout(new GridLayout(1, 2, 5, 5));
                jPanel8.add((Component)object);
                object = new JPanel();
                ((Container)object).setLayout(new BorderLayout());
                jPanel8.add((Component)object);
                JPanel jPanel9 = new JPanel();
                ((Container)object).add((Component)jPanel9, "North");
                jPanel9.setBorder(new TitledBorder("Index Base"));
                jPanel9.setLayout(new GridLayout(1, 2, 5, 5));
                this.base0Button = new JRadioButton("0-based ");
                this.base1Button = new JRadioButton("1-based ");
                ButtonGroup buttonGroup = new ButtonGroup();
                buttonGroup.add(this.base0Button);
                buttonGroup.add(this.base1Button);
                if (ViewProperties.isIndexBase1()) {
                    this.base1Button.setSelected(true);
                } else {
                    this.base0Button.setSelected(true);
                }
                jPanel9.add(this.base0Button);
                jPanel9.add(this.base1Button);
                if (n5 == 2 || n5 == 0 && ((Dataset)serializable2).getDatatype().getDatatypeSize() <= 2) {
                    int n6;
                    this.bitmaskButtons = new JRadioButton[8 * ((Dataset)serializable2).getDatatype().getDatatypeSize()];
                    for (int i = 0; i < this.bitmaskButtons.length; ++i) {
                        this.bitmaskButtons[i] = new JRadioButton(String.valueOf(i));
                        this.bitmaskButtons[i].setEnabled(false);
                        this.bitmaskButtons[i].addItemListener(this);
                    }
                    JPanel jPanel10 = new JPanel();
                    ((Container)object).add((Component)jPanel10, "Center");
                    jPanel10.setBorder(new TitledBorder("Bitmask"));
                    JPanel jPanel11 = new JPanel();
                    if (this.bitmaskButtons.length <= 8) {
                        jPanel11.setLayout(new GridLayout(1, this.bitmaskButtons.length));
                        for (n6 = this.bitmaskButtons.length; n6 > 0; --n6) {
                            jPanel11.add(this.bitmaskButtons[n6 - 1]);
                        }
                    } else {
                        jPanel11.setLayout(new GridLayout(2, this.bitmaskButtons.length / 2));
                        for (n6 = this.bitmaskButtons.length; n6 > this.bitmaskButtons.length / 2; --n6) {
                            jPanel11.add(this.bitmaskButtons[n6 - 1]);
                        }
                        for (n6 = this.bitmaskButtons.length / 2; n6 > 0; --n6) {
                            jPanel11.add(this.bitmaskButtons[n6 - 1]);
                        }
                    }
                    jPanel10.setLayout(new BorderLayout(10, 10));
                    jPanel10.add((Component)jPanel11, "Center");
                    jPanel10.add((Component)new JLabel(), "North");
                    JPanel jPanel12 = new JPanel();
                    jPanel12.setLayout(new GridLayout(2, 1));
                    jPanel12.add(this.extractBitButton);
                    jPanel12.add(this.applyBitmaskButton);
                    jPanel11 = new JPanel();
                    jPanel11.setLayout(new BorderLayout());
                    jPanel11.add((Component)jPanel12, "West");
                    jPanel12 = new JPanel();
                    jPanel12.add(this.bitmaskHelp);
                    jPanel11.add((Component)jPanel12, "East");
                    jPanel10.add((Component)jPanel11, "North");
                }
                ((Container)object3).add((Component)jPanel8, "North");
            }
        }
        serializable2 = new JPanel();
        ((Container)serializable2).setLayout(new GridLayout(5, 6, 10, 3));
        ((JComponent)serializable2).setBorder(new EtchedBorder(1));
        jPanel2.add((Component)serializable2, "Center");
        ((Container)object3).add((Component)jPanel2, "Center");
        ((Container)serializable2).add(new JLabel(" "));
        if (this.rank > 1) {
            ((Container)serializable2).add(this.transposeChoice);
        } else {
            ((Container)serializable2).add(new JLabel(" "));
        }
        object2 = new JLabel("Start:");
        ((Container)serializable2).add((Component)object2);
        object2 = new JLabel("End: ");
        ((Container)serializable2).add((Component)object2);
        object2 = new JLabel("Stride:");
        ((Container)serializable2).add((Component)object2);
        object2 = new JLabel("Max Size");
        ((Container)serializable2).add((Component)object2);
        this.choices = new JComboBox[3];
        this.maxLabels = new JLabel[3];
        this.startFields = new JTextField[3];
        this.endFields = new JTextField[3];
        this.strideFields = new JTextField[3];
        object = new JLabel[]{new JLabel("Height", 4), new JLabel("Width", 4), new JLabel("Depth", 4)};
        jComponent = this.dataset.getDimNames();
        for (int i = 0; i < 3; ++i) {
            this.choices[i] = new JComboBox();
            this.choices[i].addItemListener(this);
            for (int j = 0; j < this.rank; ++j) {
                if (jComponent == null) {
                    this.choices[i].addItem("dim " + j);
                    continue;
                }
                this.choices[i].addItem(jComponent[j]);
            }
            this.maxLabels[i] = new JLabel("1");
            this.startFields[i] = new JTextField("0");
            this.endFields[i] = new JTextField("0");
            this.strideFields[i] = new JTextField("1");
            ((Container)serializable2).add(object[i]);
            ((Container)serializable2).add(this.choices[i]);
            ((Container)serializable2).add(this.startFields[i]);
            ((Container)serializable2).add(this.endFields[i]);
            ((Container)serializable2).add(this.strideFields[i]);
            ((Container)serializable2).add(this.maxLabels[i]);
            this.choices[i].setEnabled(false);
            this.startFields[i].setEnabled(false);
            this.endFields[i].setEnabled(false);
            this.strideFields[i].setEnabled(false);
            this.maxLabels[i].setEnabled(false);
        }
        JButton jButton = new JButton("dims...");
        ((Container)serializable2).add(new JLabel("", 4));
        ((Container)serializable2).add(jButton);
        jButton.setActionCommand("Select more dimensions");
        jButton.addActionListener(this);
        jButton.setEnabled(this.rank > 3);
        ((Container)serializable2).add(new JLabel(" "));
        ((Container)serializable2).add(new JLabel(" "));
        jButton = new JButton("Reset");
        jButton.setActionCommand("Reset data range");
        jButton.addActionListener(this);
        ((Container)serializable2).add(jButton);
        ((Container)serializable2).add(new JLabel(" "));
        jPanel = new JPanel();
        ((Container)object3).add((Component)jPanel, "South");
        jButton = new JButton("   Ok   ");
        jButton.setMnemonic(79);
        jButton.setActionCommand("Ok");
        jButton.addActionListener(this);
        jPanel.add(jButton);
        jButton = new JButton("Cancel");
        jButton.setMnemonic(67);
        jButton.setActionCommand("Cancel");
        jButton.addActionListener(this);
        jPanel.add(jButton);
        this.init();
        serializable = this.getParent().getLocation();
        ((Point)serializable).x += 250;
        ((Point)serializable).y += 80;
        this.setLocation((Point)serializable);
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Ok")) {
            if (this.dataset instanceof ScalarDS && this.imageButton.isSelected()) {
                this.setPalette();
            }
            boolean bl = this.isSelectionCancelled = !this.setSelection();
            if (this.isSelectionCancelled) {
                return;
            }
            if (this.dataset instanceof ScalarDS) {
                ((ScalarDS)this.dataset).setIsImageDisplay(this.imageButton.isSelected());
            }
            this.dispose();
        } else if (string.equals("Cancel")) {
            this.dispose();
        } else if (string.equals("Reset data range")) {
            int n = this.startFields.length;
            for (int i = 0; i < n; ++i) {
                this.startFields[i].setText("0");
                this.strideFields[i].setText("1");
                long l = Long.valueOf(this.maxLabels[i].getText()) - 1L;
                this.endFields[i].setText(String.valueOf(l));
            }
        } else if (string.equals("Select more dimensions")) {
            int n;
            if (this.rank < 4) {
                return;
            }
            int n2 = 0;
            Vector vector = new Vector(this.rank);
            int[] nArray = new int[this.rank - 3];
            for (int i = 0; i < this.rank; ++i) {
                if (i == this.currentIndex[0] || i == this.currentIndex[1] || i == this.currentIndex[2]) continue;
                vector.add(this.choices[0].getItemAt(i));
                nArray[n2++] = i;
            }
            String string2 = "Select slice location for dimension(s):\n\"" + vector.get(0) + " [0 .. " + (this.dims[nArray[0]] - 1L) + "]\"";
            String string3 = String.valueOf(this.start[nArray[0]]);
            int n3 = vector.size();
            for (int i = 1; i < n3; ++i) {
                string2 = string2 + " x \"" + vector.get(i) + " [0 .. " + (this.dims[nArray[i]] - 1L) + "]\"";
                string3 = string3 + " x " + String.valueOf(this.start[nArray[i]]);
            }
            String string4 = JOptionPane.showInputDialog(this, string2, string3);
            if (string4 == null || (string4 = string4.trim()) == null || string4.length() < 1) {
                return;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string4, "x");
            if (stringTokenizer.countTokens() < n3) {
                JOptionPane.showMessageDialog(this, "Number of dimension(s) is less than " + n3 + "\n" + string4, "Select Slice Location", 0);
                return;
            }
            long[] lArray = new long[n3];
            for (n = 0; n < n3; ++n) {
                try {
                    lArray[n] = Long.parseLong(stringTokenizer.nextToken().trim());
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(this, exception.getMessage(), "Select Slice Location", 0);
                    return;
                }
                if (lArray[n] >= 0L && lArray[n] < this.dims[nArray[n]]) continue;
                JOptionPane.showMessageDialog(this, "Slice location is out of range.\n" + lArray[n] + " >= " + this.dims[nArray[n]], "Select Slice Location", 0);
                return;
            }
            for (n = 0; n < n3; ++n) {
                this.start[nArray[n]] = lArray[n];
            }
        } else if (string.equals("Help on how to set bitmask")) {
            String string5 = "\"Apply Bitmask\" applies bitwise \"AND\" to the original data.\nFor example, bits 2, 3, and 4 are selected for the bitmask\n         10010101 (data)\nAND 00011100 (mask)  \n  =     00010100 (result) ==> the decimal value is 20. \n\n\"Extract Bit(s)\" removes all the bits from the result above where\ntheir corresponding bits in the bitmask are 0. \nFor the same example above, the result is \n101 ==> the decimal value is 5.\n\n";
            JOptionPane.showMessageDialog((JFrame)((Object)this.viewer), string5);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object.equals(this.imageButton)) {
            this.choicePalette.setEnabled(!this.isTrueColorImage);
            this.choiceImageView.setEnabled(true);
            this.choiceTableView.setEnabled(false);
            this.charCheckbox.setSelected(false);
            this.charCheckbox.setEnabled(false);
        } else if (object.equals(this.spreadsheetButton)) {
            this.choicePalette.setEnabled(false);
            this.choiceImageView.setEnabled(false);
            this.choiceTableView.setEnabled(true);
            Datatype datatype = this.dataset.getDatatype();
            int n = datatype.getDatatypeClass();
            this.charCheckbox.setEnabled((n == 2 || n == 0) && datatype.getDatatypeSize() == 1);
        } else if (object instanceof JToggleButton) {
            this.checkBitmaskButtons((JToggleButton)object);
        } else if (object instanceof JComboBox) {
            int n;
            int n2;
            if (!this.performJComboBoxEvent) {
                return;
            }
            if (itemEvent.getStateChange() == 2) {
                return;
            }
            JComboBox jComboBox = (JComboBox)object;
            int n3 = -1;
            int n4 = Math.min(3, this.rank);
            for (n2 = 0; n2 < n4; ++n2) {
                if (!jComboBox.equals(this.choices[n2])) continue;
                n3 = n2;
            }
            if (n3 < 0) {
                return;
            }
            n2 = jComboBox.getSelectedIndex();
            if (n2 == this.currentIndex[n3]) {
                return;
            }
            this.start[this.currentIndex[n3]] = 0L;
            this.startFields[n3].setText("0");
            this.endFields[n3].setText(String.valueOf(this.dims[n2] - 1L));
            this.strideFields[n3].setText("1");
            this.maxLabels[n3].setText(String.valueOf(this.dims[n2]));
            for (n = 0; n < n4; ++n) {
                if (n == n3 || n2 != this.choices[n].getSelectedIndex()) continue;
                this.setJComboBoxSelectedIndex(this.choices[n], this.currentIndex[n3]);
                this.startFields[n].setText("0");
                this.endFields[n].setText(String.valueOf(this.dims[this.currentIndex[n3]] - 1L));
                this.strideFields[n].setText("1");
                this.maxLabels[n].setText(String.valueOf(this.dims[this.currentIndex[n3]]));
            }
            for (n = 0; n < n4; ++n) {
                this.currentIndex[n] = this.choices[n].getSelectedIndex();
            }
            if (this.rank > 1) {
                if (this.isText) {
                    this.endFields[1].setText(this.startFields[1].getText());
                } else {
                    n = this.choices[0].getSelectedIndex();
                    int n5 = this.choices[1].getSelectedIndex();
                    this.transposeChoice.setSelectedIndex(0);
                    if (n < n5) {
                        this.transposeChoice.setEnabled(false);
                    } else {
                        this.transposeChoice.setEnabled(true);
                    }
                    long[] lArray = this.dataset.getDims();
                    int n6 = (int)lArray[n5];
                    int n7 = (int)lArray[n];
                    this.navigator.setDimensionSize(n6, n7);
                    this.navigator.updateUI();
                }
            }
            if (this.rank > 2) {
                this.endFields[2].setText(this.startFields[2].getText());
            }
        }
    }

    public boolean isCancelled() {
        return this.isSelectionCancelled;
    }

    public boolean isImageDisplay() {
        return this.imageButton.isSelected();
    }

    public boolean isIndexBase1() {
        if (this.base1Button == null) {
            return false;
        }
        return this.base1Button.isSelected();
    }

    private void checkBitmaskButtons(JToggleButton jToggleButton) {
        boolean bl = false;
        int n = 0;
        if (jToggleButton.equals(this.applyBitmaskButton)) {
            if (this.applyBitmaskButton.isSelected()) {
                this.extractBitButton.setSelected(false);
            }
        } else if (jToggleButton.equals(this.extractBitButton) && this.extractBitButton.isSelected()) {
            this.applyBitmaskButton.setSelected(false);
        }
        bl = this.applyBitmaskButton.isSelected() || this.extractBitButton.isSelected();
        this.bitmaskButtons[0].setEnabled(bl);
        if (this.bitmaskButtons[0].isSelected()) {
            n = 1;
        }
        for (int i = 1; i < this.bitmaskButtons.length; ++i) {
            this.bitmaskButtons[i].setEnabled(bl);
            if (!this.bitmaskButtons[i].isSelected() || this.bitmaskButtons[i - 1].isSelected()) continue;
            ++n;
        }
        if (this.extractBitButton.isSelected() && n > 1) {
            if (jToggleButton.equals(this.extractBitButton) && this.extractBitButton.isSelected()) {
                this.applyBitmaskButton.setSelected(true);
                JOptionPane.showMessageDialog(this, "Selecting non-adjacent bits is only allowed \nfor the \"Apply Bitmask\" option.", "Select Bitmask", 0);
            } else if (jToggleButton instanceof JRadioButton) {
                JOptionPane.showMessageDialog(this, "Please select contiguous bits \nwhen the \"Show Value of Selected Bits\" option is checked.", "Select Bitmask", 0);
                jToggleButton.setSelected(false);
            }
        }
    }

    private void init() {
        int n;
        int n2;
        boolean bl = false;
        if (this.dataset instanceof ScalarDS) {
            ScalarDS scalarDS = (ScalarDS)this.dataset;
            bl = scalarDS.isImageDisplay();
            this.isTrueColorImage = scalarDS.isTrueColor();
        } else if (this.dataset instanceof CompoundDS) {
            this.imageButton.setEnabled(false);
        }
        this.choiceTableView.setEnabled(!bl);
        this.choiceImageView.setEnabled(bl);
        this.imageButton.setSelected(bl);
        this.choicePalette.setEnabled(bl && !this.isTrueColorImage);
        int n3 = Math.min(3, this.rank);
        long l = 0L;
        for (n2 = 0; n2 < n3; ++n2) {
            this.choices[n2].setEnabled(true);
            this.startFields[n2].setEnabled(true);
            this.endFields[n2].setEnabled(true);
            this.strideFields[n2].setEnabled(true);
            this.maxLabels[n2].setEnabled(true);
            n = this.selectedIndex[n2];
            l = this.start[n] + this.selected[n] * this.stride[n];
            if (l >= this.dims[n]) {
                l = this.dims[n];
            }
            this.setJComboBoxSelectedIndex(this.choices[n2], n);
            this.maxLabels[n2].setText(String.valueOf(this.dims[n]));
            this.startFields[n2].setText(String.valueOf(this.start[n]));
            this.endFields[n2].setText(String.valueOf(l - 1L));
            if (!this.isH5 && this.dataset instanceof CompoundDS) {
                this.strideFields[n2].setEnabled(false);
                continue;
            }
            this.strideFields[n2].setText(String.valueOf(this.stride[n]));
        }
        if (this.rank > 1) {
            this.transposeChoice.setEnabled(this.choices[0].getSelectedIndex() > this.choices[1].getSelectedIndex());
            if (this.isText) {
                this.endFields[1].setEnabled(false);
                this.endFields[1].setText(this.startFields[1].getText());
            }
        }
        if (this.rank > 2) {
            this.endFields[2].setEnabled(false);
            this.strideFields[2].setEnabled(false);
            if (this.isTrueColorImage && this.imageButton.isSelected()) {
                this.choices[0].setEnabled(false);
                this.choices[1].setEnabled(false);
                this.choices[2].setEnabled(false);
                this.startFields[2].setEnabled(false);
                this.startFields[2].setText("0");
                this.endFields[2].setText("0");
            } else {
                this.choices[0].setEnabled(true);
                this.choices[1].setEnabled(true);
                this.choices[2].setEnabled(true);
                this.startFields[2].setEnabled(true);
                this.startFields[2].setText(String.valueOf(this.start[this.selectedIndex[2]]));
                this.endFields[2].setText(this.startFields[2].getText());
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            this.currentIndex[n2] = this.choices[n2].getSelectedIndex();
        }
        Datatype datatype = this.dataset.getDatatype();
        n = datatype.getDatatypeClass();
        if (n == 2 || n == 0) {
            int n4 = datatype.getDatatypeSize();
            this.charCheckbox.setEnabled(n4 == 1 && this.spreadsheetButton.isSelected());
            this.extractBitButton.setEnabled(n4 <= 2);
            this.applyBitmaskButton.setEnabled(n4 <= 2);
        } else {
            this.charCheckbox.setEnabled(false);
            this.charCheckbox.setSelected(false);
            this.extractBitButton.setEnabled(false);
            this.applyBitmaskButton.setEnabled(false);
        }
    }

    private void setJComboBoxSelectedIndex(JComboBox jComboBox, int n) {
        this.performJComboBoxEvent = false;
        jComboBox.setSelectedIndex(n);
        this.performJComboBoxEvent = true;
    }

    private void setPalette() {
        if (!(this.dataset instanceof ScalarDS)) {
            return;
        }
        byte[][] byArray = null;
        int n = this.choicePalette.getSelectedIndex();
        if (n == 0) {
            return;
        }
        if (n == this.numberOfPalettes + 1) {
            byArray = Tools.createGrayPalette();
        } else if (n == this.numberOfPalettes + 2) {
            byArray = Tools.createReverseGrayPalette();
        } else if (n == this.numberOfPalettes + 3) {
            byArray = Tools.createGrayWavePalette();
        } else if (n == this.numberOfPalettes + 4) {
            byArray = Tools.createRainbowPalette();
        } else if (n == this.numberOfPalettes + 5) {
            byArray = Tools.createNaturePalette();
        } else if (n == this.numberOfPalettes + 6) {
            byArray = Tools.createWavePalette();
        } else if (n > 0 && n <= this.numberOfPalettes) {
            byArray = ((ScalarDS)this.dataset).readPalette(n - 1);
        }
        ((ScalarDS)this.dataset).setPalette(byArray);
    }

    private boolean setSelection() {
        int n;
        long[] lArray = new long[]{0L, 0L, 0L};
        long[] lArray2 = new long[]{0L, 0L, 0L};
        long[] lArray3 = new long[]{1L, 1L, 1L};
        int[] nArray = new int[]{0, 1, 2};
        boolean bl = true;
        int n2 = Math.min(3, this.rank);
        for (n = 0; n < n2; ++n) {
            nArray[n] = this.choices[n].getSelectedIndex();
            try {
                lArray[n] = Long.parseLong(this.startFields[n].getText());
                if (n < 2) {
                    lArray2[n] = Long.parseLong(this.endFields[n].getText());
                    lArray3[n] = Long.parseLong(this.strideFields[n].getText());
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.toolkit.beep();
                JOptionPane.showMessageDialog((JFrame)((Object)this.viewer), numberFormatException.getMessage(), this.getTitle(), 0);
                return false;
            }
            if (lArray[n] < 0L) {
                lArray[n] = 0L;
            }
            if (lArray[n] >= this.dims[nArray[n]]) {
                lArray[n] = this.dims[nArray[n]] - 1L;
            }
            if (lArray2[n] < 0L) {
                lArray2[n] = 0L;
            }
            if (lArray2[n] >= this.dims[nArray[n]]) {
                lArray2[n] = this.dims[nArray[n]] - 1L;
            }
            if (lArray[n] > lArray2[n]) {
                lArray2[n] = lArray[n];
            }
            if (lArray3[n] > this.dims[nArray[n]]) {
                lArray3[n] = this.dims[nArray[n]];
            }
            if (lArray3[n] > 0L) continue;
            lArray3[n] = 1L;
        }
        if (this.dataset instanceof CompoundDS) {
            CompoundDS compoundDS = (CompoundDS)this.dataset;
            int[] nArray2 = this.fieldList.getSelectedIndices();
            if (nArray2 == null || nArray2.length < 1) {
                this.toolkit.beep();
                JOptionPane.showMessageDialog((JFrame)((Object)this.viewer), "No member/field is selected.", this.getTitle(), 0);
                return false;
            }
            compoundDS.setMemberSelection(false);
            for (int i = 0; i < nArray2.length; ++i) {
                compoundDS.selectMember(nArray2[i]);
            }
        }
        for (n = 0; n < this.rank; ++n) {
            this.selected[n] = 1L;
            this.stride[n] = 1L;
        }
        for (n = 0; n < n2; ++n) {
            this.selectedIndex[n] = nArray[n];
            this.start[this.selectedIndex[n]] = lArray[n];
            if (n >= 2) continue;
            this.selected[this.selectedIndex[n]] = (int)((lArray2[n] - lArray[n] + 1L) / lArray3[n]);
            this.stride[this.selectedIndex[n]] = lArray3[n];
        }
        if (this.rank > 1 && this.isText) {
            this.selected[this.selectedIndex[1]] = 1L;
            this.stride[this.selectedIndex[1]] = 1L;
        } else if (this.rank > 2 && this.isTrueColorImage && this.imageButton.isSelected()) {
            this.start[this.selectedIndex[2]] = 0L;
            this.selected[this.selectedIndex[2]] = 3L;
        }
        this.dataset.clearData();
        bl = this.setBitmask();
        return bl;
    }

    private boolean setBitmask() {
        int n;
        boolean bl = false;
        boolean bl2 = false;
        if (this.bitmaskButtons == null) {
            this.bitmask = null;
            return true;
        }
        if (!this.applyBitmaskButton.isSelected() && !this.extractBitButton.isSelected()) {
            this.bitmask = null;
            return true;
        }
        int n2 = this.bitmaskButtons.length;
        for (n = 0; n < n2; ++n) {
            bl = bl && this.bitmaskButtons[n].isSelected();
            bl2 = bl2 && !this.bitmaskButtons[n].isSelected();
        }
        if (bl || bl2) {
            this.bitmask = null;
            return true;
        }
        if (this.bitmask == null) {
            this.bitmask = new BitSet(n2);
        }
        for (n = 0; n < n2; ++n) {
            this.bitmask.set(n, this.bitmaskButtons[n].isSelected());
        }
        return true;
    }

    public boolean isDisplayTypeChar() {
        return this.charCheckbox.isSelected();
    }

    public BitSet getBitmask() {
        if (this.bitmask == null) {
            return null;
        }
        if (!this.extractBitButton.isEnabled()) {
            return null;
        }
        if (this.bitmask.isEmpty()) {
            return null;
        }
        boolean bl = true;
        int n = this.bitmask.size();
        for (int i = 0; i < n; ++i) {
            bl = this.bitmask.get(i) && bl;
        }
        if (bl) {
            return null;
        }
        return this.bitmask;
    }

    public boolean isApplyBitmaskOnly() {
        if (this.getBitmask() == null) {
            return false;
        }
        return this.applyBitmaskButton.isSelected();
    }

    public boolean isTransposed() {
        return this.transposeChoice.getSelectedIndex() == 1;
    }

    public String getDataViewName() {
        String string = null;
        string = this.isText ? (String)this.choiceTextView.getSelectedItem() : (this.isImageDisplay() ? (String)this.choiceImageView.getSelectedItem() : (String)this.choiceTableView.getSelectedItem());
        return string;
    }

    private class PreviewNavigator
    extends JComponent
    implements MouseListener,
    MouseMotionListener {
        private static final long serialVersionUID = -4458114008420664965L;
        private final int NAVIGATOR_SIZE = 150;
        private int dimX;
        private int dimY;
        private int x;
        private int y;
        private double r;
        private Point startPosition;
        private Rectangle selectedArea;
        private Image previewImage = null;

        private PreviewNavigator(int n, int n2) {
            this.dimX = n;
            this.dimY = n2;
            if (this.dimX > this.dimY) {
                this.x = 150;
                this.r = (double)this.dimX / (double)this.x;
                this.y = (int)((double)this.dimY / this.r);
            } else {
                this.y = 150;
                this.r = (double)this.dimY / (double)this.y;
                this.x = (int)((double)this.dimX / this.r);
            }
            this.selectedArea = new Rectangle();
            this.setPreferredSize(new Dimension(150, 150));
            try {
                this.previewImage = this.createPreviewImage();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Image createPreviewImage() throws Exception {
            if (DataOptionDialog.this.rank <= 1 || !(DataOptionDialog.this.dataset instanceof ScalarDS)) {
                return null;
            }
            Image image = null;
            ScalarDS scalarDS = (ScalarDS)DataOptionDialog.this.dataset;
            if (scalarDS.isText()) {
                return null;
            }
            long[] lArray = new long[DataOptionDialog.this.rank];
            long[] lArray2 = new long[DataOptionDialog.this.rank];
            long[] lArray3 = new long[DataOptionDialog.this.rank];
            int[] nArray = new int[3];
            System.arraycopy(DataOptionDialog.this.stride, 0, lArray, 0, DataOptionDialog.this.rank);
            System.arraycopy(DataOptionDialog.this.selected, 0, lArray2, 0, DataOptionDialog.this.rank);
            System.arraycopy(DataOptionDialog.this.start, 0, lArray3, 0, DataOptionDialog.this.rank);
            System.arraycopy(DataOptionDialog.this.selectedIndex, 0, nArray, 0, 3);
            for (int i = 0; i < DataOptionDialog.this.rank; ++i) {
                ((DataOptionDialog)DataOptionDialog.this).start[i] = 0L;
                ((DataOptionDialog)DataOptionDialog.this).stride[i] = 1L;
                ((DataOptionDialog)DataOptionDialog.this).selected[i] = 1L;
            }
            if (DataOptionDialog.this.choices != null) {
                ((DataOptionDialog)DataOptionDialog.this).selectedIndex[0] = DataOptionDialog.this.choices[0].getSelectedIndex();
                ((DataOptionDialog)DataOptionDialog.this).selectedIndex[1] = DataOptionDialog.this.choices[1].getSelectedIndex();
            }
            long l = (long)Math.ceil(this.r);
            ((DataOptionDialog)DataOptionDialog.this).selected[((DataOptionDialog)DataOptionDialog.this).selectedIndex[0]] = DataOptionDialog.this.dims[DataOptionDialog.this.selectedIndex[0]] / l;
            ((DataOptionDialog)DataOptionDialog.this).selected[((DataOptionDialog)DataOptionDialog.this).selectedIndex[1]] = DataOptionDialog.this.dims[DataOptionDialog.this.selectedIndex[1]] / l;
            long l2 = l;
            ((DataOptionDialog)DataOptionDialog.this).stride[((DataOptionDialog)DataOptionDialog.this).selectedIndex[1]] = l2;
            ((DataOptionDialog)DataOptionDialog.this).stride[((DataOptionDialog)DataOptionDialog.this).selectedIndex[0]] = l2;
            if (DataOptionDialog.this.selected[DataOptionDialog.this.selectedIndex[0]] == 0L) {
                ((DataOptionDialog)DataOptionDialog.this).selected[((DataOptionDialog)DataOptionDialog.this).selectedIndex[0]] = 1L;
            }
            if (DataOptionDialog.this.selected[DataOptionDialog.this.selectedIndex[1]] == 0L) {
                ((DataOptionDialog)DataOptionDialog.this).selected[((DataOptionDialog)DataOptionDialog.this).selectedIndex[1]] = 1L;
            }
            if (DataOptionDialog.this.isTrueColorImage && DataOptionDialog.this.start.length > 2) {
                ((DataOptionDialog)DataOptionDialog.this).start[((DataOptionDialog)DataOptionDialog.this).selectedIndex[2]] = 0L;
                ((DataOptionDialog)DataOptionDialog.this).selected[((DataOptionDialog)DataOptionDialog.this).selectedIndex[2]] = 3L;
                ((DataOptionDialog)DataOptionDialog.this).stride[((DataOptionDialog)DataOptionDialog.this).selectedIndex[2]] = 1L;
            }
            this.y = (int)DataOptionDialog.this.selected[DataOptionDialog.this.selectedIndex[0]];
            this.x = (int)DataOptionDialog.this.selected[DataOptionDialog.this.selectedIndex[1]];
            this.r = Math.min((double)DataOptionDialog.this.dims[DataOptionDialog.this.selectedIndex[0]] / (double)DataOptionDialog.this.selected[DataOptionDialog.this.selectedIndex[0]], (double)DataOptionDialog.this.dims[DataOptionDialog.this.selectedIndex[1]] / (double)DataOptionDialog.this.selected[DataOptionDialog.this.selectedIndex[1]]);
            try {
                Object object = scalarDS.read();
                Object object2 = scalarDS.getFillValue();
                if (object2 != null && scalarDS.isFillValueConverted) {
                    object2 = ScalarDS.convertToUnsignedC(object2, null);
                }
                byte[] byArray = Tools.getBytes(object, scalarDS.getImageDataRange(), object2, null);
                int n = scalarDS.getHeight();
                int n2 = scalarDS.getWidth();
                if (DataOptionDialog.this.isTrueColorImage) {
                    boolean bl = scalarDS.getInterlace() == 2;
                    image = Tools.createTrueColorImage(byArray, bl, n2, n);
                } else {
                    int n3;
                    int n4;
                    byte[] byArray2;
                    int n5;
                    byte[][] byArray3 = scalarDS.getPalette();
                    if (byArray3 == null) {
                        byArray3 = Tools.createGrayPalette();
                    }
                    if ((DataOptionDialog.this.isH5 || DataOptionDialog.this.rank > 2) && DataOptionDialog.this.selectedIndex[0] > DataOptionDialog.this.selectedIndex[1]) {
                        n5 = byArray.length;
                        byArray2 = new byte[n5];
                        System.arraycopy(byArray, 0, byArray2, 0, n5);
                        for (n4 = 0; n4 < n; ++n4) {
                            for (n3 = 0; n3 < n2; ++n3) {
                                byArray[n4 * n2 + n3] = byArray2[n3 * n + n4];
                            }
                        }
                    }
                    if (!DataOptionDialog.this.isH5 && !scalarDS.isDefaultImageOrder() && DataOptionDialog.this.selectedIndex[1] > DataOptionDialog.this.selectedIndex[0]) {
                        n5 = byArray.length;
                        byArray2 = new byte[n5];
                        System.arraycopy(byArray, 0, byArray2, 0, n5);
                        for (n4 = 0; n4 < n; ++n4) {
                            for (n3 = 0; n3 < n2; ++n3) {
                                byArray[n4 * n2 + n3] = byArray2[n3 * n + n4];
                            }
                        }
                    }
                    image = Tools.createIndexedImage(byArray, byArray3, n2, n);
                }
            }
            finally {
                System.arraycopy(lArray, 0, DataOptionDialog.this.stride, 0, DataOptionDialog.this.rank);
                System.arraycopy(lArray2, 0, DataOptionDialog.this.selected, 0, DataOptionDialog.this.rank);
                System.arraycopy(lArray3, 0, DataOptionDialog.this.start, 0, DataOptionDialog.this.rank);
                System.arraycopy(nArray, 0, DataOptionDialog.this.selectedIndex, 0, 3);
            }
            return image;
        }

        @Override
        public void paint(Graphics graphics) {
            graphics.setColor(Color.blue);
            if (this.previewImage != null) {
                graphics.drawImage(this.previewImage, 0, 0, this);
            } else {
                graphics.fillRect(0, 0, this.x, this.y);
            }
            int n = this.selectedArea.width;
            int n2 = this.selectedArea.height;
            if (n > 0 && n2 > 0) {
                graphics.setColor(Color.red);
                graphics.drawRect(this.selectedArea.x, this.selectedArea.y, n, n2);
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.startPosition = mouseEvent.getPoint();
            this.selectedArea.setBounds(this.startPosition.x, this.startPosition.y, 0, 0);
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            this.startPosition = mouseEvent.getPoint();
            this.selectedArea.setBounds(this.startPosition.x, this.startPosition.y, 0, 0);
            this.repaint();
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            Point point = this.startPosition;
            Point point2 = mouseEvent.getPoint();
            int n = Math.max(0, Math.min(point.x, point2.x));
            int n2 = Math.max(0, Math.min(point.y, point2.y));
            int n3 = Math.min(this.x, Math.max(point.x, point2.x));
            int n4 = Math.min(this.y, Math.max(point.y, point2.y));
            int n5 = n3 - n;
            int n6 = n4 - n2;
            this.selectedArea.setBounds(n, n2, n5, n6);
            try {
                this.updateSelection(n, n2, n5, n6);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.repaint();
        }

        private void updateSelection(int n, int n2, int n3, int n4) {
            int n5 = 0;
            int n6 = 0;
            n5 = (int)((double)n2 * this.r);
            if ((long)n5 > DataOptionDialog.this.dims[DataOptionDialog.this.currentIndex[0]]) {
                n5 = (int)DataOptionDialog.this.dims[DataOptionDialog.this.currentIndex[0]];
            }
            DataOptionDialog.this.startFields[0].setText(String.valueOf(n5));
            n6 = (int)((double)(n2 + n4) * this.r);
            if (n6 < n5) {
                n6 = n5;
            }
            DataOptionDialog.this.endFields[0].setText(String.valueOf(n6));
            String string = String.valueOf((int)((double)n4 * this.r));
            if (DataOptionDialog.this.rank > 1) {
                n5 = (int)((double)n * this.r);
                if ((long)n5 > DataOptionDialog.this.dims[DataOptionDialog.this.currentIndex[1]]) {
                    n5 = (int)DataOptionDialog.this.dims[DataOptionDialog.this.currentIndex[1]];
                }
                DataOptionDialog.this.startFields[1].setText(String.valueOf(n5));
                n6 = (int)((double)(n + n3) * this.r);
                if (n6 < n5) {
                    n6 = n5;
                }
                DataOptionDialog.this.endFields[1].setText(String.valueOf(n6));
                string = string + " x " + (int)((double)n3 * this.r);
            }
            DataOptionDialog.this.selLabel.setText(string);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }

        private void setDimensionSize(int n, int n2) {
            this.dimX = n;
            this.dimY = n2;
            if (this.dimX > this.dimY) {
                this.x = 150;
                this.r = (double)this.dimX / (double)this.x;
                this.y = (int)((double)this.dimY / this.r);
            } else {
                this.y = 150;
                this.r = (double)this.dimY / (double)this.y;
                this.x = (int)((double)this.dimX / this.r);
            }
            this.setPreferredSize(new Dimension(150, 150));
            this.selectedArea.setSize(0, 0);
            try {
                this.previewImage = this.createPreviewImage();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.repaint();
        }
    }
}

